/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

public final class UITransition {
    private float duration = 100.0f;
    private float elapsed;
    private float frac;
    private boolean fadeOut;
    private boolean bIgnoreUpdateTime = false;
    private long updateTimeMS;
    private static long currentTimeMS;
    private static long elapsedTimeMS;

    public static void UpdateAll() {
        long l = System.currentTimeMillis();
        elapsedTimeMS = l - currentTimeMS;
        currentTimeMS = l;
    }

    public void init(float f, boolean bl) {
        this.duration = Math.max(f, 1.0f);
        this.elapsed = this.frac >= 1.0f ? 0.0f : (this.fadeOut != bl ? (1.0f - this.frac) * this.duration : this.frac * this.duration);
        this.fadeOut = bl;
    }

    public void update() {
        long l;
        if (!this.bIgnoreUpdateTime && this.updateTimeMS != 0L && this.updateTimeMS + (l = (long)this.duration) < currentTimeMS) {
            this.elapsed = this.duration;
        }
        this.updateTimeMS = currentTimeMS;
        this.frac = this.elapsed / this.duration;
        this.elapsed = Math.min(this.elapsed + (float)elapsedTimeMS, this.duration);
    }

    public float fraction() {
        return this.fadeOut ? 1.0f - this.frac : this.frac;
    }

    public void setFadeIn(boolean bl) {
        if (bl) {
            if (this.fadeOut) {
                this.init(100.0f, false);
            }
        } else if (!this.fadeOut) {
            this.init(200.0f, true);
        }
    }

    public void reset() {
        this.elapsed = 0.0f;
    }

    public void setIgnoreUpdateTime(boolean bl) {
        this.bIgnoreUpdateTime = bl;
    }

    public float getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(float f) {
        this.elapsed = f;
    }
}

