/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import gnu.trove.list.array.TIntArrayList;
import java.util.Stack;
import org.lwjglx.input.Keyboard;
import zombie.GameTime;
import zombie.Lua.LuaManager;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.fonts.AngelCodeFont;
import zombie.core.math.PZMath;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIDebugConsole;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UINineGrid;
import zombie.ui.UITransition;

public class UITextBox2
extends UIElement {
    public static boolean ConsoleHasFocus = false;
    public Stack<String> Lines = new Stack();
    public UINineGrid Frame = null;
    public String Text = "";
    public boolean Centred = false;
    public Color StandardFrameColour = new Color(50, 50, 50, 212);
    public Color TextEntryFrameColour = new Color(50, 50, 127, 212);
    public Color TextEntryCursorColour = new Color(170, 170, 220, 240);
    public Color TextEntryCursorColour2 = new Color(100, 100, 220, 160);
    public Color NuetralColour = new Color(0, 0, 255, 33);
    public Color NuetralColour2 = new Color(127, 0, 255, 33);
    public Color BadColour = new Color(255, 0, 0, 33);
    public Color GoodColour = new Color(0, 255, 33);
    public boolean DoingTextEntry = false;
    public int TextEntryCursorPos = 0;
    public int TextEntryMaxLength = 2000;
    public boolean IsEditable = false;
    public boolean IsSelectable = false;
    public int CursorLine = 0;
    public boolean multipleLine = false;
    public TIntArrayList TextOffsetOfLineStart = new TIntArrayList();
    public int ToSelectionIndex = 0;
    public String internalText = "";
    public String maskChr = "*";
    public boolean bMask = false;
    public boolean ignoreFirst;
    UIFont font;
    int[] HighlightLines = new int[1000];
    boolean HasFrame = false;
    int NumVisibleLines = 0;
    int TopLineIndex = 0;
    int BlinkFramesOn = 12;
    int BlinkFramesOff = 8;
    float BlinkFrame = this.BlinkFramesOn;
    boolean BlinkState = true;
    private ColorInfo textColor = new ColorInfo();
    private int EdgeSize = 5;
    private boolean SelectingRange = false;
    private int maxTextLength = -1;
    private boolean forceUpperCase = false;
    private int XOffset = 0;
    private int maxLines = 1;
    private boolean onlyNumbers = false;
    private Texture clearButtonTexture;
    private boolean bClearButton = false;
    private UITransition clearButtonTransition;
    public boolean bAlwaysPaginate = true;
    public boolean bTextChanged = false;
    private int paginateWidth = -1;
    private UIFont paginateFont = null;

    public UITextBox2(UIFont uIFont, int n, int n2, int n3, int n4, String string, boolean bl) {
        this.font = uIFont;
        this.x = n;
        this.y = n2;
        this.SetText(string);
        this.width = n3;
        this.height = n4;
        this.NumVisibleLines = 10;
        this.TopLineIndex = 0;
        Core.CurrentTextEntryBox = this;
        for (int i = 0; i < 1000; ++i) {
            this.HighlightLines[i] = 0;
        }
        this.HasFrame = bl;
        if (bl) {
            this.Frame = new UINineGrid(0, 0, n3, n4, this.EdgeSize, this.EdgeSize, this.EdgeSize, this.EdgeSize, "media/ui/Box_TopLeft.png", "media/ui/Box_Top.png", "media/ui/Box_TopRight.png", "media/ui/Box_Left.png", "media/ui/Box_Center.png", "media/ui/Box_Right.png", "media/ui/Box_BottomLeft.png", "media/ui/Box_Bottom.png", "media/ui/Box_BottomRight.png");
            this.AddChild(this.Frame);
        }
        this.Paginate();
        this.DoingTextEntry = false;
        this.TextEntryMaxLength = 2000;
        this.ToSelectionIndex = this.TextEntryCursorPos = 0;
        this.IsEditable = false;
        Keyboard.enableRepeatEvents((boolean)true);
        this.clearButtonTexture = Texture.getSharedTexture("media/ui/Panel_Icon_Close.png");
    }

    public void ClearHighlights() {
        for (int i = 0; i < 1000; ++i) {
            this.HighlightLines[i] = 0;
        }
    }

    public void setMasked(boolean bl) {
        if (this.bMask == bl) {
            return;
        }
        this.bMask = bl;
        this.Text = this.bMask ? this.maskChr.repeat(this.internalText.length()) : this.internalText;
    }

    public boolean isMasked() {
        return this.bMask;
    }

    @Override
    public void onresize() {
        this.Paginate();
    }

    @Override
    public void render() {
        int n;
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return;
        }
        if (this.bMask) {
            if (this.internalText.length() != this.Text.length()) {
                this.Text = this.maskChr.repeat(this.internalText.length());
            }
        } else {
            this.Text = this.internalText;
        }
        super.render();
        this.Paginate();
        int n2 = TextManager.instance.getFontFromEnum(this.font).getLineHeight();
        int n3 = this.getInset();
        this.keepCursorVisible();
        int n4 = (int)this.width - n3;
        if (this.bClearButton && this.clearButtonTexture != null && !this.Lines.isEmpty()) {
            n4 -= 2 + this.clearButtonTexture.getWidth() + 2;
            float f = 0.5f;
            if (!this.SelectingRange && this.isMouseOver().booleanValue() && (double)Mouse.getXA() >= this.getAbsoluteX() + (double)n4) {
                f = 1.0f;
            }
            this.clearButtonTransition.setFadeIn(f == 1.0f);
            this.clearButtonTransition.update();
            this.DrawTexture(this.clearButtonTexture, this.width - (float)n3 - 2.0f - (float)this.clearButtonTexture.getWidth(), n3 + (n2 - this.clearButtonTexture.getHeight()) / 2, f * this.clearButtonTransition.fraction() + 0.35f * (1.0f - this.clearButtonTransition.fraction()));
        }
        Double d = this.clampToParentX(this.getAbsoluteX().intValue() + n3);
        Double d2 = this.clampToParentX(this.getAbsoluteX().intValue() + n4);
        Double d3 = this.clampToParentY(this.getAbsoluteY().intValue() + n3);
        Double d4 = this.clampToParentY(this.getAbsoluteY().intValue() + (int)this.height - n3);
        this.setStencilRect(d.intValue() - this.getAbsoluteX().intValue(), d3.intValue() - this.getAbsoluteY().intValue(), d2.intValue() - d.intValue(), d4.intValue() - d3.intValue());
        if (this.Lines.size() > 0) {
            int n5 = n3;
            for (n = this.TopLineIndex; n < this.TopLineIndex + this.NumVisibleLines && n < this.Lines.size(); ++n) {
                if (this.Lines.get(n) == null) continue;
                if (n >= 0 && n < this.HighlightLines.length) {
                    if (this.HighlightLines[n] == 1) {
                        this.DrawTextureScaledCol(null, n3 - 1, n5, this.getWidth().intValue() - n3 * 2 + 2, n2, this.NuetralColour);
                    } else if (this.HighlightLines[n] == 2) {
                        this.DrawTextureScaledCol(null, n3 - 1, n5, this.getWidth().intValue() - n3 * 2 + 2, n2, this.NuetralColour2);
                    } else if (this.HighlightLines[n] == 3) {
                        this.DrawTextureScaledCol(null, n3 - 1, n5, this.getWidth().intValue() - n3 * 2 + 2, n2, this.BadColour);
                    } else if (this.HighlightLines[n] == 4) {
                        this.DrawTextureScaledCol(null, n3 - 1, n5, this.getWidth().intValue() - n3 * 2 + 2, n2, this.GoodColour);
                    }
                }
                String string = (String)this.Lines.get(n);
                if (this.Centred) {
                    TextManager.instance.DrawStringCentre(this.font, (double)this.getAbsoluteX().intValue() + this.getWidth() / 2.0 + (double)n3, this.getAbsoluteY().intValue() + n5, string, this.textColor.r, this.textColor.g, this.textColor.b, 1.0);
                } else {
                    TextManager.instance.DrawString(this.font, -this.XOffset + this.getAbsoluteX().intValue() + n3, this.getAbsoluteY().intValue() + n5, string, this.textColor.r, this.textColor.g, this.textColor.b, 1.0);
                }
                n5 += n2;
            }
        }
        ConsoleHasFocus = this.DoingTextEntry;
        if (this.TextEntryCursorPos > this.Text.length()) {
            this.TextEntryCursorPos = this.Text.length();
        }
        if (this.ToSelectionIndex > this.Text.length()) {
            this.ToSelectionIndex = this.Text.length();
        }
        this.CursorLine = this.toDisplayLine(this.TextEntryCursorPos);
        if (this.DoingTextEntry) {
            AngelCodeFont angelCodeFont = TextManager.instance.getFontFromEnum(this.font);
            if (this.BlinkState) {
                n = 0;
                if (this.Lines.size() > 0) {
                    int n6 = this.TextEntryCursorPos - this.TextOffsetOfLineStart.get(this.CursorLine);
                    n6 = Math.min(n6, ((String)this.Lines.get(this.CursorLine)).length());
                    n = angelCodeFont.getWidth((String)this.Lines.get(this.CursorLine), 0, n6 - 1, true);
                    if (n > 0) {
                        --n;
                    }
                }
                this.DrawTextureScaledCol(Texture.getWhite(), -this.XOffset + n3 + n, n3 + this.CursorLine * n2, 1.0, n2, this.TextEntryCursorColour);
            }
            if (this.Lines.size() > 0 && this.ToSelectionIndex != this.TextEntryCursorPos) {
                n = Math.min(this.TextEntryCursorPos, this.ToSelectionIndex);
                int n7 = Math.max(this.TextEntryCursorPos, this.ToSelectionIndex);
                int n8 = this.toDisplayLine(n);
                int n9 = this.toDisplayLine(n7);
                for (int i = n8; i <= n9; ++i) {
                    int n10 = this.TextOffsetOfLineStart.get(i);
                    int n11 = n10 + ((String)this.Lines.get(i)).length();
                    n10 = Math.max(n10, n);
                    n11 = Math.min(n11, n7);
                    String string = (String)this.Lines.get(i);
                    int n12 = angelCodeFont.getWidth(string, 0, n10 - this.TextOffsetOfLineStart.get(i) - 1, true);
                    int n13 = angelCodeFont.getWidth(string, 0, n11 - this.TextOffsetOfLineStart.get(i) - 1, true);
                    this.DrawTextureScaledCol(null, -this.XOffset + n3 + n12, n3 + i * n2, n13 - n12, n2, this.TextEntryCursorColour2);
                }
            }
        }
        this.clearStencilRect();
        if (StencilLevel > 0) {
            this.repaintStencilRect(d.intValue() - this.getAbsoluteX().intValue(), d3.intValue() - this.getAbsoluteY().intValue(), d2.intValue() - d.intValue(), d4.intValue() - d3.intValue());
        }
    }

    public float getFrameAlpha() {
        return this.Frame.getAlpha();
    }

    public void setFrameAlpha(float f) {
        this.Frame.setAlpha(f);
    }

    public void setTextColor(ColorInfo colorInfo) {
        this.textColor = colorInfo;
    }

    private void keepCursorVisible() {
        if (this.Lines.isEmpty() || !this.DoingTextEntry || this.multipleLine) {
            this.XOffset = 0;
            return;
        }
        if (this.TextEntryCursorPos > this.Text.length()) {
            this.TextEntryCursorPos = this.Text.length();
        }
        String string = (String)this.Lines.get(0);
        int n = TextManager.instance.MeasureStringX(this.font, string);
        int n2 = this.getInset();
        int n3 = this.getWidth().intValue() - n2 * 2;
        if (this.bClearButton && this.clearButtonTexture != null) {
            n3 -= 2 + this.clearButtonTexture.getWidth() + 2;
        }
        if (n <= n3) {
            this.XOffset = 0;
        } else if (-this.XOffset + n < n3) {
            this.XOffset = n - n3;
        }
        int n4 = TextManager.instance.MeasureStringX(this.font, string.substring(0, this.TextEntryCursorPos));
        int n5 = -this.XOffset + n2 + n4 - 1;
        if (n5 < n2) {
            this.XOffset = n4;
        } else if (n5 >= n2 + n3) {
            this.XOffset = 0;
            int n6 = this.getCursorPosFromX(n4 - n3);
            this.XOffset = TextManager.instance.MeasureStringX(this.font, string.substring(0, n6));
            n5 = -this.XOffset + n2 + n4 - 1;
            if (n5 >= n2 + n3) {
                this.XOffset = TextManager.instance.MeasureStringX(this.font, string.substring(0, n6 + 1));
            }
            if (-this.XOffset + n < n3) {
                this.XOffset = n - n3;
            }
        }
    }

    public String getText() {
        return this.Text;
    }

    public String getInternalText() {
        return this.internalText;
    }

    @Override
    public void update() {
        int n;
        if (this.maxTextLength > -1 && this.internalText.length() > this.maxTextLength) {
            this.internalText = this.internalText.substring(this.maxTextLength);
        }
        if (this.forceUpperCase) {
            this.internalText = this.internalText.toUpperCase();
        }
        if (this.bMask) {
            if (this.internalText.length() != this.Text.length()) {
                Object object = "";
                for (n = 0; n < this.internalText.length(); ++n) {
                    object = (String)object + this.maskChr;
                }
                if (this.DoingTextEntry && this.Text != object) {
                    this.resetBlink();
                }
                this.Text = object;
            }
        } else {
            if (this.DoingTextEntry && this.Text != this.internalText) {
                this.resetBlink();
            }
            this.Text = this.internalText;
        }
        this.Paginate();
        int n2 = this.getInset();
        n = TextManager.instance.getFontFromEnum(this.font).getLineHeight();
        if ((double)(n + n2 * 2) > this.getHeight()) {
            this.setHeight(n + n2 * 2);
        }
        if (this.Frame != null) {
            this.Frame.setHeight(this.getHeight());
        }
        this.NumVisibleLines = (int)(this.getHeight() - (double)(n2 * 2)) / n;
        if (this.BlinkFrame > 0.0f) {
            this.BlinkFrame -= GameTime.getInstance().getRealworldSecondsSinceLastUpdate() * 30.0f;
        } else {
            this.BlinkState = !this.BlinkState;
            this.BlinkFrame = this.BlinkState ? (float)this.BlinkFramesOn : (float)this.BlinkFramesOff;
        }
        if (this.NumVisibleLines * n + n2 * 2 < this.getHeight().intValue()) {
            if (this.NumVisibleLines < this.Lines.size()) {
                this.setScrollHeight((this.Lines.size() + 1) * n);
            }
            ++this.NumVisibleLines;
        } else {
            this.setScrollHeight(this.Lines.size() * n);
        }
        if (UIDebugConsole.instance == null || this != UIDebugConsole.instance.OutputLog) {
            this.TopLineIndex = (int)(-this.getYScroll().doubleValue() + (double)n2) / n;
        }
        this.setYScroll(-this.TopLineIndex * n);
    }

    private void Paginate() {
        boolean bl = this.bAlwaysPaginate;
        if (!this.bAlwaysPaginate) {
            if (this.paginateFont != this.font) {
                this.paginateFont = this.font;
                bl = true;
            }
            if (this.paginateWidth != this.getWidth().intValue()) {
                this.paginateWidth = this.getWidth().intValue();
                bl = true;
            }
            if (this.bTextChanged) {
                this.bTextChanged = false;
                bl = true;
            }
            if (!bl) {
                return;
            }
        }
        this.Lines.clear();
        this.TextOffsetOfLineStart.resetQuick();
        if (this.Text.isEmpty()) {
            return;
        }
        if (!this.multipleLine) {
            this.Lines.add(this.Text);
            this.TextOffsetOfLineStart.add(0);
            return;
        }
        String[] stringArray = this.Text.split("\n", -1);
        int n = 0;
        block0: for (String string : stringArray) {
            int n2 = 0;
            if (string.length() == 0) {
                this.Lines.add(this.multipleLine ? "" : " ");
                this.TextOffsetOfLineStart.add(n);
                ++n;
                continue;
            }
            do {
                int n3;
                int n4;
                if ((n4 = (n3 = string.indexOf(" ", n2 + 1))) == -1) {
                    n4 = string.length();
                }
                int n5 = TextManager.instance.MeasureStringX(this.font, string.substring(0, n4));
                int n6 = 17;
                if ((double)n5 >= this.getWidth() - (double)(this.getInset() * 2) - (double)n6 && n2 > 0) {
                    var13_13 = string.substring(0, n2);
                    string = string.substring(n2 + 1);
                    this.Lines.add(var13_13);
                    this.TextOffsetOfLineStart.add(n);
                    n += var13_13.length() + 1;
                    n3 = 0;
                } else if (n3 == -1) {
                    var13_13 = string;
                    this.Lines.add(var13_13);
                    this.TextOffsetOfLineStart.add(n);
                    n += var13_13.length() + 1;
                    continue block0;
                }
                n2 = n3;
            } while (string.length() > 0);
        }
    }

    public int getInset() {
        int n = 2;
        if (this.HasFrame) {
            n = this.EdgeSize;
        }
        return n;
    }

    public void setEditable(boolean bl) {
        this.IsEditable = bl;
    }

    public boolean isEditable() {
        return this.IsEditable;
    }

    public void setSelectable(boolean bl) {
        this.IsSelectable = bl;
    }

    public boolean isSelectable() {
        return this.IsSelectable;
    }

    @Override
    public Boolean onMouseUp(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return false;
        }
        super.onMouseUp(d, d2);
        this.SelectingRange = false;
        return Boolean.TRUE;
    }

    @Override
    public void onMouseUpOutside(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.onMouseUpOutside(d, d2);
        this.SelectingRange = false;
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        boolean bl = this.isConsumeMouseEvents();
        this.setConsumeMouseEvents(false);
        Boolean bl2 = super.onMouseMove(d, d2);
        this.setConsumeMouseEvents(bl);
        if (bl2.booleanValue()) {
            return Boolean.TRUE;
        }
        if ((this.IsEditable || this.IsSelectable) && this.SelectingRange) {
            if (this.multipleLine) {
                int n3 = this.getInset();
                int n4 = TextManager.instance.getFontFromEnum(this.font).getLineHeight();
                this.CursorLine = (n2 - this.getAbsoluteY().intValue() - n3 - this.getYScroll().intValue()) / n4;
                if (this.CursorLine > this.Lines.size() - 1) {
                    this.CursorLine = this.Lines.size() - 1;
                }
            }
            this.TextEntryCursorPos = this.getCursorPosFromX((int)((double)n - this.getAbsoluteX()));
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        if (!Mouse.isButtonDown(0)) {
            this.SelectingRange = false;
        }
        if (!this.isVisible().booleanValue()) {
            return;
        }
        super.onMouseMoveOutside(d, d2);
        if ((this.IsEditable || this.IsSelectable) && this.SelectingRange) {
            if (this.multipleLine) {
                int n3 = this.getInset();
                int n4 = TextManager.instance.getFontFromEnum(this.font).getLineHeight();
                this.CursorLine = (n2 - this.getAbsoluteY().intValue() - n3 - this.getYScroll().intValue()) / n4;
                if (this.CursorLine < 0) {
                    this.CursorLine = 0;
                }
                if (this.CursorLine > this.Lines.size() - 1) {
                    this.CursorLine = this.Lines.size() - 1;
                }
            }
            this.TextEntryCursorPos = this.getCursorPosFromX((int)((double)n - this.getAbsoluteX()));
        }
    }

    public void focus() {
        if (!this.DoingTextEntry) {
            // empty if block
        }
        this.DoingTextEntry = true;
        Core.CurrentTextEntryBox = this;
    }

    public void unfocus() {
        this.DoingTextEntry = false;
        if (Core.CurrentTextEntryBox == this) {
            Core.CurrentTextEntryBox = null;
        }
    }

    public void ignoreFirstInput() {
        this.ignoreFirst = true;
    }

    @Override
    public Boolean onMouseDown(double d, double d2) {
        int n;
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        if (!this.getControls().isEmpty()) {
            for (n = 0; n < this.getControls().size(); ++n) {
                UIElement uIElement = this.getControls().get(n);
                if (uIElement == this.Frame || !uIElement.isMouseOver().booleanValue()) continue;
                return uIElement.onMouseDown(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue()) != false ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.bClearButton && this.clearButtonTexture != null && !this.Lines.isEmpty()) {
            n = this.getWidth().intValue() - this.getInset();
            if (d >= (double)(n -= 2 + this.clearButtonTexture.getWidth() + 2)) {
                this.clearInput();
                return Boolean.TRUE;
            }
        }
        if (this.multipleLine) {
            n = this.getInset();
            int n2 = TextManager.instance.getFontFromEnum(this.font).getLineHeight();
            this.CursorLine = ((int)d2 - n - this.getYScroll().intValue()) / n2;
            if (this.CursorLine > this.Lines.size() - 1) {
                this.CursorLine = this.Lines.size() - 1;
            }
        }
        if (this.IsEditable || this.IsSelectable) {
            if (Core.CurrentTextEntryBox != this) {
                if (Core.CurrentTextEntryBox != null) {
                    Core.CurrentTextEntryBox.DoingTextEntry = false;
                    if (Core.CurrentTextEntryBox.Frame != null) {
                        Core.CurrentTextEntryBox.Frame.Colour = this.StandardFrameColour;
                    }
                }
                Core.CurrentTextEntryBox = this;
                Core.CurrentTextEntryBox.SelectingRange = true;
            }
            if (!this.DoingTextEntry) {
                this.focus();
                this.ToSelectionIndex = this.TextEntryCursorPos = this.getCursorPosFromX((int)d);
                if (this.Frame != null) {
                    this.Frame.Colour = this.TextEntryFrameColour;
                }
            } else {
                this.ToSelectionIndex = this.TextEntryCursorPos = this.getCursorPosFromX((int)d);
            }
        } else {
            if (this.Frame != null) {
                this.Frame.Colour = this.StandardFrameColour;
            }
            this.DoingTextEntry = false;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private int getCursorPosFromX(int n) {
        if (this.Lines.isEmpty()) {
            return 0;
        }
        String string = (String)this.Lines.get(this.CursorLine);
        if (string.length() == 0) {
            return this.TextOffsetOfLineStart.get(this.CursorLine);
        }
        if (n + this.XOffset < 0) {
            return this.TextOffsetOfLineStart.get(this.CursorLine);
        }
        for (int i = 0; i <= string.length(); ++i) {
            int n2;
            String string2 = "";
            if (i > 0) {
                string2 = string.substring(0, i);
            }
            if ((n2 = TextManager.instance.MeasureStringX(this.font, string2)) <= n + this.XOffset || i < 0) continue;
            return this.TextOffsetOfLineStart.get(this.CursorLine) + i - 1;
        }
        return this.TextOffsetOfLineStart.get(this.CursorLine) + string.length();
    }

    public void updateText() {
        if (this.bMask) {
            Object object = "";
            for (int i = 0; i < this.internalText.length(); ++i) {
                object = (String)object + this.maskChr;
            }
            this.Text = object;
        } else {
            this.Text = this.internalText;
        }
    }

    public void SetText(String object) {
        int n;
        this.internalText = object;
        if (this.bMask) {
            object = "";
            for (n = 0; n < this.internalText.length(); ++n) {
                object = (String)object + this.maskChr;
            }
            this.Text = object;
        } else {
            this.Text = object;
        }
        this.ToSelectionIndex = this.TextEntryCursorPos = ((String)object).length();
        this.update();
        this.ToSelectionIndex = 0;
        this.TextEntryCursorPos = 0;
        if (!this.Lines.isEmpty()) {
            n = this.Lines.size() - 1;
            this.TextEntryCursorPos = this.ToSelectionIndex = this.TextOffsetOfLineStart.get(n) + ((String)this.Lines.get(n)).length();
        }
    }

    public void clearInput() {
        this.Text = "";
        this.internalText = "";
        this.TextEntryCursorPos = 0;
        this.ToSelectionIndex = 0;
        this.update();
        this.onTextChange();
    }

    public void onPressUp() {
        if (this.getTable() != null && this.getTable().rawget((Object)"onPressUp") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onPressUp"), (Object)this.getTable());
        }
    }

    public void onPressDown() {
        if (this.getTable() != null && this.getTable().rawget((Object)"onPressDown") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onPressDown"), (Object)this.getTable());
        }
    }

    public void onCommandEntered() {
        if (this.getTable() != null && this.getTable().rawget((Object)"onCommandEntered") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onCommandEntered"), (Object)this.getTable());
        }
    }

    public void onTextChange() {
        if (this.getTable() != null && this.getTable().rawget((Object)"onTextChange") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onTextChange"), (Object)this.getTable());
        }
    }

    public void onOtherKey(int n) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onOtherKey") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onOtherKey"), new Object[]{this.getTable(), n});
        }
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int n) {
        this.maxTextLength = n;
    }

    public boolean getForceUpperCase() {
        return this.forceUpperCase;
    }

    public void setForceUpperCase(boolean bl) {
        this.forceUpperCase = bl;
    }

    public void setHasFrame(boolean bl) {
        if (this.HasFrame == bl) {
            return;
        }
        this.HasFrame = bl;
        if (this.HasFrame) {
            this.Frame = new UINineGrid(0, 0, (int)this.width, (int)this.height, this.EdgeSize, this.EdgeSize, this.EdgeSize, this.EdgeSize, "media/ui/Box_TopLeft.png", "media/ui/Box_Top.png", "media/ui/Box_TopRight.png", "media/ui/Box_Left.png", "media/ui/Box_Center.png", "media/ui/Box_Right.png", "media/ui/Box_BottomLeft.png", "media/ui/Box_Bottom.png", "media/ui/Box_BottomRight.png");
            this.Frame.setAnchorRight(true);
            this.AddChild(this.Frame);
        } else {
            this.RemoveChild(this.Frame);
            this.Frame = null;
        }
    }

    public void setClearButton(boolean bl) {
        this.bClearButton = bl;
        if (this.bClearButton && this.clearButtonTransition == null) {
            this.clearButtonTransition = new UITransition();
        }
    }

    public int toDisplayLine(int n) {
        for (int i = 0; i < this.Lines.size(); ++i) {
            if (n < this.TextOffsetOfLineStart.get(i) || n > this.TextOffsetOfLineStart.get(i) + ((String)this.Lines.get(i)).length()) continue;
            return i;
        }
        return 0;
    }

    public void setMultipleLine(boolean bl) {
        this.multipleLine = bl;
    }

    public boolean isMultipleLine() {
        return this.multipleLine;
    }

    public int getCursorLine() {
        return this.CursorLine;
    }

    public void setCursorLine(int n) {
        this.CursorLine = n;
    }

    public int getCursorPos() {
        return this.TextEntryCursorPos;
    }

    public void setCursorPos(int n) {
        if (this.multipleLine) {
            if (this.CursorLine >= 0 && this.CursorLine < this.Lines.size()) {
                this.TextEntryCursorPos = PZMath.clamp(n, 0, ((String)this.Lines.get(this.CursorLine)).length());
            }
        } else {
            this.TextEntryCursorPos = PZMath.clamp(n, 0, this.internalText.length());
        }
        this.ToSelectionIndex = this.TextEntryCursorPos;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
    }

    public boolean isFocused() {
        return this.DoingTextEntry;
    }

    public boolean isOnlyNumbers() {
        return this.onlyNumbers;
    }

    public void setOnlyNumbers(boolean bl) {
        this.onlyNumbers = bl;
    }

    public void resetBlink() {
        this.BlinkState = true;
        this.BlinkFrame = this.BlinkFramesOn;
    }

    public void selectAll() {
        this.TextEntryCursorPos = this.internalText.length();
        this.ToSelectionIndex = 0;
    }
}

