/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.krka.kahlua.vm.KahluaThread;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoPlayer;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.Styles.TransparentStyle;
import zombie.core.Styles.UIFBOStyle;
import zombie.core.Translator;
import zombie.core.opengl.RenderThread;
import zombie.core.textures.Texture;
import zombie.core.textures.TextureFBO;
import zombie.debug.DebugOptions;
import zombie.gameStates.GameLoadingState;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.iso.IsoCamera;
import zombie.iso.IsoObject;
import zombie.iso.IsoObjectPicker;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.iso.areas.SafeHouse;
import zombie.network.CoopMaster;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.ActionProgressBar;
import zombie.ui.Clock;
import zombie.ui.ModalDialog;
import zombie.ui.MoodlesUI;
import zombie.ui.ObjectTooltip;
import zombie.ui.SpeedControls;
import zombie.ui.TextManager;
import zombie.ui.TutorialManager;
import zombie.ui.UIDebugConsole;
import zombie.ui.UIElement;
import zombie.ui.UIFont;
import zombie.ui.UIServerToolbox;
import zombie.ui.UITransition;
import zombie.util.list.PZArrayUtil;

public final class UIManager {
    public static int lastMouseX = 0;
    public static int lastMouseY = 0;
    public static IsoObjectPicker.ClickObject Picked = null;
    public static Clock clock;
    public static final ArrayList<UIElement> UI;
    public static ObjectTooltip toolTip;
    public static Texture mouseArrow;
    public static Texture mouseExamine;
    public static Texture mouseAttack;
    public static Texture mouseGrab;
    public static SpeedControls speedControls;
    public static UIDebugConsole DebugConsole;
    public static UIServerToolbox ServerToolbox;
    public static final MoodlesUI[] MoodleUI;
    public static boolean bFadeBeforeUI;
    public static final ActionProgressBar[] ProgressBar;
    public static float FadeAlpha;
    public static int FadeInTimeMax;
    public static int FadeInTime;
    public static boolean FadingOut;
    public static Texture lastMouseTexture;
    public static IsoObject LastPicked;
    public static final ArrayList<String> DoneTutorials;
    public static float lastOffX;
    public static float lastOffY;
    public static ModalDialog Modal;
    public static boolean KeyDownZoomIn;
    public static boolean KeyDownZoomOut;
    public static boolean doTick;
    public static boolean VisibleAllUI;
    public static TextureFBO UIFBO;
    public static boolean useUIFBO;
    public static Texture black;
    public static boolean bSuspend;
    public static float lastAlpha;
    public static final Vector2 PickedTileLocal;
    public static final Vector2 PickedTile;
    public static IsoObject RightDownObject;
    public static long uiUpdateTimeMS;
    public static long uiUpdateIntervalMS;
    public static long uiRenderTimeMS;
    public static long uiRenderIntervalMS;
    private static final ArrayList<UIElement> tutorialStack;
    public static final ArrayList<UIElement> toTop;
    public static KahluaThread defaultthread;
    public static KahluaThread previousThread;
    static final ArrayList<UIElement> toRemove;
    static final ArrayList<UIElement> toAdd;
    static int wheel;
    static int lastwheel;
    static final ArrayList<UIElement> debugUI;
    static boolean bShowLuaDebuggerOnError;
    public static String luaDebuggerAction;
    static final Sync sync;
    private static boolean showPausedMessage;
    private static UIElement playerInventoryUI;
    private static UIElement playerLootUI;
    private static UIElement playerInventoryTooltip;
    private static UIElement playerLootTooltip;
    private static final FadeInfo[] playerFadeInfo;

    public static void AddUI(UIElement uIElement) {
        toRemove.remove(uIElement);
        toRemove.add(uIElement);
        toAdd.remove(uIElement);
        toAdd.add(uIElement);
    }

    public static void RemoveElement(UIElement uIElement) {
        toAdd.remove(uIElement);
        toRemove.remove(uIElement);
        toRemove.add(uIElement);
    }

    public static void clearArrays() {
        toAdd.clear();
        toRemove.clear();
        UI.clear();
    }

    public static void closeContainers() {
    }

    public static void CloseContainers() {
    }

    public static void DrawTexture(Texture texture, double d, double d2) {
        double d3 = d;
        double d4 = d2;
        SpriteRenderer.instance.renderi(texture, (int)(d3 += (double)texture.offsetX), (int)(d4 += (double)texture.offsetY), texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, 1.0f, null);
    }

    public static void DrawTexture(Texture texture, double d, double d2, double d3, double d4, double d5) {
        double d6 = d;
        double d7 = d2;
        SpriteRenderer.instance.renderi(texture, (int)(d6 += (double)texture.offsetX), (int)(d7 += (double)texture.offsetY), (int)d3, (int)d4, 1.0f, 1.0f, 1.0f, (float)d5, null);
    }

    public static void FadeIn(double d) {
        UIManager.setFadeInTimeMax((int)(d * 30.0 * (double)((float)PerformanceSettings.getLockFPS() / 30.0f)));
        UIManager.setFadeInTime(UIManager.getFadeInTimeMax());
        UIManager.setFadingOut(false);
    }

    public static void FadeOut(double d) {
        UIManager.setFadeInTimeMax((int)(d * 30.0 * (double)((float)PerformanceSettings.getLockFPS() / 30.0f)));
        UIManager.setFadeInTime(UIManager.getFadeInTimeMax());
        UIManager.setFadingOut(true);
    }

    public static void CreateFBO(int n, int n2) {
        if (Core.SafeMode) {
            useUIFBO = false;
            return;
        }
        if (useUIFBO && (UIFBO == null || UIFBO.getTexture().getWidth() != n || UIFBO.getTexture().getHeight() != n2)) {
            if (UIFBO != null) {
                RenderThread.invokeOnRenderContext(() -> UIFBO.destroy());
            }
            try {
                UIFBO = UIManager.createTexture(n, n2, false);
            }
            catch (Exception exception) {
                useUIFBO = false;
                exception.printStackTrace();
            }
        }
    }

    public static TextureFBO createTexture(float f, float f2, boolean bl) throws Exception {
        if (bl) {
            Texture texture = new Texture((int)f, (int)f2, 16);
            TextureFBO textureFBO = new TextureFBO(texture);
            textureFBO.destroy();
            return null;
        }
        Texture texture = new Texture((int)f, (int)f2, 16);
        return new TextureFBO(texture);
    }

    public static void init() {
        UIElement uIElement;
        int n;
        showPausedMessage = true;
        UIManager.getUI().clear();
        debugUI.clear();
        clock = null;
        for (n = 0; n < 4; ++n) {
            UIManager.MoodleUI[n] = null;
        }
        UIManager.setSpeedControls(new SpeedControls());
        SpeedControls.instance = UIManager.getSpeedControls();
        UIManager.setbFadeBeforeUI(false);
        VisibleAllUI = true;
        for (n = 0; n < 4; ++n) {
            playerFadeInfo[n].setFadeBeforeUI(false);
            playerFadeInfo[n].setFadeTime(0);
            playerFadeInfo[n].setFadingOut(false);
        }
        UIManager.setPicked(null);
        UIManager.setLastPicked(null);
        RightDownObject = null;
        if (IsoPlayer.getInstance() == null) {
            return;
        }
        if (!Core.GameMode.equals("LastStand") && !GameClient.bClient) {
            UIManager.getUI().add(UIManager.getSpeedControls());
        }
        if (GameServer.bServer) {
            return;
        }
        UIManager.setToolTip(new ObjectTooltip());
        if (Core.getInstance().getOptionClockSize() == 2) {
            UIManager.setClock(new Clock(Core.getInstance().getOffscreenWidth(0) - 166, 10));
        } else {
            UIManager.setClock(new Clock(Core.getInstance().getOffscreenWidth(0) - 91, 10));
        }
        if (!Core.GameMode.equals("LastStand")) {
            UIManager.getUI().add(UIManager.getClock());
        }
        UIManager.getUI().add(UIManager.getToolTip());
        UIManager.setDebugConsole(new UIDebugConsole(20, Core.getInstance().getScreenHeight() - 265));
        UIManager.setServerToolbox(new UIServerToolbox(100, 200));
        if (Core.bDebug && DebugOptions.instance.UIDebugConsoleStartVisible.getValue()) {
            DebugConsole.setVisible(true);
        } else {
            DebugConsole.setVisible(false);
        }
        if (CoopMaster.instance.isRunning()) {
            ServerToolbox.setVisible(true);
        } else {
            ServerToolbox.setVisible(false);
        }
        for (n = 0; n < 4; ++n) {
            uIElement = new MoodlesUI();
            UIManager.setMoodleUI(n, (MoodlesUI)uIElement);
            uIElement.setVisible(true);
            UIManager.getUI().add(uIElement);
        }
        UIManager.getUI().add(UIManager.getDebugConsole());
        UIManager.getUI().add(UIManager.getServerToolbox());
        UIManager.setLastMouseTexture(UIManager.getMouseArrow());
        UIManager.resize();
        for (n = 0; n < 4; ++n) {
            uIElement = new ActionProgressBar(0, 0);
            uIElement.setRenderThisPlayerOnly(n);
            UIManager.setProgressBar(n, (ActionProgressBar)uIElement);
            UIManager.getUI().add(uIElement);
            ((ActionProgressBar)uIElement).setValue(1.0f);
            uIElement.setVisible(false);
        }
        playerInventoryUI = null;
        playerLootUI = null;
        LuaEventManager.triggerEvent("OnCreateUI");
    }

    public static void render() {
        int n;
        if (useUIFBO && !Core.getInstance().UIRenderThisFrame) {
            return;
        }
        if (bSuspend) {
            return;
        }
        long l = System.currentTimeMillis();
        uiRenderIntervalMS = Math.min(l - uiRenderTimeMS, 1000L);
        uiRenderTimeMS = l;
        UIElement.StencilLevel = 0;
        if (useUIFBO) {
            SpriteRenderer.instance.setDefaultStyle(UIFBOStyle.instance);
        }
        UITransition.UpdateAll();
        if (UIManager.getBlack() == null) {
            UIManager.setBlack(Texture.getSharedTexture("black.png"));
        }
        if (LuaManager.thread == defaultthread) {
            LuaEventManager.triggerEvent("OnPreUIDraw");
        }
        int n2 = Mouse.getXA();
        int n3 = Mouse.getYA();
        if (UIManager.isbFadeBeforeUI()) {
            UIManager.setFadeAlpha(UIManager.getFadeInTime().floatValue() / UIManager.getFadeInTimeMax().floatValue());
            if (UIManager.getFadeAlpha() > 1.0) {
                UIManager.setFadeAlpha(1.0);
            }
            if (UIManager.getFadeAlpha() < 0.0) {
                UIManager.setFadeAlpha(0.0);
            }
            if (UIManager.isFadingOut().booleanValue()) {
                UIManager.setFadeAlpha(1.0 - UIManager.getFadeAlpha());
            }
            if (IsoCamera.CamCharacter != null && UIManager.getFadeAlpha() > 0.0) {
                UIManager.DrawTexture(UIManager.getBlack(), 0.0, 0.0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), UIManager.getFadeAlpha());
            }
        }
        UIManager.setLastAlpha(UIManager.getFadeAlpha().floatValue());
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            if (IsoPlayer.players[n] == null || !playerFadeInfo[n].isFadeBeforeUI()) continue;
            playerFadeInfo[n].render();
        }
        for (n = 0; n < UIManager.getUI().size(); ++n) {
            if (!UI.get(n).isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || UI.get(n).isFollowGameWorld().booleanValue()) continue;
            try {
                if (!UIManager.getUI().get(n).isDefaultDraw().booleanValue()) continue;
                UIManager.getUI().get(n).render();
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(GameWindow.class.getName()).log(Level.SEVERE, null, exception);
            }
        }
        if (UIManager.getToolTip() != null) {
            UIManager.getToolTip().render();
        }
        if (UIManager.isShowPausedMessage() && GameTime.isGamePaused() && (UIManager.getModal() == null || !Modal.isVisible().booleanValue()) && VisibleAllUI) {
            String string = Translator.getText("IGUI_GamePaused");
            int n4 = TextManager.instance.MeasureStringX(UIFont.Small, string) + 32;
            int n5 = TextManager.instance.font.getLineHeight();
            int n6 = (int)Math.ceil((double)n5 * 1.5);
            SpriteRenderer.instance.renderi(null, Core.getInstance().getScreenWidth() / 2 - n4 / 2, Core.getInstance().getScreenHeight() / 2 - n6 / 2, n4, n6, 0.0f, 0.0f, 0.0f, 0.75f, null);
            TextManager.instance.DrawStringCentre(Core.getInstance().getScreenWidth() / 2, Core.getInstance().getScreenHeight() / 2 - n5 / 2, string, 1.0, 1.0, 1.0, 1.0);
        }
        if (!UIManager.isbFadeBeforeUI()) {
            UIManager.setFadeAlpha(UIManager.getFadeInTime() / UIManager.getFadeInTimeMax());
            if (UIManager.getFadeAlpha() > 1.0) {
                UIManager.setFadeAlpha(1.0);
            }
            if (UIManager.getFadeAlpha() < 0.0) {
                UIManager.setFadeAlpha(0.0);
            }
            if (UIManager.isFadingOut().booleanValue()) {
                UIManager.setFadeAlpha(1.0 - UIManager.getFadeAlpha());
            }
            if (IsoCamera.CamCharacter != null && UIManager.getFadeAlpha() > 0.0) {
                UIManager.DrawTexture(UIManager.getBlack(), 0.0, 0.0, Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight(), UIManager.getFadeAlpha());
            }
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            if (IsoPlayer.players[i] == null || playerFadeInfo[i].isFadeBeforeUI()) continue;
            playerFadeInfo[i].render();
        }
        if (LuaManager.thread == defaultthread) {
            LuaEventManager.triggerEvent("OnPostUIDraw");
        }
        if (useUIFBO) {
            SpriteRenderer.instance.setDefaultStyle(TransparentStyle.instance);
        }
    }

    public static void resize() {
        if (useUIFBO && UIFBO != null) {
            UIManager.CreateFBO(Core.getInstance().getScreenWidth(), Core.getInstance().getScreenHeight());
        }
        if (UIManager.getClock() == null) {
            return;
        }
        UIManager.setLastOffX(Core.getInstance().getScreenWidth());
        UIManager.setLastOffY(Core.getInstance().getScreenHeight());
        for (int i = 0; i < 4; ++i) {
            int n = Core.getInstance().getScreenWidth();
            int n2 = Core.getInstance().getScreenHeight();
            int n3 = Clock.instance.isVisible() == false ? 24 : 64;
            if (i == 0 && IsoPlayer.numPlayers > 1 || i == 2) {
                n /= 2;
            }
            MoodleUI[i].setX(n - 50);
            if ((i == 0 || i == 1) && IsoPlayer.numPlayers > 1) {
                MoodleUI[i].setY(n3);
            }
            if (i == 2 || i == 3) {
                MoodleUI[i].setY(n2 / 2 + n3);
            }
            MoodleUI[i].setVisible(VisibleAllUI && IsoPlayer.players[i] != null);
        }
        clock.resize();
        if (IsoPlayer.numPlayers == 1) {
            if (Core.getInstance().getOptionClockSize() == 2) {
                clock.setX(Core.getInstance().getScreenWidth() - 166);
            } else {
                clock.setX(Core.getInstance().getScreenWidth() - 91);
            }
        } else {
            if (Core.getInstance().getOptionClockSize() == 2) {
                clock.setX((float)Core.getInstance().getScreenWidth() / 2.0f - 83.0f);
            } else {
                clock.setX((float)Core.getInstance().getScreenWidth() / 2.0f - 45.5f);
            }
            clock.setY(Core.getInstance().getScreenHeight() - 70);
        }
        if (IsoPlayer.numPlayers == 1) {
            speedControls.setX(Core.getInstance().getScreenWidth() - 110);
        } else {
            speedControls.setX(Core.getInstance().getScreenWidth() / 2 - 50);
        }
        if (IsoPlayer.numPlayers == 1 && !clock.isVisible().booleanValue()) {
            speedControls.setY(clock.getY());
        } else {
            speedControls.setY(clock.getY() + clock.getHeight() + 6.0);
        }
        speedControls.setVisible(VisibleAllUI && !IsoPlayer.allPlayersDead());
    }

    public static Vector2 getTileFromMouse(double d, double d2, double d3) {
        UIManager.PickedTile.x = IsoUtils.XToIso((float)(d - 0.0), (float)(d2 - 0.0), (float)d3);
        UIManager.PickedTile.y = IsoUtils.YToIso((float)(d - 0.0), (float)(d2 - 0.0), (float)d3);
        UIManager.PickedTileLocal.x = UIManager.getPickedTile().x - (float)((int)UIManager.getPickedTile().x);
        UIManager.PickedTileLocal.y = UIManager.getPickedTile().y - (float)((int)UIManager.getPickedTile().y);
        UIManager.PickedTile.x = (int)UIManager.getPickedTile().x;
        UIManager.PickedTile.y = (int)UIManager.getPickedTile().y;
        return UIManager.getPickedTile();
    }

    public static void update() {
        Object object;
        UIElement uIElement;
        UIElement uIElement2;
        int n;
        if (bSuspend) {
            return;
        }
        if (!toRemove.isEmpty()) {
            UI.removeAll(toRemove);
        }
        toRemove.clear();
        if (!toAdd.isEmpty()) {
            UI.addAll(toAdd);
        }
        toAdd.clear();
        UIManager.setFadeInTime(UIManager.getFadeInTime() - 1.0);
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            playerFadeInfo[i].update();
        }
        long l = System.currentTimeMillis();
        if (l - uiUpdateTimeMS >= 100L) {
            doTick = true;
            uiUpdateIntervalMS = Math.min(l - uiUpdateTimeMS, 1000L);
            uiUpdateTimeMS = l;
        } else {
            doTick = false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = Mouse.getXA();
        int n3 = Mouse.getYA();
        int n4 = Mouse.getX();
        int n5 = Mouse.getY();
        tutorialStack.clear();
        for (n = UI.size() - 1; n >= 0; --n) {
            uIElement2 = UI.get(n);
            if (uIElement2.getParent() != null) {
                UI.remove(n);
                throw new IllegalStateException();
            }
            if (uIElement2.isFollowGameWorld().booleanValue()) {
                tutorialStack.add(uIElement2);
            }
            if (!(uIElement2 instanceof ObjectTooltip)) continue;
            uIElement = UI.remove(n);
            UI.add(uIElement);
        }
        for (n = 0; n < UI.size(); ++n) {
            uIElement2 = UI.get(n);
            if (!uIElement2.alwaysOnTop && !toTop.contains(uIElement2)) continue;
            uIElement = UI.remove(n);
            --n;
            toAdd.add(uIElement);
        }
        if (!toAdd.isEmpty()) {
            UI.addAll(toAdd);
            toAdd.clear();
        }
        toTop.clear();
        for (n = 0; n < UI.size(); ++n) {
            uIElement2 = UI.get(n);
            if (!uIElement2.alwaysBack) continue;
            uIElement = UI.remove(n);
            UI.add(0, uIElement);
        }
        for (n = 0; n < tutorialStack.size(); ++n) {
            UI.remove(tutorialStack.get(n));
            UI.add(0, tutorialStack.get(n));
        }
        if (Mouse.isLeftPressed()) {
            Core.UnfocusActiveTextEntryBox();
            for (n = UI.size() - 1; n >= 0; --n) {
                uIElement2 = UI.get(n);
                if (UIManager.getModal() != null && UIManager.getModal() != uIElement2 && UIManager.getModal().isVisible().booleanValue() || !uIElement2.isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || !uIElement2.isVisible().booleanValue()) continue;
                if ((double)n2 >= uIElement2.getX() && (double)n3 >= uIElement2.getY() && (double)n2 < uIElement2.getX() + uIElement2.getWidth() && (double)n3 < uIElement2.getY() + uIElement2.getHeight() || uIElement2.isCapture().booleanValue()) {
                    if (!uIElement2.onMouseDown(n2 - uIElement2.getX().intValue(), n3 - uIElement2.getY().intValue()).booleanValue()) continue;
                    bl = true;
                    break;
                }
                uIElement2.onMouseDownOutside(n2 - uIElement2.getX().intValue(), n3 - uIElement2.getY().intValue());
            }
            if (UIManager.checkPicked() && !bl) {
                LuaEventManager.triggerEvent("OnObjectLeftMouseButtonDown", UIManager.Picked.tile, BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
            }
            if (!bl) {
                LuaEventManager.triggerEvent("OnMouseDown", BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                UIManager.CloseContainers();
                if (!(IsoWorld.instance.CurrentCell == null || IsoWorld.instance.CurrentCell.DoBuilding(0, false) || UIManager.getPicked() == null || GameTime.isGamePaused() || IsoPlayer.getInstance() == null || IsoPlayer.getInstance().isAiming() || IsoPlayer.getInstance().isAsleep())) {
                    UIManager.getPicked().tile.onMouseLeftClick(UIManager.getPicked().lx, UIManager.getPicked().ly);
                }
            } else {
                Mouse.UIBlockButtonDown(0);
            }
        }
        if (Mouse.isLeftReleased()) {
            n = 0;
            for (int i = UI.size() - 1; i >= 0; --i) {
                uIElement = UI.get(i);
                if (!uIElement.isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || !uIElement.isVisible().booleanValue() || UIManager.getModal() != null && UIManager.getModal() != uIElement && UIManager.getModal().isVisible().booleanValue()) continue;
                if ((double)n2 >= uIElement.getX() && (double)n3 >= uIElement.getY() && (double)n2 < uIElement.getX() + uIElement.getWidth() && (double)n3 < uIElement.getY() + uIElement.getHeight() || uIElement.isCapture().booleanValue()) {
                    if (!uIElement.onMouseUp(n2 - uIElement.getX().intValue(), n3 - uIElement.getY().intValue()).booleanValue()) continue;
                    n = 1;
                    break;
                }
                uIElement.onMouseUpOutside(n2 - uIElement.getX().intValue(), n3 - uIElement.getY().intValue());
            }
            if (n == 0) {
                LuaEventManager.triggerEvent("OnMouseUp", BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                if (UIManager.checkPicked() && !bl) {
                    LuaEventManager.triggerEvent("OnObjectLeftMouseButtonUp", UIManager.Picked.tile, BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                }
            }
        }
        if (Mouse.isRightPressed()) {
            for (n = UI.size() - 1; n >= 0; --n) {
                UIElement uIElement3 = UI.get(n);
                if (!uIElement3.isVisible().booleanValue() || UIManager.getModal() != null && UIManager.getModal() != uIElement3 && UIManager.getModal().isVisible().booleanValue()) continue;
                if ((double)n2 >= uIElement3.getX() && (double)n3 >= uIElement3.getY() && (double)n2 < uIElement3.getX() + uIElement3.getWidth() && (double)n3 < uIElement3.getY() + uIElement3.getHeight() || uIElement3.isCapture().booleanValue()) {
                    if (!uIElement3.onRightMouseDown(n2 - uIElement3.getX().intValue(), n3 - uIElement3.getY().intValue()).booleanValue()) continue;
                    bl2 = true;
                    break;
                }
                uIElement3.onRightMouseDownOutside(n2 - uIElement3.getX().intValue(), n3 - uIElement3.getY().intValue());
            }
            if (!bl2) {
                LuaEventManager.triggerEvent("OnRightMouseDown", BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                if (UIManager.checkPicked() && !bl2) {
                    LuaEventManager.triggerEvent("OnObjectRightMouseButtonDown", UIManager.Picked.tile, BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                }
            } else {
                Mouse.UIBlockButtonDown(1);
            }
            if (!(IsoWorld.instance.CurrentCell == null || UIManager.getPicked() == null || UIManager.getSpeedControls() == null || IsoPlayer.getInstance().isAiming() || IsoPlayer.getInstance().isAsleep() || GameTime.isGamePaused())) {
                UIManager.getSpeedControls().SetCurrentGameSpeed(1);
                UIManager.getPicked().tile.onMouseRightClick(UIManager.getPicked().lx, UIManager.getPicked().ly);
                UIManager.setRightDownObject(UIManager.getPicked().tile);
            }
        }
        if (Mouse.isRightReleased()) {
            n = 0;
            boolean bl4 = false;
            for (n = UI.size() - 1; n >= 0; --n) {
                uIElement = UI.get(n);
                if (!uIElement.isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || !uIElement.isVisible().booleanValue() || UIManager.getModal() != null && UIManager.getModal() != uIElement && UIManager.getModal().isVisible().booleanValue()) continue;
                if ((double)n2 >= uIElement.getX() && (double)n3 >= uIElement.getY() && (double)n2 < uIElement.getX() + uIElement.getWidth() && (double)n3 < uIElement.getY() + uIElement.getHeight() || uIElement.isCapture().booleanValue()) {
                    if (!uIElement.onRightMouseUp(n2 - uIElement.getX().intValue(), n3 - uIElement.getY().intValue()).booleanValue()) continue;
                    bl4 = true;
                    break;
                }
                uIElement.onRightMouseUpOutside(n2 - uIElement.getX().intValue(), n3 - uIElement.getY().intValue());
            }
            if (!bl4) {
                LuaEventManager.triggerEvent("OnRightMouseUp", BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                if (UIManager.checkPicked()) {
                    boolean bl5 = true;
                    if (GameClient.bClient && UIManager.Picked.tile.getSquare() != null && (object = SafeHouse.isSafeHouse(UIManager.Picked.tile.getSquare(), IsoPlayer.getInstance().getUsername(), true)) != null) {
                        bl5 = false;
                    }
                    if (bl5) {
                        LuaEventManager.triggerEvent("OnObjectRightMouseButtonUp", UIManager.Picked.tile, BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3));
                    }
                }
            }
            if (IsoPlayer.getInstance() != null) {
                IsoPlayer.getInstance().setDragObject(null);
            }
            if (IsoWorld.instance.CurrentCell != null && UIManager.getRightDownObject() != null && IsoPlayer.getInstance() != null && !IsoPlayer.getInstance().IsAiming() && !IsoPlayer.getInstance().isAsleep()) {
                UIManager.getRightDownObject().onMouseRightReleased();
                UIManager.setRightDownObject(null);
            }
        }
        lastwheel = 0;
        wheel = Mouse.getWheelState();
        n = 0;
        if (wheel != lastwheel) {
            int n6 = wheel - lastwheel < 0 ? 1 : -1;
            for (int i = UI.size() - 1; i >= 0; --i) {
                object = UI.get(i);
                if (!((UIElement)object).isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || !((UIElement)object).isVisible().booleanValue() || !((UIElement)object).isPointOver(n2, n3).booleanValue() && !((UIElement)object).isCapture().booleanValue() || !((UIElement)object).onMouseWheel(n6).booleanValue()) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                Core.getInstance().doZoomScroll(0, n6);
            }
        }
        if (UIManager.getLastMouseX() != (double)n2 || UIManager.getLastMouseY() != (double)n3) {
            for (int i = UI.size() - 1; i >= 0; --i) {
                UIElement uIElement4 = UI.get(i);
                if (!uIElement4.isIgnoreLossControl().booleanValue() && TutorialManager.instance.StealControl || !uIElement4.isVisible().booleanValue()) continue;
                if ((double)n2 >= uIElement4.getX() && (double)n3 >= uIElement4.getY() && (double)n2 < uIElement4.getX() + uIElement4.getWidth() && (double)n3 < uIElement4.getY() + uIElement4.getHeight() || uIElement4.isCapture().booleanValue()) {
                    if (bl3 || !uIElement4.onMouseMove((double)n2 - UIManager.getLastMouseX(), (double)n3 - UIManager.getLastMouseY()).booleanValue()) continue;
                    bl3 = true;
                    continue;
                }
                uIElement4.onMouseMoveOutside((double)n2 - UIManager.getLastMouseX(), (double)n3 - UIManager.getLastMouseY());
            }
        }
        if (!bl3 && IsoPlayer.players[0] != null) {
            UIManager.setPicked(IsoObjectPicker.Instance.ContextPick(n2, n3));
            if (IsoCamera.CamCharacter != null) {
                UIManager.setPickedTile(UIManager.getTileFromMouse(n4, n5, (int)IsoPlayer.players[0].getZ()));
            }
            LuaEventManager.triggerEvent("OnMouseMove", BoxedStaticValues.toDouble(n2), BoxedStaticValues.toDouble(n3), BoxedStaticValues.toDouble(n4), BoxedStaticValues.toDouble(n5));
        } else {
            Mouse.UIBlockButtonDown(2);
        }
        UIManager.setLastMouseX(n2);
        UIManager.setLastMouseY(n3);
        for (int i = 0; i < UI.size(); ++i) {
            UI.get(i).update();
        }
        UIManager.updateTooltip(n2, n3);
        UIManager.handleZoomKeys();
        IsoCamera.cameras[0].lastOffX = (int)IsoCamera.cameras[0].OffX;
        IsoCamera.cameras[0].lastOffY = (int)IsoCamera.cameras[0].OffY;
    }

    private static boolean checkPicked() {
        return Picked != null && UIManager.Picked.tile != null && UIManager.Picked.tile.getObjectIndex() != -1;
    }

    private static void handleZoomKeys() {
        boolean bl = true;
        if (Core.CurrentTextEntryBox != null && Core.CurrentTextEntryBox.IsEditable && Core.CurrentTextEntryBox.DoingTextEntry) {
            bl = false;
        }
        if (GameTime.isGamePaused()) {
            bl = false;
        }
        if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Zoom in"))) {
            if (bl && !KeyDownZoomIn) {
                Core.getInstance().doZoomScroll(0, -1);
            }
            KeyDownZoomIn = true;
        } else {
            KeyDownZoomIn = false;
        }
        if (GameKeyboard.isKeyDown(Core.getInstance().getKey("Zoom out"))) {
            if (bl && !KeyDownZoomOut) {
                Core.getInstance().doZoomScroll(0, 1);
            }
            KeyDownZoomOut = true;
        } else {
            KeyDownZoomOut = false;
        }
    }

    public static Double getLastMouseX() {
        return BoxedStaticValues.toDouble(lastMouseX);
    }

    public static void setLastMouseX(double d) {
        lastMouseX = (int)d;
    }

    public static Double getLastMouseY() {
        return BoxedStaticValues.toDouble(lastMouseY);
    }

    public static void setLastMouseY(double d) {
        lastMouseY = (int)d;
    }

    public static IsoObjectPicker.ClickObject getPicked() {
        return Picked;
    }

    public static void setPicked(IsoObjectPicker.ClickObject clickObject) {
        Picked = clickObject;
    }

    public static Clock getClock() {
        return clock;
    }

    public static void setClock(Clock clock) {
        UIManager.clock = clock;
    }

    public static ArrayList<UIElement> getUI() {
        return UI;
    }

    public static void setUI(ArrayList<UIElement> arrayList) {
        PZArrayUtil.copy(UI, arrayList);
    }

    public static ObjectTooltip getToolTip() {
        return toolTip;
    }

    public static void setToolTip(ObjectTooltip objectTooltip) {
        toolTip = objectTooltip;
    }

    public static Texture getMouseArrow() {
        return mouseArrow;
    }

    public static void setMouseArrow(Texture texture) {
        mouseArrow = texture;
    }

    public static Texture getMouseExamine() {
        return mouseExamine;
    }

    public static void setMouseExamine(Texture texture) {
        mouseExamine = texture;
    }

    public static Texture getMouseAttack() {
        return mouseAttack;
    }

    public static void setMouseAttack(Texture texture) {
        mouseAttack = texture;
    }

    public static Texture getMouseGrab() {
        return mouseGrab;
    }

    public static void setMouseGrab(Texture texture) {
        mouseGrab = texture;
    }

    public static SpeedControls getSpeedControls() {
        return speedControls;
    }

    public static void setSpeedControls(SpeedControls speedControls) {
        UIManager.speedControls = speedControls;
    }

    public static UIDebugConsole getDebugConsole() {
        return DebugConsole;
    }

    public static void setDebugConsole(UIDebugConsole uIDebugConsole) {
        DebugConsole = uIDebugConsole;
    }

    public static UIServerToolbox getServerToolbox() {
        return ServerToolbox;
    }

    public static void setServerToolbox(UIServerToolbox uIServerToolbox) {
        ServerToolbox = uIServerToolbox;
    }

    public static MoodlesUI getMoodleUI(double d) {
        return MoodleUI[(int)d];
    }

    public static void setMoodleUI(double d, MoodlesUI moodlesUI) {
        UIManager.MoodleUI[(int)d] = moodlesUI;
    }

    public static boolean isbFadeBeforeUI() {
        return bFadeBeforeUI;
    }

    public static void setbFadeBeforeUI(boolean bl) {
        bFadeBeforeUI = bl;
    }

    public static ActionProgressBar getProgressBar(double d) {
        return ProgressBar[(int)d];
    }

    public static void setProgressBar(double d, ActionProgressBar actionProgressBar) {
        UIManager.ProgressBar[(int)d] = actionProgressBar;
    }

    public static Double getFadeAlpha() {
        return BoxedStaticValues.toDouble(FadeAlpha);
    }

    public static void setFadeAlpha(double d) {
        FadeAlpha = (float)d;
    }

    public static Double getFadeInTimeMax() {
        return BoxedStaticValues.toDouble(FadeInTimeMax);
    }

    public static void setFadeInTimeMax(double d) {
        FadeInTimeMax = (int)d;
    }

    public static Double getFadeInTime() {
        return BoxedStaticValues.toDouble(FadeInTime);
    }

    public static void setFadeInTime(double d) {
        FadeInTime = Math.max((int)d, 0);
    }

    public static Boolean isFadingOut() {
        return FadingOut ? Boolean.TRUE : Boolean.FALSE;
    }

    public static void setFadingOut(boolean bl) {
        FadingOut = bl;
    }

    public static Texture getLastMouseTexture() {
        return lastMouseTexture;
    }

    public static void setLastMouseTexture(Texture texture) {
        lastMouseTexture = texture;
    }

    public static IsoObject getLastPicked() {
        return LastPicked;
    }

    public static void setLastPicked(IsoObject isoObject) {
        LastPicked = isoObject;
    }

    public static ArrayList<String> getDoneTutorials() {
        return DoneTutorials;
    }

    public static void setDoneTutorials(ArrayList<String> arrayList) {
        PZArrayUtil.copy(DoneTutorials, arrayList);
    }

    public static float getLastOffX() {
        return lastOffX;
    }

    public static void setLastOffX(float f) {
        lastOffX = f;
    }

    public static float getLastOffY() {
        return lastOffY;
    }

    public static void setLastOffY(float f) {
        lastOffY = f;
    }

    public static ModalDialog getModal() {
        return Modal;
    }

    public static void setModal(ModalDialog modalDialog) {
        Modal = modalDialog;
    }

    public static Texture getBlack() {
        return black;
    }

    public static void setBlack(Texture texture) {
        black = texture;
    }

    public static float getLastAlpha() {
        return lastAlpha;
    }

    public static void setLastAlpha(float f) {
        lastAlpha = f;
    }

    public static Vector2 getPickedTileLocal() {
        return PickedTileLocal;
    }

    public static void setPickedTileLocal(Vector2 vector22) {
        PickedTileLocal.set(vector22);
    }

    public static Vector2 getPickedTile() {
        return PickedTile;
    }

    public static void setPickedTile(Vector2 vector22) {
        PickedTile.set(vector22);
    }

    public static IsoObject getRightDownObject() {
        return RightDownObject;
    }

    public static void setRightDownObject(IsoObject isoObject) {
        RightDownObject = isoObject;
    }

    static void pushToTop(UIElement uIElement) {
        toTop.add(uIElement);
    }

    public static boolean isShowPausedMessage() {
        return showPausedMessage;
    }

    public static void setShowPausedMessage(boolean bl) {
        showPausedMessage = bl;
    }

    public static void setShowLuaDebuggerOnError(boolean bl) {
        bShowLuaDebuggerOnError = bl;
    }

    public static boolean isShowLuaDebuggerOnError() {
        return bShowLuaDebuggerOnError;
    }

    public static void debugBreakpoint(String string, long l) {
        if (!bShowLuaDebuggerOnError) {
            return;
        }
        if (Core.CurrentTextEntryBox != null) {
            Core.CurrentTextEntryBox.DoingTextEntry = false;
            Core.CurrentTextEntryBox = null;
        }
        if (GameServer.bServer) {
            return;
        }
        if (GameWindow.states.current instanceof GameLoadingState) {
            return;
        }
        previousThread = defaultthread;
        defaultthread = LuaManager.debugthread;
        int n = Core.getInstance().frameStage;
        if (n != 0) {
            if (n <= 1) {
                Core.getInstance().EndFrame(0);
            }
            if (n <= 2) {
                Core.getInstance().StartFrameUI();
            }
            if (n <= 3) {
                Core.getInstance().EndFrameUI();
            }
        }
        LuaManager.thread.bStep = false;
        LuaManager.thread.bStepInto = false;
        if (!toRemove.isEmpty()) {
            UI.removeAll(toRemove);
        }
        toRemove.clear();
        if (!toAdd.isEmpty()) {
            UI.addAll(toAdd);
        }
        toAdd.clear();
        ArrayList<UIElement> arrayList = new ArrayList<UIElement>();
        boolean bl = bSuspend;
        arrayList.addAll(UI);
        UI.clear();
        bSuspend = false;
        UIManager.setShowPausedMessage(false);
        boolean bl2 = false;
        boolean[] blArray = new boolean[11];
        for (int i = 0; i < 11; ++i) {
            blArray[i] = true;
        }
        if (debugUI.size() == 0) {
            LuaManager.debugcaller.pcall(LuaManager.debugthread, LuaManager.env.rawget((Object)"DoLuaDebugger"), new Object[]{string, l});
        } else {
            UI.addAll(debugUI);
            LuaManager.debugcaller.pcall(LuaManager.debugthread, LuaManager.env.rawget((Object)"DoLuaDebuggerOnBreak"), new Object[]{string, l});
        }
        Mouse.setCursorVisible(true);
        sync.begin();
        while (!bl2) {
            if (RenderThread.isCloseRequested()) {
                System.exit(0);
            }
            if (!GameWindow.bLuaDebuggerKeyDown && GameKeyboard.isKeyDown(Core.getInstance().getKey("Toggle Lua Debugger"))) {
                GameWindow.bLuaDebuggerKeyDown = true;
                UIManager.executeGame(arrayList, bl, n);
                return;
            }
            String string2 = luaDebuggerAction;
            luaDebuggerAction = null;
            if ("StepInto".equalsIgnoreCase(string2)) {
                LuaManager.thread.bStep = true;
                LuaManager.thread.bStepInto = true;
                UIManager.executeGame(arrayList, bl, n);
                return;
            }
            if ("StepOver".equalsIgnoreCase(string2)) {
                LuaManager.thread.bStep = true;
                LuaManager.thread.bStepInto = false;
                LuaManager.thread.lastCallFrame = LuaManager.thread.getCurrentCoroutine().getCallframeTop();
                UIManager.executeGame(arrayList, bl, n);
                return;
            }
            if ("Resume".equalsIgnoreCase(string2)) {
                UIManager.executeGame(arrayList, bl, n);
                return;
            }
            sync.startFrame();
            for (int i = 0; i < 11; ++i) {
                boolean bl3 = GameKeyboard.isKeyDown(59 + i);
                if (bl3) {
                    if (!blArray[i]) {
                        if (i + 1 == 5) {
                            LuaManager.thread.bStep = true;
                            LuaManager.thread.bStepInto = true;
                            UIManager.executeGame(arrayList, bl, n);
                            return;
                        }
                        if (i + 1 == 6) {
                            LuaManager.thread.bStep = true;
                            LuaManager.thread.bStepInto = false;
                            LuaManager.thread.lastCallFrame = LuaManager.thread.getCurrentCoroutine().getCallframeTop();
                            UIManager.executeGame(arrayList, bl, n);
                            return;
                        }
                    }
                    blArray[i] = true;
                    continue;
                }
                blArray[i] = false;
            }
            Mouse.update();
            GameKeyboard.update();
            Core.getInstance().DoFrameReady();
            UIManager.update();
            Core.getInstance().StartFrame(0, true);
            Core.getInstance().EndFrame(0);
            Core.getInstance().RenderOffScreenBuffer();
            if (Core.getInstance().StartFrameUI()) {
                UIManager.render();
            }
            Core.getInstance().EndFrameUI();
            UIManager.resize();
            if (!GameKeyboard.isKeyDown(Core.getInstance().getKey("Toggle Lua Debugger"))) {
                GameWindow.bLuaDebuggerKeyDown = false;
            }
            sync.endFrame();
            Core.getInstance().setScreenSize(RenderThread.getDisplayWidth(), RenderThread.getDisplayHeight());
        }
    }

    private static void executeGame(ArrayList<UIElement> arrayList, boolean bl, int n) {
        debugUI.clear();
        debugUI.addAll(UI);
        UI.clear();
        UI.addAll(arrayList);
        bSuspend = bl;
        UIManager.setShowPausedMessage(true);
        if (!LuaManager.thread.bStep && n != 0) {
            if (n == 1) {
                Core.getInstance().StartFrame(0, true);
            }
            if (n == 2) {
                Core.getInstance().StartFrame(0, true);
                Core.getInstance().EndFrame(0);
            }
            if (n == 3) {
                Core.getInstance().StartFrame(0, true);
                Core.getInstance().EndFrame(0);
                Core.getInstance().StartFrameUI();
            }
        }
        defaultthread = previousThread;
    }

    public static KahluaThread getDefaultThread() {
        if (defaultthread == null) {
            defaultthread = LuaManager.thread;
        }
        return defaultthread;
    }

    public static Double getDoubleClickInterval() {
        return BoxedStaticValues.toDouble(500.0);
    }

    public static Double getDoubleClickDist() {
        return BoxedStaticValues.toDouble(5.0);
    }

    public static Boolean isDoubleClick(double d, double d2, double d3, double d4, double d5) {
        if (Math.abs(d3 - d) > UIManager.getDoubleClickDist()) {
            return false;
        }
        if (Math.abs(d4 - d2) > UIManager.getDoubleClickDist()) {
            return false;
        }
        if ((double)System.currentTimeMillis() - d5 > UIManager.getDoubleClickInterval()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected static void updateTooltip(double d, double d2) {
        UIElement uIElement = null;
        for (int i = UIManager.getUI().size() - 1; i >= 0; --i) {
            UIElement uIElement2 = UIManager.getUI().get(i);
            if (uIElement2 == toolTip || !uIElement2.isVisible().booleanValue() || !(d >= uIElement2.getX()) || !(d2 >= uIElement2.getY()) || !(d < uIElement2.getX() + uIElement2.getWidth()) || !(d2 < uIElement2.getY() + uIElement2.getHeight()) || uIElement2.maxDrawHeight != -1 && !(d2 < uIElement2.getY() + (double)uIElement2.maxDrawHeight)) continue;
            uIElement = uIElement2;
            break;
        }
        IsoObject isoObject = null;
        if (uIElement == null && UIManager.getPicked() != null && (isoObject = UIManager.getPicked().tile) != UIManager.getLastPicked() && toolTip != null) {
            UIManager.toolTip.targetAlpha = 0.0f;
            if (isoObject.haveSpecialTooltip()) {
                if (UIManager.getToolTip().Object != isoObject) {
                    UIManager.getToolTip().show(isoObject, (double)((int)d + 8), (double)((int)d2 + 16));
                    if (toolTip.isVisible().booleanValue()) {
                        UIManager.toolTip.showDelay = 0;
                    }
                } else {
                    UIManager.toolTip.targetAlpha = 1.0f;
                }
            }
        }
        UIManager.setLastPicked(isoObject);
        if (toolTip != null && (isoObject == null || UIManager.toolTip.alpha <= 0.0f && UIManager.toolTip.targetAlpha <= 0.0f)) {
            toolTip.hide();
        }
    }

    public static void setPlayerInventory(int n, UIElement uIElement, UIElement uIElement2) {
        if (n != 0) {
            return;
        }
        playerInventoryUI = uIElement;
        playerLootUI = uIElement2;
    }

    public static void setPlayerInventoryTooltip(int n, UIElement uIElement, UIElement uIElement2) {
        if (n != 0) {
            return;
        }
        playerInventoryTooltip = uIElement;
        playerLootTooltip = uIElement2;
    }

    public static boolean isMouseOverInventory() {
        if (playerInventoryTooltip != null && playerInventoryTooltip.isMouseOver().booleanValue()) {
            return true;
        }
        if (playerLootTooltip != null && playerLootTooltip.isMouseOver().booleanValue()) {
            return true;
        }
        if (playerInventoryUI == null || playerLootUI == null) {
            return false;
        }
        if (playerInventoryUI.getMaxDrawHeight() == -1.0 && playerInventoryUI.isMouseOver().booleanValue()) {
            return true;
        }
        return playerLootUI.getMaxDrawHeight() == -1.0 && playerLootUI.isMouseOver() != false;
    }

    public static void updateBeforeFadeOut() {
        if (!toRemove.isEmpty()) {
            UI.removeAll(toRemove);
            toRemove.clear();
        }
        if (!toAdd.isEmpty()) {
            UI.addAll(toAdd);
            toAdd.clear();
        }
    }

    public static void setVisibleAllUI(boolean bl) {
        VisibleAllUI = bl;
    }

    public static void setFadeBeforeUI(int n, boolean bl) {
        playerFadeInfo[n].setFadeBeforeUI(bl);
    }

    public static float getFadeAlpha(double d) {
        return playerFadeInfo[(int)d].getFadeAlpha();
    }

    public static void setFadeTime(double d, double d2) {
        playerFadeInfo[(int)d].setFadeTime((int)d2);
    }

    public static void FadeIn(double d, double d2) {
        playerFadeInfo[(int)d].FadeIn((int)d2);
    }

    public static void FadeOut(double d, double d2) {
        playerFadeInfo[(int)d].FadeOut((int)d2);
    }

    public static boolean isFBOActive() {
        return useUIFBO;
    }

    public static double getMillisSinceLastUpdate() {
        return uiUpdateIntervalMS;
    }

    public static double getSecondsSinceLastUpdate() {
        return (double)uiUpdateIntervalMS / 1000.0;
    }

    public static double getMillisSinceLastRender() {
        return uiRenderIntervalMS;
    }

    public static double getSecondsSinceLastRender() {
        return (double)uiRenderIntervalMS / 1000.0;
    }

    public static boolean onKeyPress(int n) {
        for (int i = UI.size() - 1; i >= 0; --i) {
            UIElement uIElement = UI.get(i);
            if (!uIElement.isVisible().booleanValue() || !uIElement.isWantKeyEvents()) continue;
            uIElement.onKeyPress(n);
            if (!uIElement.isKeyConsumed(n)) continue;
            return true;
        }
        return false;
    }

    public static boolean onKeyRepeat(int n) {
        for (int i = UI.size() - 1; i >= 0; --i) {
            UIElement uIElement = UI.get(i);
            if (!uIElement.isVisible().booleanValue() || !uIElement.isWantKeyEvents()) continue;
            uIElement.onKeyRepeat(n);
            if (!uIElement.isKeyConsumed(n)) continue;
            return true;
        }
        return false;
    }

    public static boolean onKeyRelease(int n) {
        for (int i = UI.size() - 1; i >= 0; --i) {
            UIElement uIElement = UI.get(i);
            if (!uIElement.isVisible().booleanValue() || !uIElement.isWantKeyEvents()) continue;
            uIElement.onKeyRelease(n);
            if (!uIElement.isKeyConsumed(n)) continue;
            return true;
        }
        return false;
    }

    public static boolean isForceCursorVisible() {
        for (int i = UI.size() - 1; i >= 0; --i) {
            UIElement uIElement = UI.get(i);
            if (!uIElement.isVisible().booleanValue() || !uIElement.isForceCursorVisible() && !uIElement.isMouseOver().booleanValue()) continue;
            return true;
        }
        return false;
    }

    static {
        UI = new ArrayList();
        toolTip = null;
        MoodleUI = new MoodlesUI[4];
        bFadeBeforeUI = false;
        ProgressBar = new ActionProgressBar[4];
        FadeAlpha = 1.0f;
        FadeInTimeMax = 180;
        FadeInTime = 180;
        FadingOut = false;
        LastPicked = null;
        DoneTutorials = new ArrayList();
        lastOffX = 0.0f;
        lastOffY = 0.0f;
        Modal = null;
        KeyDownZoomIn = false;
        KeyDownZoomOut = false;
        VisibleAllUI = true;
        useUIFBO = false;
        black = null;
        bSuspend = false;
        lastAlpha = 10000.0f;
        PickedTileLocal = new Vector2();
        PickedTile = new Vector2();
        RightDownObject = null;
        uiUpdateTimeMS = 0L;
        uiUpdateIntervalMS = 0L;
        uiRenderTimeMS = 0L;
        uiRenderIntervalMS = 0L;
        tutorialStack = new ArrayList();
        toTop = new ArrayList();
        defaultthread = null;
        previousThread = null;
        toRemove = new ArrayList();
        toAdd = new ArrayList();
        wheel = 0;
        lastwheel = 0;
        debugUI = new ArrayList();
        bShowLuaDebuggerOnError = true;
        luaDebuggerAction = null;
        sync = new Sync();
        showPausedMessage = true;
        playerFadeInfo = new FadeInfo[4];
        for (int i = 0; i < 4; ++i) {
            UIManager.playerFadeInfo[i] = new FadeInfo(i);
        }
    }

    private static class FadeInfo {
        public int playerIndex;
        public boolean bFadeBeforeUI = false;
        public float FadeAlpha = 0.0f;
        public int FadeTime = 2;
        public int FadeTimeMax = 2;
        public boolean FadingOut = false;

        public FadeInfo(int n) {
            this.playerIndex = n;
        }

        public boolean isFadeBeforeUI() {
            return this.bFadeBeforeUI;
        }

        public void setFadeBeforeUI(boolean bl) {
            this.bFadeBeforeUI = bl;
        }

        public float getFadeAlpha() {
            return this.FadeAlpha;
        }

        public void setFadeAlpha(float f) {
            this.FadeAlpha = f;
        }

        public int getFadeTime() {
            return this.FadeTime;
        }

        public void setFadeTime(int n) {
            this.FadeTime = n;
        }

        public int getFadeTimeMax() {
            return this.FadeTimeMax;
        }

        public void setFadeTimeMax(int n) {
            this.FadeTimeMax = n;
        }

        public boolean isFadingOut() {
            return this.FadingOut;
        }

        public void setFadingOut(boolean bl) {
            this.FadingOut = bl;
        }

        public void FadeIn(int n) {
            this.setFadeTimeMax((int)((float)(n * 30) * ((float)PerformanceSettings.getLockFPS() / 30.0f)));
            this.setFadeTime(this.getFadeTimeMax());
            this.setFadingOut(false);
        }

        public void FadeOut(int n) {
            this.setFadeTimeMax((int)((float)(n * 30) * ((float)PerformanceSettings.getLockFPS() / 30.0f)));
            this.setFadeTime(this.getFadeTimeMax());
            this.setFadingOut(true);
        }

        public void update() {
            this.setFadeTime(this.getFadeTime() - 1);
        }

        public void render() {
            this.setFadeAlpha((float)this.getFadeTime() / (float)this.getFadeTimeMax());
            if (this.getFadeAlpha() > 1.0f) {
                this.setFadeAlpha(1.0f);
            }
            if (this.getFadeAlpha() < 0.0f) {
                this.setFadeAlpha(0.0f);
            }
            if (this.isFadingOut()) {
                this.setFadeAlpha(1.0f - this.getFadeAlpha());
            }
            if (this.getFadeAlpha() <= 0.0f) {
                return;
            }
            int n = IsoCamera.getScreenLeft(this.playerIndex);
            int n2 = IsoCamera.getScreenTop(this.playerIndex);
            int n3 = IsoCamera.getScreenWidth(this.playerIndex);
            int n4 = IsoCamera.getScreenHeight(this.playerIndex);
            UIManager.DrawTexture(UIManager.getBlack(), n, n2, n3, n4, this.getFadeAlpha());
        }
    }

    static class Sync {
        private int fps = 30;
        private long period = 1000000000L / (long)this.fps;
        private long excess;
        private long beforeTime = System.nanoTime();
        private long overSleepTime = 0L;

        Sync() {
        }

        void begin() {
            this.beforeTime = System.nanoTime();
            this.overSleepTime = 0L;
        }

        void startFrame() {
            this.excess = 0L;
        }

        void endFrame() {
            long l = System.nanoTime();
            long l2 = l - this.beforeTime;
            long l3 = this.period - l2 - this.overSleepTime;
            if (l3 > 0L) {
                try {
                    Thread.sleep(l3 / 1000000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.overSleepTime = System.nanoTime() - l - l3;
            } else {
                this.excess -= l3;
                this.overSleepTime = 0L;
            }
            this.beforeTime = System.nanoTime();
        }
    }
}

