/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import java.util.Vector;
import se.krka.kahlua.vm.KahluaTable;
import zombie.IndieGL;
import zombie.Lua.LuaManager;
import zombie.core.BoxedStaticValues;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.textures.Texture;
import zombie.debug.DebugOptions;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.ui.UIManager;

public class UIElement {
    static final Color tempcol = new Color(0, 0, 0, 0);
    static final ArrayList<UIElement> toAdd = new ArrayList(0);
    static Texture white;
    static int StencilLevel;
    public boolean capture = false;
    public boolean IgnoreLossControl = false;
    public String clickedValue = null;
    public final ArrayList<UIElement> Controls = new ArrayList();
    public boolean defaultDraw = true;
    public boolean followGameWorld = false;
    private int renderThisPlayerOnly = -1;
    public float height = 256.0f;
    public UIElement Parent = null;
    public boolean visible = true;
    public float width = 256.0f;
    public double x = 0.0;
    public double y = 0.0;
    public KahluaTable table;
    public boolean alwaysBack;
    public boolean bScrollChildren = false;
    public boolean bScrollWithParent = true;
    private boolean bRenderClippedChildren = true;
    public boolean anchorTop = true;
    public boolean anchorLeft = true;
    public boolean anchorRight = false;
    public boolean anchorBottom = false;
    public int playerContext = -1;
    boolean alwaysOnTop = false;
    int maxDrawHeight = -1;
    Double yScroll = 0.0;
    Double xScroll = 0.0;
    int scrollHeight = 0;
    double lastheight = -1.0;
    double lastwidth = -1.0;
    boolean bResizeDirty = false;
    boolean enabled = true;
    private final ArrayList<UIElement> toTop = new ArrayList(0);
    private boolean bConsumeMouseEvents = true;
    private long leftDownTime = 0L;
    private boolean clicked;
    private double clickX;
    private double clickY;
    private String uiname = "";
    private boolean bWantKeyEvents = false;
    private boolean bForceCursorVisible = false;

    public UIElement() {
    }

    public UIElement(KahluaTable kahluaTable) {
        this.table = kahluaTable;
    }

    public Double getMaxDrawHeight() {
        return BoxedStaticValues.toDouble(this.maxDrawHeight);
    }

    public void setMaxDrawHeight(double d) {
        this.maxDrawHeight = (int)d;
    }

    public void clearMaxDrawHeight() {
        this.maxDrawHeight = -1;
    }

    public Double getXScroll() {
        return this.xScroll;
    }

    public void setXScroll(double d) {
        this.xScroll = d;
    }

    public Double getYScroll() {
        return this.yScroll;
    }

    public void setYScroll(double d) {
        this.yScroll = d;
    }

    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    public void backMost() {
        this.alwaysBack = true;
    }

    public void AddChild(UIElement uIElement) {
        this.getControls().add(uIElement);
        uIElement.setParent(this);
    }

    public void RemoveChild(UIElement uIElement) {
        this.getControls().remove(uIElement);
        uIElement.setParent(null);
    }

    public Double getScrollHeight() {
        return BoxedStaticValues.toDouble(this.scrollHeight);
    }

    public void setScrollHeight(double d) {
        this.scrollHeight = (int)d;
    }

    public boolean isConsumeMouseEvents() {
        return this.bConsumeMouseEvents;
    }

    public void setConsumeMouseEvents(boolean bl) {
        this.bConsumeMouseEvents = bl;
    }

    public void ClearChildren() {
        this.getControls().clear();
    }

    public void ButtonClicked(String string) {
        this.setClickedValue(string);
    }

    public void DrawText(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        TextManager.instance.DrawString(uIFont, d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, (float)d3, string, d4, d5, d6, d7);
    }

    public void DrawText(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        TextManager.instance.DrawString(d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawText(String string, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        TextManager.instance.DrawString(d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d5, d6, d7, d8);
    }

    public void DrawText(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (string == null) {
            return;
        }
        int n = (int)(d2 + this.getAbsoluteY() + this.yScroll);
        if (n + 100 < 0 || n > 4096) {
            return;
        }
        TextManager.instance.DrawString(uIFont, d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextUntrimmed(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        if (string == null) {
            return;
        }
        TextManager.instance.DrawStringUntrimmed(uIFont, d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextCentre(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        TextManager.instance.DrawStringCentre(d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextCentre(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        TextManager.instance.DrawStringCentre(uIFont, d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextRight(String string, double d, double d2, double d3, double d4, double d5, double d6) {
        TextManager.instance.DrawStringRight(d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextRight(UIFont uIFont, String string, double d, double d2, double d3, double d4, double d5, double d6) {
        TextManager.instance.DrawStringRight(uIFont, d + this.getAbsoluteX() + this.xScroll, d2 + this.getAbsoluteY() + this.yScroll, string, d3, d4, d5, d6);
    }

    public void DrawTextureAngle(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        float f = texture.getWidth() / 2;
        float f2 = texture.getHeight() / 2;
        double d8 = Math.toRadians(180.0 + d3);
        double d9 = Math.cos(d8) * (double)f;
        double d10 = Math.sin(d8) * (double)f;
        double d11 = Math.cos(d8) * (double)f2;
        double d12 = Math.sin(d8) * (double)f2;
        double d13 = d9 - d12;
        double d14 = d11 + d10;
        double d15 = -d9 - d12;
        double d16 = d11 - d10;
        double d17 = -d9 + d12;
        double d18 = -d11 - d10;
        double d19 = d9 + d12;
        double d20 = -d11 + d10;
        SpriteRenderer.instance.render(texture, d13 += this.getAbsoluteX() + d, d14 += this.getAbsoluteY() + d2, d15 += this.getAbsoluteX() + d, d16 += this.getAbsoluteY() + d2, d17 += this.getAbsoluteX() + d, d18 += this.getAbsoluteY() + d2, d19 += this.getAbsoluteX() + d, d20 += this.getAbsoluteY() + d2, (float)d4, (float)d5, (float)d6, (float)d7, (float)d4, (float)d5, (float)d6, (float)d7, (float)d4, (float)d5, (float)d6, (float)d7, (float)d4, (float)d5, (float)d6, (float)d7, null);
    }

    public void DrawTextureAngle(Texture texture, double d, double d2, double d3) {
        this.DrawTextureAngle(texture, d, d2, d3, 1.0, 1.0, 1.0, 1.0);
    }

    public void DrawTexture(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        SpriteRenderer.instance.render(texture, d, d2, d3, d4, d5, d6, d7, d8, (float)d9, (float)d10, (float)d11, (float)d12, (float)d9, (float)d10, (float)d11, (float)d12, (float)d9, (float)d10, (float)d11, (float)d12, (float)d9, (float)d10, (float)d11, (float)d12, null);
    }

    public void DrawTexture(Texture texture, double d, double d2, double d3) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d4 = d + this.getAbsoluteX();
        double d5 = d2 + this.getAbsoluteY();
        d4 += (double)texture.offsetX;
        int n = (int)((d5 += (double)texture.offsetY) + this.yScroll);
        if (n + texture.getHeight() < 0 || n > 4096) {
            return;
        }
        SpriteRenderer.instance.renderi(texture, (int)(d4 + this.xScroll), (int)(d5 + this.yScroll), texture.getWidth(), texture.getHeight(), 1.0f, 1.0f, 1.0f, (float)d3, null);
    }

    public void DrawTextureCol(Texture texture, double d, double d2, Color color) {
        int n;
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d3 = d + this.getAbsoluteX();
        double d4 = d2 + this.getAbsoluteY();
        int n2 = 0;
        int n3 = 0;
        if (texture != null) {
            d3 += (double)texture.offsetX;
            d4 += (double)texture.offsetY;
            n2 = texture.getWidth();
            n3 = texture.getHeight();
        }
        if ((n = (int)(d4 + this.yScroll)) + n3 < 0 || n > 4096) {
            return;
        }
        SpriteRenderer.instance.renderi(texture, (int)(d3 + this.xScroll), (int)(d4 + this.yScroll), n2, n3, color.r, color.g, color.b, color.a, null);
    }

    public void DrawTextureScaled(Texture texture, double d, double d2, double d3, double d4, double d5) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d6 = d + this.getAbsoluteX();
        double d7 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.renderi(texture, (int)(d6 + this.xScroll), (int)(d7 + this.yScroll), (int)d3, (int)d4, 1.0f, 1.0f, 1.0f, (float)d5, null);
    }

    public void DrawTextureScaledUniform(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (!this.isVisible().booleanValue() || texture == null) {
            return;
        }
        double d8 = d + this.getAbsoluteX();
        double d9 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.renderi(texture, (int)((d8 += (double)texture.offsetX * d3) + this.xScroll), (int)((d9 += (double)texture.offsetY * d3) + this.yScroll), (int)((double)texture.getWidth() * d3), (int)((double)texture.getHeight() * d3), (float)d4, (float)d5, (float)d6, (float)d7, null);
    }

    public void DrawTextureScaledAspect(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (!this.isVisible().booleanValue() || texture == null) {
            return;
        }
        double d9 = d + this.getAbsoluteX();
        double d10 = d2 + this.getAbsoluteY();
        if (texture.getWidth() > 0 && texture.getHeight() > 0 && d3 > 0.0 && d4 > 0.0) {
            double d11 = Math.min(d3 / (double)texture.getWidthOrig(), d4 / (double)texture.getHeightOrig());
            double d12 = d3;
            double d13 = d4;
            d3 = (double)texture.getWidth() * d11;
            d4 = (double)texture.getHeight() * d11;
            d9 -= (d3 - d12) / 2.0;
            d10 -= (d4 - d13) / 2.0;
        }
        SpriteRenderer.instance.renderi(texture, (int)(d9 + this.xScroll), (int)(d10 + this.yScroll), (int)d3, (int)d4, (float)d5, (float)d6, (float)d7, (float)d8, null);
    }

    public void DrawTextureScaledAspect2(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (!this.isVisible().booleanValue() || texture == null) {
            return;
        }
        double d9 = d + this.getAbsoluteX();
        double d10 = d2 + this.getAbsoluteY();
        if (texture.getWidth() > 0 && texture.getHeight() > 0 && d3 > 0.0 && d4 > 0.0) {
            double d11 = Math.min(d3 / (double)texture.getWidth(), d4 / (double)texture.getHeight());
            double d12 = d3;
            double d13 = d4;
            d3 = (double)texture.getWidth() * d11;
            d4 = (double)texture.getHeight() * d11;
            d9 -= (d3 - d12) / 2.0;
            d10 -= (d4 - d13) / 2.0;
        }
        SpriteRenderer.instance.render(texture, (int)(d9 + this.xScroll), (int)(d10 + this.yScroll), (int)d3, (int)d4, (float)d5, (float)d6, (float)d7, (float)d8, null);
    }

    public void DrawTextureScaledCol(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (texture != null) {
            boolean bl = false;
        }
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d9 = d + this.getAbsoluteX();
        double d10 = d2 + this.getAbsoluteY();
        int n = (int)(d10 + this.yScroll);
        if ((double)n + d4 < 0.0 || n > 4096) {
            return;
        }
        SpriteRenderer.instance.renderi(texture, (int)(d9 + this.xScroll), (int)(d10 + this.yScroll), (int)d3, (int)d4, (float)d5, (float)d6, (float)d7, (float)d8, null);
    }

    public void DrawTextureScaledCol(Texture texture, double d, double d2, double d3, double d4, Color color) {
        if (texture != null) {
            boolean bl = false;
        }
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d5 = d + this.getAbsoluteX();
        double d6 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.render(texture, (int)(d5 + this.xScroll), (int)(d6 + this.yScroll), (int)d3, (int)d4, color.r, color.g, color.b, color.a, null);
    }

    public void DrawTextureScaledColor(Texture texture, Double d, Double d2, Double d3, Double d4, Double d5, Double d6, Double d7, Double d8) {
        this.DrawTextureScaledCol(texture, d, d2, d3, d4, d5, d6, d7, d8);
    }

    public void DrawTextureColor(Texture texture, double d, double d2, double d3, double d4, double d5, double d6) {
        UIElement.tempcol.r = (float)d3;
        UIElement.tempcol.g = (float)d4;
        UIElement.tempcol.b = (float)d5;
        UIElement.tempcol.a = (float)d6;
        this.DrawTextureCol(texture, d, d2, tempcol);
    }

    public void DrawSubTextureRGBA(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        if (texture == null || this.isVisible() == false || d3 <= 0.0 || d4 <= 0.0 || d7 <= 0.0 || d8 <= 0.0) {
            return;
        }
        double d13 = d5 + this.getAbsoluteX() + this.xScroll;
        double d14 = d6 + this.getAbsoluteY() + this.yScroll;
        d13 += (double)texture.offsetX;
        if ((d14 += (double)texture.offsetY) + d8 < 0.0 || d14 > 4096.0) {
            return;
        }
        float f = PZMath.clamp((float)d, 0.0f, (float)texture.getWidth());
        float f2 = PZMath.clamp((float)d2, 0.0f, (float)texture.getHeight());
        float f3 = PZMath.clamp((float)((double)f + d3), 0.0f, (float)texture.getWidth()) - f;
        float f4 = PZMath.clamp((float)((double)f2 + d4), 0.0f, (float)texture.getHeight()) - f2;
        float f5 = f / (float)texture.getWidth();
        float f6 = f2 / (float)texture.getHeight();
        float f7 = (f + f3) / (float)texture.getWidth();
        float f8 = (f2 + f4) / (float)texture.getHeight();
        float f9 = texture.getXEnd() - texture.getXStart();
        float f10 = texture.getYEnd() - texture.getYStart();
        f5 = texture.getXStart() + f5 * f9;
        f7 = texture.getXStart() + f7 * f9;
        f6 = texture.getYStart() + f6 * f10;
        f8 = texture.getYStart() + f8 * f10;
        SpriteRenderer.instance.render(texture, (float)d13, (float)d14, (float)d7, (float)d8, (float)d9, (float)d10, (float)d11, (float)d12, f5, f6, f7, f6, f7, f8, f5, f8);
    }

    public void DrawTextureTiled(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (texture == null || !this.isVisible().booleanValue() || d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        for (double d9 = d2; d9 < d2 + d4; d9 += (double)texture.getHeight()) {
            for (double d10 = d; d10 < d + d3; d10 += (double)texture.getWidth()) {
                double d11 = texture.getWidth();
                double d12 = texture.getHeight();
                if (d10 + d11 > d + d3) {
                    d11 = d + d3 - d10;
                }
                if (d9 + (double)texture.getHeight() > d2 + d4) {
                    d12 = d2 + d4 - d9;
                }
                this.DrawSubTextureRGBA(texture, 0.0, 0.0, d11, d12, d10, d9, d11, d12, d5, d6, d7, d8);
            }
        }
    }

    public void DrawTextureTiledX(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (texture == null || !this.isVisible().booleanValue() || d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        for (double d9 = d; d9 < d + d3; d9 += (double)texture.getWidth()) {
            double d10 = texture.getWidth();
            double d11 = texture.getHeight();
            if (d9 + d10 > d + d3) {
                d10 = d + d3 - d9;
            }
            this.DrawSubTextureRGBA(texture, 0.0, 0.0, d10, d11, d9, d2, d10, d11, d5, d6, d7, d8);
        }
    }

    public void DrawTextureTiledY(Texture texture, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        if (texture == null || !this.isVisible().booleanValue() || d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        for (double d9 = d2; d9 < d2 + d4; d9 += (double)texture.getHeight()) {
            double d10 = texture.getWidth();
            double d11 = texture.getHeight();
            if (d9 + (double)texture.getHeight() > d2 + d4) {
                d11 = d2 + d4 - d9;
            }
            this.DrawSubTextureRGBA(texture, 0.0, 0.0, d10, d11, d, d9, d10, d11, d5, d6, d7, d8);
        }
    }

    public void DrawTextureIgnoreOffset(Texture texture, double d, double d2, int n, int n2, Color color) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d3 = d + this.getAbsoluteX();
        double d4 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.render(texture, (int)(d3 + this.xScroll), (int)(d4 + this.yScroll), n, n2, color.r, color.g, color.b, color.a, null);
    }

    public void DrawTexture_FlippedX(Texture texture, double d, double d2, int n, int n2, Color color) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d3 = d + this.getAbsoluteX();
        double d4 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.renderflipped(texture, (float)(d3 + this.xScroll), (float)(d4 + this.yScroll), n, n2, color.r, color.g, color.b, color.a, null);
    }

    public void DrawTexture_FlippedXIgnoreOffset(Texture texture, double d, double d2, int n, int n2, Color color) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d3 = d + this.getAbsoluteX();
        double d4 = d2 + this.getAbsoluteY();
        SpriteRenderer.instance.renderflipped(texture, (float)(d3 + this.xScroll), (float)(d4 + this.yScroll), n, n2, color.r, color.g, color.b, color.a, null);
    }

    public void DrawUVSliceTexture(Texture texture, double d, double d2, double d3, double d4, Color color, double d5, double d6, double d7, double d8) {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        double d9 = d + this.getAbsoluteX();
        double d10 = d2 + this.getAbsoluteY();
        d9 += (double)texture.offsetX;
        d10 += (double)texture.offsetY;
        Texture.lr = color.r;
        Texture.lg = color.g;
        Texture.lb = color.b;
        Texture.la = color.a;
        double d11 = texture.getXStart();
        double d12 = texture.getYStart();
        double d13 = texture.getXEnd();
        double d14 = texture.getYEnd();
        double d15 = d13 - d11;
        double d16 = d14 - d12;
        double d17 = d7 - d5;
        double d18 = d8 - d6;
        double d19 = d17 / 1.0;
        double d20 = d18 / 1.0;
        d11 += d5 * d15;
        d12 += d6 * d16;
        d13 -= (1.0 - d7) * d15;
        d14 -= (1.0 - d8) * d16;
        d11 = (float)((int)(d11 * 1000.0)) / 1000.0f;
        d13 = (float)((int)(d13 * 1000.0)) / 1000.0f;
        d12 = (float)((int)(d12 * 1000.0)) / 1000.0f;
        d14 = (float)((int)(d14 * 1000.0)) / 1000.0f;
        double d21 = d9 + d3;
        double d22 = d10 + d4;
        SpriteRenderer.instance.render(texture, (float)(d9 += d5 * d3) + (float)this.getXScroll().intValue(), (float)(d10 += d6 * d4) + (float)this.getYScroll().intValue(), (float)((d21 -= (1.0 - d7) * d3) - d9), (float)((d22 -= (1.0 - d8) * d4) - d10), color.r, color.g, color.b, color.a, (float)d11, (float)d12, (float)d13, (float)d12, (float)d13, (float)d14, (float)d11, (float)d14);
    }

    public Boolean getScrollChildren() {
        return this.bScrollChildren ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setScrollChildren(boolean bl) {
        this.bScrollChildren = bl;
    }

    public Boolean getScrollWithParent() {
        return this.bScrollWithParent ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setScrollWithParent(boolean bl) {
        this.bScrollWithParent = bl;
    }

    public void setRenderClippedChildren(boolean bl) {
        this.bRenderClippedChildren = bl;
    }

    public Double getAbsoluteX() {
        if (this.getParent() != null) {
            if (this.getParent().getScrollChildren().booleanValue() && this.getScrollWithParent().booleanValue()) {
                return BoxedStaticValues.toDouble(this.getParent().getAbsoluteX() + (double)this.getX().intValue() + (double)this.getParent().getXScroll().intValue());
            }
            return BoxedStaticValues.toDouble(this.getParent().getAbsoluteX() + (double)this.getX().intValue());
        }
        return BoxedStaticValues.toDouble(this.getX().intValue());
    }

    public Double getAbsoluteY() {
        if (this.getParent() != null) {
            if (this.getParent().getScrollChildren().booleanValue() && this.getScrollWithParent().booleanValue()) {
                return BoxedStaticValues.toDouble(this.getParent().getAbsoluteY() + (double)this.getY().intValue() + (double)this.getParent().getYScroll().intValue());
            }
            return BoxedStaticValues.toDouble(this.getParent().getAbsoluteY() + (double)this.getY().intValue());
        }
        return BoxedStaticValues.toDouble(this.getY().intValue());
    }

    public String getClickedValue() {
        return this.clickedValue;
    }

    public void setClickedValue(String string) {
        this.clickedValue = string;
    }

    public void bringToTop() {
        UIManager.pushToTop(this);
        if (this.Parent != null) {
            this.Parent.addBringToTop(this);
        }
    }

    void onRightMouseUpOutside(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onRightMouseUpOutside") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseUpOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            uIElement.onRightMouseUpOutside(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue());
        }
    }

    void onRightMouseDownOutside(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onRightMouseDownOutside") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseDownOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            uIElement.onRightMouseDownOutside(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue());
        }
    }

    public void onMouseUpOutside(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseUpOutside") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseUpOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            uIElement.onMouseUpOutside(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue());
        }
    }

    void onMouseDownOutside(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseDownOutside") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseDownOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            uIElement.onMouseDownOutside(d - (double)uIElement.getX().intValue(), d2 - (double)uIElement.getY().intValue());
        }
    }

    public Boolean onMouseDown(double d, double d2) {
        if (this.clicked && UIManager.isDoubleClick((int)this.clickX, (int)this.clickY, (int)d, (int)d2, this.leftDownTime).booleanValue() && this.getTable() != null && this.getTable().rawget((Object)"onMouseDoubleClick") != null) {
            this.clicked = false;
            return this.onMouseDoubleClick(d, d2) != false ? Boolean.TRUE : Boolean.FALSE;
        }
        this.clicked = true;
        this.clickX = d;
        this.clickY = d2;
        this.leftDownTime = System.currentTimeMillis();
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (!this.visible) {
            return Boolean.FALSE;
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"onFocus") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onFocus"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        boolean bl = false;
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (!bl && (d > uIElement.getXScrolled(this) && d2 > uIElement.getYScrolled(this) && d < uIElement.getXScrolled(this) + uIElement.getWidth() && d2 < uIElement.getYScrolled(this) + uIElement.getHeight() || uIElement.isCapture().booleanValue())) {
                if (!uIElement.onMouseDown(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue()).booleanValue()) continue;
                bl = true;
                continue;
            }
            if (uIElement.getTable() == null || uIElement.getTable().rawget((Object)"onMouseDownOutside") == null) continue;
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), uIElement.getTable().rawget((Object)"onMouseDownOutside"), (Object)uIElement.getTable(), (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        if (this.getTable() != null) {
            if (bl) {
                if (this.getTable().rawget((Object)"onMouseDownOutside") != null) {
                    Boolean bl2 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseDownOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                    if (bl2 == null) {
                        return Boolean.TRUE;
                    }
                    if (bl2 == Boolean.TRUE) {
                        return Boolean.TRUE;
                    }
                }
            } else if (this.getTable().rawget((Object)"onMouseDown") != null) {
                Boolean bl3 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseDown"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                if (bl3 == null) {
                    return Boolean.TRUE;
                }
                if (bl3 == Boolean.TRUE) {
                    return Boolean.TRUE;
                }
            }
        }
        return bl;
    }

    private Boolean onMouseDoubleClick(double d, double d2) {
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= this.y) {
            return Boolean.FALSE;
        }
        if (!this.visible) {
            return Boolean.FALSE;
        }
        if (this.getTable().rawget((Object)"onMouseDoubleClick") != null) {
            Boolean bl = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseDoubleClick"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
            if (bl == null) {
                return Boolean.TRUE;
            }
            if (bl == Boolean.TRUE) {
                return Boolean.TRUE;
            }
        }
        return Boolean.TRUE;
    }

    public Boolean onMouseWheel(double d) {
        Boolean bl;
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseWheel") != null && (bl = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseWheel"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d))) == Boolean.TRUE) {
            return Boolean.TRUE;
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (!uIElement.isVisible().booleanValue() || !((double)n >= uIElement.getAbsoluteX() && (double)n2 >= uIElement.getAbsoluteY() && (double)n < uIElement.getAbsoluteX() + uIElement.getWidth() && (double)n2 < uIElement.getAbsoluteY() + uIElement.getHeight()) && !uIElement.isCapture().booleanValue() || !uIElement.onMouseWheel(d).booleanValue()) continue;
            return this.bConsumeMouseEvents ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean onMouseMove(double d, double d2) {
        int n = Mouse.getXA();
        int n2 = Mouse.getYA();
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= (double)n2 - this.getAbsoluteY()) {
            return Boolean.FALSE;
        }
        if (!this.visible) {
            return Boolean.FALSE;
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseMove") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseMove"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d), (Object)BoxedStaticValues.toDouble(d2));
        }
        boolean bl = false;
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if ((double)n >= uIElement.getAbsoluteX() && (double)n2 >= uIElement.getAbsoluteY() && (double)n < uIElement.getAbsoluteX() + uIElement.getWidth() && (double)n2 < uIElement.getAbsoluteY() + uIElement.getHeight() || uIElement.isCapture().booleanValue()) {
                if (bl || !uIElement.onMouseMove(d, d2).booleanValue()) continue;
                bl = true;
                continue;
            }
            uIElement.onMouseMoveOutside(d, d2);
        }
        return this.bConsumeMouseEvents ? Boolean.TRUE : Boolean.FALSE;
    }

    public void onMouseMoveOutside(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseMoveOutside") != null) {
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseMoveOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d), (Object)BoxedStaticValues.toDouble(d2));
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            uIElement.onMouseMoveOutside(d, d2);
        }
    }

    public Boolean onMouseUp(double d, double d2) {
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (!this.visible) {
            return Boolean.FALSE;
        }
        boolean bl = false;
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (!bl && (d >= uIElement.getXScrolled(this) && d2 >= uIElement.getYScrolled(this) && d < uIElement.getXScrolled(this) + uIElement.getWidth() && d2 < uIElement.getYScrolled(this) + uIElement.getHeight() || uIElement.isCapture().booleanValue())) {
                if (uIElement.onMouseUp(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue()).booleanValue()) {
                    bl = true;
                }
            } else {
                uIElement.onMouseUpOutside(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue());
            }
            i = PZMath.min(i, this.getControls().size());
        }
        if (this.getTable() != null) {
            if (bl) {
                if (this.getTable().rawget((Object)"onMouseUpOutside") != null) {
                    Boolean bl2 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseUpOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                    if (bl2 == null) {
                        return Boolean.TRUE;
                    }
                    if (bl2 == Boolean.TRUE) {
                        return Boolean.TRUE;
                    }
                }
            } else if (this.getTable().rawget((Object)"onMouseUp") != null) {
                Boolean bl3 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onMouseUp"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                if (bl3 == null) {
                    return Boolean.TRUE;
                }
                if (bl3 == Boolean.TRUE) {
                    return Boolean.TRUE;
                }
            }
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void onresize() {
    }

    public void onResize() {
        if (this.Parent != null && this.Parent.bResizeDirty) {
            double d = this.Parent.getWidth() - this.Parent.lastwidth;
            double d2 = this.Parent.getHeight() - this.Parent.lastheight;
            if (!this.anchorTop && this.anchorBottom) {
                this.setY(this.getY() + d2);
            }
            if (this.anchorTop && this.anchorBottom) {
                this.setHeight(this.getHeight() + d2);
            }
            if (!this.anchorLeft && this.anchorRight) {
                this.setX(this.getX() + d);
            }
            if (this.anchorLeft && this.anchorRight) {
                this.setWidth(this.getWidth() + d);
            }
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"onResize") != null) {
            LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onResize"), (Object)this.table, (Object)this.getWidth(), (Object)this.getHeight());
        }
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (uIElement == null) {
                this.getControls().remove(i);
                continue;
            }
            uIElement.onResize();
        }
        this.bResizeDirty = false;
        this.lastwidth = this.getWidth();
        this.lastheight = this.getHeight();
    }

    public Boolean onRightMouseDown(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        boolean bl = false;
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (!bl && (d >= uIElement.getXScrolled(this) && d2 >= uIElement.getYScrolled(this) && d < uIElement.getXScrolled(this) + uIElement.getWidth() && d2 < uIElement.getYScrolled(this) + uIElement.getHeight() || uIElement.isCapture().booleanValue())) {
                if (!uIElement.onRightMouseDown(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue()).booleanValue()) continue;
                bl = true;
                continue;
            }
            if (uIElement.getTable() == null || uIElement.getTable().rawget((Object)"onRightMouseDownOutside") == null) continue;
            LuaManager.caller.protectedCallVoid(UIManager.getDefaultThread(), uIElement.getTable().rawget((Object)"onRightMouseDownOutside"), (Object)uIElement.getTable(), (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
        }
        if (this.getTable() != null) {
            if (bl) {
                if (this.getTable().rawget((Object)"onRightMouseDownOutside") != null) {
                    Boolean bl2 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseDownOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                    if (bl2 == null) {
                        return Boolean.TRUE;
                    }
                    if (bl2 == Boolean.TRUE) {
                        return Boolean.TRUE;
                    }
                }
            } else if (this.getTable().rawget((Object)"onRightMouseDown") != null) {
                Boolean bl3 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseDown"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                if (bl3 == null) {
                    return Boolean.TRUE;
                }
                if (bl3 == Boolean.TRUE) {
                    return Boolean.TRUE;
                }
            }
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean onRightMouseUp(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        if (this.maxDrawHeight != -1 && (double)this.maxDrawHeight <= d2) {
            return Boolean.FALSE;
        }
        boolean bl = false;
        for (int i = this.getControls().size() - 1; i >= 0; --i) {
            UIElement uIElement = this.getControls().get(i);
            if (!bl && (d >= uIElement.getXScrolled(this) && d2 >= uIElement.getYScrolled(this) && d < uIElement.getXScrolled(this) + uIElement.getWidth() && d2 < uIElement.getYScrolled(this) + uIElement.getHeight() || uIElement.isCapture().booleanValue())) {
                if (!uIElement.onRightMouseUp(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue()).booleanValue()) continue;
                bl = true;
                continue;
            }
            uIElement.onRightMouseUpOutside(d - (double)uIElement.getXScrolled(this).intValue(), d2 - (double)uIElement.getYScrolled(this).intValue());
        }
        if (this.getTable() != null) {
            if (bl) {
                if (this.getTable().rawget((Object)"onRightMouseUpOutside") != null) {
                    Boolean bl2 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseUpOutside"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                    if (bl2 == null) {
                        return Boolean.TRUE;
                    }
                    if (bl2 == Boolean.TRUE) {
                        return Boolean.TRUE;
                    }
                }
            } else if (this.getTable().rawget((Object)"onRightMouseUp") != null) {
                Boolean bl3 = LuaManager.caller.protectedCallBoolean(UIManager.getDefaultThread(), this.getTable().rawget((Object)"onRightMouseUp"), (Object)this.table, (Object)BoxedStaticValues.toDouble(d - this.xScroll), (Object)BoxedStaticValues.toDouble(d2 - this.yScroll));
                if (bl3 == null) {
                    return Boolean.TRUE;
                }
                if (bl3 == Boolean.TRUE) {
                    return Boolean.TRUE;
                }
            }
        }
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void RemoveControl(UIElement uIElement) {
        this.getControls().remove(uIElement);
        uIElement.setParent(null);
    }

    public void render() {
        if (!this.enabled) {
            return;
        }
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (this.Parent != null && this.Parent.maxDrawHeight != -1 && (double)this.Parent.maxDrawHeight <= this.y) {
            return;
        }
        if (this.Parent != null && !this.Parent.bRenderClippedChildren) {
            Double d = this.Parent.getAbsoluteY();
            double d2 = this.getAbsoluteY();
            if (d2 + this.getHeight() <= d || d2 >= d + this.getParent().getHeight()) {
                return;
            }
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"prerender") != null) {
            try {
                LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"prerender"), (Object)this.table);
            }
            catch (Exception exception) {
                boolean bl = false;
            }
        }
        for (int i = 0; i < this.getControls().size(); ++i) {
            this.getControls().get(i).render();
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"render") != null) {
            LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"render"), (Object)this.table);
        }
        if (Core.bDebug && DebugOptions.instance.UIRenderOutline.getValue()) {
            if (this.table != null && "ISScrollingListBox".equals(this.table.rawget((Object)"Type"))) {
                this.repaintStencilRect(0.0, 0.0, (int)this.width, (int)this.height);
            }
            Double d = -this.getXScroll().doubleValue();
            Double d3 = -this.getYScroll().doubleValue();
            double d4 = 1.0;
            if (this.isMouseOver().booleanValue()) {
                d4 = 0.0;
            }
            double d5 = this.maxDrawHeight == -1 ? (double)this.height : (double)this.maxDrawHeight;
            this.DrawTextureScaledColor(null, d, d3, 1.0, d5, d4, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d + 1.0, d3, (double)this.width - 2.0, 1.0, d4, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d + (double)this.width - 1.0, d3, 1.0, d5, d4, 1.0, 1.0, 0.5);
            this.DrawTextureScaledColor(null, d + 1.0, d3 + d5 - 1.0, (double)this.width - 2.0, 1.0, d4, 1.0, 1.0, 0.5);
        }
    }

    public void update() {
        int n;
        if (!this.enabled) {
            return;
        }
        for (n = 0; n < this.Controls.size(); ++n) {
            if (!this.toTop.contains(this.Controls.get(n))) continue;
            UIElement uIElement = this.Controls.remove(n);
            --n;
            toAdd.add(uIElement);
        }
        this.Controls.addAll(toAdd);
        toAdd.clear();
        this.toTop.clear();
        if (UIManager.doTick && this.getTable() != null && this.getTable().rawget((Object)"update") != null) {
            LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), this.getTable().rawget((Object)"update"), (Object)this.table);
        }
        if (this.bResizeDirty) {
            this.onResize();
            this.lastwidth = this.width;
            this.lastheight = this.height;
            this.bResizeDirty = false;
        }
        for (n = 0; n < this.getControls().size(); ++n) {
            this.getControls().get(n).update();
        }
    }

    public void BringToTop(UIElement uIElement) {
        this.getControls().remove(uIElement);
        this.getControls().add(uIElement);
    }

    public Boolean isCapture() {
        return this.capture ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setCapture(boolean bl) {
        this.capture = bl;
    }

    public Boolean isIgnoreLossControl() {
        return this.IgnoreLossControl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setIgnoreLossControl(boolean bl) {
        this.IgnoreLossControl = bl;
    }

    public ArrayList<UIElement> getControls() {
        return this.Controls;
    }

    public void setControls(Vector<UIElement> vector) {
        this.setControls(vector);
    }

    public Boolean isDefaultDraw() {
        return this.defaultDraw ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultDraw(boolean bl) {
        this.defaultDraw = bl;
    }

    public Boolean isFollowGameWorld() {
        return this.followGameWorld ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setFollowGameWorld(boolean bl) {
        this.followGameWorld = bl;
    }

    public int getRenderThisPlayerOnly() {
        return this.renderThisPlayerOnly;
    }

    public void setRenderThisPlayerOnly(int n) {
        this.renderThisPlayerOnly = n;
    }

    public Double getHeight() {
        return BoxedStaticValues.toDouble(this.height);
    }

    public void setHeight(double d) {
        if ((double)this.height != d) {
            this.bResizeDirty = true;
        }
        this.lastheight = this.height;
        this.height = (float)d;
    }

    public UIElement getParent() {
        return this.Parent;
    }

    public void setParent(UIElement uIElement) {
        this.Parent = uIElement;
    }

    public Boolean isVisible() {
        return this.visible ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public Double getWidth() {
        return BoxedStaticValues.toDouble(this.width);
    }

    public void setWidth(double d) {
        if ((double)this.width != d) {
            this.bResizeDirty = true;
        }
        this.lastwidth = this.width;
        this.width = (float)d;
    }

    public Double getX() {
        return BoxedStaticValues.toDouble(this.x);
    }

    public void setX(double d) {
        this.x = (float)d;
    }

    public Double getXScrolled(UIElement uIElement) {
        if (uIElement != null && uIElement.bScrollChildren && this.bScrollWithParent) {
            return BoxedStaticValues.toDouble(this.x + uIElement.getXScroll());
        }
        return BoxedStaticValues.toDouble(this.x);
    }

    public Double getYScrolled(UIElement uIElement) {
        if (uIElement != null && uIElement.bScrollChildren && this.bScrollWithParent) {
            return BoxedStaticValues.toDouble(this.y + uIElement.getYScroll());
        }
        return BoxedStaticValues.toDouble(this.y);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Double getY() {
        return BoxedStaticValues.toDouble(this.y);
    }

    public void setY(double d) {
        this.y = (float)d;
    }

    public void suspendStencil() {
        IndieGL.disableStencilTest();
        IndieGL.disableAlphaTest();
    }

    public void resumeStencil() {
        IndieGL.enableStencilTest();
        IndieGL.enableAlphaTest();
    }

    public void setStencilRect(double d, double d2, double d3, double d4) {
        d += this.getAbsoluteX().doubleValue();
        d2 += this.getAbsoluteY().doubleValue();
        IndieGL.glStencilMask(255);
        IndieGL.enableStencilTest();
        IndieGL.enableAlphaTest();
        IndieGL.glStencilFunc(519, ++StencilLevel, 255);
        IndieGL.glStencilOp(7680, 7680, 7681);
        IndieGL.glColorMask(false, false, false, false);
        SpriteRenderer.instance.renderi(null, (int)d, (int)d2, (int)d3, (int)d4, 1.0f, 0.0f, 0.0f, 1.0f, null);
        IndieGL.glColorMask(true, true, true, true);
        IndieGL.glStencilOp(7680, 7680, 7680);
        IndieGL.glStencilFunc(514, StencilLevel, 255);
    }

    public void clearStencilRect() {
        if (StencilLevel > 0) {
            --StencilLevel;
        }
        if (StencilLevel > 0) {
            IndieGL.glStencilFunc(514, StencilLevel, 255);
        } else {
            IndieGL.glAlphaFunc(519, 0.0f);
            IndieGL.disableStencilTest();
            IndieGL.disableAlphaTest();
            IndieGL.glStencilFunc(519, 255, 255);
            IndieGL.glStencilOp(7680, 7680, 7680);
            IndieGL.glClear(1280);
        }
    }

    public void repaintStencilRect(double d, double d2, double d3, double d4) {
        if (StencilLevel <= 0) {
            return;
        }
        IndieGL.glStencilFunc(519, StencilLevel, 255);
        IndieGL.glStencilOp(7680, 7680, 7681);
        IndieGL.glColorMask(false, false, false, false);
        SpriteRenderer.instance.renderi(null, (int)(d += this.getAbsoluteX().doubleValue()), (int)(d2 += this.getAbsoluteY().doubleValue()), (int)d3, (int)d4, 1.0f, 0.0f, 0.0f, 1.0f, null);
        IndieGL.glColorMask(true, true, true, true);
        IndieGL.glStencilOp(7680, 7680, 7680);
        IndieGL.glStencilFunc(514, StencilLevel, 255);
    }

    public KahluaTable getTable() {
        return this.table;
    }

    public void setTable(KahluaTable kahluaTable) {
        this.table = kahluaTable;
    }

    public void setHeightSilent(double d) {
        this.lastheight = this.height;
        this.height = (float)d;
    }

    public void setWidthSilent(double d) {
        this.lastwidth = this.width;
        this.width = (float)d;
    }

    public void setHeightOnly(double d) {
        this.height = (float)d;
    }

    public void setWidthOnly(double d) {
        this.width = (float)d;
    }

    public boolean isAnchorTop() {
        return this.anchorTop;
    }

    public void setAnchorTop(boolean bl) {
        this.anchorTop = bl;
        this.lastwidth = this.width;
        this.lastheight = this.height;
    }

    public void ignoreWidthChange() {
        this.lastwidth = this.width;
    }

    public void ignoreHeightChange() {
        this.lastheight = this.height;
    }

    public Boolean isAnchorLeft() {
        return this.anchorLeft ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAnchorLeft(boolean bl) {
        this.anchorLeft = bl;
        this.lastwidth = this.width;
        this.lastheight = this.height;
    }

    public Boolean isAnchorRight() {
        return this.anchorRight ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAnchorRight(boolean bl) {
        this.anchorRight = bl;
        this.lastwidth = this.width;
        this.lastheight = this.height;
    }

    public Boolean isAnchorBottom() {
        return this.anchorBottom ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setAnchorBottom(boolean bl) {
        this.anchorBottom = bl;
        this.lastwidth = this.width;
        this.lastheight = this.height;
    }

    private void addBringToTop(UIElement uIElement) {
        this.toTop.add(uIElement);
    }

    public int getPlayerContext() {
        return this.playerContext;
    }

    public void setPlayerContext(int n) {
        this.playerContext = n;
    }

    public String getUIName() {
        return this.uiname;
    }

    public void setUIName(String string) {
        this.uiname = string != null ? string : "";
    }

    public Double clampToParentX(double d) {
        if (this.getParent() == null) {
            return BoxedStaticValues.toDouble(d);
        }
        double d2 = this.getParent().clampToParentX(this.getParent().getAbsoluteX());
        double d3 = this.getParent().clampToParentX(d2 + (double)this.getParent().getWidth().intValue());
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return BoxedStaticValues.toDouble(d);
    }

    public Double clampToParentY(double d) {
        if (this.getParent() == null) {
            return d;
        }
        double d2 = this.getParent().clampToParentY(this.getParent().getAbsoluteY());
        double d3 = this.getParent().clampToParentY(d2 + (double)this.getParent().getHeight().intValue());
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return d;
    }

    public Boolean isPointOver(double d, double d2) {
        UIElement uIElement;
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        int n = this.getHeight().intValue();
        if (this.maxDrawHeight != -1) {
            n = Math.min(n, this.maxDrawHeight);
        }
        double d3 = d - this.getAbsoluteX();
        double d4 = d2 - this.getAbsoluteY();
        if (d3 < 0.0 || d3 >= this.getWidth() || d4 < 0.0 || d4 >= (double)n) {
            return Boolean.FALSE;
        }
        if (this.Parent == null) {
            UIElement uIElement2;
            ArrayList<UIElement> arrayList = UIManager.getUI();
            for (int i = arrayList.size() - 1; i >= 0 && (uIElement2 = arrayList.get(i)) != this; --i) {
                if (!uIElement2.isPointOver(d, d2).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        for (int i = this.Parent.Controls.size() - 1; i >= 0 && (uIElement = this.Parent.Controls.get(i)) != this; --i) {
            if (!uIElement.isVisible().booleanValue()) continue;
            n = uIElement.getHeight().intValue();
            if (uIElement.maxDrawHeight != -1) {
                n = Math.min(n, uIElement.maxDrawHeight);
            }
            d3 = d - uIElement.getAbsoluteX();
            d4 = d2 - uIElement.getAbsoluteY();
            if (!(d3 >= 0.0) || !(d3 < uIElement.getWidth()) || !(d4 >= 0.0) || !(d4 < (double)n)) continue;
            return Boolean.FALSE;
        }
        return this.Parent.isPointOver(d, d2) != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isMouseOver() {
        return this.isPointOver(Mouse.getXA(), Mouse.getYA()) != false ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object tryGetTableValue(String string) {
        if (this.getTable() == null) {
            return null;
        }
        return this.getTable().rawget((Object)string);
    }

    public void setWantKeyEvents(boolean bl) {
        this.bWantKeyEvents = bl;
    }

    public boolean isWantKeyEvents() {
        return this.bWantKeyEvents;
    }

    public boolean isKeyConsumed(int n) {
        Object object = this.tryGetTableValue("isKeyConsumed");
        if (object == null) {
            return false;
        }
        Boolean bl = LuaManager.caller.pcallBoolean(UIManager.getDefaultThread(), object, (Object)this.getTable(), (Object)BoxedStaticValues.toDouble(n));
        return bl == null ? Boolean.FALSE.booleanValue() : bl.booleanValue();
    }

    public void onKeyPress(int n) {
        Object object = this.tryGetTableValue("onKeyPress");
        if (object == null) {
            return;
        }
        LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), object, (Object)this.getTable(), (Object)BoxedStaticValues.toDouble(n));
    }

    public void onKeyRepeat(int n) {
        Object object = this.tryGetTableValue("onKeyRepeat");
        if (object == null) {
            return;
        }
        LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), object, (Object)this.getTable(), (Object)BoxedStaticValues.toDouble(n));
    }

    public void onKeyRelease(int n) {
        Object object = this.tryGetTableValue("onKeyRelease");
        if (object == null) {
            return;
        }
        LuaManager.caller.pcallvoid(UIManager.getDefaultThread(), object, (Object)this.getTable(), (Object)BoxedStaticValues.toDouble(n));
    }

    public boolean isForceCursorVisible() {
        return this.bForceCursorVisible;
    }

    public void setForceCursorVisible(boolean bl) {
        this.bForceCursorVisible = bl;
    }

    static {
        StencilLevel = 0;
    }
}

