/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.fonts.AngelCodeFont;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.network.ServerGUI;
import zombie.ui.FontsFile;
import zombie.ui.FontsFileFont;
import zombie.ui.TextDrawObject;
import zombie.ui.UIFont;

public final class TextManager {
    public AngelCodeFont font;
    public AngelCodeFont font2;
    public AngelCodeFont font3;
    public AngelCodeFont font4;
    public AngelCodeFont main1;
    public AngelCodeFont main2;
    public AngelCodeFont zombiefontcredits1;
    public AngelCodeFont zombiefontcredits2;
    public AngelCodeFont zombienew1;
    public AngelCodeFont zombienew2;
    public AngelCodeFont zomboidDialogue;
    public AngelCodeFont codetext;
    public AngelCodeFont debugConsole;
    public AngelCodeFont intro;
    public AngelCodeFont handwritten;
    public final AngelCodeFont[] normal = new AngelCodeFont[14];
    public AngelCodeFont zombienew3;
    public final AngelCodeFont[] enumToFont = new AngelCodeFont[UIFont.values().length];
    public static final TextManager instance = new TextManager();
    public ArrayList<DeferedTextDraw> todoTextList = new ArrayList();

    public void DrawString(double d, double d2, String string) {
        this.font.drawString((float)d, (float)d2, string, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void DrawString(double d, double d2, String string, double d3, double d4, double d5, double d6) {
        this.font.drawString((float)d, (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void DrawString(UIFont uIFont, double d, double d2, double d3, String string, double d4, double d5, double d6, double d7) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        angelCodeFont.drawString((float)d, (float)d2, (float)d3, string, (float)d4, (float)d5, (float)d6, (float)d7);
    }

    public void DrawString(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        angelCodeFont.drawString((float)d, (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void DrawStringUntrimmed(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        angelCodeFont.drawString((float)d, (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void DrawStringCentre(double d, double d2, String string, double d3, double d4, double d5, double d6) {
        this.font.drawString((float)(d -= (double)(this.font.getWidth(string) / 2)), (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void DrawStringCentre(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        angelCodeFont.drawString((float)(d -= (double)(angelCodeFont.getWidth(string) / 2)), (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public void DrawStringCentreDefered(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
        this.todoTextList.add(new DeferedTextDraw(uIFont, d, d2, string, d3, d4, d5, d6));
    }

    public void DrawTextFromGameWorld() {
        for (int i = 0; i < this.todoTextList.size(); ++i) {
            DeferedTextDraw deferedTextDraw = this.todoTextList.get(i);
            this.DrawStringCentre(deferedTextDraw.font, deferedTextDraw.x, deferedTextDraw.y, deferedTextDraw.str, deferedTextDraw.r, deferedTextDraw.g, deferedTextDraw.b, deferedTextDraw.a);
        }
        this.todoTextList.clear();
    }

    public void DrawStringRight(double d, double d2, String string, double d3, double d4, double d5, double d6) {
        this.font.drawString((float)(d -= (double)this.font.getWidth(string)), (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    public TextDrawObject GetDrawTextObject(String string, int n, boolean bl) {
        TextDrawObject textDrawObject = new TextDrawObject();
        return textDrawObject;
    }

    public void DrawTextObject(double d, double d2, TextDrawObject textDrawObject) {
    }

    public void DrawStringBBcode(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
    }

    public AngelCodeFont getNormalFromFontSize(int n) {
        return this.normal[n - 11];
    }

    public AngelCodeFont getFontFromEnum(UIFont uIFont) {
        if (uIFont == null) {
            return this.font;
        }
        AngelCodeFont angelCodeFont = this.enumToFont[uIFont.ordinal()];
        return angelCodeFont == null ? this.font : angelCodeFont;
    }

    public int getFontHeight(UIFont uIFont) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        return angelCodeFont.getLineHeight();
    }

    public void DrawStringRight(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        angelCodeFont.drawString((float)(d -= (double)angelCodeFont.getWidth(string)), (float)d2, string, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    private String getFontFilePath(String string, String string2, String string3) {
        String string4;
        if (string2 != null && ZomboidFileSystem.instance.getString(string4 = "media/fonts/" + string + "/" + string2 + "/" + string3) != string4) {
            return string4;
        }
        string4 = "media/fonts/" + string + "/" + string3;
        if (ZomboidFileSystem.instance.getString(string4) != string4) {
            return string4;
        }
        if (!"EN".equals(string)) {
            if (string2 != null && ZomboidFileSystem.instance.getString(string4 = "media/fonts/EN/" + string2 + "/" + string3) != string4) {
                return string4;
            }
            string4 = "media/fonts/EN/" + string3;
            if (ZomboidFileSystem.instance.getString(string4) != string4) {
                return string4;
            }
        }
        if (ZomboidFileSystem.instance.getString(string4 = "media/fonts/" + string3) != string4) {
            return string4;
        }
        return "media/" + string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void Init() throws FileNotFoundException {
        void var7_12;
        String string = ZomboidFileSystem.instance.getString("media/fonts/EN/fonts.txt");
        FontsFile fontsFile = new FontsFile();
        HashMap<String, FontsFileFont> hashMap = new HashMap<String, FontsFileFont>();
        fontsFile.read(string, hashMap);
        String string2 = Translator.getLanguage().name();
        if (!"EN".equals(string2)) {
            string = ZomboidFileSystem.instance.getString("media/fonts/" + string2 + "/fonts.txt");
            fontsFile.read(string, hashMap);
        }
        HashMap<CallSite, AngelCodeFont> hashMap2 = new HashMap<CallSite, AngelCodeFont>();
        String string3 = null;
        if (Core.OptionFontSize == 2) {
            string3 = "1x";
        } else if (Core.OptionFontSize == 3) {
            string3 = "2x";
        } else if (Core.OptionFontSize == 4) {
            string3 = "3x";
        } else if (Core.OptionFontSize == 5) {
            string3 = "4x";
        }
        for (AngelCodeFont angelCodeFont : this.enumToFont) {
            if (angelCodeFont == null) continue;
            angelCodeFont.destroy();
        }
        Arrays.fill(this.enumToFont, null);
        for (AngelCodeFont angelCodeFont : this.normal) {
            if (angelCodeFont == null) continue;
            angelCodeFont.destroy();
        }
        Arrays.fill(this.normal, null);
        for (UIFont uIFont : UIFont.values()) {
            AngelCodeFont angelCodeFont;
            String string4;
            FontsFileFont fontsFileFont = hashMap.get(uIFont.name());
            if (fontsFileFont == null) {
                DebugLog.General.warn("font \"%s\" not found in fonts.txt", uIFont.name());
                continue;
            }
            String string5 = this.getFontFilePath(string2, string3, fontsFileFont.fnt);
            String string6 = null;
            if (fontsFileFont.img != null) {
                string6 = this.getFontFilePath(string2, string3, fontsFileFont.img);
            }
            if (hashMap2.get(string4 = string5 + "|" + string6) != null) {
                this.enumToFont[uIFont.ordinal()] = (AngelCodeFont)hashMap2.get(string4);
                continue;
            }
            this.enumToFont[uIFont.ordinal()] = angelCodeFont = new AngelCodeFont(string5, string6);
            hashMap2.put((CallSite)((Object)string4), angelCodeFont);
        }
        try {
            ZomboidFileSystem.instance.IgnoreActiveFileMap.set(true);
            String string7 = new File("").getAbsolutePath().replaceAll("\\\\", "/");
            String string8 = string7 + "/media/fonts/zomboidSmall.fnt";
            String string9 = string7 + "/media/fonts/zomboidSmall_0.png";
            if (string8.startsWith("/")) {
                string8 = "/" + string8;
            }
            this.enumToFont[UIFont.DebugConsole.ordinal()] = new AngelCodeFont(string8, string9);
        }
        finally {
            ZomboidFileSystem.instance.IgnoreActiveFileMap.set(false);
        }
        boolean bl = false;
        while (var7_12 < this.normal.length) {
            this.normal[var7_12] = new AngelCodeFont("media/fonts/zomboidNormal" + (int)(var7_12 + 11) + ".fnt", "media/fonts/zomboidNormal" + (int)(var7_12 + 11) + "_0");
            ++var7_12;
        }
        this.font = this.enumToFont[UIFont.Small.ordinal()];
        this.font2 = this.enumToFont[UIFont.Medium.ordinal()];
        this.font3 = this.enumToFont[UIFont.Large.ordinal()];
        this.font4 = this.enumToFont[UIFont.Massive.ordinal()];
        this.main1 = this.enumToFont[UIFont.MainMenu1.ordinal()];
        this.main2 = this.enumToFont[UIFont.MainMenu2.ordinal()];
        this.zombiefontcredits1 = this.enumToFont[UIFont.Cred1.ordinal()];
        this.zombiefontcredits2 = this.enumToFont[UIFont.Cred2.ordinal()];
        this.zombienew1 = this.enumToFont[UIFont.NewSmall.ordinal()];
        this.zombienew2 = this.enumToFont[UIFont.NewMedium.ordinal()];
        this.zombienew3 = this.enumToFont[UIFont.NewLarge.ordinal()];
        this.codetext = this.enumToFont[UIFont.Code.ordinal()];
        this.enumToFont[UIFont.MediumNew.ordinal()] = null;
        this.enumToFont[UIFont.AutoNormSmall.ordinal()] = null;
        this.enumToFont[UIFont.AutoNormMedium.ordinal()] = null;
        this.enumToFont[UIFont.AutoNormLarge.ordinal()] = null;
        this.zomboidDialogue = this.enumToFont[UIFont.Dialogue.ordinal()];
        this.intro = this.enumToFont[UIFont.Intro.ordinal()];
        this.handwritten = this.enumToFont[UIFont.Handwritten.ordinal()];
        this.debugConsole = this.enumToFont[UIFont.DebugConsole.ordinal()];
    }

    public int MeasureStringX(UIFont uIFont, String string) {
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return 0;
        }
        if (string == null) {
            return 0;
        }
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        return angelCodeFont.getWidth(string);
    }

    public int MeasureStringY(UIFont uIFont, String string) {
        if (uIFont == null || string == null) {
            return 0;
        }
        if (GameServer.bServer && !ServerGUI.isCreated()) {
            return 0;
        }
        AngelCodeFont angelCodeFont = this.getFontFromEnum(uIFont);
        return angelCodeFont.getHeight(string);
    }

    public int MeasureFont(UIFont uIFont) {
        if (uIFont == UIFont.Small) {
            return 10;
        }
        if (uIFont == UIFont.Dialogue) {
            return 20;
        }
        if (uIFont == UIFont.Medium) {
            return 20;
        }
        if (uIFont == UIFont.Large) {
            return 24;
        }
        if (uIFont == UIFont.Massive) {
            return 30;
        }
        if (uIFont == UIFont.MainMenu1) {
            return 30;
        }
        if (uIFont == UIFont.MainMenu2) {
            return 30;
        }
        return this.getFontFromEnum(uIFont).getLineHeight();
    }

    public static class DeferedTextDraw {
        public double x;
        public double y;
        public UIFont font;
        public String str;
        public double r;
        public double g;
        public double b;
        public double a;

        public DeferedTextDraw(UIFont uIFont, double d, double d2, String string, double d3, double d4, double d5, double d6) {
            this.font = uIFont;
            this.x = d;
            this.y = d2;
            this.str = string;
            this.r = d3;
            this.g = d4;
            this.b = d5;
            this.a = d6;
        }
    }

    public static interface StringDrawer {
        public void draw(UIFont var1, double var2, double var4, String var6, double var7, double var9, double var11, double var13);
    }
}

