/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.Stack;
import org.lwjgl.util.Rectangle;
import zombie.characters.IsoGameCharacter;
import zombie.characters.Moodles.MoodleType;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.textures.Texture;
import zombie.input.GameKeyboard;
import zombie.input.Mouse;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIManager;

public final class MoodlesUI
extends UIElement {
    public float clientH = 0.0f;
    public float clientW = 0.0f;
    public boolean Movable = false;
    public int ncclientH = 0;
    public int ncclientW = 0;
    private static MoodlesUI instance = null;
    private static final float OFFSCREEN_Y = 10000.0f;
    public Stack<Rectangle> nestedItems = new Stack();
    float alpha = 1.0f;
    Texture Back_Bad_1 = null;
    Texture Back_Bad_2 = null;
    Texture Back_Bad_3 = null;
    Texture Back_Bad_4 = null;
    Texture Back_Good_1 = null;
    Texture Back_Good_2 = null;
    Texture Back_Good_3 = null;
    Texture Back_Good_4 = null;
    Texture Back_Neutral = null;
    Texture Endurance = null;
    Texture Bleeding = null;
    Texture Angry = null;
    Texture Stress = null;
    Texture Thirst = null;
    Texture Panic = null;
    Texture Hungry = null;
    Texture Injured = null;
    Texture Pain = null;
    Texture Sick = null;
    Texture Bored = null;
    Texture Unhappy = null;
    Texture Tired = null;
    Texture HeavyLoad = null;
    Texture Drunk = null;
    Texture Wet = null;
    Texture HasACold = null;
    Texture Dead = null;
    Texture Zombie = null;
    Texture Windchill = null;
    Texture CantSprint = null;
    Texture FoodEaten = null;
    Texture Hyperthermia = null;
    Texture Hypothermia = null;
    public static Texture plusRed;
    public static Texture plusGreen;
    public static Texture minusRed;
    public static Texture minusGreen;
    public static Texture chevronUp;
    public static Texture chevronUpBorder;
    public static Texture chevronDown;
    public static Texture chevronDownBorder;
    float MoodleDistY = 36.0f;
    boolean MouseOver = false;
    int MouseOverSlot = 0;
    int NumUsedSlots = 0;
    private int DebugKeyDelay = 0;
    private int DistFromRighEdge = 46;
    private int[] GoodBadNeutral = new int[MoodleType.ToIndex(MoodleType.MAX)];
    private int[] MoodleLevel = new int[MoodleType.ToIndex(MoodleType.MAX)];
    private float[] MoodleOscilationLevel = new float[MoodleType.ToIndex(MoodleType.MAX)];
    private float[] MoodleSlotsDesiredPos = new float[MoodleType.ToIndex(MoodleType.MAX)];
    private float[] MoodleSlotsPos = new float[MoodleType.ToIndex(MoodleType.MAX)];
    private int[] MoodleTypeInSlot = new int[MoodleType.ToIndex(MoodleType.MAX)];
    private float Oscilator = 0.0f;
    private float OscilatorDecelerator = 0.96f;
    private float OscilatorRate = 0.8f;
    private float OscilatorScalar = 15.6f;
    private float OscilatorStartLevel = 1.0f;
    private float OscilatorStep = 0.0f;
    private IsoGameCharacter UseCharacter = null;
    private boolean alphaIncrease = true;

    public MoodlesUI() {
        this.x = Core.getInstance().getScreenWidth() - this.DistFromRighEdge;
        this.y = 100.0;
        this.width = 32.0f;
        this.height = 500.0f;
        this.Back_Bad_1 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Bad_1.png");
        this.Back_Bad_2 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Bad_2.png");
        this.Back_Bad_3 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Bad_3.png");
        this.Back_Bad_4 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Bad_4.png");
        this.Back_Good_1 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Good_1.png");
        this.Back_Good_2 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Good_2.png");
        this.Back_Good_3 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Good_3.png");
        this.Back_Good_4 = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Good_4.png");
        this.Back_Neutral = Texture.getSharedTexture("media/ui/Moodles/Moodle_Bkg_Bad_1.png");
        this.Endurance = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Endurance.png");
        this.Tired = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Tired.png");
        this.Hungry = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Hungry.png");
        this.Panic = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Panic.png");
        this.Sick = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Sick.png");
        this.Bored = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Bored.png");
        this.Unhappy = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Unhappy.png");
        this.Bleeding = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Bleeding.png");
        this.Wet = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Wet.png");
        this.HasACold = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Cold.png");
        this.Angry = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Angry.png");
        this.Stress = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Stressed.png");
        this.Thirst = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Thirsty.png");
        this.Injured = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Injured.png");
        this.Pain = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Pain.png");
        this.HeavyLoad = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_HeavyLoad.png");
        this.Drunk = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Drunk.png");
        this.Dead = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Dead.png");
        this.Zombie = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Zombie.png");
        this.FoodEaten = Texture.getSharedTexture("media/ui/Moodles/Moodle_Icon_Hungry.png");
        this.Hyperthermia = Texture.getSharedTexture("media/ui/weather/Moodle_Icon_TempHot.png");
        this.Hypothermia = Texture.getSharedTexture("media/ui/weather/Moodle_Icon_TempCold.png");
        this.Windchill = Texture.getSharedTexture("media/ui/Moodle_Icon_Windchill.png");
        this.CantSprint = Texture.getSharedTexture("media/ui/Moodle_Icon_CantSprint.png");
        plusRed = Texture.getSharedTexture("media/ui/Moodle_internal_plus_red.png");
        minusRed = Texture.getSharedTexture("media/ui/Moodle_internal_minus_red.png");
        plusGreen = Texture.getSharedTexture("media/ui/Moodle_internal_plus_green.png");
        minusGreen = Texture.getSharedTexture("media/ui/Moodle_internal_minus_green.png");
        chevronUp = Texture.getSharedTexture("media/ui/Moodle_chevron_up.png");
        chevronUpBorder = Texture.getSharedTexture("media/ui/Moodle_chevron_up_border.png");
        chevronDown = Texture.getSharedTexture("media/ui/Moodle_chevron_down.png");
        chevronDownBorder = Texture.getSharedTexture("media/ui/Moodle_chevron_down_border.png");
        for (int i = 0; i < MoodleType.ToIndex(MoodleType.MAX); ++i) {
            this.MoodleSlotsPos[i] = 10000.0f;
            this.MoodleSlotsDesiredPos[i] = 10000.0f;
        }
        this.clientW = this.width;
        this.clientH = this.height;
        instance = this;
    }

    public boolean CurrentlyAnimating() {
        boolean bl = false;
        for (int i = 0; i < MoodleType.ToIndex(MoodleType.MAX); ++i) {
            if (this.MoodleSlotsPos[i] == this.MoodleSlotsDesiredPos[i]) continue;
            bl = true;
        }
        return bl;
    }

    public void Nest(UIElement uIElement, int n, int n2, int n3, int n4) {
        this.AddChild(uIElement);
        this.nestedItems.add(new Rectangle(n4, n, n2, n3));
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return Boolean.FALSE;
        }
        this.MouseOver = true;
        super.onMouseMove(d, d2);
        this.MouseOverSlot = (int)(((double)Mouse.getYA() - this.getY()) / (double)this.MoodleDistY);
        if (this.MouseOverSlot >= this.NumUsedSlots) {
            this.MouseOverSlot = 1000;
        }
        return Boolean.TRUE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        super.onMouseMoveOutside(d, d2);
        this.MouseOverSlot = 1000;
        this.MouseOver = false;
    }

    @Override
    public void render() {
        if (this.UseCharacter == null) {
            return;
        }
        float f = (float)(UIManager.getMillisSinceLastRender() / 33.3);
        this.OscilatorStep += this.OscilatorRate * f * 0.5f;
        this.Oscilator = (float)Math.sin(this.OscilatorStep);
        int n = 0;
        for (int i = 0; i < MoodleType.ToIndex(MoodleType.MAX); ++i) {
            int n2;
            int n3;
            Object object;
            if (this.MoodleSlotsPos[i] == 10000.0f) continue;
            float f2 = this.Oscilator * this.OscilatorScalar * this.MoodleOscilationLevel[i];
            Texture texture = this.Back_Neutral;
            Texture texture2 = this.Tired;
            block0 : switch (this.GoodBadNeutral[i]) {
                case 0: {
                    texture = this.Back_Neutral;
                    break;
                }
                case 1: {
                    switch (this.MoodleLevel[i]) {
                        case 1: {
                            texture = this.Back_Good_1;
                            break;
                        }
                        case 2: {
                            texture = this.Back_Good_2;
                            break;
                        }
                        case 3: {
                            texture = this.Back_Good_3;
                            break;
                        }
                        case 4: {
                            texture = this.Back_Good_4;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.MoodleLevel[i]) {
                        case 1: {
                            texture = this.Back_Bad_1;
                            break block0;
                        }
                        case 2: {
                            texture = this.Back_Bad_2;
                            break block0;
                        }
                        case 3: {
                            texture = this.Back_Bad_3;
                            break block0;
                        }
                        case 4: {
                            texture = this.Back_Bad_4;
                        }
                    }
                }
            }
            switch (i) {
                case 0: {
                    texture2 = this.Endurance;
                    break;
                }
                case 1: {
                    texture2 = this.Tired;
                    break;
                }
                case 2: {
                    texture2 = this.Hungry;
                    break;
                }
                case 3: {
                    texture2 = this.Panic;
                    break;
                }
                case 4: {
                    texture2 = this.Sick;
                    break;
                }
                case 5: {
                    texture2 = this.Bored;
                    break;
                }
                case 6: {
                    texture2 = this.Unhappy;
                    break;
                }
                case 7: {
                    texture2 = this.Bleeding;
                    break;
                }
                case 8: {
                    texture2 = this.Wet;
                    break;
                }
                case 9: {
                    texture2 = this.HasACold;
                    break;
                }
                case 10: {
                    texture2 = this.Angry;
                    break;
                }
                case 11: {
                    texture2 = this.Stress;
                    break;
                }
                case 12: {
                    texture2 = this.Thirst;
                    break;
                }
                case 13: {
                    texture2 = this.Injured;
                    break;
                }
                case 14: {
                    texture2 = this.Pain;
                    break;
                }
                case 15: {
                    texture2 = this.HeavyLoad;
                    break;
                }
                case 16: {
                    texture2 = this.Drunk;
                    break;
                }
                case 17: {
                    texture2 = this.Dead;
                    break;
                }
                case 18: {
                    texture2 = this.Zombie;
                    break;
                }
                case 19: {
                    texture2 = this.FoodEaten;
                    break;
                }
                case 20: {
                    texture2 = this.Hyperthermia;
                    break;
                }
                case 21: {
                    texture2 = this.Hypothermia;
                    break;
                }
                case 22: {
                    texture2 = this.Windchill;
                    break;
                }
                case 23: {
                    texture2 = this.CantSprint;
                }
            }
            if (MoodleType.FromIndex(i).name().equals(Core.getInstance().getBlinkingMoodle())) {
                if (this.alphaIncrease) {
                    this.alpha += 0.1f * (30.0f / (float)PerformanceSettings.instance.getUIRenderFPS());
                    if (this.alpha > 1.0f) {
                        this.alpha = 1.0f;
                        this.alphaIncrease = false;
                    }
                } else {
                    this.alpha -= 0.1f * (30.0f / (float)PerformanceSettings.instance.getUIRenderFPS());
                    if (this.alpha < 0.0f) {
                        this.alpha = 0.0f;
                        this.alphaIncrease = true;
                    }
                }
            }
            if (Core.getInstance().getBlinkingMoodle() == null) {
                this.alpha = 1.0f;
            }
            this.DrawTexture(texture, (int)f2, (int)this.MoodleSlotsPos[i], this.alpha);
            this.DrawTexture(texture2, (int)f2, (int)this.MoodleSlotsPos[i], this.alpha);
            if (this.UseCharacter.getMoodles().getMoodleChevronCount(i) > 0) {
                boolean bl = this.UseCharacter.getMoodles().getMoodleChevronIsUp(i);
                object = this.UseCharacter.getMoodles().getMoodleChevronColor(i);
                ((Color)object).a = this.alpha;
                for (n3 = 0; n3 < this.UseCharacter.getMoodles().getMoodleChevronCount(i); ++n3) {
                    n2 = n3 * 4;
                    this.DrawTextureCol(bl ? chevronUp : chevronDown, (int)f2 + 16, (int)this.MoodleSlotsPos[i] + 20 - n2, (Color)object);
                    this.DrawTextureCol(bl ? chevronUpBorder : chevronDownBorder, (int)f2 + 16, (int)this.MoodleSlotsPos[i] + 20 - n2, (Color)object);
                }
            }
            if (this.MouseOver && n == this.MouseOverSlot) {
                String string = this.UseCharacter.getMoodles().getMoodleDisplayString(i);
                object = this.UseCharacter.getMoodles().getMoodleDescriptionString(i);
                n3 = TextManager.instance.font.getWidth(string);
                n2 = TextManager.instance.font.getWidth((String)object);
                int n4 = Math.max(n3, n2);
                int n5 = TextManager.instance.font.getLineHeight();
                int n6 = (int)this.MoodleSlotsPos[i] + 1;
                int n7 = (2 + n5) * 2;
                this.DrawTextureScaledColor(null, -10.0 - (double)n4 - 6.0, (double)n6 - 2.0, (double)n4 + 12.0, Double.valueOf(n7), 0.0, 0.0, 0.0, 0.6);
                this.DrawTextRight(string, -10.0, n6, 1.0, 1.0, 1.0, 1.0);
                this.DrawTextRight((String)object, -10.0, n6 + n5, 0.8f, 0.8f, 0.8f, 1.0);
            }
            ++n;
        }
        super.render();
    }

    public void wiggle(MoodleType moodleType) {
        this.MoodleOscilationLevel[MoodleType.ToIndex((MoodleType)moodleType)] = this.OscilatorStartLevel;
    }

    @Override
    public void update() {
        int n;
        super.update();
        if (this.UseCharacter == null) {
            return;
        }
        if (!this.CurrentlyAnimating()) {
            if (this.DebugKeyDelay > 0) {
                --this.DebugKeyDelay;
            } else if (GameKeyboard.isKeyDown(57)) {
                this.DebugKeyDelay = 10;
            }
        }
        float f = (float)PerformanceSettings.getLockFPS() / 30.0f;
        for (n = 0; n < MoodleType.ToIndex(MoodleType.MAX); ++n) {
            int n2 = n;
            this.MoodleOscilationLevel[n2] = this.MoodleOscilationLevel[n2] - this.MoodleOscilationLevel[n] * (1.0f - this.OscilatorDecelerator) / f;
            if (!((double)this.MoodleOscilationLevel[n] < 0.01)) continue;
            this.MoodleOscilationLevel[n] = 0.0f;
        }
        if (this.UseCharacter.getMoodles().UI_RefreshNeeded()) {
            n = 0;
            for (int i = 0; i < MoodleType.ToIndex(MoodleType.MAX); ++i) {
                if (this.UseCharacter.getMoodles().getMoodleLevel(i) > 0) {
                    boolean bl = false;
                    if (this.MoodleLevel[i] != this.UseCharacter.getMoodles().getMoodleLevel(i)) {
                        bl = true;
                        this.MoodleLevel[i] = this.UseCharacter.getMoodles().getMoodleLevel(i);
                        this.MoodleOscilationLevel[i] = this.OscilatorStartLevel;
                    }
                    this.MoodleSlotsDesiredPos[i] = this.MoodleDistY * (float)n;
                    if (bl) {
                        if (this.MoodleSlotsPos[i] == 10000.0f) {
                            this.MoodleSlotsPos[i] = this.MoodleSlotsDesiredPos[i] + 500.0f;
                            this.MoodleOscilationLevel[i] = 0.0f;
                        }
                        this.GoodBadNeutral[i] = this.UseCharacter.getMoodles().getGoodBadNeutral(i);
                    } else {
                        this.MoodleOscilationLevel[i] = 0.0f;
                    }
                    this.MoodleTypeInSlot[n] = i;
                    ++n;
                    continue;
                }
                this.MoodleSlotsPos[i] = 10000.0f;
                this.MoodleSlotsDesiredPos[i] = 10000.0f;
                this.MoodleOscilationLevel[i] = 0.0f;
                this.MoodleLevel[i] = 0;
            }
            this.NumUsedSlots = n;
        }
        for (n = 0; n < MoodleType.ToIndex(MoodleType.MAX); ++n) {
            if (Math.abs(this.MoodleSlotsPos[n] - this.MoodleSlotsDesiredPos[n]) > 0.8f) {
                int n3 = n;
                this.MoodleSlotsPos[n3] = this.MoodleSlotsPos[n3] + (this.MoodleSlotsDesiredPos[n] - this.MoodleSlotsPos[n]) * 0.15f;
                continue;
            }
            this.MoodleSlotsPos[n] = this.MoodleSlotsDesiredPos[n];
        }
    }

    public void setCharacter(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter == this.UseCharacter) {
            return;
        }
        this.UseCharacter = isoGameCharacter;
        if (this.UseCharacter != null && this.UseCharacter.getMoodles() != null) {
            this.UseCharacter.getMoodles().setMoodlesStateChanged(true);
        }
    }

    public static MoodlesUI getInstance() {
        return instance;
    }
}

