/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import java.util.ArrayList;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.input.Mouse;
import zombie.ui.UIElement;
import zombie.ui.UIManager;

public final class FPSGraph
extends UIElement {
    public static FPSGraph instance;
    private static final int NUM_BARS = 30;
    private static final int BAR_WID = 8;
    private final Graph fpsGraph = new Graph();
    private final Graph upsGraph = new Graph();
    private final Graph lpsGraph = new Graph();
    private final Graph uiGraph = new Graph();

    public FPSGraph() {
        this.setVisible(false);
        this.setWidth(232.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRender(long l) {
        Graph graph = this.fpsGraph;
        synchronized (graph) {
            this.fpsGraph.add(l);
        }
    }

    public void addUpdate(long l) {
        this.upsGraph.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLighting(long l) {
        Graph graph = this.lpsGraph;
        synchronized (graph) {
            this.lpsGraph.add(l);
        }
    }

    public void addUI(long l) {
        this.uiGraph.add(l);
    }

    @Override
    public void update() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        this.setHeight(108.0);
        this.setWidth(232.0);
        this.setX(20.0);
        this.setY((double)(Core.getInstance().getScreenHeight() - 20) - this.getHeight());
        super.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        if (!UIManager.VisibleAllUI) {
            return;
        }
        int n = this.getHeight().intValue() - 4;
        int n2 = -1;
        if (this.isMouseOver().booleanValue()) {
            this.DrawTextureScaledCol(UIElement.white, 0.0, 0.0, this.getWidth(), this.getHeight(), 0.0, 0.2f, 0.0, 0.5);
            int n3 = Mouse.getXA() - this.getAbsoluteX().intValue();
            n2 = n3 / 8;
        }
        Graph graph = this.fpsGraph;
        synchronized (graph) {
            this.fpsGraph.render(0.0f, 1.0f, 0.0f);
            if (n2 >= 0 && n2 < this.fpsGraph.bars.size()) {
                this.DrawText("FPS: " + this.fpsGraph.bars.get(n2), 20.0, n / 2 - 10, 0.0, 1.0, 0.0, 1.0);
            }
        }
        graph = this.lpsGraph;
        synchronized (graph) {
            this.lpsGraph.render(1.0f, 1.0f, 0.0f);
            if (n2 >= 0 && n2 < this.lpsGraph.bars.size()) {
                this.DrawText("LPS: " + this.lpsGraph.bars.get(n2), 20.0, n / 2 + 20, 1.0, 1.0, 0.0, 1.0);
            }
        }
        this.upsGraph.render(0.0f, 1.0f, 1.0f);
        if (n2 >= 0 && n2 < this.upsGraph.bars.size()) {
            this.DrawText("UPS: " + this.upsGraph.bars.get(n2), 20.0, n / 2 + 5, 0.0, 1.0, 1.0, 1.0);
            this.DrawTextureScaledCol(UIElement.white, n2 * 8 + 4, 0.0, 1.0, this.getHeight(), 1.0, 1.0, 1.0, 0.5);
        }
        this.uiGraph.render(1.0f, 0.0f, 1.0f);
        if (n2 >= 0 && n2 < this.uiGraph.bars.size()) {
            this.DrawText("UI: " + this.uiGraph.bars.get(n2), 20.0, n / 2 - 26, 1.0, 0.0, 1.0, 1.0);
        }
    }

    private final class Graph {
        private final ArrayList<Long> times = new ArrayList();
        private final ArrayList<Integer> bars = new ArrayList();

        private Graph() {
        }

        public void add(long l) {
            int n;
            this.times.add(l);
            this.bars.clear();
            long l2 = this.times.get(0);
            int n2 = 1;
            for (n = 1; n < this.times.size(); ++n) {
                if (n == this.times.size() - 1 || this.times.get(n) - l2 > 1000L) {
                    long l3 = (this.times.get(n) - l2) / 1000L - 1L;
                    int n3 = 0;
                    while ((long)n3 < l3) {
                        this.bars.add(0);
                        ++n3;
                    }
                    this.bars.add(n2);
                    n2 = 1;
                    l2 = this.times.get(n);
                    continue;
                }
                ++n2;
            }
            while (this.bars.size() > 30) {
                n = this.bars.get(0);
                for (int i = 0; i < n; ++i) {
                    this.times.remove(0);
                }
                this.bars.remove(0);
            }
        }

        public void render(float f, float f2, float f3) {
            if (this.bars.isEmpty()) {
                return;
            }
            float f4 = FPSGraph.this.getHeight().intValue() - 4;
            float f5 = FPSGraph.this.getHeight().intValue() - 2;
            int n = Math.max(PerformanceSettings.getLockFPS(), PerformanceSettings.LightingFPS);
            int n2 = 8;
            float f6 = f4 * ((float)Math.min(n, this.bars.get(0)) / (float)n);
            for (int i = 1; i < this.bars.size() - 1; ++i) {
                float f7 = f4 * ((float)Math.min(n, this.bars.get(i)) / (float)n);
                SpriteRenderer.instance.renderline(null, FPSGraph.this.getAbsoluteX().intValue() + n2 - 8 + 4, FPSGraph.this.getAbsoluteY().intValue() + (int)(f5 - f6), FPSGraph.this.getAbsoluteX().intValue() + n2 + 4, FPSGraph.this.getAbsoluteY().intValue() + (int)(f5 - f7), f, f2, f3, 0.35f, 1);
                n2 += 8;
                f6 = f7;
            }
        }
    }
}

