/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.Lua.LuaManager;
import zombie.core.Color;
import zombie.core.textures.Texture;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIEventHandler;
import zombie.ui.UIFont;

public final class DialogButton
extends UIElement {
    public boolean clicked = false;
    public UIElement MessageTarget;
    public boolean mouseOver = false;
    public String name;
    public String text;
    Texture downLeft;
    Texture downMid;
    Texture downRight;
    float origX;
    Texture upLeft;
    Texture upMid;
    Texture upRight;
    private UIEventHandler MessageTarget2 = null;

    public DialogButton(UIElement uIElement, float f, float f2, String string, String string2) {
        this.x = f;
        this.y = f2;
        this.origX = f;
        this.MessageTarget = uIElement;
        this.upLeft = Texture.getSharedTexture("ButtonL_Up");
        this.upMid = Texture.getSharedTexture("ButtonM_Up");
        this.upRight = Texture.getSharedTexture("ButtonR_Up");
        this.downLeft = Texture.getSharedTexture("ButtonL_Down");
        this.downMid = Texture.getSharedTexture("ButtonM_Down");
        this.downRight = Texture.getSharedTexture("ButtonR_Down");
        this.name = string2;
        this.text = string;
        this.width = TextManager.instance.MeasureStringX(UIFont.Small, string);
        this.width += 8.0f;
        if (this.width < 40.0f) {
            this.width = 40.0f;
        }
        this.height = this.downMid.getHeight();
        this.x -= (double)(this.width / 2.0f);
    }

    public DialogButton(UIEventHandler uIEventHandler, int n, int n2, String string, String string2) {
        this.x = n;
        this.y = n2;
        this.origX = n;
        this.MessageTarget2 = uIEventHandler;
        this.upLeft = Texture.getSharedTexture("ButtonL_Up");
        this.upMid = Texture.getSharedTexture("ButtonM_Up");
        this.upRight = Texture.getSharedTexture("ButtonR_Up");
        this.downLeft = Texture.getSharedTexture("ButtonL_Down");
        this.downMid = Texture.getSharedTexture("ButtonM_Down");
        this.downRight = Texture.getSharedTexture("ButtonR_Down");
        this.name = string2;
        this.text = string;
        this.width = TextManager.instance.MeasureStringX(UIFont.Small, string);
        this.width += 8.0f;
        if (this.width < 40.0f) {
            this.width = 40.0f;
        }
        this.height = this.downMid.getHeight();
        this.x -= (double)(this.width / 2.0f);
    }

    @Override
    public Boolean onMouseDown(double d, double d2) {
        if (!this.isVisible().booleanValue()) {
            return false;
        }
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseDown") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onMouseDown"), new Object[]{this.table, d, d2});
        }
        this.clicked = true;
        return Boolean.TRUE;
    }

    @Override
    public Boolean onMouseMove(double d, double d2) {
        this.mouseOver = true;
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseMove") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onMouseMove"), new Object[]{this.table, d, d2});
        }
        return Boolean.TRUE;
    }

    @Override
    public void onMouseMoveOutside(double d, double d2) {
        this.clicked = false;
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseMoveOutside") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onMouseMoveOutside"), new Object[]{this.table, d, d2});
        }
        this.mouseOver = false;
    }

    @Override
    public Boolean onMouseUp(double d, double d2) {
        if (this.getTable() != null && this.getTable().rawget((Object)"onMouseUp") != null) {
            Object[] objectArray = LuaManager.caller.pcall(LuaManager.thread, this.getTable().rawget((Object)"onMouseUp"), new Object[]{this.table, d, d2});
        }
        if (this.clicked) {
            if (this.MessageTarget2 != null) {
                this.MessageTarget2.Selected(this.name, 0, 0);
            } else if (this.MessageTarget != null) {
                this.MessageTarget.ButtonClicked(this.name);
            }
        }
        this.clicked = false;
        return Boolean.TRUE;
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue()) {
            return;
        }
        boolean bl = false;
        if (this.clicked) {
            this.DrawTexture(this.downLeft, 0.0, 0.0, 1.0);
            this.DrawTextureScaledCol(this.downMid, this.downLeft.getWidth(), 0.0, (int)(this.getWidth() - (double)(this.downLeft.getWidth() * 2)), this.downLeft.getHeight(), new Color(255, 255, 255, 255));
            this.DrawTexture(this.downRight, (int)(this.getWidth() - (double)this.downRight.getWidth()), 0.0, 1.0);
            this.DrawTextCentre(this.text, this.getWidth() / 2.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            this.DrawTexture(this.upLeft, 0.0, 0.0, 1.0);
            this.DrawTextureScaledCol(this.upMid, this.downLeft.getWidth(), 0.0, (int)(this.getWidth() - (double)(this.downLeft.getWidth() * 2)), this.downLeft.getHeight(), new Color(255, 255, 255, 255));
            this.DrawTexture(this.upRight, (int)(this.getWidth() - (double)this.downRight.getWidth()), 0.0, 1.0);
            this.DrawTextCentre(this.text, this.getWidth() / 2.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        }
        super.render();
    }
}

