/*
 * Decompiled with CFR 0.152.
 */
package zombie.ui;

import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.textures.Texture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoUtils;
import zombie.ui.UIElement;
import zombie.ui.UIManager;

public final class ActionProgressBar
extends UIElement {
    Texture background = Texture.getSharedTexture("BuildBar_Bkg");
    Texture foreground = Texture.getSharedTexture("BuildBar_Bar");
    float deltaValue = 1.0f;
    float animationProgress = 0.0f;
    public int delayHide = 0;
    private final int offsetX;
    private final int offsetY;

    public ActionProgressBar(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
        this.width = this.background.getWidth();
        this.height = this.background.getHeight();
        this.followGameWorld = true;
    }

    @Override
    public void render() {
        if (!this.isVisible().booleanValue() || !UIManager.VisibleAllUI) {
            return;
        }
        this.DrawUVSliceTexture(this.background, 0.0, 0.0, this.background.getWidth(), this.background.getHeight(), Color.white, 0.0, 0.0, 1.0, 1.0);
        if (this.deltaValue == Float.POSITIVE_INFINITY) {
            if (this.animationProgress < 0.5f) {
                this.DrawUVSliceTexture(this.foreground, 3.0, 0.0, this.foreground.getWidth(), this.foreground.getHeight(), Color.white, 0.0, 0.0, this.animationProgress * 2.0f, 1.0);
            } else {
                this.DrawUVSliceTexture(this.foreground, 3.0, 0.0, this.foreground.getWidth(), this.foreground.getHeight(), Color.white, (this.animationProgress - 0.5f) * 2.0f, 0.0, 1.0, 1.0);
            }
        } else {
            this.DrawUVSliceTexture(this.foreground, 3.0, 0.0, this.foreground.getWidth(), this.foreground.getHeight(), Color.white, 0.0, 0.0, this.deltaValue, 1.0);
        }
    }

    public void setValue(float f) {
        this.deltaValue = f;
    }

    public float getValue() {
        return this.deltaValue;
    }

    public void update(int n) {
        if (this.deltaValue == Float.POSITIVE_INFINITY) {
            this.animationProgress += 0.02f * (GameTime.getInstance().getRealworldSecondsSinceLastUpdate() * 60.0f);
            if (this.animationProgress > 1.0f) {
                this.animationProgress = 0.0f;
            }
            this.setVisible(true);
            this.updateScreenPos(n);
            this.delayHide = 2;
            return;
        }
        if (this.getValue() > 0.0f && this.getValue() < 1.0f) {
            this.setVisible(true);
            this.delayHide = 2;
        } else if (this.isVisible().booleanValue() && this.delayHide > 0 && --this.delayHide == 0) {
            this.setVisible(false);
        }
        if (!UIManager.VisibleAllUI) {
            this.setVisible(false);
        }
        if (this.isVisible().booleanValue()) {
            this.updateScreenPos(n);
        }
    }

    private void updateScreenPos(int n) {
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer == null) {
            return;
        }
        float f = IsoUtils.XToScreen(isoPlayer.getX(), isoPlayer.getY(), isoPlayer.getZ(), 0);
        float f2 = IsoUtils.YToScreen(isoPlayer.getX(), isoPlayer.getY(), isoPlayer.getZ(), 0);
        f = f - IsoCamera.getOffX() - isoPlayer.offsetX;
        f2 = f2 - IsoCamera.getOffY() - isoPlayer.offsetY;
        f2 -= (float)(128 / (2 / Core.TileScale));
        f /= Core.getInstance().getZoom(n);
        f2 /= Core.getInstance().getZoom(n);
        f -= this.width / 2.0f;
        f2 -= this.height;
        if (isoPlayer.getUserNameHeight() > 0) {
            f2 -= (float)(isoPlayer.getUserNameHeight() + 2);
        }
        this.setX(f + (float)this.offsetX);
        this.setY(f2 + (float)this.offsetY);
    }
}

