/*
 * Decompiled with CFR 0.152.
 */
package zombie.text.templating;

import java.util.Random;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.Lua.LuaEventManager;
import zombie.characters.SurvivorFactory;
import zombie.text.templating.IReplace;
import zombie.text.templating.IReplaceProvider;
import zombie.text.templating.ITemplateBuilder;
import zombie.text.templating.TemplateTextBuilder;

public class TemplateText {
    private static final ITemplateBuilder builder = new TemplateTextBuilder();
    private static final Random m_random = new Random(4397238L);

    public static String Build(String string) {
        return builder.Build(string);
    }

    public static String Build(String string, IReplaceProvider iReplaceProvider) {
        return builder.Build(string, iReplaceProvider);
    }

    public static String Build(String string, KahluaTableImpl kahluaTableImpl) {
        try {
            return builder.Build(string, kahluaTableImpl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static void RegisterKey(String string, KahluaTableImpl kahluaTableImpl) {
        builder.RegisterKey(string, kahluaTableImpl);
    }

    public static void RegisterKey(String string, IReplace iReplace) {
        builder.RegisterKey(string, iReplace);
    }

    public static void Initialize() {
        builder.RegisterKey("lastname", new IReplace(){

            @Override
            public String getString() {
                return SurvivorFactory.getRandomSurname();
            }
        });
        builder.RegisterKey("firstname", new IReplace(){

            @Override
            public String getString() {
                return TemplateText.RandNext(100) > 50 ? SurvivorFactory.getRandomForename(true) : SurvivorFactory.getRandomForename(false);
            }
        });
        builder.RegisterKey("maleName", new IReplace(){

            @Override
            public String getString() {
                return SurvivorFactory.getRandomForename(false);
            }
        });
        builder.RegisterKey("femaleName", new IReplace(){

            @Override
            public String getString() {
                return SurvivorFactory.getRandomForename(true);
            }
        });
        LuaEventManager.triggerEvent("OnTemplateTextInit");
    }

    public static void Reset() {
        builder.Reset();
    }

    public static float RandNext(float f, float f2) {
        if (f == f2) {
            return f;
        }
        if (f > f2) {
            float f3 = f;
            f2 = f = f2;
        }
        return f + m_random.nextFloat() * (f2 - f);
    }

    public static float RandNext(float f) {
        return m_random.nextFloat() * f;
    }

    public static int RandNext(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (n > n2) {
            int n3 = n;
            n2 = n = n2;
        }
        return n + m_random.nextInt(n2 - n);
    }

    public static int RandNext(int n) {
        return m_random.nextInt(n);
    }
}

