/*
 * Decompiled with CFR 0.152.
 */
package zombie.text.templating;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import zombie.debug.DebugLog;
import zombie.text.templating.IReplace;
import zombie.text.templating.IReplaceProvider;
import zombie.text.templating.ReplaceList;

public class ReplaceProvider
implements IReplaceProvider {
    protected final Map<String, IReplace> m_keys = new HashMap<String, IReplace>();

    public void addKey(String string, final String string2) {
        this.addReplacer(string, new IReplace(){

            @Override
            public String getString() {
                return string2;
            }
        });
    }

    public void addKey(String string, KahluaTableImpl kahluaTableImpl) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < kahluaTableImpl.len() + 1; ++i) {
                arrayList.add((String)kahluaTableImpl.rawget(i));
            }
            if (arrayList.size() > 0) {
                this.addReplacer(string, new ReplaceList(arrayList));
            } else {
                DebugLog.log("ReplaceProvider -> key '" + string + "' contains no entries, ignoring.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addReplacer(String string, IReplace iReplace) {
        if (this.m_keys.containsKey(string.toLowerCase())) {
            DebugLog.log("ReplaceProvider -> Warning: key '" + string + "' replaces an existing key.");
        }
        this.m_keys.put(string.toLowerCase(), iReplace);
    }

    @Override
    public boolean hasReplacer(String string) {
        return this.m_keys.containsKey(string);
    }

    @Override
    public IReplace getReplacer(String string) {
        return this.m_keys.get(string);
    }
}

