/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import zombie.characters.skills.PerkFactory;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.scripting.objects.BaseScriptObject;
import zombie.util.StringUtils;

public class Recipe
extends BaseScriptObject {
    private boolean canBeDoneFromFloor = false;
    public float TimeToMake = 0.0f;
    public String Sound;
    protected String AnimNode;
    protected String Prop1;
    protected String Prop2;
    public final ArrayList<Source> Source = new ArrayList();
    public Result Result = null;
    public boolean AllowDestroyedItem = false;
    public boolean AllowFrozenItem = false;
    public boolean AllowRottenItem = false;
    public boolean InSameInventory = false;
    public String LuaTest = null;
    public String LuaCreate = null;
    public String LuaGrab = null;
    public String name = "recipe";
    private String originalname;
    private String nearItem;
    private String LuaCanPerform;
    private String tooltip = null;
    public ArrayList<RequiredSkill> skillRequired = null;
    public String LuaGiveXP;
    private boolean needToBeLearn = false;
    protected String category = null;
    protected boolean removeResultItem = false;
    private float heat = 0.0f;
    protected boolean stopOnWalk = true;
    protected boolean stopOnRun = true;
    public boolean hidden = false;

    public boolean isCanBeDoneFromFloor() {
        return this.canBeDoneFromFloor;
    }

    public void setCanBeDoneFromFloor(boolean bl) {
        this.canBeDoneFromFloor = bl;
    }

    public Recipe() {
        this.setOriginalname("recipe");
    }

    public int FindIndexOf(InventoryItem inventoryItem) {
        return -1;
    }

    public ArrayList<Source> getSource() {
        return this.Source;
    }

    public int getNumberOfNeededItem() {
        int n = 0;
        for (int i = 0; i < this.getSource().size(); ++i) {
            Source source = this.getSource().get(i);
            if (source.getItems().isEmpty()) continue;
            n = (int)((float)n + source.getCount());
        }
        return n;
    }

    public float getTimeToMake() {
        return this.TimeToMake;
    }

    public String getName() {
        return this.name;
    }

    public String getFullType() {
        return this.module + "." + this.originalname;
    }

    @Override
    public void Load(String string, String[] stringArray) {
        Recipe recipe;
        this.name = Translator.getRecipeName(string);
        this.originalname = string;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().isEmpty()) continue;
            if (stringArray[i].contains(":")) {
                String[] stringArray2 = stringArray[i].split(":");
                String string2 = stringArray2[0].trim();
                String string3 = stringArray2[1].trim();
                if (string2.equals("Override")) {
                    bl = string3.trim().equalsIgnoreCase("true");
                }
                if (string2.equals("AnimNode")) {
                    this.AnimNode = string3.trim();
                }
                if (string2.equals("Prop1")) {
                    this.Prop1 = string3.trim();
                }
                if (string2.equals("Prop2")) {
                    this.Prop2 = string3.trim();
                }
                if (string2.equals("Time")) {
                    this.TimeToMake = Float.parseFloat(string3);
                }
                if (string2.equals("Sound")) {
                    this.Sound = string3.trim();
                }
                if (string2.equals("InSameInventory")) {
                    this.InSameInventory = Boolean.parseBoolean(string3);
                }
                if (string2.equals("Result")) {
                    this.DoResult(string3);
                }
                if (string2.equals("OnCanPerform")) {
                    this.LuaCanPerform = StringUtils.discardNullOrWhitespace(string3);
                }
                if (string2.equals("OnTest")) {
                    this.LuaTest = string3;
                }
                if (string2.equals("OnCreate")) {
                    this.LuaCreate = string3;
                }
                if (string2.equals("AllowDestroyedItem")) {
                    this.AllowDestroyedItem = Boolean.parseBoolean(string3);
                }
                if (string2.equals("AllowFrozenItem")) {
                    this.AllowFrozenItem = Boolean.parseBoolean(string3);
                }
                if (string2.equals("AllowRottenItem")) {
                    this.AllowRottenItem = Boolean.parseBoolean(string3);
                }
                if (string2.equals("OnGrab")) {
                    this.LuaGrab = string3;
                }
                if (string2.toLowerCase().equals("needtobelearn")) {
                    this.setNeedToBeLearn(string3.trim().equalsIgnoreCase("true"));
                }
                if (string2.toLowerCase().equals("category")) {
                    this.setCategory(string3.trim());
                }
                if (string2.equals("RemoveResultItem")) {
                    this.removeResultItem = string3.trim().equalsIgnoreCase("true");
                }
                if (string2.equals("CanBeDoneFromFloor")) {
                    this.setCanBeDoneFromFloor(string3.trim().equalsIgnoreCase("true"));
                }
                if (string2.equals("NearItem")) {
                    this.setNearItem(string3.trim());
                }
                if (string2.equals("SkillRequired")) {
                    this.skillRequired = new ArrayList();
                    String[] stringArray3 = string3.split(";");
                    for (int j = 0; j < stringArray3.length; ++j) {
                        String[] stringArray4 = stringArray3[j].split("=");
                        PerkFactory.Perk perk = PerkFactory.Perks.FromString(stringArray4[0]);
                        if (perk == PerkFactory.Perks.MAX) {
                            DebugLog.Recipe.warn("Unknown skill \"%s\" in recipe \"%s\"", stringArray4, this.name);
                            continue;
                        }
                        int n = PZMath.tryParseInt(stringArray4[1], 1);
                        RequiredSkill requiredSkill = new RequiredSkill(perk, n);
                        this.skillRequired.add(requiredSkill);
                    }
                }
                if (string2.equals("OnGiveXP")) {
                    this.LuaGiveXP = string3;
                }
                if (string2.equalsIgnoreCase("Tooltip")) {
                    this.tooltip = StringUtils.discardNullOrWhitespace(string3);
                }
                if (string2.equals("Obsolete") && string3.trim().toLowerCase().equals("true")) {
                    this.module.RecipeMap.remove(this);
                    this.module.RecipeByName.remove(this.getOriginalname());
                    this.module.RecipesWithDotInName.remove(this);
                    return;
                }
                if (string2.equals("Heat")) {
                    this.heat = Float.parseFloat(string3);
                }
                if (string2.equals("NoBrokenItems")) {
                    boolean bl2 = this.AllowDestroyedItem = !StringUtils.tryParseBoolean(string3);
                }
                if (string2.equals("StopOnWalk")) {
                    this.stopOnWalk = string3.trim().equalsIgnoreCase("true");
                }
                if (string2.equals("StopOnRun")) {
                    this.stopOnRun = string3.trim().equalsIgnoreCase("true");
                }
                if (!string2.equals("IsHidden")) continue;
                this.hidden = string3.trim().equalsIgnoreCase("true");
                continue;
            }
            this.DoSource(stringArray[i].trim());
        }
        if (bl && (recipe = this.module.getRecipe(string)) != null && recipe != this) {
            this.module.RecipeMap.remove(recipe);
            this.module.RecipeByName.put(string, this);
        }
    }

    public void DoSource(String string) {
        Source source = new Source();
        if (string.contains("=")) {
            source.count = new Float(string.split("=")[1].trim()).floatValue();
            string = string.split("=")[0].trim();
        }
        if (string.indexOf("keep") == 0) {
            string = string.replace("keep ", "");
            source.keep = true;
        }
        if (string.contains(";")) {
            String[] stringArray = string.split(";");
            string = stringArray[0];
            source.use = Float.parseFloat(stringArray[1]);
        }
        if (string.indexOf("destroy") == 0) {
            string = string.replace("destroy ", "");
            source.destroy = true;
        }
        if (string.equals("null")) {
            source.getItems().clear();
        } else if (string.contains("/")) {
            string = string.replaceFirst("keep ", "").trim();
            source.getItems().addAll(Arrays.asList(string.split("/")));
        } else {
            source.getItems().add(string);
        }
        if (!string.isEmpty()) {
            this.Source.add(source);
        }
    }

    public void DoResult(String string) {
        String[] stringArray;
        Result result = new Result();
        if (string.contains("=")) {
            stringArray = string.split("=");
            string = stringArray[0].trim();
            result.count = Integer.parseInt(stringArray[1].trim());
        }
        if (string.contains(";")) {
            stringArray = string.split(";");
            string = stringArray[0].trim();
            result.drainableCount = Integer.parseInt(stringArray[1].trim());
        }
        if (string.contains(".")) {
            result.type = string.split("\\.")[1];
            result.module = string.split("\\.")[0];
        } else {
            result.type = string;
        }
        this.Result = result;
    }

    public Result getResult() {
        return this.Result;
    }

    public String getSound() {
        return this.Sound;
    }

    public void setSound(String string) {
        this.Sound = string;
    }

    public String getOriginalname() {
        return this.originalname;
    }

    public void setOriginalname(String string) {
        this.originalname = string;
    }

    public boolean needToBeLearn() {
        return this.needToBeLearn;
    }

    public void setNeedToBeLearn(boolean bl) {
        this.needToBeLearn = bl;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        this.category = string;
    }

    public ArrayList<String> getRequiredSkills() {
        ArrayList<CallSite> arrayList = null;
        if (this.skillRequired != null) {
            arrayList = new ArrayList<CallSite>();
            for (int i = 0; i < this.skillRequired.size(); ++i) {
                RequiredSkill requiredSkill = this.skillRequired.get(i);
                PerkFactory.Perk perk = PerkFactory.getPerk(requiredSkill.perk);
                if (perk == null) {
                    arrayList.add((CallSite)((Object)(requiredSkill.perk.name + " " + requiredSkill.level)));
                    continue;
                }
                String string = perk.name + " " + requiredSkill.level;
                arrayList.add((CallSite)((Object)string));
            }
        }
        return arrayList;
    }

    public int getRequiredSkillCount() {
        return this.skillRequired == null ? 0 : this.skillRequired.size();
    }

    public RequiredSkill getRequiredSkill(int n) {
        if (this.skillRequired == null || n < 0 || n >= this.skillRequired.size()) {
            return null;
        }
        return this.skillRequired.get(n);
    }

    public void clearRequiredSkills() {
        if (this.skillRequired == null) {
            return;
        }
        this.skillRequired.clear();
    }

    public void addRequiredSkill(PerkFactory.Perk perk, int n) {
        if (this.skillRequired == null) {
            this.skillRequired = new ArrayList();
        }
        this.skillRequired.add(new RequiredSkill(perk, n));
    }

    public Source findSource(String string) {
        for (int i = 0; i < this.Source.size(); ++i) {
            Source source = this.Source.get(i);
            for (int j = 0; j < source.getItems().size(); ++j) {
                if (!source.getItems().get(j).equals(string)) continue;
                return source;
            }
        }
        return null;
    }

    public boolean isDestroy(String string) {
        Source source = this.findSource(string);
        if (source != null) {
            return source.isDestroy();
        }
        throw new RuntimeException("recipe " + this.getOriginalname() + " doesn't use item " + string);
    }

    public boolean isKeep(String string) {
        Source source = this.findSource(string);
        if (source != null) {
            return source.isKeep();
        }
        throw new RuntimeException("recipe " + this.getOriginalname() + " doesn't use item " + string);
    }

    public float getHeat() {
        return this.heat;
    }

    public boolean noBrokenItems() {
        return !this.AllowDestroyedItem;
    }

    public boolean isAllowDestroyedItem() {
        return this.AllowDestroyedItem;
    }

    public void setAllowDestroyedItem(boolean bl) {
        this.AllowDestroyedItem = bl;
    }

    public boolean isAllowFrozenItem() {
        return this.AllowFrozenItem;
    }

    public void setAllowFrozenItem(boolean bl) {
        this.AllowFrozenItem = bl;
    }

    public boolean isAllowRottenItem() {
        return this.AllowRottenItem;
    }

    public void setAllowRottenItem(boolean bl) {
        this.AllowRottenItem = bl;
    }

    public int getWaterAmountNeeded() {
        Source source = this.findSource("Water");
        if (source != null) {
            return (int)source.getCount();
        }
        return 0;
    }

    public String getNearItem() {
        return this.nearItem;
    }

    public void setNearItem(String string) {
        this.nearItem = string;
    }

    public String getCanPerform() {
        return this.LuaCanPerform;
    }

    public void setCanPerform(String string) {
        this.LuaCanPerform = string;
    }

    public String getLuaTest() {
        return this.LuaTest;
    }

    public void setLuaTest(String string) {
        this.LuaTest = string;
    }

    public String getLuaCreate() {
        return this.LuaCreate;
    }

    public void setLuaCreate(String string) {
        this.LuaCreate = string;
    }

    public String getLuaGrab() {
        return this.LuaGrab;
    }

    public void setLuaGrab(String string) {
        this.LuaGrab = string;
    }

    public String getLuaGiveXP() {
        return this.LuaGiveXP;
    }

    public void setLuaGiveXP(String string) {
        this.LuaGiveXP = string;
    }

    public boolean isRemoveResultItem() {
        return this.removeResultItem;
    }

    public void setRemoveResultItem(boolean bl) {
        this.removeResultItem = bl;
    }

    public String getAnimNode() {
        return this.AnimNode;
    }

    public void setAnimNode(String string) {
        this.AnimNode = string;
    }

    public String getProp1() {
        return this.Prop1;
    }

    public void setProp1(String string) {
        this.Prop1 = string;
    }

    public String getProp2() {
        return this.Prop2;
    }

    public void setProp2(String string) {
        this.Prop2 = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setStopOnWalk(boolean bl) {
        this.stopOnWalk = bl;
    }

    public boolean isStopOnWalk() {
        return this.stopOnWalk;
    }

    public void setStopOnRun(boolean bl) {
        this.stopOnRun = bl;
    }

    public boolean isStopOnRun() {
        return this.stopOnRun;
    }

    public void setIsHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isInSameInventory() {
        return this.InSameInventory;
    }

    public static final class Result {
        public String module = null;
        public String type;
        public int count = 1;
        public int drainableCount = 0;

        public String getType() {
            return this.type;
        }

        public void setType(String string) {
            this.type = string;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }

        public String getModule() {
            return this.module;
        }

        public void setModule(String string) {
            this.module = string;
        }

        public String getFullType() {
            return this.module + "." + this.type;
        }

        public int getDrainableCount() {
            return this.drainableCount;
        }

        public void setDrainableCount(int n) {
            this.drainableCount = n;
        }
    }

    public static final class Source {
        public boolean keep = false;
        private final ArrayList<String> items = new ArrayList();
        public boolean destroy = false;
        public float count = 1.0f;
        public float use = 0.0f;

        public boolean isDestroy() {
            return this.destroy;
        }

        public void setDestroy(boolean bl) {
            this.destroy = bl;
        }

        public boolean isKeep() {
            return this.keep;
        }

        public void setKeep(boolean bl) {
            this.keep = bl;
        }

        public float getCount() {
            return this.count;
        }

        public void setCount(float f) {
            this.count = f;
        }

        public float getUse() {
            return this.use;
        }

        public void setUse(float f) {
            this.use = f;
        }

        public ArrayList<String> getItems() {
            return this.items;
        }

        public String getOnlyItem() {
            if (this.items.size() != 1) {
                throw new RuntimeException("items.size() == " + this.items.size());
            }
            return this.items.get(0);
        }
    }

    public static final class RequiredSkill {
        private final PerkFactory.Perk perk;
        private final int level;

        public RequiredSkill(PerkFactory.Perk perk, int n) {
            this.perk = perk;
            this.level = n;
        }

        public PerkFactory.Perk getPerk() {
            return this.perk;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

