/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.joml.Vector3f;
import zombie.ZomboidFileSystem;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.advancedanimation.AnimBoneWeight;
import zombie.core.skinnedmodel.model.Model;
import zombie.debug.DebugLog;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.BaseScriptObject;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.ModelAttachment;
import zombie.scripting.objects.Recipe;
import zombie.util.StringUtils;

public final class ModelScript
extends BaseScriptObject {
    public static final String DEFAULT_SHADER_NAME = "basicEffect";
    public String fileName;
    public String name;
    public String meshName;
    public String textureName;
    public String shaderName;
    public boolean bStatic = true;
    public float scale = 1.0f;
    public final ArrayList<ModelAttachment> m_attachments = new ArrayList();
    public boolean invertX = false;
    public Model loadedModel;
    public final ArrayList<AnimBoneWeight> boneWeights = new ArrayList();
    public String animationsMesh = null;
    private static final HashSet<String> reported = new HashSet();

    public void Load(String string, String string2) {
        ScriptManager scriptManager = ScriptManager.instance;
        this.fileName = scriptManager.currentFileName;
        this.name = string;
        ScriptParser.Block block = ScriptParser.parse(string2);
        block = block.children.get(0);
        for (ScriptParser.Block blockElement : block.children) {
            if (!"attachment".equals(blockElement.type)) continue;
            this.LoadAttachment(blockElement);
        }
        for (ScriptParser.Value value : block.values) {
            String string3 = value.getKey().trim();
            String string4 = value.getValue().trim();
            if ("mesh".equalsIgnoreCase(string3)) {
                this.meshName = string4;
                continue;
            }
            if ("scale".equalsIgnoreCase(string3)) {
                this.scale = Float.parseFloat(string4);
                continue;
            }
            if ("shader".equalsIgnoreCase(string3)) {
                this.shaderName = string4;
                continue;
            }
            if ("static".equalsIgnoreCase(string3)) {
                this.bStatic = Boolean.parseBoolean(string4);
                continue;
            }
            if ("texture".equalsIgnoreCase(string3)) {
                this.textureName = string4;
                continue;
            }
            if ("invertX".equalsIgnoreCase(string3)) {
                this.invertX = Boolean.parseBoolean(string4);
                continue;
            }
            if ("boneWeight".equalsIgnoreCase(string3)) {
                String[] stringArray = string4.split("\\s+");
                if (stringArray.length != 2) continue;
                AnimBoneWeight animBoneWeight = new AnimBoneWeight(stringArray[0], PZMath.tryParseFloat(stringArray[1], 1.0f));
                animBoneWeight.includeDescendants = false;
                this.boneWeights.add(animBoneWeight);
                continue;
            }
            if (!"animationsMesh".equalsIgnoreCase(string3)) continue;
            this.animationsMesh = StringUtils.discardNullOrWhitespace(string4);
        }
    }

    private ModelAttachment LoadAttachment(ScriptParser.Block block) {
        ModelAttachment modelAttachment = this.getAttachmentById(block.id);
        if (modelAttachment == null) {
            modelAttachment = new ModelAttachment(block.id);
            this.m_attachments.add(modelAttachment);
        }
        for (ScriptParser.Value value : block.values) {
            String string = value.getKey().trim();
            String string2 = value.getValue().trim();
            if ("bone".equals(string)) {
                modelAttachment.setBone(string2);
                continue;
            }
            if ("offset".equals(string)) {
                this.LoadVector3f(string2, modelAttachment.getOffset());
                continue;
            }
            if (!"rotate".equals(string)) continue;
            this.LoadVector3f(string2, modelAttachment.getRotate());
        }
        return modelAttachment;
    }

    private void LoadVector3f(String string, Vector3f vector3f) {
        String[] stringArray = string.split(" ");
        vector3f.set(Float.parseFloat(stringArray[0]), Float.parseFloat(stringArray[1]), Float.parseFloat(stringArray[2]));
    }

    public String getName() {
        return this.name;
    }

    public String getFullType() {
        return this.module.name + "." + this.name;
    }

    public String getMeshName() {
        return this.meshName;
    }

    public String getTextureName() {
        if (StringUtils.isNullOrWhitespace(this.textureName)) {
            return this.meshName;
        }
        return this.textureName;
    }

    public String getTextureName(boolean bl) {
        if (StringUtils.isNullOrWhitespace(this.textureName) && !bl) {
            return this.meshName;
        }
        return this.textureName;
    }

    public String getShaderName() {
        if (StringUtils.isNullOrWhitespace(this.shaderName)) {
            return DEFAULT_SHADER_NAME;
        }
        return this.shaderName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getAttachmentCount() {
        return this.m_attachments.size();
    }

    public ModelAttachment getAttachment(int n) {
        return this.m_attachments.get(n);
    }

    public ModelAttachment getAttachmentById(String string) {
        for (int i = 0; i < this.m_attachments.size(); ++i) {
            ModelAttachment modelAttachment = this.m_attachments.get(i);
            if (!modelAttachment.getId().equals(string)) continue;
            return modelAttachment;
        }
        return null;
    }

    public ModelAttachment addAttachment(ModelAttachment modelAttachment) {
        this.m_attachments.add(modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment removeAttachment(ModelAttachment modelAttachment) {
        this.m_attachments.remove(modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment addAttachmentAt(int n, ModelAttachment modelAttachment) {
        this.m_attachments.add(n, modelAttachment);
        return modelAttachment;
    }

    public ModelAttachment removeAttachment(int n) {
        return this.m_attachments.remove(n);
    }

    public void reset() {
        this.invertX = false;
        this.name = null;
        this.meshName = null;
        this.textureName = null;
        this.shaderName = null;
        this.bStatic = true;
        this.scale = 1.0f;
        this.boneWeights.clear();
    }

    private static void checkMesh(String string, String string2) {
        if (StringUtils.isNullOrWhitespace(string2)) {
            return;
        }
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        if (!(ZomboidFileSystem.instance.ActiveFileMap.containsKey("media/models_x/" + string3 + ".fbx") || ZomboidFileSystem.instance.ActiveFileMap.containsKey("media/models_x/" + string3 + ".x") || ZomboidFileSystem.instance.ActiveFileMap.containsKey("media/models/" + string3 + ".txt"))) {
            reported.add(string2);
            DebugLog.Script.warn("no such mesh \"" + string2 + "\" for " + string);
        }
    }

    private static void checkTexture(String string, String string2) {
        if (GameServer.bServer) {
            return;
        }
        if (StringUtils.isNullOrWhitespace(string2)) {
            return;
        }
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        if (!ZomboidFileSystem.instance.ActiveFileMap.containsKey("media/textures/" + string3 + ".png")) {
            reported.add(string2);
            DebugLog.Script.warn("no such texture \"" + string2 + "\" for " + string);
        }
    }

    private static void check(String string, String string2) {
        ModelScript.check(string, string2, null);
    }

    private static void check(String string, String string2, String string3) {
        if (StringUtils.isNullOrWhitespace(string2)) {
            return;
        }
        if (reported.contains(string2)) {
            return;
        }
        ModelScript modelScript = ScriptManager.instance.getModelScript(string2);
        if (modelScript == null) {
            reported.add(string2);
            DebugLog.Script.warn("no such model \"" + string2 + "\" for " + string);
        } else {
            ModelScript.checkMesh(modelScript.getFullType(), modelScript.getMeshName());
            if (StringUtils.isNullOrWhitespace(string3)) {
                ModelScript.checkTexture(modelScript.getFullType(), modelScript.getTextureName());
            }
        }
    }

    public static void ScriptsLoaded() {
        reported.clear();
        ArrayList<Item> arrayList = ScriptManager.instance.getAllItems();
        for (Item object2 : arrayList) {
            object2.resolveModelScripts();
            ModelScript.check(object2.getFullName(), object2.getStaticModel());
            ModelScript.check(object2.getFullName(), object2.getWeaponSprite());
            ModelScript.check(object2.getFullName(), object2.worldStaticModel, object2.getClothingItem());
        }
        ArrayList<Recipe> arrayList2 = ScriptManager.instance.getAllRecipes();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Recipe recipe = (Recipe)iterator.next();
            if (recipe.getProp1() != null && !recipe.getProp1().startsWith("Source=")) {
                ModelScript.check(recipe.getFullType(), recipe.getProp1());
            }
            if (recipe.getProp2() == null || recipe.getProp2().startsWith("Source=")) continue;
            ModelScript.check(recipe.getFullType(), recipe.getProp2());
        }
    }
}

