/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.characterTextures.BloodClothingType;
import zombie.core.Color;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.population.OutfitRNG;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.gameStates.GameLoadingState;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.AlarmClock;
import zombie.inventory.types.AlarmClockClothing;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.ComboItem;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Key;
import zombie.inventory.types.KeyRing;
import zombie.inventory.types.Literature;
import zombie.inventory.types.MapItem;
import zombie.inventory.types.Moveable;
import zombie.inventory.types.Radio;
import zombie.inventory.types.WeaponPart;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.radio.devices.DeviceData;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.BaseScriptObject;
import zombie.scripting.objects.EvolvedRecipe;
import zombie.scripting.objects.ItemRecipe;
import zombie.scripting.objects.ItemReplacement;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.util.StringUtils;
import zombie.world.WorldDictionary;
import zombie.worldMap.MapDefinitions;

public final class Item
extends BaseScriptObject {
    public String clothingExtraSubmenu = null;
    public String DisplayName = null;
    public boolean Hidden = false;
    public boolean CantEat = false;
    public String Icon = "None";
    public boolean Medical = false;
    public boolean CannedFood = false;
    public boolean SurvivalGear = false;
    public boolean MechanicsItem = false;
    public boolean UseWorldItem = false;
    public float ScaleWorldIcon = 1.0f;
    public String CloseKillMove = null;
    public float WeaponLength = 0.4f;
    public float ActualWeight = 1.0f;
    public float WeightWet = 0.0f;
    public float WeightEmpty = 0.0f;
    public float HungerChange = 0.0f;
    public float CriticalChance = 20.0f;
    public int Count = 1;
    public int DaysFresh = 1000000000;
    public int DaysTotallyRotten = 1000000000;
    public int MinutesToCook = 60;
    public int MinutesToBurn = 120;
    public boolean IsCookable = false;
    private String CookingSound = null;
    public float StressChange = 0.0f;
    public float BoredomChange = 0.0f;
    public float UnhappyChange = 0.0f;
    public boolean AlwaysWelcomeGift = false;
    public String ReplaceOnDeplete = null;
    public boolean Ranged = false;
    public boolean CanStoreWater = false;
    public float MaxRange = 1.0f;
    public float MinRange = 0.0f;
    public float ThirstChange = 0.0f;
    public float FatigueChange = 0.0f;
    public float MinAngle = 1.0f;
    public boolean RequiresEquippedBothHands = false;
    public float MaxDamage = 1.5f;
    public float MinDamage = 0.0f;
    public float MinimumSwingTime = 0.0f;
    public String SwingSound = "BaseballBatSwing";
    public String WeaponSprite;
    public boolean AngleFalloff = false;
    public int SoundVolume = 0;
    public float ToHitModifier = 1.0f;
    public int SoundRadius = 0;
    public float OtherCharacterVolumeBoost;
    public final ArrayList<String> Categories = new ArrayList();
    public final ArrayList<String> Tags = new ArrayList();
    public String ImpactSound = "BaseballBatHit";
    public float SwingTime = 1.0f;
    public boolean KnockBackOnNoDeath = true;
    public boolean SplatBloodOnNoDeath = false;
    public float SwingAmountBeforeImpact = 0.0f;
    public String AmmoType = null;
    public int maxAmmo = 0;
    public String GunType = null;
    public int DoorDamage = 1;
    public int ConditionLowerChance = 1000000;
    public int ConditionMax = 10;
    public boolean CanBandage = false;
    public String name;
    public String moduleDotType;
    public int MaxHitCount = 1000;
    public boolean UseSelf = false;
    public boolean OtherHandUse = false;
    public String OtherHandRequire;
    public String PhysicsObject;
    public String SwingAnim = "Rifle";
    public float WeaponWeight = 1.0f;
    public float EnduranceChange = 0.0f;
    public String IdleAnim = "Idle";
    public String RunAnim = "Run";
    public String attachmentType = null;
    public String makeUpType = null;
    public String consolidateOption = null;
    public ArrayList<String> RequireInHandOrInventory = null;
    public String DoorHitSound = "BaseballBatHit";
    public String ReplaceOnUse = null;
    public boolean DangerousUncooked = false;
    public boolean Alcoholic = false;
    public float PushBackMod = 1.0f;
    public int SplatNumber = 2;
    public float NPCSoundBoost = 1.0f;
    public boolean RangeFalloff = false;
    public boolean UseEndurance = true;
    public boolean MultipleHitConditionAffected = true;
    public boolean ShareDamage = true;
    public boolean ShareEndurance = false;
    public boolean CanBarricade = false;
    public boolean UseWhileEquipped = true;
    public boolean UseWhileUnequipped = false;
    public int TicksPerEquipUse = 30;
    public boolean DisappearOnUse = true;
    public float UseDelta = 0.03125f;
    public boolean AlwaysKnockdown = false;
    public float EnduranceMod = 1.0f;
    public float KnockdownMod = 1.0f;
    public boolean CantAttackWithLowestEndurance = false;
    public String ReplaceOnUseOn = null;
    private String ReplaceTypes = null;
    private HashMap<String, String> ReplaceTypesMap = null;
    public boolean IsWaterSource = false;
    public ArrayList<String> attachmentsProvided = null;
    public String FoodType = null;
    public boolean Poison = false;
    public Integer PoisonDetectionLevel = null;
    public int PoisonPower = 0;
    public KahluaTable DefaultModData = null;
    public boolean IsAimedFirearm = false;
    public boolean IsAimedHandWeapon = false;
    public boolean CanStack = true;
    public float AimingMod = 1.0f;
    public int ProjectileCount = 1;
    public float HitAngleMod = 0.0f;
    public float SplatSize = 1.0f;
    public float Temperature = 0.0f;
    public int NumberOfPages = -1;
    public int LvlSkillTrained = -1;
    public int NumLevelsTrained = 1;
    public String SkillTrained = "";
    public int Capacity = 0;
    public int WeightReduction = 0;
    public String SubCategory = "";
    public boolean ActivatedItem = false;
    public float LightStrength = 0.0f;
    public boolean TorchCone = false;
    public int LightDistance = 0;
    public String CanBeEquipped = "";
    public boolean TwoHandWeapon = false;
    public String CustomContextMenu = null;
    public String Tooltip = null;
    public List<String> ReplaceOnCooked = null;
    public String DisplayCategory = null;
    public Boolean Trap = false;
    public boolean OBSOLETE = false;
    public boolean FishingLure = false;
    public boolean canBeWrite = false;
    public int AimingPerkCritModifier = 0;
    public float AimingPerkRangeModifier = 0.0f;
    public float AimingPerkHitChanceModifier = 0.0f;
    public int HitChance = 0;
    public float AimingPerkMinAngleModifier = 0.0f;
    public int RecoilDelay = 0;
    public boolean PiercingBullets = false;
    public float SoundGain = 1.0f;
    public boolean ProtectFromRainWhenEquipped = false;
    private float maxRangeModifier = 0.0f;
    private float minRangeRangedModifier = 0.0f;
    private float damageModifier = 0.0f;
    private float recoilDelayModifier = 0.0f;
    private int clipSizeModifier = 0;
    private ArrayList<String> mountOn = null;
    private String partType = null;
    private int ClipSize = 0;
    private int reloadTime = 0;
    private int reloadTimeModifier = 0;
    private int aimingTime = 0;
    private int aimingTimeModifier = 0;
    private int hitChanceModifier = 0;
    private float angleModifier = 0.0f;
    private float weightModifier = 0.0f;
    private int PageToWrite = 0;
    private boolean RemoveNegativeEffectOnCooked = false;
    private int treeDamage = 0;
    private float alcoholPower = 0.0f;
    private String PutInSound = null;
    private String PlaceOneSound = null;
    private String PlaceMultipleSound = null;
    private String OpenSound = null;
    private String CloseSound = null;
    private String breakSound = null;
    private String customEatSound = null;
    private String fillFromDispenserSound = null;
    private String fillFromTapSound = null;
    private String bulletOutSound = null;
    private String ShellFallSound = null;
    private HashMap<String, String> SoundMap = null;
    private float bandagePower = 0.0f;
    private float ReduceInfectionPower = 0.0f;
    private String OnCooked = null;
    private String OnlyAcceptCategory = null;
    private String AcceptItemFunction = null;
    private boolean padlock = false;
    private boolean digitalPadlock = false;
    private List<String> teachedRecipes = null;
    private int triggerExplosionTimer = 0;
    private boolean canBePlaced = false;
    private int explosionRange = 0;
    private int explosionPower = 0;
    private int fireRange = 0;
    private int firePower = 0;
    private int smokeRange = 0;
    private int noiseRange = 0;
    private int noiseDuration = 0;
    private float extraDamage = 0.0f;
    private int explosionTimer = 0;
    private String PlacedSprite = null;
    private boolean canBeReused = false;
    private int sensorRange = 0;
    private boolean canBeRemote = false;
    private boolean remoteController = false;
    private int remoteRange = 0;
    private String countDownSound = null;
    private String explosionSound = null;
    private int fluReduction = 0;
    private int ReduceFoodSickness = 0;
    private int painReduction = 0;
    private float rainFactor = 0.0f;
    public float torchDot = 0.96f;
    public int colorRed = 255;
    public int colorGreen = 255;
    public int colorBlue = 255;
    public boolean twoWay = false;
    public int transmitRange = 0;
    public int micRange = 0;
    public float baseVolumeRange = 0.0f;
    public boolean isPortable = false;
    public boolean isTelevision = false;
    public int minChannel = 88000;
    public int maxChannel = 108000;
    public boolean usesBattery = false;
    public boolean isHighTier = false;
    public String HerbalistType;
    private float carbohydrates = 0.0f;
    private float lipids = 0.0f;
    private float proteins = 0.0f;
    private float calories = 0.0f;
    private boolean packaged = false;
    private boolean cantBeFrozen = false;
    private String evolvedRecipeName = null;
    private String ReplaceOnRotten = null;
    private float metalValue = 0.0f;
    private String AlarmSound = null;
    private String itemWhenDry = null;
    private float wetCooldown = 0.0f;
    private boolean isWet = false;
    private String onEat = null;
    private boolean cantBeConsolided = false;
    private boolean BadInMicrowave = false;
    private boolean GoodHot = false;
    private boolean BadCold = false;
    public String map = null;
    private boolean keepOnDeplete = false;
    public int vehicleType = 0;
    private int maxCapacity = -1;
    private int itemCapacity = -1;
    private boolean ConditionAffectsCapacity = false;
    private float brakeForce = 0.0f;
    private int chanceToSpawnDamaged = 0;
    private float conditionLowerNormal = 0.0f;
    private float conditionLowerOffroad = 0.0f;
    private float wheelFriction = 0.0f;
    private float suspensionDamping = 0.0f;
    private float suspensionCompression = 0.0f;
    private float engineLoudness = 0.0f;
    public String ClothingItem = null;
    private ClothingItem clothingItemAsset = null;
    private String staticModel = null;
    public String primaryAnimMask = null;
    public String secondaryAnimMask = null;
    public String primaryAnimMaskAttachment = null;
    public String secondaryAnimMaskAttachment = null;
    public String replaceInSecondHand = null;
    public String replaceInPrimaryHand = null;
    public String replaceWhenUnequip = null;
    public ItemReplacement replacePrimaryHand = null;
    public ItemReplacement replaceSecondHand = null;
    public String worldObjectSprite = null;
    public String ItemName;
    public Texture NormalTexture;
    public List<Texture> SpecialTextures = new ArrayList<Texture>();
    public List<String> SpecialWorldTextureNames = new ArrayList<String>();
    public String WorldTextureName;
    public Texture WorldTexture;
    public String eatType;
    private ArrayList<String> IconsForTexture;
    private float baseSpeed = 1.0f;
    private ArrayList<BloodClothingType> bloodClothingType;
    private float stompPower = 1.0f;
    public float runSpeedModifier = 1.0f;
    public float combatSpeedModifier = 1.0f;
    public ArrayList<String> clothingItemExtra;
    public ArrayList<String> clothingItemExtraOption;
    private Boolean removeOnBroken = false;
    public Boolean canHaveHoles = true;
    private boolean cosmetic = false;
    private String ammoBox = null;
    public boolean hairDye = false;
    private String insertAmmoStartSound = null;
    private String insertAmmoSound = null;
    private String insertAmmoStopSound = null;
    private String ejectAmmoStartSound = null;
    private String ejectAmmoSound = null;
    private String ejectAmmoStopSound = null;
    private String rackSound = null;
    private String clickSound = "Stormy9mmClick";
    private String equipSound = null;
    private String unequipSound = null;
    private String bringToBearSound = null;
    private String magazineType = null;
    private String weaponReloadType = null;
    private boolean rackAfterShoot = false;
    private float jamGunChance = 1.0f;
    private ArrayList<ModelWeaponPart> modelWeaponPart = null;
    private boolean haveChamber = true;
    private boolean manuallyRemoveSpentRounds = false;
    private float biteDefense = 0.0f;
    private float scratchDefense = 0.0f;
    private float bulletDefense = 0.0f;
    private String damageCategory = null;
    private boolean damageMakeHole = false;
    public float neckProtectionModifier = 1.0f;
    private String attachmentReplacement = null;
    private boolean insertAllBulletsReload = false;
    private int chanceToFall = 0;
    public String fabricType = null;
    public boolean equippedNoSprint = false;
    public String worldStaticModel = null;
    private float critDmgMultiplier = 0.0f;
    private float insulation = 0.0f;
    private float windresist = 0.0f;
    private float waterresist = 0.0f;
    private String fireMode = null;
    private ArrayList<String> fireModePossibilities = null;
    public boolean RemoveUnhappinessWhenCooked = false;
    private short registry_id = (short)-1;
    private boolean existsAsVanilla = false;
    private String modID;
    private String fileAbsPath;
    public float stopPower = 5.0f;
    private String recordedMediaCat;
    private byte acceptMediaType = (byte)-1;
    private boolean noTransmit = false;
    private boolean worldRender = true;
    private String LuaCreate = null;
    private HashMap<String, String> soundParameterMap = null;
    public String HitSound = "BaseballBatHit";
    public String hitFloorSound = "BatOnFloor";
    public String BodyLocation = "";
    public Stack<String> PaletteChoices = new Stack();
    public String SpriteName = null;
    public String PalettesStart = "";
    public static HashMap<Integer, String> NetIDToItem = new HashMap();
    public static HashMap<String, Integer> NetItemToID = new HashMap();
    static int IDMax = 0;
    public Type type = Type.Normal;
    private boolean Spice = false;
    private int UseForPoison;

    public String getDisplayName() {
        return this.DisplayName;
    }

    public void setDisplayName(String string) {
        this.DisplayName = string;
    }

    public boolean isHidden() {
        return this.Hidden;
    }

    public String getDisplayCategory() {
        return this.DisplayCategory;
    }

    public String getIcon() {
        return this.Icon;
    }

    public void setIcon(String string) {
        this.Icon = string;
    }

    public int getNoiseDuration() {
        return this.noiseDuration;
    }

    public Texture getNormalTexture() {
        return this.NormalTexture;
    }

    public int getNumberOfPages() {
        return this.NumberOfPages;
    }

    public float getActualWeight() {
        return this.ActualWeight;
    }

    public void setActualWeight(float f) {
        this.ActualWeight = f;
    }

    public float getWeightWet() {
        return this.WeightWet;
    }

    public void setWeightWet(float f) {
        this.WeightWet = f;
    }

    public float getWeightEmpty() {
        return this.WeightEmpty;
    }

    public void setWeightEmpty(float f) {
        this.WeightEmpty = f;
    }

    public float getHungerChange() {
        return this.HungerChange;
    }

    public void setHungerChange(float f) {
        this.HungerChange = f;
    }

    public float getThirstChange() {
        return this.ThirstChange;
    }

    public void setThirstChange(float f) {
        this.ThirstChange = f;
    }

    public int getCount() {
        return this.Count;
    }

    public void setCount(int n) {
        this.Count = n;
    }

    public int getDaysFresh() {
        return this.DaysFresh;
    }

    public void setDaysFresh(int n) {
        this.DaysFresh = n;
    }

    public int getDaysTotallyRotten() {
        return this.DaysTotallyRotten;
    }

    public void setDaysTotallyRotten(int n) {
        this.DaysTotallyRotten = n;
    }

    public int getMinutesToCook() {
        return this.MinutesToCook;
    }

    public void setMinutesToCook(int n) {
        this.MinutesToCook = n;
    }

    public int getMinutesToBurn() {
        return this.MinutesToBurn;
    }

    public void setMinutesToBurn(int n) {
        this.MinutesToBurn = n;
    }

    public boolean isIsCookable() {
        return this.IsCookable;
    }

    public void setIsCookable(boolean bl) {
        this.IsCookable = bl;
    }

    public String getCookingSound() {
        return this.CookingSound;
    }

    public float getStressChange() {
        return this.StressChange;
    }

    public void setStressChange(float f) {
        this.StressChange = f;
    }

    public float getBoredomChange() {
        return this.BoredomChange;
    }

    public void setBoredomChange(float f) {
        this.BoredomChange = f;
    }

    public float getUnhappyChange() {
        return this.UnhappyChange;
    }

    public void setUnhappyChange(float f) {
        this.UnhappyChange = f;
    }

    public boolean isAlwaysWelcomeGift() {
        return this.AlwaysWelcomeGift;
    }

    public void setAlwaysWelcomeGift(boolean bl) {
        this.AlwaysWelcomeGift = bl;
    }

    public boolean isRanged() {
        return this.Ranged;
    }

    public boolean getCanStoreWater() {
        return this.CanStoreWater;
    }

    public void setRanged(boolean bl) {
        this.Ranged = bl;
    }

    public float getMaxRange() {
        return this.MaxRange;
    }

    public void setMaxRange(float f) {
        this.MaxRange = f;
    }

    public float getMinAngle() {
        return this.MinAngle;
    }

    public void setMinAngle(float f) {
        this.MinAngle = f;
    }

    public float getMaxDamage() {
        return this.MaxDamage;
    }

    public void setMaxDamage(float f) {
        this.MaxDamage = f;
    }

    public float getMinDamage() {
        return this.MinDamage;
    }

    public void setMinDamage(float f) {
        this.MinDamage = f;
    }

    public float getMinimumSwingTime() {
        return this.MinimumSwingTime;
    }

    public void setMinimumSwingTime(float f) {
        this.MinimumSwingTime = f;
    }

    public String getSwingSound() {
        return this.SwingSound;
    }

    public void setSwingSound(String string) {
        this.SwingSound = string;
    }

    public String getWeaponSprite() {
        return this.WeaponSprite;
    }

    public void setWeaponSprite(String string) {
        this.WeaponSprite = string;
    }

    public boolean isAngleFalloff() {
        return this.AngleFalloff;
    }

    public void setAngleFalloff(boolean bl) {
        this.AngleFalloff = bl;
    }

    public int getSoundVolume() {
        return this.SoundVolume;
    }

    public void setSoundVolume(int n) {
        this.SoundVolume = n;
    }

    public float getToHitModifier() {
        return this.ToHitModifier;
    }

    public void setToHitModifier(float f) {
        this.ToHitModifier = f;
    }

    public int getSoundRadius() {
        return this.SoundRadius;
    }

    public void setSoundRadius(int n) {
        this.SoundRadius = n;
    }

    public float getOtherCharacterVolumeBoost() {
        return this.OtherCharacterVolumeBoost;
    }

    public void setOtherCharacterVolumeBoost(float f) {
        this.OtherCharacterVolumeBoost = f;
    }

    public ArrayList<String> getCategories() {
        return this.Categories;
    }

    public void setCategories(ArrayList<String> arrayList) {
        this.Categories.clear();
        this.Categories.addAll(arrayList);
    }

    public ArrayList<String> getTags() {
        return this.Tags;
    }

    public String getImpactSound() {
        return this.ImpactSound;
    }

    public void setImpactSound(String string) {
        this.ImpactSound = string;
    }

    public float getSwingTime() {
        return this.SwingTime;
    }

    public void setSwingTime(float f) {
        this.SwingTime = f;
    }

    public boolean isKnockBackOnNoDeath() {
        return this.KnockBackOnNoDeath;
    }

    public void setKnockBackOnNoDeath(boolean bl) {
        this.KnockBackOnNoDeath = bl;
    }

    public boolean isSplatBloodOnNoDeath() {
        return this.SplatBloodOnNoDeath;
    }

    public void setSplatBloodOnNoDeath(boolean bl) {
        this.SplatBloodOnNoDeath = bl;
    }

    public float getSwingAmountBeforeImpact() {
        return this.SwingAmountBeforeImpact;
    }

    public void setSwingAmountBeforeImpact(float f) {
        this.SwingAmountBeforeImpact = f;
    }

    public String getAmmoType() {
        return this.AmmoType;
    }

    public void setAmmoType(String string) {
        this.AmmoType = string;
    }

    public int getDoorDamage() {
        return this.DoorDamage;
    }

    public void setDoorDamage(int n) {
        this.DoorDamage = n;
    }

    public int getConditionLowerChance() {
        return this.ConditionLowerChance;
    }

    public void setConditionLowerChance(int n) {
        this.ConditionLowerChance = n;
    }

    public int getConditionMax() {
        return this.ConditionMax;
    }

    public void setConditionMax(int n) {
        this.ConditionMax = n;
    }

    public boolean isCanBandage() {
        return this.CanBandage;
    }

    public void setCanBandage(boolean bl) {
        this.CanBandage = bl;
    }

    public boolean isCosmetic() {
        return this.cosmetic;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        return this.module.name;
    }

    public String getFullName() {
        return this.moduleDotType;
    }

    public void setName(String string) {
        this.name = string;
        this.moduleDotType = this.module.name + "." + string;
    }

    public int getMaxHitCount() {
        return this.MaxHitCount;
    }

    public void setMaxHitCount(int n) {
        this.MaxHitCount = n;
    }

    public boolean isUseSelf() {
        return this.UseSelf;
    }

    public void setUseSelf(boolean bl) {
        this.UseSelf = bl;
    }

    public boolean isOtherHandUse() {
        return this.OtherHandUse;
    }

    public void setOtherHandUse(boolean bl) {
        this.OtherHandUse = bl;
    }

    public String getOtherHandRequire() {
        return this.OtherHandRequire;
    }

    public void setOtherHandRequire(String string) {
        this.OtherHandRequire = string;
    }

    public String getPhysicsObject() {
        return this.PhysicsObject;
    }

    public void setPhysicsObject(String string) {
        this.PhysicsObject = string;
    }

    public String getSwingAnim() {
        return this.SwingAnim;
    }

    public void setSwingAnim(String string) {
        this.SwingAnim = string;
    }

    public float getWeaponWeight() {
        return this.WeaponWeight;
    }

    public void setWeaponWeight(float f) {
        this.WeaponWeight = f;
    }

    public float getEnduranceChange() {
        return this.EnduranceChange;
    }

    public void setEnduranceChange(float f) {
        this.EnduranceChange = f;
    }

    public String getBreakSound() {
        return this.breakSound;
    }

    public String getBulletOutSound() {
        return this.bulletOutSound;
    }

    public String getCloseSound() {
        return this.CloseSound;
    }

    public String getClothingItem() {
        return this.ClothingItem;
    }

    public void setClothingItemAsset(ClothingItem clothingItem) {
        this.clothingItemAsset = clothingItem;
    }

    public ClothingItem getClothingItemAsset() {
        return this.clothingItemAsset;
    }

    public ArrayList<String> getClothingItemExtra() {
        return this.clothingItemExtra;
    }

    public ArrayList<String> getClothingItemExtraOption() {
        return this.clothingItemExtraOption;
    }

    public String getFabricType() {
        return this.fabricType;
    }

    public ArrayList<String> getIconsForTexture() {
        return this.IconsForTexture;
    }

    public String getCustomEatSound() {
        return this.customEatSound;
    }

    public String getFillFromDispenserSound() {
        return this.fillFromDispenserSound;
    }

    public String getFillFromTapSound() {
        return this.fillFromTapSound;
    }

    public String getEatType() {
        return this.eatType;
    }

    public String getCountDownSound() {
        return this.countDownSound;
    }

    public String getBringToBearSound() {
        return this.bringToBearSound;
    }

    public String getEjectAmmoStartSound() {
        return this.ejectAmmoStartSound;
    }

    public String getEjectAmmoSound() {
        return this.ejectAmmoSound;
    }

    public String getEjectAmmoStopSound() {
        return this.ejectAmmoStopSound;
    }

    public String getInsertAmmoStartSound() {
        return this.insertAmmoStartSound;
    }

    public String getInsertAmmoSound() {
        return this.insertAmmoSound;
    }

    public String getInsertAmmoStopSound() {
        return this.insertAmmoStopSound;
    }

    public String getEquipSound() {
        return this.equipSound;
    }

    public String getUnequipSound() {
        return this.unequipSound;
    }

    public String getExplosionSound() {
        return this.explosionSound;
    }

    public String getStaticModel() {
        return this.staticModel;
    }

    public String getOpenSound() {
        return this.OpenSound;
    }

    public String getPutInSound() {
        return this.PutInSound;
    }

    public String getPlaceOneSound() {
        return this.PlaceOneSound;
    }

    public String getPlaceMultipleSound() {
        return this.PlaceMultipleSound;
    }

    public String getShellFallSound() {
        return this.ShellFallSound;
    }

    public String getSoundByID(String string) {
        if (this.SoundMap == null) {
            return null;
        }
        return this.SoundMap.getOrDefault(string, null);
    }

    public String getSkillTrained() {
        return this.SkillTrained;
    }

    public String getDoorHitSound() {
        return this.DoorHitSound;
    }

    public void setDoorHitSound(String string) {
        this.DoorHitSound = string;
    }

    public boolean isManuallyRemoveSpentRounds() {
        return this.manuallyRemoveSpentRounds;
    }

    public float getRainFactor() {
        return this.rainFactor;
    }

    public String getReplaceOnUse() {
        return this.ReplaceOnUse;
    }

    public void setReplaceOnUse(String string) {
        this.ReplaceOnUse = string;
    }

    public String getReplaceOnDeplete() {
        return this.ReplaceOnDeplete;
    }

    public void setReplaceOnDeplete(String string) {
        this.ReplaceOnDeplete = string;
    }

    public String getReplaceTypes() {
        return this.ReplaceTypes;
    }

    public HashMap<String, String> getReplaceTypesMap() {
        return this.ReplaceTypesMap;
    }

    public String getReplaceType(String string) {
        return this.ReplaceTypesMap == null ? null : this.ReplaceTypesMap.get(string);
    }

    public boolean hasReplaceType(String string) {
        return this.getReplaceType(string) != null;
    }

    public boolean isDangerousUncooked() {
        return this.DangerousUncooked;
    }

    public void setDangerousUncooked(boolean bl) {
        this.DangerousUncooked = bl;
    }

    public boolean isAlcoholic() {
        return this.Alcoholic;
    }

    public void setAlcoholic(boolean bl) {
        this.Alcoholic = bl;
    }

    public float getPushBackMod() {
        return this.PushBackMod;
    }

    public void setPushBackMod(float f) {
        this.PushBackMod = f;
    }

    public int getSplatNumber() {
        return this.SplatNumber;
    }

    public void setSplatNumber(int n) {
        this.SplatNumber = n;
    }

    public float getNPCSoundBoost() {
        return this.NPCSoundBoost;
    }

    public void setNPCSoundBoost(float f) {
        this.NPCSoundBoost = f;
    }

    public boolean isRangeFalloff() {
        return this.RangeFalloff;
    }

    public void setRangeFalloff(boolean bl) {
        this.RangeFalloff = bl;
    }

    public boolean isUseEndurance() {
        return this.UseEndurance;
    }

    public void setUseEndurance(boolean bl) {
        this.UseEndurance = bl;
    }

    public boolean isMultipleHitConditionAffected() {
        return this.MultipleHitConditionAffected;
    }

    public void setMultipleHitConditionAffected(boolean bl) {
        this.MultipleHitConditionAffected = bl;
    }

    public boolean isShareDamage() {
        return this.ShareDamage;
    }

    public void setShareDamage(boolean bl) {
        this.ShareDamage = bl;
    }

    public boolean isShareEndurance() {
        return this.ShareEndurance;
    }

    public void setShareEndurance(boolean bl) {
        this.ShareEndurance = bl;
    }

    public boolean isCanBarricade() {
        return this.CanBarricade;
    }

    public void setCanBarricade(boolean bl) {
        this.CanBarricade = bl;
    }

    public boolean isUseWhileEquipped() {
        return this.UseWhileEquipped;
    }

    public void setUseWhileEquipped(boolean bl) {
        this.UseWhileEquipped = bl;
    }

    public boolean isUseWhileUnequipped() {
        return this.UseWhileUnequipped;
    }

    public void setUseWhileUnequipped(boolean bl) {
        this.UseWhileUnequipped = bl;
    }

    public void setTicksPerEquipUse(int n) {
        this.TicksPerEquipUse = n;
    }

    public float getTicksPerEquipUse() {
        return this.TicksPerEquipUse;
    }

    public boolean isDisappearOnUse() {
        return this.DisappearOnUse;
    }

    public void setDisappearOnUse(boolean bl) {
        this.DisappearOnUse = bl;
    }

    public float getUseDelta() {
        return this.UseDelta;
    }

    public void setUseDelta(float f) {
        this.UseDelta = f;
    }

    public boolean isAlwaysKnockdown() {
        return this.AlwaysKnockdown;
    }

    public void setAlwaysKnockdown(boolean bl) {
        this.AlwaysKnockdown = bl;
    }

    public float getEnduranceMod() {
        return this.EnduranceMod;
    }

    public void setEnduranceMod(float f) {
        this.EnduranceMod = f;
    }

    public float getKnockdownMod() {
        return this.KnockdownMod;
    }

    public void setKnockdownMod(float f) {
        this.KnockdownMod = f;
    }

    public boolean isCantAttackWithLowestEndurance() {
        return this.CantAttackWithLowestEndurance;
    }

    public void setCantAttackWithLowestEndurance(boolean bl) {
        this.CantAttackWithLowestEndurance = bl;
    }

    public String getBodyLocation() {
        return this.BodyLocation;
    }

    public void setBodyLocation(String string) {
        this.BodyLocation = string;
    }

    public Stack<String> getPaletteChoices() {
        return this.PaletteChoices;
    }

    public void setPaletteChoices(Stack<String> stack) {
        this.PaletteChoices = stack;
    }

    public String getSpriteName() {
        return this.SpriteName;
    }

    public void setSpriteName(String string) {
        this.SpriteName = string;
    }

    public String getPalettesStart() {
        return this.PalettesStart;
    }

    public void setPalettesStart(String string) {
        this.PalettesStart = string;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getTypeString() {
        return this.type.name();
    }

    public String getMapID() {
        return this.map;
    }

    @Override
    public void Load(String string, String[] stringArray) {
        this.name = string;
        this.moduleDotType = this.module.name + "." + string;
        int n = IDMax++;
        NetIDToItem.put(n, this.moduleDotType);
        NetItemToID.put(this.moduleDotType, n);
        this.modID = ScriptManager.getCurrentLoadFileMod();
        if (this.modID.equals("pz-vanilla")) {
            this.existsAsVanilla = true;
        }
        this.fileAbsPath = ScriptManager.getCurrentLoadFileAbsPath();
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray2[i];
            this.DoParam(string2);
        }
        if (this.DisplayName == null) {
            this.DisplayName = this.getFullName();
            this.Hidden = true;
        }
        if (!StringUtils.isNullOrWhitespace(this.replaceInPrimaryHand) && (stringArray2 = this.replaceInPrimaryHand.trim().split("\\s+")).length == 2) {
            this.replacePrimaryHand = new ItemReplacement();
            this.replacePrimaryHand.clothingItemName = stringArray2[0].trim();
            this.replacePrimaryHand.maskVariableValue = stringArray2[1].trim();
            this.replacePrimaryHand.maskVariableName = "RightHandMask";
        }
        if (!StringUtils.isNullOrWhitespace(this.replaceInSecondHand) && (stringArray2 = this.replaceInSecondHand.trim().split("\\s+")).length == 2) {
            this.replaceSecondHand = new ItemReplacement();
            this.replaceSecondHand.clothingItemName = stringArray2[0].trim();
            this.replaceSecondHand.maskVariableValue = stringArray2[1].trim();
            this.replaceSecondHand.maskVariableName = "LeftHandMask";
        }
        if (!StringUtils.isNullOrWhitespace(this.primaryAnimMask)) {
            this.replacePrimaryHand = new ItemReplacement();
            this.replacePrimaryHand.maskVariableValue = this.primaryAnimMask;
            this.replacePrimaryHand.maskVariableName = "RightHandMask";
            this.replacePrimaryHand.attachment = this.primaryAnimMaskAttachment;
        }
        if (!StringUtils.isNullOrWhitespace(this.secondaryAnimMask)) {
            this.replaceSecondHand = new ItemReplacement();
            this.replaceSecondHand.maskVariableValue = this.secondaryAnimMask;
            this.replaceSecondHand.maskVariableName = "LeftHandMask";
            this.replaceSecondHand.attachment = this.secondaryAnimMaskAttachment;
        }
        WorldDictionary.onLoadItem(this);
    }

    public InventoryItem InstanceItem(String string) {
        Object object;
        Object object2;
        Object object3 = null;
        if (this.type == Type.Key) {
            object3 = new Key(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon);
            ((Key)object3).setDigitalPadlock(this.digitalPadlock);
            ((Key)object3).setPadlock(this.padlock);
            if (((Key)object3).isPadlock()) {
                ((Key)object3).setNumberOfKey(2);
                ((Key)object3).setKeyId(Rand.Next(10000000));
            }
        }
        if (this.type == Type.KeyRing) {
            object3 = new KeyRing(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon);
        }
        if (this.type == Type.WeaponPart) {
            object3 = new WeaponPart(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon);
            object2 = (WeaponPart)object3;
            ((WeaponPart)object2).setDamage(this.damageModifier);
            ((WeaponPart)object2).setClipSize(this.clipSizeModifier);
            ((WeaponPart)object2).setMaxRange(this.maxRangeModifier);
            ((WeaponPart)object2).setMinRangeRanged(this.minRangeRangedModifier);
            ((WeaponPart)object2).setRecoilDelay(this.recoilDelayModifier);
            ((WeaponPart)object2).setMountOn(this.mountOn);
            ((WeaponPart)object2).setPartType(this.partType);
            ((WeaponPart)object2).setReloadTime(this.reloadTimeModifier);
            ((WeaponPart)object2).setAimingTime(this.aimingTimeModifier);
            ((WeaponPart)object2).setHitChance(this.hitChanceModifier);
            ((WeaponPart)object2).setAngle(this.angleModifier);
            ((WeaponPart)object2).setWeightModifier(this.weightModifier);
        }
        if (this.type == Type.Container) {
            object3 = new InventoryContainer(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon);
            object2 = (InventoryContainer)object3;
            ((InventoryItem)object2).setItemCapacity(this.Capacity);
            ((InventoryContainer)object2).setCapacity(this.Capacity);
            ((InventoryContainer)object2).setWeightReduction(this.WeightReduction);
            ((InventoryContainer)object2).setCanBeEquipped(this.CanBeEquipped);
            ((InventoryContainer)object2).getInventory().setPutSound(this.PutInSound);
            ((InventoryContainer)object2).getInventory().setCloseSound(this.CloseSound);
            ((InventoryContainer)object2).getInventory().setOpenSound(this.OpenSound);
            ((InventoryContainer)object2).getInventory().setOnlyAcceptCategory(this.OnlyAcceptCategory);
            ((InventoryContainer)object2).getInventory().setAcceptItemFunction(this.AcceptItemFunction);
        }
        if (this.type == Type.Food) {
            object3 = new Food(this.module.name, this.DisplayName, this.name, this);
            object2 = (Food)object3;
            ((Food)object2).Poison = this.Poison;
            ((Food)object2).setPoisonLevelForRecipe(this.PoisonDetectionLevel);
            ((Food)object2).setFoodType(this.FoodType);
            ((Food)object2).setPoisonPower(this.PoisonPower);
            ((Food)object2).setUseForPoison(this.UseForPoison);
            ((Food)object2).setThirstChange(this.ThirstChange / 100.0f);
            ((Food)object2).setHungChange(this.HungerChange / 100.0f);
            ((Food)object2).setBaseHunger(this.HungerChange / 100.0f);
            ((Food)object2).setEndChange(this.EnduranceChange / 100.0f);
            ((InventoryItem)object2).setOffAge(this.DaysFresh);
            ((InventoryItem)object2).setOffAgeMax(this.DaysTotallyRotten);
            ((InventoryItem)object2).setIsCookable(this.IsCookable);
            ((InventoryItem)object2).setMinutesToCook(this.MinutesToCook);
            ((InventoryItem)object2).setMinutesToBurn(this.MinutesToBurn);
            ((Food)object2).setbDangerousUncooked(this.DangerousUncooked);
            ((InventoryItem)object2).setReplaceOnUse(this.ReplaceOnUse);
            ((Food)object2).setReplaceOnCooked(this.ReplaceOnCooked);
            ((Food)object2).setSpice(this.Spice);
            ((Food)object2).setRemoveNegativeEffectOnCooked(this.RemoveNegativeEffectOnCooked);
            ((Food)object2).setCustomEatSound(this.customEatSound);
            ((Food)object2).setOnCooked(this.OnCooked);
            ((Food)object2).setFluReduction(this.fluReduction);
            ((Food)object2).setReduceFoodSickness(this.ReduceFoodSickness);
            ((Food)object2).setPainReduction(this.painReduction);
            ((Food)object2).setHerbalistType(this.HerbalistType);
            ((Food)object2).setCarbohydrates(this.carbohydrates);
            ((Food)object2).setLipids(this.lipids);
            ((Food)object2).setProteins(this.proteins);
            ((Food)object2).setCalories(this.calories);
            ((Food)object2).setPackaged(this.packaged);
            ((Food)object2).setCanBeFrozen(!this.cantBeFrozen);
            ((Food)object2).setReplaceOnRotten(this.ReplaceOnRotten);
            ((Food)object2).setOnEat(this.onEat);
            ((Food)object2).setBadInMicrowave(this.BadInMicrowave);
            ((Food)object2).setGoodHot(this.GoodHot);
            ((Food)object2).setBadCold(this.BadCold);
        }
        if (this.type == Type.Literature) {
            object3 = new Literature(this.module.name, this.DisplayName, this.name, this);
            object2 = (Literature)object3;
            ((InventoryItem)object2).setReplaceOnUse(this.ReplaceOnUse);
            ((Literature)object2).setNumberOfPages(this.NumberOfPages);
            ((Literature)object2).setAlreadyReadPages(0);
            ((Literature)object2).setSkillTrained(this.SkillTrained);
            ((Literature)object2).setLvlSkillTrained(this.LvlSkillTrained);
            ((Literature)object2).setNumLevelsTrained(this.NumLevelsTrained);
            ((Literature)object2).setCanBeWrite(this.canBeWrite);
            ((Literature)object2).setPageToWrite(this.PageToWrite);
            ((Literature)object2).setTeachedRecipes(this.teachedRecipes);
        } else if (this.type == Type.AlarmClock) {
            object3 = new AlarmClock(this.module.name, this.DisplayName, this.name, this);
            object2 = (AlarmClock)object3;
            ((AlarmClock)object2).setAlarmSound(this.AlarmSound);
            ((AlarmClock)object2).setSoundRadius(this.SoundRadius);
        } else if (this.type == Type.AlarmClockClothing) {
            object2 = "";
            String string2 = null;
            if (!this.PaletteChoices.isEmpty() || string != null) {
                int n = Rand.Next(this.PaletteChoices.size());
                string2 = (String)this.PaletteChoices.get(n);
                if (string != null) {
                    string2 = string;
                }
                object2 = "_" + string2.replace(this.PalettesStart, "");
            }
            object3 = new AlarmClockClothing(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon.replace(".png", "") + (String)object2, string2, this.SpriteName);
            object = (AlarmClockClothing)object3;
            ((Clothing)object).setTemperature(this.Temperature);
            ((Clothing)object).setInsulation(this.insulation);
            ((Clothing)object).setConditionLowerChance(this.ConditionLowerChance);
            ((Clothing)object).setStompPower(this.stompPower);
            ((Clothing)object).setRunSpeedModifier(this.runSpeedModifier);
            ((Clothing)object).setCombatSpeedModifier(this.combatSpeedModifier);
            ((Clothing)object).setRemoveOnBroken(this.removeOnBroken);
            ((Clothing)object).setCanHaveHoles(this.canHaveHoles);
            ((Clothing)object).setWeightWet(this.WeightWet);
            ((Clothing)object).setBiteDefense(this.biteDefense);
            ((Clothing)object).setBulletDefense(this.bulletDefense);
            ((Clothing)object).setNeckProtectionModifier(this.neckProtectionModifier);
            ((Clothing)object).setScratchDefense(this.scratchDefense);
            ((Clothing)object).setChanceToFall(this.chanceToFall);
            ((Clothing)object).setWindresistance(this.windresist);
            ((Clothing)object).setWaterResistance(this.waterresist);
            ((AlarmClockClothing)object).setAlarmSound(this.AlarmSound);
            ((AlarmClockClothing)object).setSoundRadius(this.SoundRadius);
        } else if (this.type == Type.Weapon) {
            object3 = new HandWeapon(this.module.name, this.DisplayName, this.name, this);
            object2 = (HandWeapon)object3;
            ((HandWeapon)object2).setMultipleHitConditionAffected(this.MultipleHitConditionAffected);
            ((HandWeapon)object2).setConditionLowerChance(this.ConditionLowerChance);
            ((HandWeapon)object2).SplatSize = this.SplatSize;
            ((HandWeapon)object2).aimingMod = this.AimingMod;
            ((HandWeapon)object2).setMinDamage(this.MinDamage);
            ((HandWeapon)object2).setMaxDamage(this.MaxDamage);
            ((HandWeapon)object2).setBaseSpeed(this.baseSpeed);
            ((HandWeapon)object2).setPhysicsObject(this.PhysicsObject);
            ((HandWeapon)object2).setOtherHandRequire(this.OtherHandRequire);
            ((HandWeapon)object2).setOtherHandUse(this.OtherHandUse);
            ((HandWeapon)object2).setMaxRange(this.MaxRange);
            ((HandWeapon)object2).setMinRange(this.MinRange);
            ((HandWeapon)object2).setShareEndurance(this.ShareEndurance);
            ((HandWeapon)object2).setKnockdownMod(this.KnockdownMod);
            ((HandWeapon)object2).bIsAimedFirearm = this.IsAimedFirearm;
            ((HandWeapon)object2).RunAnim = this.RunAnim;
            ((HandWeapon)object2).IdleAnim = this.IdleAnim;
            ((HandWeapon)object2).HitAngleMod = (float)Math.toRadians(this.HitAngleMod);
            ((HandWeapon)object2).bIsAimedHandWeapon = this.IsAimedHandWeapon;
            ((HandWeapon)object2).setCantAttackWithLowestEndurance(this.CantAttackWithLowestEndurance);
            ((HandWeapon)object2).setAlwaysKnockdown(this.AlwaysKnockdown);
            ((HandWeapon)object2).setEnduranceMod(this.EnduranceMod);
            ((HandWeapon)object2).setUseSelf(this.UseSelf);
            ((HandWeapon)object2).setMaxHitCount(this.MaxHitCount);
            ((HandWeapon)object2).setMinimumSwingTime(this.MinimumSwingTime);
            ((HandWeapon)object2).setSwingTime(this.SwingTime);
            ((HandWeapon)object2).setDoSwingBeforeImpact(this.SwingAmountBeforeImpact);
            ((HandWeapon)object2).setMinAngle(this.MinAngle);
            ((HandWeapon)object2).setDoorDamage(this.DoorDamage);
            ((HandWeapon)object2).setTreeDamage(this.treeDamage);
            ((HandWeapon)object2).setDoorHitSound(this.DoorHitSound);
            ((HandWeapon)object2).setHitFloorSound(this.hitFloorSound);
            ((HandWeapon)object2).setZombieHitSound(this.HitSound);
            ((HandWeapon)object2).setPushBackMod(this.PushBackMod);
            ((InventoryItem)object2).setWeight(this.WeaponWeight);
            ((HandWeapon)object2).setImpactSound(this.ImpactSound);
            ((HandWeapon)object2).setSplatNumber(this.SplatNumber);
            ((HandWeapon)object2).setKnockBackOnNoDeath(this.KnockBackOnNoDeath);
            ((HandWeapon)object2).setSplatBloodOnNoDeath(this.SplatBloodOnNoDeath);
            ((HandWeapon)object2).setSwingSound(this.SwingSound);
            ((HandWeapon)object2).setBulletOutSound(this.bulletOutSound);
            ((HandWeapon)object2).setShellFallSound(this.ShellFallSound);
            ((HandWeapon)object2).setAngleFalloff(this.AngleFalloff);
            ((HandWeapon)object2).setSoundVolume(this.SoundVolume);
            ((HandWeapon)object2).setSoundRadius(this.SoundRadius);
            ((HandWeapon)object2).setToHitModifier(this.ToHitModifier);
            ((HandWeapon)object2).setOtherBoost(this.NPCSoundBoost);
            ((HandWeapon)object2).setRanged(this.Ranged);
            ((HandWeapon)object2).setRangeFalloff(this.RangeFalloff);
            ((HandWeapon)object2).setUseEndurance(this.UseEndurance);
            ((HandWeapon)object2).setCriticalChance(this.CriticalChance);
            ((HandWeapon)object2).setCritDmgMultiplier(this.critDmgMultiplier);
            ((HandWeapon)object2).setShareDamage(this.ShareDamage);
            ((HandWeapon)object2).setCanBarracade(this.CanBarricade);
            ((HandWeapon)object2).setWeaponSprite(this.WeaponSprite);
            ((HandWeapon)object2).setOriginalWeaponSprite(this.WeaponSprite);
            ((HandWeapon)object2).setSubCategory(this.SubCategory);
            ((HandWeapon)object2).setCategories(this.Categories);
            ((HandWeapon)object2).setSoundGain(this.SoundGain);
            ((HandWeapon)object2).setAimingPerkCritModifier(this.AimingPerkCritModifier);
            ((HandWeapon)object2).setAimingPerkRangeModifier(this.AimingPerkRangeModifier);
            ((HandWeapon)object2).setAimingPerkHitChanceModifier(this.AimingPerkHitChanceModifier);
            ((HandWeapon)object2).setHitChance(this.HitChance);
            ((HandWeapon)object2).setRecoilDelay(this.RecoilDelay);
            ((HandWeapon)object2).setAimingPerkMinAngleModifier(this.AimingPerkMinAngleModifier);
            ((HandWeapon)object2).setPiercingBullets(this.PiercingBullets);
            ((HandWeapon)object2).setClipSize(this.ClipSize);
            ((HandWeapon)object2).setReloadTime(this.reloadTime);
            ((HandWeapon)object2).setAimingTime(this.aimingTime);
            ((HandWeapon)object2).setTriggerExplosionTimer(this.triggerExplosionTimer);
            ((HandWeapon)object2).setSensorRange(this.sensorRange);
            ((HandWeapon)object2).setWeaponLength(this.WeaponLength);
            ((HandWeapon)object2).setPlacedSprite(this.PlacedSprite);
            ((HandWeapon)object2).setExplosionTimer(this.explosionTimer);
            ((HandWeapon)object2).setCanBePlaced(this.canBePlaced);
            ((HandWeapon)object2).setCanBeReused(this.canBeReused);
            ((HandWeapon)object2).setExplosionRange(this.explosionRange);
            ((HandWeapon)object2).setExplosionPower(this.explosionPower);
            ((HandWeapon)object2).setFireRange(this.fireRange);
            ((HandWeapon)object2).setFirePower(this.firePower);
            ((HandWeapon)object2).setSmokeRange(this.smokeRange);
            ((HandWeapon)object2).setNoiseRange(this.noiseRange);
            ((HandWeapon)object2).setExtraDamage(this.extraDamage);
            ((HandWeapon)object2).setAmmoBox(this.ammoBox);
            ((HandWeapon)object2).setRackSound(this.rackSound);
            ((HandWeapon)object2).setClickSound(this.clickSound);
            ((HandWeapon)object2).setMagazineType(this.magazineType);
            ((HandWeapon)object2).setWeaponReloadType(this.weaponReloadType);
            ((HandWeapon)object2).setInsertAllBulletsReload(this.insertAllBulletsReload);
            ((HandWeapon)object2).setRackAfterShoot(this.rackAfterShoot);
            ((HandWeapon)object2).setJamGunChance(this.jamGunChance);
            ((HandWeapon)object2).setModelWeaponPart(this.modelWeaponPart);
            ((HandWeapon)object2).setHaveChamber(this.haveChamber);
            ((HandWeapon)object2).setDamageCategory(this.damageCategory);
            ((HandWeapon)object2).setDamageMakeHole(this.damageMakeHole);
            ((HandWeapon)object2).setFireMode(this.fireMode);
            ((HandWeapon)object2).setFireModePossibilities(this.fireModePossibilities);
        } else if (this.type == Type.Normal) {
            object3 = new ComboItem(this.module.name, this.DisplayName, this.name, this);
        } else if (this.type == Type.Clothing) {
            object2 = "";
            String string3 = null;
            if (!this.PaletteChoices.isEmpty() || string != null) {
                int n = Rand.Next(this.PaletteChoices.size());
                string3 = (String)this.PaletteChoices.get(n);
                if (string != null) {
                    string3 = string;
                }
                object2 = "_" + string3.replace(this.PalettesStart, "");
            }
            object3 = new Clothing(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon.replace(".png", "") + (String)object2, string3, this.SpriteName);
            object = (Clothing)object3;
            ((Clothing)object).setTemperature(this.Temperature);
            ((Clothing)object).setInsulation(this.insulation);
            ((Clothing)object).setConditionLowerChance(this.ConditionLowerChance);
            ((Clothing)object).setStompPower(this.stompPower);
            ((Clothing)object).setRunSpeedModifier(this.runSpeedModifier);
            ((Clothing)object).setCombatSpeedModifier(this.combatSpeedModifier);
            ((Clothing)object).setRemoveOnBroken(this.removeOnBroken);
            ((Clothing)object).setCanHaveHoles(this.canHaveHoles);
            ((Clothing)object).setWeightWet(this.WeightWet);
            ((Clothing)object).setBiteDefense(this.biteDefense);
            ((Clothing)object).setBulletDefense(this.bulletDefense);
            ((Clothing)object).setNeckProtectionModifier(this.neckProtectionModifier);
            ((Clothing)object).setScratchDefense(this.scratchDefense);
            ((Clothing)object).setChanceToFall(this.chanceToFall);
            ((Clothing)object).setWindresistance(this.windresist);
            ((Clothing)object).setWaterResistance(this.waterresist);
        } else if (this.type == Type.Drainable) {
            object3 = new DrainableComboItem(this.module.name, this.DisplayName, this.name, this);
            object2 = (DrainableComboItem)object3;
            ((DrainableComboItem)object2).setUseWhileEquiped(this.UseWhileEquipped);
            ((DrainableComboItem)object2).setUseWhileUnequiped(this.UseWhileUnequipped);
            ((DrainableComboItem)object2).setTicksPerEquipUse(this.TicksPerEquipUse);
            ((DrainableComboItem)object2).setUseDelta(this.UseDelta);
            ((DrainableComboItem)object2).setReplaceOnDeplete(this.ReplaceOnDeplete);
            ((InventoryItem)object2).setIsCookable(this.IsCookable);
            ((DrainableComboItem)object2).setReplaceOnCooked(this.ReplaceOnCooked);
            ((InventoryItem)object2).setMinutesToCook(this.MinutesToCook);
            ((DrainableComboItem)object2).setOnCooked(this.OnCooked);
            ((DrainableComboItem)object2).setRainFactor(this.rainFactor);
            ((DrainableComboItem)object2).setCanConsolidate(!this.cantBeConsolided);
            ((DrainableComboItem)object2).setWeightEmpty(this.WeightEmpty);
        } else if (this.type == Type.Radio) {
            object3 = new Radio(this.module.name, this.DisplayName, this.name, "Item_" + this.Icon);
            object2 = (Radio)object3;
            DeviceData deviceData = ((Radio)object2).getDeviceData();
            if (deviceData != null) {
                if (this.DisplayName != null) {
                    deviceData.setDeviceName(this.DisplayName);
                }
                deviceData.setIsTwoWay(this.twoWay);
                deviceData.setTransmitRange(this.transmitRange);
                deviceData.setMicRange(this.micRange);
                deviceData.setBaseVolumeRange(this.baseVolumeRange);
                deviceData.setIsPortable(this.isPortable);
                deviceData.setIsTelevision(this.isTelevision);
                deviceData.setMinChannelRange(this.minChannel);
                deviceData.setMaxChannelRange(this.maxChannel);
                deviceData.setIsBatteryPowered(this.usesBattery);
                deviceData.setIsHighTier(this.isHighTier);
                deviceData.setUseDelta(this.UseDelta);
                deviceData.setMediaType(this.acceptMediaType);
                deviceData.setNoTransmit(this.noTransmit);
                deviceData.generatePresets();
                deviceData.setRandomChannel();
            }
            if (!StringUtils.isNullOrWhitespace(this.worldObjectSprite) && !((Radio)object2).ReadFromWorldSprite(this.worldObjectSprite)) {
                DebugLog.log("Item -> Radio item = " + (this.moduleDotType != null ? this.moduleDotType : "unknown"));
            }
        } else if (this.type == Type.Moveable) {
            object3 = new Moveable(this.module.name, this.DisplayName, this.name, this);
            object2 = (Moveable)object3;
            ((Moveable)object2).ReadFromWorldSprite(this.worldObjectSprite);
            this.ActualWeight = ((InventoryItem)object2).getActualWeight();
        } else if (this.type == Type.Map) {
            object2 = new MapItem(this.module.name, this.DisplayName, this.name, this);
            if (StringUtils.isNullOrWhitespace(this.map)) {
                ((MapItem)object2).setMapID(MapDefinitions.getInstance().pickRandom());
            } else {
                ((MapItem)object2).setMapID(this.map);
            }
            object3 = object2;
        }
        if (this.colorRed < 255 || this.colorGreen < 255 || this.colorBlue < 255) {
            ((InventoryItem)object3).setColor(new Color((float)this.colorRed / 255.0f, (float)this.colorGreen / 255.0f, (float)this.colorBlue / 255.0f));
        }
        ((InventoryItem)object3).setAlcoholPower(this.alcoholPower);
        ((InventoryItem)object3).setConditionMax(this.ConditionMax);
        ((InventoryItem)object3).setCondition(this.ConditionMax);
        ((InventoryItem)object3).setCanBeActivated(this.ActivatedItem);
        ((InventoryItem)object3).setLightStrength(this.LightStrength);
        ((InventoryItem)object3).setTorchCone(this.TorchCone);
        ((InventoryItem)object3).setLightDistance(this.LightDistance);
        ((InventoryItem)object3).setActualWeight(this.ActualWeight);
        ((InventoryItem)object3).setWeight(this.ActualWeight);
        ((InventoryItem)object3).setUses(this.Count);
        ((InventoryItem)object3).setScriptItem(this);
        ((InventoryItem)object3).setBoredomChange(this.BoredomChange);
        ((InventoryItem)object3).setStressChange(this.StressChange / 100.0f);
        ((InventoryItem)object3).setUnhappyChange(this.UnhappyChange);
        ((InventoryItem)object3).setReplaceOnUseOn(this.ReplaceOnUseOn);
        ((InventoryItem)object3).setRequireInHandOrInventory(this.RequireInHandOrInventory);
        ((InventoryItem)object3).setAttachmentsProvided(this.attachmentsProvided);
        ((InventoryItem)object3).setAttachmentReplacement(this.attachmentReplacement);
        ((InventoryItem)object3).setIsWaterSource(this.IsWaterSource);
        ((InventoryItem)object3).CanStoreWater = this.CanStoreWater;
        ((InventoryItem)object3).CanStack = this.CanStack;
        ((InventoryItem)object3).copyModData(this.DefaultModData);
        ((InventoryItem)object3).setCount(this.Count);
        ((InventoryItem)object3).setFatigueChange(this.FatigueChange / 100.0f);
        ((InventoryItem)object3).setTooltip(this.Tooltip);
        ((InventoryItem)object3).setDisplayCategory(this.DisplayCategory);
        ((InventoryItem)object3).setAlcoholic(this.Alcoholic);
        ((InventoryItem)object3).RequiresEquippedBothHands = this.RequiresEquippedBothHands;
        ((InventoryItem)object3).setBreakSound(this.breakSound);
        ((InventoryItem)object3).setReplaceOnUse(this.ReplaceOnUse);
        ((InventoryItem)object3).setBandagePower(this.bandagePower);
        ((InventoryItem)object3).setReduceInfectionPower(this.ReduceInfectionPower);
        ((InventoryItem)object3).setCanBeRemote(this.canBeRemote);
        ((InventoryItem)object3).setRemoteController(this.remoteController);
        ((InventoryItem)object3).setRemoteRange(this.remoteRange);
        ((InventoryItem)object3).setCountDownSound(this.countDownSound);
        ((InventoryItem)object3).setExplosionSound(this.explosionSound);
        ((InventoryItem)object3).setColorRed((float)this.colorRed / 255.0f);
        ((InventoryItem)object3).setColorGreen((float)this.colorGreen / 255.0f);
        ((InventoryItem)object3).setColorBlue((float)this.colorBlue / 255.0f);
        ((InventoryItem)object3).setEvolvedRecipeName(this.evolvedRecipeName);
        ((InventoryItem)object3).setMetalValue(this.metalValue);
        ((InventoryItem)object3).setWet(this.isWet);
        ((InventoryItem)object3).setWetCooldown(this.wetCooldown);
        ((InventoryItem)object3).setItemWhenDry(this.itemWhenDry);
        ((InventoryItem)object3).keepOnDeplete = this.keepOnDeplete;
        ((InventoryItem)object3).setItemCapacity(this.itemCapacity);
        ((InventoryItem)object3).setMaxCapacity(this.maxCapacity);
        ((InventoryItem)object3).setBrakeForce(this.brakeForce);
        ((InventoryItem)object3).setChanceToSpawnDamaged(this.chanceToSpawnDamaged);
        ((InventoryItem)object3).setConditionLowerNormal(this.conditionLowerNormal);
        ((InventoryItem)object3).setConditionLowerOffroad(this.conditionLowerOffroad);
        ((InventoryItem)object3).setWheelFriction(this.wheelFriction);
        ((InventoryItem)object3).setSuspensionCompression(this.suspensionCompression);
        ((InventoryItem)object3).setEngineLoudness(this.engineLoudness);
        ((InventoryItem)object3).setSuspensionDamping(this.suspensionDamping);
        if (this.CustomContextMenu != null) {
            ((InventoryItem)object3).setCustomMenuOption(Translator.getText("ContextMenu_" + this.CustomContextMenu));
        }
        if (this.IconsForTexture != null && !this.IconsForTexture.isEmpty()) {
            ((InventoryItem)object3).setIconsForTexture(this.IconsForTexture);
        }
        ((InventoryItem)object3).setBloodClothingType(this.bloodClothingType);
        ((InventoryItem)object3).CloseKillMove = this.CloseKillMove;
        ((InventoryItem)object3).setAmmoType(this.AmmoType);
        ((InventoryItem)object3).setMaxAmmo(this.maxAmmo);
        ((InventoryItem)object3).setGunType(this.GunType);
        ((InventoryItem)object3).setAttachmentType(this.attachmentType);
        long l = OutfitRNG.getSeed();
        OutfitRNG.setSeed(Rand.Next(Integer.MAX_VALUE));
        ((InventoryItem)object3).synchWithVisual();
        OutfitRNG.setSeed(l);
        ((InventoryItem)object3).setRegistry_id(this);
        object = Thread.currentThread();
        if (!(object != GameWindow.GameThread && object != GameLoadingState.loader && object != GameServer.MainThread || ((InventoryItem)object3).isInitialised())) {
            ((InventoryItem)object3).initialiseItem();
        }
        return object3;
    }

    public void DoParam(String string) {
        block376: {
            if (string.trim().length() == 0) {
                return;
            }
            try {
                String[] stringArray = string.split("=");
                String string2 = stringArray[0].trim();
                String string3 = stringArray[1].trim();
                if (string2.trim().equalsIgnoreCase("BodyLocation")) {
                    this.BodyLocation = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Palettes")) {
                    String[] stringArray2 = string3.split("/");
                    for (int i = 0; i < stringArray2.length; ++i) {
                        this.PaletteChoices.add(stringArray2[i].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HitSound")) {
                    this.HitSound = string3.trim();
                    if (this.HitSound.equals("null")) {
                        this.HitSound = null;
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HitFloorSound")) {
                    this.hitFloorSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PalettesStart")) {
                    this.PalettesStart = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DisplayName")) {
                    this.DisplayName = Translator.getDisplayItemName(string3.trim());
                    this.DisplayName = Translator.getItemNameFromFullType(this.getFullName());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MetalValue")) {
                    this.metalValue = new Float(string3.trim()).floatValue();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SpriteName")) {
                    this.SpriteName = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Type")) {
                    this.type = Type.valueOf(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SplatSize")) {
                    this.SplatSize = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanStoreWater")) {
                    this.CanStoreWater = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsWaterSource")) {
                    this.IsWaterSource = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Poison")) {
                    this.Poison = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("FoodType")) {
                    this.FoodType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PoisonDetectionLevel")) {
                    this.PoisonDetectionLevel = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PoisonPower")) {
                    this.PoisonPower = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseForPoison")) {
                    this.UseForPoison = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SwingAnim")) {
                    this.SwingAnim = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Icon")) {
                    this.Icon = string3;
                    this.ItemName = "Item_" + this.Icon;
                    this.NormalTexture = Texture.trygetTexture(this.ItemName);
                    if (this.NormalTexture == null) {
                        this.NormalTexture = Texture.getSharedTexture("media/inventory/Question_On.png");
                    }
                    this.WorldTextureName = this.ItemName.replace("Item_", "media/inventory/world/WItem_");
                    this.WorldTextureName = this.WorldTextureName + ".png";
                    this.WorldTexture = Texture.getSharedTexture(this.WorldTextureName);
                    if (this.type == Type.Food) {
                        Texture texture = Texture.trygetTexture(this.ItemName + "Rotten");
                        String string4 = this.WorldTextureName.replace(".png", "Rotten.png");
                        if (texture == null) {
                            texture = Texture.trygetTexture(this.ItemName + "Spoiled");
                            string4 = string4.replace("Rotten.png", "Spoiled.png");
                        }
                        this.SpecialWorldTextureNames.add(string4);
                        this.SpecialTextures.add(texture);
                        this.SpecialTextures.add(Texture.trygetTexture(this.ItemName + "Cooked"));
                        this.SpecialWorldTextureNames.add(this.WorldTextureName.replace(".png", "Cooked.png"));
                        Texture texture2 = Texture.trygetTexture(this.ItemName + "Overdone");
                        String string5 = this.WorldTextureName.replace(".png", "Overdone.png");
                        if (texture2 == null) {
                            texture2 = Texture.trygetTexture(this.ItemName + "Burnt");
                            string5 = string5.replace("Overdone.png", "Burnt.png");
                        }
                        this.SpecialTextures.add(texture2);
                        this.SpecialWorldTextureNames.add(string5);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseWorldItem")) {
                    this.UseWorldItem = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Medical")) {
                    this.Medical = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CannedFood")) {
                    this.CannedFood = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MechanicsItem")) {
                    this.MechanicsItem = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SurvivalGear")) {
                    this.SurvivalGear = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ScaleWorldIcon")) {
                    this.ScaleWorldIcon = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HairDye")) {
                    this.hairDye = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DoorHitSound")) {
                    this.DoorHitSound = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Weight")) {
                    this.ActualWeight = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeightWet")) {
                    this.WeightWet = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeightEmpty")) {
                    this.WeightEmpty = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HungerChange")) {
                    this.HungerChange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ThirstChange")) {
                    this.ThirstChange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("FatigueChange")) {
                    this.FatigueChange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EnduranceChange")) {
                    this.EnduranceChange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CriticalChance")) {
                    this.CriticalChance = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("critDmgMultiplier")) {
                    this.critDmgMultiplier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DaysFresh")) {
                    this.DaysFresh = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DaysTotallyRotten")) {
                    this.DaysTotallyRotten = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsCookable")) {
                    this.IsCookable = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CookingSound")) {
                    this.CookingSound = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinutesToCook")) {
                    this.MinutesToCook = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinutesToBurn")) {
                    this.MinutesToBurn = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BoredomChange")) {
                    this.BoredomChange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("StressChange")) {
                    this.StressChange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UnhappyChange")) {
                    this.UnhappyChange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RemoveUnhappinessWhenCooked")) {
                    this.RemoveUnhappinessWhenCooked = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceOnDeplete")) {
                    this.ReplaceOnDeplete = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceOnUseOn")) {
                    this.ReplaceOnUseOn = string3;
                    if (string3.contains("-")) {
                        String[] stringArray3 = string3.split("-");
                        String string6 = stringArray3[0].trim();
                        String string7 = stringArray3[1].trim();
                        if (!string6.isEmpty() && !string7.isEmpty()) {
                            if (this.ReplaceTypesMap == null) {
                                this.ReplaceTypesMap = new HashMap();
                            }
                            this.ReplaceTypesMap.put(string6, string7);
                        }
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceTypes")) {
                    String[] stringArray4;
                    this.ReplaceTypes = string3;
                    for (String string8 : stringArray4 = string3.split(";")) {
                        String[] stringArray5 = string8.trim().split("\\s+");
                        if (stringArray5.length != 2) continue;
                        String string9 = stringArray5[0].trim();
                        String string10 = stringArray5[1].trim();
                        if (string9.isEmpty() || string10.isEmpty()) continue;
                        if (this.ReplaceTypesMap == null) {
                            this.ReplaceTypesMap = new HashMap();
                        }
                        this.ReplaceTypesMap.put(string9, string10);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Ranged")) {
                    this.Ranged = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseSelf")) {
                    this.UseSelf = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OtherHandUse")) {
                    this.OtherHandUse = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DangerousUncooked")) {
                    this.DangerousUncooked = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxRange")) {
                    this.MaxRange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinRange")) {
                    this.MinRange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinAngle")) {
                    this.MinAngle = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxDamage")) {
                    this.MaxDamage = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BaseSpeed")) {
                    this.baseSpeed = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("stompPower")) {
                    this.stompPower = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("combatSpeedModifier")) {
                    this.combatSpeedModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("runSpeedModifier")) {
                    this.runSpeedModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("clothingItemExtra")) {
                    this.clothingItemExtra = new ArrayList();
                    String[] stringArray6 = string3.split(";");
                    for (int i = 0; i < stringArray6.length; ++i) {
                        this.clothingItemExtra.add(stringArray6[i]);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("clothingExtraSubmenu")) {
                    this.clothingExtraSubmenu = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("removeOnBroken")) {
                    this.removeOnBroken = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("canHaveHoles")) {
                    this.canHaveHoles = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Cosmetic")) {
                    this.cosmetic = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ammoBox")) {
                    this.ammoBox = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("InsertAmmoStartSound")) {
                    this.insertAmmoStartSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("InsertAmmoSound")) {
                    this.insertAmmoSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("InsertAmmoStopSound")) {
                    this.insertAmmoStopSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EjectAmmoStartSound")) {
                    this.ejectAmmoStartSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EjectAmmoSound")) {
                    this.ejectAmmoSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EjectAmmoStopSound")) {
                    this.ejectAmmoStopSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("rackSound")) {
                    this.rackSound = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("clickSound")) {
                    this.clickSound = string3;
                    break block376;
                }
                if (string2.equalsIgnoreCase("BringToBearSound")) {
                    this.bringToBearSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.equalsIgnoreCase("EquipSound")) {
                    this.equipSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.equalsIgnoreCase("UnequipSound")) {
                    this.unequipSound = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("magazineType")) {
                    this.magazineType = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("jamGunChance")) {
                    this.jamGunChance = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("modelWeaponPart")) {
                    String[] stringArray7;
                    if (this.modelWeaponPart == null) {
                        this.modelWeaponPart = new ArrayList();
                    }
                    if ((stringArray7 = string3.split("\\s+")).length >= 2 && stringArray7.length <= 4) {
                        ModelWeaponPart modelWeaponPart = null;
                        for (int i = 0; i < this.modelWeaponPart.size(); ++i) {
                            ModelWeaponPart modelWeaponPart2 = this.modelWeaponPart.get(i);
                            if (!modelWeaponPart2.partType.equals(stringArray7[0])) continue;
                            modelWeaponPart = modelWeaponPart2;
                            break;
                        }
                        if (modelWeaponPart == null) {
                            modelWeaponPart = new ModelWeaponPart();
                        }
                        modelWeaponPart.partType = stringArray7[0];
                        modelWeaponPart.modelName = stringArray7[1];
                        modelWeaponPart.attachmentNameSelf = stringArray7.length > 2 ? stringArray7[2] : null;
                        String string11 = modelWeaponPart.attachmentParent = stringArray7.length > 3 ? stringArray7[3] : null;
                        if (!modelWeaponPart.partType.contains(".")) {
                            modelWeaponPart.partType = this.module.name + "." + modelWeaponPart.partType;
                        }
                        if (!modelWeaponPart.modelName.contains(".")) {
                            modelWeaponPart.modelName = this.module.name + "." + modelWeaponPart.modelName;
                        }
                        if ("none".equalsIgnoreCase(modelWeaponPart.attachmentNameSelf)) {
                            modelWeaponPart.attachmentNameSelf = null;
                        }
                        if ("none".equalsIgnoreCase(modelWeaponPart.attachmentParent)) {
                            modelWeaponPart.attachmentParent = null;
                        }
                        this.modelWeaponPart.add(modelWeaponPart);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("rackAfterShoot")) {
                    this.rackAfterShoot = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("haveChamber")) {
                    this.haveChamber = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.equalsIgnoreCase("ManuallyRemoveSpentRounds")) {
                    this.manuallyRemoveSpentRounds = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("biteDefense")) {
                    this.biteDefense = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("bulletDefense")) {
                    this.bulletDefense = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("neckProtectionModifier")) {
                    this.neckProtectionModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("damageCategory")) {
                    this.damageCategory = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("fireMode")) {
                    this.fireMode = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("damageMakeHole")) {
                    this.damageMakeHole = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("equippedNoSprint")) {
                    this.equippedNoSprint = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("scratchDefense")) {
                    this.scratchDefense = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("weaponReloadType")) {
                    this.weaponReloadType = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("insertAllBulletsReload")) {
                    this.insertAllBulletsReload = Boolean.parseBoolean(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("clothingItemExtraOption")) {
                    this.clothingItemExtraOption = new ArrayList();
                    String[] stringArray8 = string3.split(";");
                    for (int i = 0; i < stringArray8.length; ++i) {
                        this.clothingItemExtraOption.add(stringArray8[i]);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ConditionLowerChanceOneIn")) {
                    this.ConditionLowerChance = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MultipleHitConditionAffected")) {
                    this.MultipleHitConditionAffected = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanBandage")) {
                    this.CanBandage = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ConditionMax")) {
                    this.ConditionMax = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SoundGain")) {
                    this.SoundGain = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinDamage")) {
                    this.MinDamage = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinimumSwingTime")) {
                    this.MinimumSwingTime = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SwingSound")) {
                    this.SwingSound = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceOnUse")) {
                    this.ReplaceOnUse = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeaponSprite")) {
                    this.WeaponSprite = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingPerkCritModifier")) {
                    this.AimingPerkCritModifier = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingPerkRangeModifier")) {
                    this.AimingPerkRangeModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingPerkHitChanceModifier")) {
                    this.AimingPerkHitChanceModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AngleModifier")) {
                    this.angleModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeightModifier")) {
                    this.weightModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingPerkMinAngleModifier")) {
                    this.AimingPerkMinAngleModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HitChance")) {
                    this.HitChance = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RecoilDelay")) {
                    this.RecoilDelay = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("StopPower")) {
                    this.stopPower = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PiercingBullets")) {
                    this.PiercingBullets = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AngleFalloff")) {
                    this.AngleFalloff = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SoundVolume")) {
                    this.SoundVolume = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ToHitModifier")) {
                    this.ToHitModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SoundRadius")) {
                    this.SoundRadius = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Categories")) {
                    String[] stringArray9 = string3.split(";");
                    for (int i = 0; i < stringArray9.length; ++i) {
                        this.Categories.add(stringArray9[i].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Tags")) {
                    String[] stringArray10 = string3.split(";");
                    for (int i = 0; i < stringArray10.length; ++i) {
                        this.Tags.add(stringArray10[i].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OtherCharacterVolumeBoost")) {
                    this.OtherCharacterVolumeBoost = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ImpactSound")) {
                    this.ImpactSound = string3;
                    if (this.ImpactSound.equals("null")) {
                        this.ImpactSound = null;
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SwingTime")) {
                    this.SwingTime = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("KnockBackOnNoDeath")) {
                    this.KnockBackOnNoDeath = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Alcoholic")) {
                    this.Alcoholic = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SplatBloodOnNoDeath")) {
                    this.SplatBloodOnNoDeath = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SwingAmountBeforeImpact")) {
                    this.SwingAmountBeforeImpact = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AmmoType")) {
                    this.AmmoType = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("maxAmmo")) {
                    this.maxAmmo = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("GunType")) {
                    this.GunType = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HitAngleMod")) {
                    this.HitAngleMod = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OtherHandRequire")) {
                    this.OtherHandRequire = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AlwaysWelcomeGift")) {
                    this.AlwaysWelcomeGift = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CantAttackWithLowestEndurance")) {
                    this.CantAttackWithLowestEndurance = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EnduranceMod")) {
                    this.EnduranceMod = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("KnockdownMod")) {
                    this.KnockdownMod = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DoorDamage")) {
                    this.DoorDamage = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxHitCount")) {
                    this.MaxHitCount = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PhysicsObject")) {
                    this.PhysicsObject = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Count")) {
                    this.Count = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SwingAnim")) {
                    this.SwingAnim = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeaponWeight")) {
                    this.WeaponWeight = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IdleAnim")) {
                    this.IdleAnim = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RunAnim")) {
                    this.RunAnim = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RequireInHandOrInventory")) {
                    this.RequireInHandOrInventory = new ArrayList<String>(Arrays.asList(string3.split("/")));
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("fireModePossibilities")) {
                    this.fireModePossibilities = new ArrayList<String>(Arrays.asList(string3.split("/")));
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("attachmentsProvided")) {
                    this.attachmentsProvided = new ArrayList<String>(Arrays.asList(string3.split(";")));
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("attachmentReplacement")) {
                    this.attachmentReplacement = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PushBackMod")) {
                    this.PushBackMod = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("NPCSoundBoost")) {
                    this.NPCSoundBoost = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SplatNumber")) {
                    this.SplatNumber = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RangeFalloff")) {
                    this.RangeFalloff = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseEndurance")) {
                    this.UseEndurance = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ShareDamage")) {
                    this.ShareDamage = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ShareEndurance")) {
                    this.ShareEndurance = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AlwaysKnockdown")) {
                    this.AlwaysKnockdown = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsAimedFirearm")) {
                    this.IsAimedFirearm = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("bulletOutSound")) {
                    this.bulletOutSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ShellFallSound")) {
                    this.ShellFallSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SoundMap")) {
                    String[] stringArray11 = string3.split("\\s+");
                    if (stringArray11.length == 2 && !stringArray11[0].trim().isEmpty()) {
                        if (this.SoundMap == null) {
                            this.SoundMap = new HashMap();
                        }
                        this.SoundMap.put(stringArray11[0].trim(), stringArray11[1].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsAimedHandWeapon")) {
                    this.IsAimedHandWeapon = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingMod")) {
                    this.AimingMod = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ProjectileCount")) {
                    this.ProjectileCount = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanStack")) {
                    this.IsAimedFirearm = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HerbalistType")) {
                    this.HerbalistType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanBarricade")) {
                    this.CanBarricade = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseWhileEquipped")) {
                    this.UseWhileEquipped = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseWhileUnequipped")) {
                    this.UseWhileUnequipped = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TicksPerEquipUse")) {
                    this.TicksPerEquipUse = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DisappearOnUse")) {
                    this.DisappearOnUse = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Temperature")) {
                    this.Temperature = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Insulation")) {
                    this.insulation = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WindResistance")) {
                    this.windresist = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WaterResistance")) {
                    this.waterresist = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CloseKillMove")) {
                    this.CloseKillMove = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UseDelta")) {
                    this.UseDelta = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RainFactor")) {
                    this.rainFactor = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TorchDot")) {
                    this.torchDot = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("NumberOfPages")) {
                    this.NumberOfPages = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SkillTrained")) {
                    this.SkillTrained = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("LvlSkillTrained")) {
                    this.LvlSkillTrained = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("NumLevelsTrained")) {
                    this.NumLevelsTrained = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Capacity")) {
                    this.Capacity = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxCapacity")) {
                    this.maxCapacity = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ItemCapacity")) {
                    this.itemCapacity = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ConditionAffectsCapacity")) {
                    this.ConditionAffectsCapacity = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BrakeForce")) {
                    this.brakeForce = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ChanceToSpawnDamaged")) {
                    this.chanceToSpawnDamaged = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeaponLength")) {
                    this.WeaponLength = new Float(string3.trim()).floatValue();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ClipSize")) {
                    this.ClipSize = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReloadTime")) {
                    this.reloadTime = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingTime")) {
                    this.aimingTime = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AimingTimeModifier")) {
                    this.aimingTimeModifier = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReloadTimeModifier")) {
                    this.reloadTimeModifier = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("HitChanceModifier")) {
                    this.hitChanceModifier = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WeightReduction")) {
                    this.WeightReduction = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanBeEquipped")) {
                    this.CanBeEquipped = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SubCategory")) {
                    this.SubCategory = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ActivatedItem")) {
                    this.ActivatedItem = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ProtectFromRainWhenEquipped")) {
                    this.ProtectFromRainWhenEquipped = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("LightStrength")) {
                    this.LightStrength = new Float(string3.trim()).floatValue();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TorchCone")) {
                    this.TorchCone = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("LightDistance")) {
                    this.LightDistance = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TwoHandWeapon")) {
                    this.TwoHandWeapon = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Tooltip")) {
                    this.Tooltip = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DisplayCategory")) {
                    this.DisplayCategory = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BadInMicrowave")) {
                    this.BadInMicrowave = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("GoodHot")) {
                    this.GoodHot = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BadCold")) {
                    this.BadCold = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AlarmSound")) {
                    this.AlarmSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RequiresEquippedBothHands")) {
                    this.RequiresEquippedBothHands = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceOnCooked")) {
                    this.ReplaceOnCooked = Arrays.asList(string3.trim().split(";"));
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CustomContextMenu")) {
                    this.CustomContextMenu = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Trap")) {
                    this.Trap = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Wet")) {
                    this.isWet = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WetCooldown")) {
                    this.wetCooldown = Float.parseFloat(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ItemWhenDry")) {
                    this.itemWhenDry = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("FishingLure")) {
                    this.FishingLure = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanBeWrite")) {
                    this.canBeWrite = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PageToWrite")) {
                    this.PageToWrite = Integer.parseInt(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Spice")) {
                    this.Spice = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RemoveNegativeEffectOnCooked")) {
                    this.RemoveNegativeEffectOnCooked = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ClipSizeModifier")) {
                    this.clipSizeModifier = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("RecoilDelayModifier")) {
                    this.recoilDelayModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxRangeModifier")) {
                    this.maxRangeModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinRangeModifier")) {
                    this.minRangeRangedModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DamageModifier")) {
                    this.damageModifier = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Map")) {
                    this.map = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PutInSound")) {
                    this.PutInSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PlaceOneSound")) {
                    this.PlaceOneSound = StringUtils.discardNullOrWhitespace(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PlaceMultipleSound")) {
                    this.PlaceMultipleSound = StringUtils.discardNullOrWhitespace(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CloseSound")) {
                    this.CloseSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OpenSound")) {
                    this.OpenSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BreakSound")) {
                    this.breakSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TreeDamage")) {
                    this.treeDamage = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CustomEatSound")) {
                    this.customEatSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("FillFromDispenserSound")) {
                    this.fillFromDispenserSound = StringUtils.discardNullOrWhitespace(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("FillFromTapSound")) {
                    this.fillFromTapSound = StringUtils.discardNullOrWhitespace(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AlcoholPower")) {
                    this.alcoholPower = Float.parseFloat(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BandagePower")) {
                    this.bandagePower = Float.parseFloat(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReduceInfectionPower")) {
                    this.ReduceInfectionPower = Float.parseFloat(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OnCooked")) {
                    this.OnCooked = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OnlyAcceptCategory")) {
                    this.OnlyAcceptCategory = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AcceptItemFunction")) {
                    this.AcceptItemFunction = StringUtils.discardNullOrWhitespace(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Padlock")) {
                    this.padlock = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("DigitalPadlock")) {
                    this.digitalPadlock = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("triggerExplosionTimer")) {
                    this.triggerExplosionTimer = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("sensorRange")) {
                    this.sensorRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("remoteRange")) {
                    this.remoteRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CountDownSound")) {
                    this.countDownSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("explosionSound")) {
                    this.explosionSound = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PlacedSprite")) {
                    this.PlacedSprite = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("explosionTimer")) {
                    this.explosionTimer = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("explosionRange")) {
                    this.explosionRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("explosionPower")) {
                    this.explosionPower = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("fireRange")) {
                    this.fireRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("firePower")) {
                    this.firePower = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("canBePlaced")) {
                    this.canBePlaced = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CanBeReused")) {
                    this.canBeReused = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("canBeRemote")) {
                    this.canBeRemote = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("remoteController")) {
                    this.remoteController = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("smokeRange")) {
                    this.smokeRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("noiseRange")) {
                    this.noiseRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("noiseDuration")) {
                    this.noiseDuration = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("extraDamage")) {
                    this.extraDamage = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TwoWay")) {
                    this.twoWay = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TransmitRange")) {
                    this.transmitRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MicRange")) {
                    this.micRange = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BaseVolumeRange")) {
                    this.baseVolumeRange = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsPortable")) {
                    this.isPortable = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsTelevision")) {
                    this.isTelevision = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MinChannel")) {
                    this.minChannel = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MaxChannel")) {
                    this.maxChannel = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("UsesBattery")) {
                    this.usesBattery = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IsHighTier")) {
                    this.isHighTier = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WorldObjectSprite")) {
                    this.worldObjectSprite = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("fluReduction")) {
                    this.fluReduction = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReduceFoodSickness")) {
                    this.ReduceFoodSickness = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("painReduction")) {
                    this.painReduction = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ColorRed")) {
                    this.colorRed = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ColorGreen")) {
                    this.colorGreen = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ColorBlue")) {
                    this.colorBlue = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("calories")) {
                    this.calories = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("carbohydrates")) {
                    this.carbohydrates = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("lipids")) {
                    this.lipids = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("proteins")) {
                    this.proteins = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("Packaged")) {
                    this.packaged = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CantBeFrozen")) {
                    this.cantBeFrozen = string3.trim().equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EvolvedRecipeName")) {
                    Translator.setDefaultItemEvolvedRecipeName(this.getFullName(), string3);
                    this.evolvedRecipeName = Translator.getItemEvolvedRecipeName(this.getFullName());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ReplaceOnRotten")) {
                    this.ReplaceOnRotten = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CantBeConsolided")) {
                    this.cantBeConsolided = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OnEat")) {
                    this.onEat = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("KeepOnDeplete")) {
                    this.keepOnDeplete = string3.equalsIgnoreCase("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("VehicleType")) {
                    this.vehicleType = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ChanceToFall")) {
                    this.chanceToFall = Integer.parseInt(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("conditionLowerOffroad")) {
                    this.conditionLowerOffroad = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ConditionLowerStandard")) {
                    this.conditionLowerNormal = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("wheelFriction")) {
                    this.wheelFriction = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("suspensionDamping")) {
                    this.suspensionDamping = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("suspensionCompression")) {
                    this.suspensionCompression = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("engineLoudness")) {
                    this.engineLoudness = Float.parseFloat(string3);
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("attachmentType")) {
                    this.attachmentType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("makeUpType")) {
                    this.makeUpType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("consolidateOption")) {
                    this.consolidateOption = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("fabricType")) {
                    this.fabricType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("TeachedRecipes")) {
                    this.teachedRecipes = new ArrayList<String>();
                    String[] stringArray12 = string3.split(";");
                    for (int i = 0; i < stringArray12.length; ++i) {
                        String string12 = stringArray12[i].trim();
                        this.teachedRecipes.add(string12);
                        if (!Translator.debug) continue;
                        Translator.getRecipeName(string12);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MountOn")) {
                    this.mountOn = new ArrayList();
                    String[] stringArray13 = string3.split(";");
                    for (int i = 0; i < stringArray13.length; ++i) {
                        this.mountOn.add(stringArray13[i].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("PartType")) {
                    this.partType = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("ClothingItem")) {
                    this.ClothingItem = string3;
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EvolvedRecipe")) {
                    String[] stringArray14 = string3.split(";");
                    for (int i = 0; i < stringArray14.length; ++i) {
                        Object object;
                        Object object2;
                        String string13 = stringArray14[i];
                        String string14 = null;
                        int n = 0;
                        boolean bl = false;
                        if (string13.contains(":")) {
                            string14 = string13.split(":")[0];
                            object2 = string13.split(":")[1];
                            if (((String)object2).contains("|")) {
                                object = ((String)object2).split("\\|");
                                for (int j = 0; j < ((String[])object).length; ++j) {
                                    if (!"Cooked".equals(object[j])) continue;
                                    bl = true;
                                }
                                n = Integer.parseInt(object[0]);
                            } else {
                                n = Integer.parseInt(string13.split(":")[1]);
                            }
                        } else {
                            string14 = string13;
                        }
                        object2 = new ItemRecipe(this.name, this.module.getName(), n);
                        object = null;
                        for (EvolvedRecipe evolvedRecipe : ScriptManager.instance.ModuleMap.get((Object)"Base").EvolvedRecipeMap) {
                            if (!evolvedRecipe.name.equals(string14)) continue;
                            object = evolvedRecipe;
                            break;
                        }
                        ((ItemRecipe)object2).cooked = bl;
                        if (object == null) {
                            object = new EvolvedRecipe(string14);
                            ScriptManager.instance.ModuleMap.get((Object)"Base").EvolvedRecipeMap.add((EvolvedRecipe)object);
                        }
                        object.itemsList.put(this.name, (ItemRecipe)object2);
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("StaticModel")) {
                    this.staticModel = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("worldStaticModel")) {
                    this.worldStaticModel = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("primaryAnimMask")) {
                    this.primaryAnimMask = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("secondaryAnimMask")) {
                    this.secondaryAnimMask = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("primaryAnimMaskAttachment")) {
                    this.primaryAnimMaskAttachment = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("secondaryAnimMaskAttachment")) {
                    this.secondaryAnimMaskAttachment = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("replaceInSecondHand")) {
                    this.replaceInSecondHand = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("replaceInPrimaryHand")) {
                    this.replaceInPrimaryHand = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("replaceWhenUnequip")) {
                    this.replaceWhenUnequip = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("EatType")) {
                    this.eatType = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("IconsForTexture")) {
                    this.IconsForTexture = new ArrayList();
                    String[] stringArray15 = string3.split(";");
                    for (int i = 0; i < stringArray15.length; ++i) {
                        this.IconsForTexture.add(stringArray15[i].trim());
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("BloodLocation")) {
                    this.bloodClothingType = new ArrayList();
                    String[] stringArray16 = string3.split(";");
                    for (int i = 0; i < stringArray16.length; ++i) {
                        this.bloodClothingType.add(BloodClothingType.fromString(stringArray16[i].trim()));
                    }
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("MediaCategory")) {
                    this.recordedMediaCat = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("AcceptMediaType")) {
                    this.acceptMediaType = Byte.parseByte(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("NoTransmit")) {
                    this.noTransmit = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("WorldRender")) {
                    this.worldRender = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("CantEat")) {
                    this.CantEat = Boolean.parseBoolean(string3.trim());
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OBSOLETE")) {
                    this.OBSOLETE = string3.trim().toLowerCase().equals("true");
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("OnCreate")) {
                    this.LuaCreate = string3.trim();
                    break block376;
                }
                if (string2.trim().equalsIgnoreCase("SoundParameter")) {
                    String[] stringArray17 = string3.split("\\s+");
                    if (this.soundParameterMap == null) {
                        this.soundParameterMap = new HashMap();
                    }
                    this.soundParameterMap.put(stringArray17[0].trim(), stringArray17[1].trim());
                    break block376;
                }
                DebugLog.log("adding unknown item param \"" + string2.trim() + "\" = \"" + string3.trim() + "\"");
                if (this.DefaultModData == null) {
                    this.DefaultModData = LuaManager.platform.newTable();
                }
                try {
                    Double d = Double.parseDouble(string3.trim());
                    this.DefaultModData.rawset((Object)string2.trim(), (Object)d);
                }
                catch (Exception exception) {
                    this.DefaultModData.rawset((Object)string2.trim(), (Object)string3);
                }
            }
            catch (Exception exception) {
                throw new InvalidParameterException("Error: " + string.trim() + " is not a valid parameter in item: " + this.name);
            }
        }
    }

    public int getLevelSkillTrained() {
        return this.LvlSkillTrained;
    }

    public int getNumLevelsTrained() {
        return this.NumLevelsTrained;
    }

    public int getMaxLevelTrained() {
        if (this.LvlSkillTrained == -1) {
            return -1;
        }
        return this.LvlSkillTrained + this.NumLevelsTrained;
    }

    public List<String> getTeachedRecipes() {
        return this.teachedRecipes;
    }

    public float getTemperature() {
        return this.Temperature;
    }

    public void setTemperature(float f) {
        this.Temperature = f;
    }

    public boolean isConditionAffectsCapacity() {
        return this.ConditionAffectsCapacity;
    }

    public int getChanceToFall() {
        return this.chanceToFall;
    }

    public float getInsulation() {
        return this.insulation;
    }

    public void setInsulation(float f) {
        this.insulation = f;
    }

    public float getWindresist() {
        return this.windresist;
    }

    public void setWindresist(float f) {
        this.windresist = f;
    }

    public float getWaterresist() {
        return this.waterresist;
    }

    public void setWaterresist(float f) {
        this.waterresist = f;
    }

    public boolean getObsolete() {
        return this.OBSOLETE;
    }

    public String getAcceptItemFunction() {
        return this.AcceptItemFunction;
    }

    public ArrayList<BloodClothingType> getBloodClothingType() {
        return this.bloodClothingType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{Module: " + (this.module != null ? this.module.name : "null") + ", Name:" + this.name + ", Type:" + this.type + "}";
    }

    public String getReplaceWhenUnequip() {
        return this.replaceWhenUnequip;
    }

    public void resolveItemTypes() {
        this.AmmoType = ScriptManager.instance.resolveItemType(this.module, this.AmmoType);
        this.magazineType = ScriptManager.instance.resolveItemType(this.module, this.magazineType);
        if (this.RequireInHandOrInventory != null) {
            for (int i = 0; i < this.RequireInHandOrInventory.size(); ++i) {
                String string = this.RequireInHandOrInventory.get(i);
                string = ScriptManager.instance.resolveItemType(this.module, string);
                this.RequireInHandOrInventory.set(i, string);
            }
        }
        if (this.ReplaceTypesMap != null) {
            for (String string : this.ReplaceTypesMap.keySet()) {
                String string2 = this.ReplaceTypesMap.get(string);
                this.ReplaceTypesMap.replace(string, ScriptManager.instance.resolveItemType(this.module, string2));
            }
        }
    }

    public void resolveModelScripts() {
        this.staticModel = ScriptManager.instance.resolveModelScript(this.module, this.staticModel);
        this.worldStaticModel = ScriptManager.instance.resolveModelScript(this.module, this.worldStaticModel);
    }

    public short getRegistry_id() {
        return this.registry_id;
    }

    public void setRegistry_id(short s) {
        if (this.registry_id != -1) {
            WorldDictionary.DebugPrintItem(s);
            throw new RuntimeException("Cannot override existing registry id (" + this.registry_id + ") to new id (" + s + "), item: " + (this.getFullName() != null ? this.getFullName() : "unknown"));
        }
        this.registry_id = s;
    }

    public String getModID() {
        return this.modID;
    }

    public boolean getExistsAsVanilla() {
        return this.existsAsVanilla;
    }

    public String getFileAbsPath() {
        return this.fileAbsPath;
    }

    public void setModID(String string) {
        if (GameClient.bClient) {
            if (this.modID == null) {
                this.modID = string;
            } else if (!string.equals(this.modID) && Core.bDebug) {
                WorldDictionary.DebugPrintItem(this);
                throw new RuntimeException("Cannot override modID. ModID=" + (string != null ? string : "null"));
            }
        }
    }

    public String getRecordedMediaCat() {
        return this.recordedMediaCat;
    }

    public Boolean isWorldRender() {
        return this.worldRender;
    }

    public Boolean isCantEat() {
        return this.CantEat;
    }

    public String getLuaCreate() {
        return this.LuaCreate;
    }

    public void setLuaCreate(String string) {
        this.LuaCreate = string;
    }

    public String getSoundParameter(String string) {
        return this.soundParameterMap == null ? null : this.soundParameterMap.get(string);
    }

    public static enum Type {
        Normal,
        Weapon,
        Food,
        Literature,
        Drainable,
        Clothing,
        Container,
        WeaponPart,
        Key,
        KeyRing,
        Moveable,
        Radio,
        AlarmClock,
        AlarmClockClothing,
        Map;

    }
}

