/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.DrainableComboItem;
import zombie.scripting.objects.BaseScriptObject;
import zombie.util.Type;

public final class Fixing
extends BaseScriptObject {
    private String name = null;
    private ArrayList<String> require = null;
    private final LinkedList<Fixer> fixers = new LinkedList();
    private Fixer globalItem = null;
    private float conditionModifier = 1.0f;
    private static final PredicateRequired s_PredicateRequired = new PredicateRequired();
    private static final ArrayList<InventoryItem> s_InventoryItems = new ArrayList();

    @Override
    public void Load(String string, String[] stringArray) {
        this.setName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            List<String> list;
            if (stringArray[i].trim().isEmpty() || !stringArray[i].contains(":")) continue;
            String[] stringArray2 = stringArray[i].split(":");
            String string2 = stringArray2[0].trim();
            String string3 = stringArray2[1].trim();
            if (string2.equals("Require")) {
                list = Arrays.asList(string3.split(";"));
                for (int j = 0; j < list.size(); ++j) {
                    this.addRequiredItem(list.get(j).trim());
                }
                continue;
            }
            if (string2.equals("Fixer")) {
                if (string3.contains(";")) {
                    list = new LinkedList<String>();
                    List<String> list2 = Arrays.asList(string3.split(";"));
                    for (int j = 1; j < list2.size(); ++j) {
                        String[] stringArray3 = list2.get(j).trim().split("=");
                        ((LinkedList)list).add((String)((Object)new FixerSkill(stringArray3[0].trim(), Integer.parseInt(stringArray3[1].trim()))));
                    }
                    if (string3.split(";")[0].trim().contains("=")) {
                        String[] stringArray4 = string3.split(";")[0].trim().split("=");
                        this.fixers.add(new Fixer(stringArray4[0], (LinkedList<FixerSkill>)list, Integer.parseInt(stringArray4[1])));
                        continue;
                    }
                    this.fixers.add(new Fixer(string3.split(";")[0].trim(), (LinkedList<FixerSkill>)list, 1));
                    continue;
                }
                if (string3.contains("=")) {
                    this.fixers.add(new Fixer(string3.split("=")[0], null, Integer.parseInt(string3.split("=")[1])));
                    continue;
                }
                this.fixers.add(new Fixer(string3, null, 1));
                continue;
            }
            if (string2.equals("GlobalItem")) {
                if (string3.contains("=")) {
                    this.setGlobalItem(new Fixer(string3.split("=")[0], null, Integer.parseInt(string3.split("=")[1])));
                    continue;
                }
                this.setGlobalItem(new Fixer(string3, null, 1));
                continue;
            }
            if (!string2.equals("ConditionModifier")) continue;
            this.setConditionModifier(Float.parseFloat(string3.trim()));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ArrayList<String> getRequiredItem() {
        return this.require;
    }

    public void addRequiredItem(String string) {
        if (this.require == null) {
            this.require = new ArrayList();
        }
        this.require.add(string);
    }

    public LinkedList<Fixer> getFixers() {
        return this.fixers;
    }

    public Fixer usedInFixer(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter) {
        for (int i = 0; i < this.getFixers().size(); ++i) {
            Fixer fixer = this.getFixers().get(i);
            if (!fixer.getFixerName().equals(inventoryItem.getType())) continue;
            if (inventoryItem instanceof DrainableComboItem) {
                DrainableComboItem drainableComboItem = (DrainableComboItem)inventoryItem;
                if (drainableComboItem.getUsedDelta() < 1.0f) {
                    if (drainableComboItem.getDrainableUsesInt() < fixer.getNumberOfUse()) continue;
                    return fixer;
                }
                return fixer;
            }
            if (isoGameCharacter.getInventory().getCountTypeRecurse(this.getModule().getName() + "." + fixer.getFixerName()) < fixer.getNumberOfUse()) continue;
            return fixer;
        }
        return null;
    }

    public InventoryItem haveGlobalItem(IsoGameCharacter isoGameCharacter) {
        s_InventoryItems.clear();
        ArrayList<InventoryItem> arrayList = this.getRequiredFixerItems(isoGameCharacter, this.getGlobalItem(), null, s_InventoryItems);
        return arrayList == null ? null : arrayList.get(0);
    }

    public InventoryItem haveThisFixer(IsoGameCharacter isoGameCharacter, Fixer fixer, InventoryItem inventoryItem) {
        s_InventoryItems.clear();
        ArrayList<InventoryItem> arrayList = this.getRequiredFixerItems(isoGameCharacter, fixer, inventoryItem, s_InventoryItems);
        return arrayList == null ? null : arrayList.get(0);
    }

    public int countUses(IsoGameCharacter isoGameCharacter, Fixer fixer, InventoryItem inventoryItem) {
        s_InventoryItems.clear();
        Fixing.s_PredicateRequired.uses = 0;
        this.getRequiredFixerItems(isoGameCharacter, fixer, inventoryItem, s_InventoryItems);
        return Fixing.s_PredicateRequired.uses;
    }

    private static int countUses(InventoryItem inventoryItem) {
        DrainableComboItem drainableComboItem = Type.tryCastTo(inventoryItem, DrainableComboItem.class);
        if (drainableComboItem != null) {
            return drainableComboItem.getDrainableUsesInt();
        }
        return 1;
    }

    public ArrayList<InventoryItem> getRequiredFixerItems(IsoGameCharacter isoGameCharacter, Fixer fixer, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList) {
        if (fixer == null) {
            return null;
        }
        assert (Thread.currentThread() == GameWindow.GameThread);
        PredicateRequired predicateRequired = s_PredicateRequired;
        predicateRequired.fixer = fixer;
        predicateRequired.brokenItem = inventoryItem;
        predicateRequired.uses = 0;
        isoGameCharacter.getInventory().getAllRecurse(predicateRequired, arrayList);
        return predicateRequired.uses >= fixer.getNumberOfUse() ? arrayList : null;
    }

    public ArrayList<InventoryItem> getRequiredItems(IsoGameCharacter isoGameCharacter, Fixer fixer, InventoryItem inventoryItem) {
        ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
        if (this.getRequiredFixerItems(isoGameCharacter, fixer, inventoryItem, arrayList) == null) {
            arrayList.clear();
            return null;
        }
        if (this.getGlobalItem() != null && this.getRequiredFixerItems(isoGameCharacter, this.getGlobalItem(), inventoryItem, arrayList) == null) {
            arrayList.clear();
            return null;
        }
        return arrayList;
    }

    public Fixer getGlobalItem() {
        return this.globalItem;
    }

    public void setGlobalItem(Fixer fixer) {
        this.globalItem = fixer;
    }

    public float getConditionModifier() {
        return this.conditionModifier;
    }

    public void setConditionModifier(float f) {
        this.conditionModifier = f;
    }

    public static final class Fixer {
        private String fixerName = null;
        private LinkedList<FixerSkill> skills = null;
        private int numberOfUse = 1;

        public Fixer(String string, LinkedList<FixerSkill> linkedList, int n) {
            this.fixerName = string;
            this.skills = linkedList;
            this.numberOfUse = n;
        }

        public String getFixerName() {
            return this.fixerName;
        }

        public LinkedList<FixerSkill> getFixerSkills() {
            return this.skills;
        }

        public int getNumberOfUse() {
            return this.numberOfUse;
        }
    }

    public static final class FixerSkill {
        private String skillName = null;
        private int skillLvl = 0;

        public FixerSkill(String string, int n) {
            this.skillName = string;
            this.skillLvl = n;
        }

        public String getSkillName() {
            return this.skillName;
        }

        public int getSkillLevel() {
            return this.skillLvl;
        }
    }

    private static final class PredicateRequired
    implements Predicate<InventoryItem> {
        Fixer fixer;
        InventoryItem brokenItem;
        int uses;

        private PredicateRequired() {
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            if (this.uses >= this.fixer.getNumberOfUse()) {
                return false;
            }
            if (inventoryItem == this.brokenItem) {
                return false;
            }
            if (!this.fixer.getFixerName().equals(inventoryItem.getType())) {
                return false;
            }
            int n = Fixing.countUses(inventoryItem);
            if (n > 0) {
                this.uses += n;
                return true;
            }
            return false;
        }
    }
}

