/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting.objects;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import zombie.characters.IsoGameCharacter;
import zombie.characters.skills.PerkFactory;
import zombie.core.Translator;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.BaseScriptObject;
import zombie.scripting.objects.ItemRecipe;
import zombie.scripting.objects.UniqueRecipe;
import zombie.util.StringUtils;

public final class EvolvedRecipe
extends BaseScriptObject {
    private static final DecimalFormat DECIMAL_FORMAT = (DecimalFormat)NumberFormat.getInstance(Locale.US);
    public String name = null;
    public String DisplayName = null;
    private String originalname;
    public int maxItems = 0;
    public final Map<String, ItemRecipe> itemsList = new HashMap<String, ItemRecipe>();
    public String resultItem = null;
    public String baseItem = null;
    public boolean cookable = false;
    public boolean addIngredientIfCooked = false;
    public boolean canAddSpicesEmpty = false;
    public String addIngredientSound = null;
    public boolean hidden = false;
    public boolean allowFrozenItem = false;

    public EvolvedRecipe(String string) {
        this.name = string;
    }

    @Override
    public void Load(String string, String[] stringArray) {
        this.DisplayName = Translator.getRecipeName(string);
        this.originalname = string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].trim().isEmpty() || !stringArray[i].contains(":")) continue;
            String[] stringArray2 = stringArray[i].split(":");
            String string2 = stringArray2[0].trim();
            String string3 = stringArray2[1].trim();
            if (string2.equals("BaseItem")) {
                this.baseItem = string3;
                continue;
            }
            if (string2.equals("Name")) {
                this.DisplayName = Translator.getRecipeName(string3);
                this.originalname = string3;
                continue;
            }
            if (string2.equals("ResultItem")) {
                this.resultItem = string3;
                if (string3.contains(".")) continue;
                this.resultItem = string3;
                continue;
            }
            if (string2.equals("Cookable")) {
                this.cookable = true;
                continue;
            }
            if (string2.equals("MaxItems")) {
                this.maxItems = Integer.parseInt(string3);
                continue;
            }
            if (string2.equals("AddIngredientIfCooked")) {
                this.addIngredientIfCooked = Boolean.parseBoolean(string3);
                continue;
            }
            if (string2.equals("AddIngredientSound")) {
                this.addIngredientSound = StringUtils.discardNullOrWhitespace(string3);
                continue;
            }
            if (string2.equals("CanAddSpicesEmpty")) {
                this.canAddSpicesEmpty = Boolean.parseBoolean(string3);
                continue;
            }
            if (string2.equals("IsHidden")) {
                this.hidden = Boolean.parseBoolean(string3);
                continue;
            }
            if (!string2.equals("AllowFrozenItem")) continue;
            this.allowFrozenItem = Boolean.parseBoolean(string3);
        }
    }

    public boolean needToBeCooked(InventoryItem inventoryItem) {
        ItemRecipe itemRecipe = this.getItemRecipe(inventoryItem);
        if (itemRecipe == null) {
            return true;
        }
        return itemRecipe.cooked.booleanValue() == inventoryItem.isCooked() || itemRecipe.cooked.booleanValue() == inventoryItem.isBurnt() || itemRecipe.cooked == false;
    }

    public ArrayList<InventoryItem> getItemsCanBeUse(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ArrayList<ItemContainer> arrayList) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Cooking);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        ArrayList<InventoryItem> arrayList2 = new ArrayList<InventoryItem>();
        Iterator<String> iterator = this.itemsList.keySet().iterator();
        if (!arrayList.contains(isoGameCharacter.getInventory())) {
            arrayList.add(isoGameCharacter.getInventory());
        }
        while (iterator.hasNext()) {
            String string = iterator.next();
            for (ItemContainer itemContainer : arrayList) {
                this.checkItemCanBeUse(itemContainer, string, inventoryItem, n, arrayList2);
            }
        }
        if (inventoryItem.haveExtraItems() && inventoryItem.getExtraItems().size() >= 3) {
            for (int i = 0; i < arrayList.size(); ++i) {
                ItemContainer itemContainer = arrayList.get(i);
                for (int j = 0; j < itemContainer.getItems().size(); ++j) {
                    InventoryItem inventoryItem2 = itemContainer.getItems().get(j);
                    if (!(inventoryItem2 instanceof Food) || ((Food)inventoryItem2).getPoisonLevelForRecipe() == null || !isoGameCharacter.isKnownPoison(inventoryItem2) || arrayList2.contains(inventoryItem2)) continue;
                    arrayList2.add(inventoryItem2);
                }
            }
        }
        return arrayList2;
    }

    private void checkItemCanBeUse(ItemContainer itemContainer, String string, InventoryItem inventoryItem, int n, ArrayList<InventoryItem> arrayList) {
        ArrayList<InventoryItem> arrayList2 = itemContainer.getItemsFromType(string);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Object object;
            InventoryItem inventoryItem2 = arrayList2.get(i);
            boolean bl = false;
            if (inventoryItem2 instanceof Food && this.itemsList.get((Object)string).use != -1) {
                object = (Food)inventoryItem2;
                if (((Food)object).isSpice()) {
                    if (this.isResultItem(inventoryItem)) {
                        bl = !this.isSpiceAdded(inventoryItem, (InventoryItem)object);
                    } else if (this.canAddSpicesEmpty) {
                        bl = true;
                    }
                    if (((Food)object).isRotten() && n < 7) {
                        bl = false;
                    }
                } else if (!(inventoryItem.haveExtraItems() && inventoryItem.extraItems.size() >= this.maxItems || ((Food)object).isRotten() && n < 7)) {
                    bl = true;
                }
                if (((Food)object).isFrozen() && !this.allowFrozenItem) {
                    bl = false;
                }
            } else {
                bl = true;
            }
            object = this.getItemRecipe(inventoryItem2);
            if (!bl) continue;
            arrayList.add(inventoryItem2);
        }
    }

    public InventoryItem addItem(InventoryItem inventoryItem, InventoryItem inventoryItem2, IsoGameCharacter isoGameCharacter) {
        InventoryItem inventoryItem3;
        InventoryItem inventoryItem4;
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Cooking);
        if (!this.isResultItem(inventoryItem)) {
            InventoryItem inventoryItem5 = inventoryItem instanceof Food ? inventoryItem : null;
            inventoryItem4 = InventoryItemFactory.CreateItem(this.resultItem);
            if (inventoryItem4 != null) {
                if (inventoryItem instanceof HandWeapon) {
                    inventoryItem4.getModData().rawset((Object)("condition:" + inventoryItem.getType()), (Object)((double)inventoryItem.getCondition() / (double)inventoryItem.getConditionMax()));
                }
                isoGameCharacter.getInventory().Remove(inventoryItem);
                isoGameCharacter.getInventory().AddItem(inventoryItem4);
                inventoryItem3 = inventoryItem;
                inventoryItem = inventoryItem4;
                if (inventoryItem instanceof Food) {
                    ((Food)inventoryItem).setCalories(0.0f);
                    ((Food)inventoryItem).setCarbohydrates(0.0f);
                    ((Food)inventoryItem).setProteins(0.0f);
                    ((Food)inventoryItem).setLipids(0.0f);
                    if (inventoryItem2 instanceof Food && ((Food)inventoryItem2).getPoisonLevelForRecipe() != null) {
                        this.addPoison(inventoryItem2, inventoryItem, isoGameCharacter);
                    }
                    ((Food)inventoryItem).setIsCookable(this.cookable);
                    if (inventoryItem5 != null) {
                        ((Food)inventoryItem).setHungChange(((Food)inventoryItem5).getHungChange());
                        ((Food)inventoryItem).setBaseHunger(((Food)inventoryItem5).getBaseHunger());
                    } else {
                        ((Food)inventoryItem).setHungChange(0.0f);
                        ((Food)inventoryItem).setBaseHunger(0.0f);
                    }
                    if (inventoryItem3.isTaintedWater()) {
                        inventoryItem.setTaintedWater(true);
                    }
                    if (inventoryItem3 instanceof Food && inventoryItem3.getOffAgeMax() != 1000000000 && inventoryItem.getOffAgeMax() != 1000000000) {
                        float f = inventoryItem3.getAge() / (float)inventoryItem3.getOffAgeMax();
                        inventoryItem.setAge((float)inventoryItem.getOffAgeMax() * f);
                    }
                    if (inventoryItem5 instanceof Food) {
                        ((Food)inventoryItem).setCalories(((Food)inventoryItem5).getCalories());
                        ((Food)inventoryItem).setProteins(((Food)inventoryItem5).getProteins());
                        ((Food)inventoryItem).setLipids(((Food)inventoryItem5).getLipids());
                        ((Food)inventoryItem).setCarbohydrates(((Food)inventoryItem5).getCarbohydrates());
                        ((Food)inventoryItem).setThirstChange(((Food)inventoryItem5).getThirstChange());
                    }
                }
                inventoryItem.setUnhappyChange(0.0f);
                inventoryItem.setBoredomChange(0.0f);
            }
        }
        if (this.itemsList.get(inventoryItem2.getType()) != null && this.itemsList.get((Object)inventoryItem2.getType()).use > -1) {
            if (inventoryItem2 instanceof Food) {
                DecimalFormat decimalFormat;
                boolean bl;
                float f = (float)this.itemsList.get((Object)inventoryItem2.getType()).use.intValue() / 100.0f;
                inventoryItem4 = (Food)inventoryItem2;
                inventoryItem3 = (Food)inventoryItem;
                boolean bl2 = bl = inventoryItem3.hasTag("HerbalTea") && inventoryItem4.hasTag("HerbalTea");
                if (((Food)inventoryItem4).isSpice() && inventoryItem instanceof Food) {
                    if (inventoryItem instanceof Food && bl) {
                        ((Food)inventoryItem3).setReduceFoodSickness(((Food)inventoryItem3).getReduceFoodSickness() + ((Food)inventoryItem4).getReduceFoodSickness());
                        ((Food)inventoryItem3).setPainReduction(((Food)inventoryItem3).getPainReduction() + ((Food)inventoryItem4).getPainReduction());
                        ((Food)inventoryItem3).setFluReduction(((Food)inventoryItem3).getFluReduction() + ((Food)inventoryItem4).getFluReduction());
                        if (((Food)inventoryItem4).getEnduranceChange() > 0.0f) {
                            ((Food)inventoryItem3).setEnduranceChange(((Food)inventoryItem3).getEnduranceChange() + ((Food)inventoryItem4).getEnduranceChange());
                        }
                        if (((Food)inventoryItem3).getReduceFoodSickness() > 12) {
                            ((Food)inventoryItem3).setReduceFoodSickness(12);
                        }
                    }
                    this.useSpice((Food)inventoryItem4, (Food)inventoryItem, f, n);
                    return inventoryItem;
                }
                boolean bl3 = false;
                if (((Food)inventoryItem4).isRotten()) {
                    decimalFormat = DECIMAL_FORMAT;
                    decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
                    if (n == 7 || n == 8) {
                        f = Float.parseFloat(decimalFormat.format(Math.abs(((Food)inventoryItem4).getBaseHunger() - (((Food)inventoryItem4).getBaseHunger() - 0.05f * ((Food)inventoryItem4).getBaseHunger()))).replace(",", "."));
                    } else if (n == 9 || n == 10) {
                        f = Float.parseFloat(decimalFormat.format(Math.abs(((Food)inventoryItem4).getBaseHunger() - (((Food)inventoryItem4).getBaseHunger() - 0.1f * ((Food)inventoryItem4).getBaseHunger()))).replace(",", "."));
                    }
                    bl3 = true;
                }
                if (Math.abs(((Food)inventoryItem4).getHungerChange()) < f) {
                    decimalFormat = DECIMAL_FORMAT;
                    decimalFormat.setRoundingMode(RoundingMode.DOWN);
                    f = Math.abs(Float.parseFloat(decimalFormat.format(((Food)inventoryItem4).getHungerChange()).replace(",", ".")));
                    bl3 = true;
                }
                if (inventoryItem instanceof Food) {
                    float f2;
                    float f3;
                    if (inventoryItem2 instanceof Food && ((Food)inventoryItem2).getPoisonLevelForRecipe() != null) {
                        this.addPoison(inventoryItem2, inventoryItem, isoGameCharacter);
                    }
                    ((Food)inventoryItem3).setHungChange(((Food)inventoryItem3).getHungChange() - f);
                    ((Food)inventoryItem3).setBaseHunger(((Food)inventoryItem3).getBaseHunger() - f);
                    if (((Food)inventoryItem4).isbDangerousUncooked() && !inventoryItem4.isCooked()) {
                        ((Food)inventoryItem3).setbDangerousUncooked(true);
                    }
                    int n2 = 0;
                    if (inventoryItem.extraItems != null) {
                        for (int i = 0; i < inventoryItem.extraItems.size(); ++i) {
                            if (!inventoryItem.extraItems.get(i).equals(inventoryItem2.getFullType())) continue;
                            ++n2;
                        }
                    }
                    if (inventoryItem.extraItems != null && inventoryItem.extraItems.size() - 2 > n) {
                        n2 += inventoryItem.extraItems.size() - 2 - n * 3;
                    }
                    if ((f3 = Math.abs((f2 = f - (float)(3 * n) / 100.0f * f) / ((Food)inventoryItem4).getHungChange())) > 1.0f) {
                        f3 = 1.0f;
                    }
                    inventoryItem.setUnhappyChange(((Food)inventoryItem).getUnhappyChangeUnmodified() - (float)(5 - n2 * 5));
                    if (inventoryItem.getUnhappyChange() > 25.0f) {
                        inventoryItem.setUnhappyChange(25.0f);
                    }
                    float f4 = (float)n / 15.0f + 1.0f;
                    ((Food)inventoryItem3).setCalories(((Food)inventoryItem3).getCalories() + ((Food)inventoryItem4).getCalories() * f4 * f3);
                    ((Food)inventoryItem3).setProteins(((Food)inventoryItem3).getProteins() + ((Food)inventoryItem4).getProteins() * f4 * f3);
                    ((Food)inventoryItem3).setCarbohydrates(((Food)inventoryItem3).getCarbohydrates() + ((Food)inventoryItem4).getCarbohydrates() * f4 * f3);
                    ((Food)inventoryItem3).setLipids(((Food)inventoryItem3).getLipids() + ((Food)inventoryItem4).getLipids() * f4 * f3);
                    float f5 = ((Food)inventoryItem4).getThirstChangeUnmodified() * f4 * f3;
                    if (!inventoryItem4.hasTag("DriedFood")) {
                        ((Food)inventoryItem3).setThirstChange(((Food)inventoryItem3).getThirstChangeUnmodified() + f5);
                    }
                    if (inventoryItem4.isCooked()) {
                        f2 = (float)((double)f2 / 1.3);
                    }
                    ((Food)inventoryItem4).setHungChange(((Food)inventoryItem4).getHungChange() + f2);
                    ((Food)inventoryItem4).setBaseHunger(((Food)inventoryItem4).getBaseHunger() + f2);
                    ((Food)inventoryItem4).setThirstChange(((Food)inventoryItem4).getThirstChange() - f5);
                    ((Food)inventoryItem4).setCalories(((Food)inventoryItem4).getCalories() - ((Food)inventoryItem4).getCalories() * f3);
                    ((Food)inventoryItem4).setProteins(((Food)inventoryItem4).getProteins() - ((Food)inventoryItem4).getProteins() * f3);
                    ((Food)inventoryItem4).setCarbohydrates(((Food)inventoryItem4).getCarbohydrates() - ((Food)inventoryItem4).getCarbohydrates() * f3);
                    ((Food)inventoryItem4).setLipids(((Food)inventoryItem4).getLipids() - ((Food)inventoryItem4).getLipids() * f3);
                    if (inventoryItem3.hasTag("AlcoholicBeverage") && inventoryItem4.isAlcoholic()) {
                        inventoryItem3.setAlcoholic(true);
                    }
                    if (bl) {
                        ((Food)inventoryItem3).setReduceFoodSickness(((Food)inventoryItem3).getReduceFoodSickness() + ((Food)inventoryItem4).getReduceFoodSickness());
                        ((Food)inventoryItem3).setPainReduction(((Food)inventoryItem3).getPainReduction() + ((Food)inventoryItem4).getPainReduction());
                        ((Food)inventoryItem3).setFluReduction(((Food)inventoryItem3).getFluReduction() + ((Food)inventoryItem4).getFluReduction());
                        if (((Food)inventoryItem3).getReduceFoodSickness() > 12) {
                            ((Food)inventoryItem3).setReduceFoodSickness(12);
                        }
                    }
                    if ((double)((Food)inventoryItem4).getHungerChange() >= -0.02 || bl3) {
                        inventoryItem2.Use();
                    }
                    if (inventoryItem4.getFatigueChange() < 0.0f) {
                        inventoryItem.setFatigueChange(inventoryItem4.getFatigueChange() * f3);
                        inventoryItem4.setFatigueChange(inventoryItem4.getFatigueChange() - inventoryItem4.getFatigueChange() * f3);
                    }
                    if (((Food)inventoryItem4).getPoisonPower() > 0) {
                        ((Food)inventoryItem4).setPoisonPower((int)((double)((float)((Food)inventoryItem4).getPoisonPower() - (float)((Food)inventoryItem4).getPoisonPower() * f3) + 0.999));
                        ((Food)inventoryItem).setPoisonPower((int)((double)((float)((Food)inventoryItem4).getPoisonPower() * f3) + 0.999));
                    }
                }
            } else {
                inventoryItem2.Use();
            }
            inventoryItem.addExtraItem(inventoryItem2.getFullType());
        } else if (inventoryItem2 instanceof Food && ((Food)inventoryItem2).getPoisonLevelForRecipe() != null) {
            this.addPoison(inventoryItem2, inventoryItem, isoGameCharacter);
        }
        this.checkUniqueRecipe(inventoryItem);
        isoGameCharacter.getXp().AddXP(PerkFactory.Perks.Cooking, 3.0f);
        return inventoryItem;
    }

    private void checkUniqueRecipe(InventoryItem inventoryItem) {
        if (inventoryItem instanceof Food) {
            Food food = (Food)inventoryItem;
            Stack<UniqueRecipe> stack = ScriptManager.instance.getAllUniqueRecipes();
            for (int i = 0; i < stack.size(); ++i) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                UniqueRecipe uniqueRecipe = (UniqueRecipe)stack.get(i);
                if (!uniqueRecipe.getBaseRecipe().equals(inventoryItem.getType())) continue;
                boolean bl = true;
                for (int j = 0; j < uniqueRecipe.getItems().size(); ++j) {
                    boolean bl2 = false;
                    for (int k = 0; k < food.getExtraItems().size(); ++k) {
                        if (arrayList.contains(k) || !food.getExtraItems().get(k).equals(uniqueRecipe.getItems().get(j))) continue;
                        bl2 = true;
                        arrayList.add(k);
                        break;
                    }
                    if (bl2) continue;
                    bl = false;
                    break;
                }
                if (food.getExtraItems().size() != uniqueRecipe.getItems().size() || !bl) continue;
                food.setName(uniqueRecipe.getName());
                if (food.hasTag("Beer")) {
                    food.setName("Beer");
                }
                food.setBaseHunger(food.getBaseHunger() - (float)uniqueRecipe.getHungerBonus() / 100.0f);
                food.setHungChange(food.getBaseHunger());
                food.setBoredomChange(food.getBoredomChangeUnmodified() - (float)uniqueRecipe.getBoredomBonus());
                food.setUnhappyChange(food.getUnhappyChangeUnmodified() - (float)uniqueRecipe.getHapinessBonus());
                food.setCustomName(true);
            }
        }
    }

    private void addPoison(InventoryItem inventoryItem, InventoryItem inventoryItem2, IsoGameCharacter isoGameCharacter) {
        Food food = (Food)inventoryItem;
        if (inventoryItem2 instanceof Food) {
            Food food2 = (Food)inventoryItem2;
            int n = food.getPoisonLevelForRecipe() - isoGameCharacter.getPerkLevel(PerkFactory.Perks.Cooking);
            if (n < 1) {
                n = 1;
            }
            Float f = Float.valueOf(0.0f);
            if (food.getThirstChange() <= -0.01f) {
                var8_8 = (float)food.getUseForPoison() / 100.0f;
                if (Math.abs(food.getThirstChange()) < var8_8) {
                    var8_8 = Math.abs(food.getThirstChange());
                }
                f = Float.valueOf(Math.abs(var8_8 / food.getThirstChange()));
                f = new Float((double)Math.round(f.doubleValue() * 100.0) / 100.0);
                food.setThirstChange(food.getThirstChange() + var8_8);
                if ((double)food.getThirstChange() > -0.01) {
                    food.Use();
                }
            } else if (food.getBaseHunger() <= -0.01f) {
                var8_8 = (float)food.getUseForPoison() / 100.0f;
                if (Math.abs(food.getBaseHunger()) < var8_8) {
                    var8_8 = Math.abs(food.getThirstChange());
                }
                f = Float.valueOf(Math.abs(var8_8 / food.getBaseHunger()));
                f = new Float((double)Math.round(f.doubleValue() * 100.0) / 100.0);
            }
            if (food2.getPoisonDetectionLevel() == -1) {
                food2.setPoisonDetectionLevel(0);
            }
            food2.setPoisonDetectionLevel(food2.getPoisonDetectionLevel() + n);
            if (food2.getPoisonDetectionLevel() > 10) {
                food2.setPoisonDetectionLevel(10);
            }
            int n2 = new Float(f.floatValue() * ((float)food.getPoisonPower() / 100.0f) * 100.0f).intValue();
            food2.setPoisonPower(food2.getPoisonPower() + n2);
            food.setPoisonPower(food.getPoisonPower() - n2);
        }
    }

    private void useSpice(Food food, Food food2, float f, int n) {
        if (!this.isSpiceAdded(food2, food)) {
            float f2;
            if (food2.spices == null) {
                food2.spices = new ArrayList();
            }
            food2.spices.add(food.getFullType());
            float f3 = f;
            if (food.isRotten()) {
                DecimalFormat decimalFormat = DECIMAL_FORMAT;
                decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
                if (n == 7 || n == 8) {
                    f = Float.parseFloat(decimalFormat.format(Math.abs(food.getBaseHunger() - (food.getBaseHunger() - 0.05f * food.getBaseHunger()))).replace(",", "."));
                } else if (n == 9 || n == 10) {
                    f = Float.parseFloat(decimalFormat.format(Math.abs(food.getBaseHunger() - (food.getBaseHunger() - 0.1f * food.getBaseHunger()))).replace(",", "."));
                }
            }
            if ((f2 = Math.abs(f / food.getHungChange())) > 1.0f) {
                f2 = 1.0f;
            }
            float f4 = (float)n / 15.0f + 1.0f;
            food2.setUnhappyChange(food2.getUnhappyChangeUnmodified() - f * 200.0f);
            food2.setBoredomChange(food2.getBoredomChangeUnmodified() - f * 200.0f);
            food2.setCalories(food2.getCalories() + food.getCalories() * f4 * f2);
            food2.setProteins(food2.getProteins() + food.getProteins() * f4 * f2);
            food2.setCarbohydrates(food2.getCarbohydrates() + food.getCarbohydrates() * f4 * f2);
            food2.setLipids(food2.getLipids() + food.getLipids() * f4 * f2);
            f2 = Math.abs(f3 / food.getHungChange());
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            food.setCalories(food.getCalories() - food.getCalories() * f2);
            food.setProteins(food.getProteins() - food.getProteins() * f2);
            food.setCarbohydrates(food.getCarbohydrates() - food.getCarbohydrates() * f2);
            food.setLipids(food.getLipids() - food.getLipids() * f2);
            food.setHungChange(food.getHungChange() + f3);
            if ((double)food.getHungerChange() > -0.01) {
                food.Use();
            }
        }
    }

    public ItemRecipe getItemRecipe(InventoryItem inventoryItem) {
        return this.itemsList.get(inventoryItem.getType());
    }

    public String getName() {
        return this.DisplayName;
    }

    public String getOriginalname() {
        return this.originalname;
    }

    public String getUntranslatedName() {
        return this.name;
    }

    public String getBaseItem() {
        return this.baseItem;
    }

    public Map<String, ItemRecipe> getItemsList() {
        return this.itemsList;
    }

    public ArrayList<ItemRecipe> getPossibleItems() {
        ArrayList<ItemRecipe> arrayList = new ArrayList<ItemRecipe>();
        for (ItemRecipe itemRecipe : this.itemsList.values()) {
            arrayList.add(itemRecipe);
        }
        return arrayList;
    }

    public String getResultItem() {
        if (!this.resultItem.contains(".")) {
            return this.resultItem;
        }
        return this.resultItem.split("\\.")[1];
    }

    public String getFullResultItem() {
        return this.resultItem;
    }

    public boolean isCookable() {
        return this.cookable;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public boolean isResultItem(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return false;
        }
        return this.getResultItem().equals(inventoryItem.getType());
    }

    public boolean isSpiceAdded(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
        if (!this.isResultItem(inventoryItem)) {
            return false;
        }
        if (!(inventoryItem instanceof Food) || !(inventoryItem2 instanceof Food)) {
            return false;
        }
        if (!((Food)inventoryItem2).isSpice()) {
            return false;
        }
        ArrayList<String> arrayList = ((Food)inventoryItem).getSpices();
        if (arrayList == null) {
            return false;
        }
        return arrayList.contains(inventoryItem2.getFullType());
    }

    public String getAddIngredientSound() {
        return this.addIngredientSound;
    }

    public void setIsHidden(boolean bl) {
        this.hidden = bl;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isAllowFrozenItem() {
        return this.allowFrozenItem;
    }

    public void setAllowFrozenItem(boolean bl) {
        this.allowFrozenItem = bl;
    }

    static {
        DECIMAL_FORMAT.applyPattern("#.##");
    }
}

