/*
 * Decompiled with CFR 0.152.
 */
package zombie.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import zombie.GameSounds;
import zombie.SoundManager;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.IndieFileLoader;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.skinnedmodel.runtime.RuntimeAnimationScript;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.inventory.RecipeManager;
import zombie.iso.IsoWorld;
import zombie.iso.MultiStageBuilding;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.NetChecksum;
import zombie.scripting.IScriptObjectStore;
import zombie.scripting.ScriptParser;
import zombie.scripting.objects.AnimationsMesh;
import zombie.scripting.objects.EvolvedRecipe;
import zombie.scripting.objects.Fixing;
import zombie.scripting.objects.GameSoundScript;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.MannequinScript;
import zombie.scripting.objects.ModelScript;
import zombie.scripting.objects.Recipe;
import zombie.scripting.objects.ScriptModule;
import zombie.scripting.objects.SoundTimelineScript;
import zombie.scripting.objects.UniqueRecipe;
import zombie.scripting.objects.VehicleScript;
import zombie.scripting.objects.VehicleTemplate;
import zombie.util.StringUtils;
import zombie.vehicles.VehicleEngineRPM;
import zombie.world.WorldDictionary;

public final class ScriptManager
implements IScriptObjectStore {
    public static final ScriptManager instance = new ScriptManager();
    public String currentFileName;
    public final ArrayList<String> scriptsWithVehicles = new ArrayList();
    public final ArrayList<String> scriptsWithVehicleTemplates = new ArrayList();
    public final HashMap<String, ScriptModule> ModuleMap = new HashMap();
    public final ArrayList<ScriptModule> ModuleList = new ArrayList();
    private final HashMap<String, Item> FullTypeToItemMap = new HashMap();
    private final HashMap<String, SoundTimelineScript> SoundTimelineMap = new HashMap();
    public ScriptModule CurrentLoadingModule = null;
    private final HashMap<String, String> ModuleAliases = new HashMap();
    private final StringBuilder buf = new StringBuilder();
    private final HashMap<String, ScriptModule> CachedModules = new HashMap();
    private final ArrayList<Recipe> recipesTempList = new ArrayList();
    private final Stack<EvolvedRecipe> evolvedRecipesTempList = new Stack();
    private final Stack<UniqueRecipe> uniqueRecipesTempList = new Stack();
    private final ArrayList<Item> itemTempList = new ArrayList();
    private final HashMap<String, ArrayList<Item>> tagToItemMap = new HashMap();
    private final HashMap<String, ArrayList<Item>> typeToItemMap = new HashMap();
    private final ArrayList<AnimationsMesh> animationsMeshTempList = new ArrayList();
    private final ArrayList<MannequinScript> mannequinScriptTempList = new ArrayList();
    private final ArrayList<ModelScript> modelScriptTempList = new ArrayList();
    private final ArrayList<VehicleScript> vehicleScriptTempList = new ArrayList();
    private final HashMap<String, String> clothingToItemMap = new HashMap();
    private final ArrayList<String> visualDamagesList = new ArrayList();
    private static final String Base = "Base";
    private static final String Base_Module = "Base.";
    private String checksum = "";
    private HashMap<String, String> tempFileToModMap;
    private static String currentLoadFileMod;
    private static String currentLoadFileAbsPath;
    public static final String VanillaID = "pz-vanilla";

    public void ParseScript(String string) {
        if (DebugLog.isEnabled(DebugType.Script)) {
            DebugLog.Script.debugln("Parsing...");
        }
        ArrayList<String> arrayList = ScriptParser.parseTokens(string);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            this.CreateFromToken(string2);
        }
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadFile(String string, boolean bl) throws FileNotFoundException {
        if (DebugLog.isEnabled(DebugType.Script)) {
            DebugLog.Script.debugln(string + (bl ? " bLoadJar" : ""));
        }
        if (!GameServer.bServer) {
            Thread.yield();
            Core.getInstance().DoFrameReady();
        }
        if (string.contains(".tmx")) {
            IsoWorld.mapPath = string.substring(0, string.lastIndexOf("/"));
            IsoWorld.mapUseJar = bl;
            DebugLog.Script.debugln("  file is a .tmx (map) file. Set mapPath to " + IsoWorld.mapPath + (IsoWorld.mapUseJar ? " mapUseJar" : ""));
            return;
        }
        if (!string.endsWith(".txt")) {
            DebugLog.Script.warn(" file is not a .txt (script) file: " + string);
            return;
        }
        InputStreamReader inputStreamReader = IndieFileLoader.getStreamReader(string, !bl);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        this.buf.setLength(0);
        String string2 = null;
        String string3 = "";
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                this.buf.append(string2);
                this.buf.append('\n');
            }
        }
        catch (Exception exception) {
            DebugLog.Script.error("Exception thrown reading file " + string + "\n  " + exception);
            return;
        }
        finally {
            try {
                bufferedReader.close();
                inputStreamReader.close();
            }
            catch (Exception exception) {
                DebugLog.Script.error("Exception thrown closing file " + string + "\n  " + exception);
                exception.printStackTrace(DebugLog.Script);
            }
        }
        string3 = this.buf.toString();
        string3 = ScriptParser.stripComments(string3);
        this.currentFileName = string;
        this.ParseScript(string3);
        this.currentFileName = null;
    }

    private void CreateFromToken(String string) {
        if ((string = string.trim()).indexOf("module") == 0) {
            int n = string.indexOf("{");
            int n2 = string.lastIndexOf("}");
            String[] stringArray = string.split("[{}]");
            String string2 = stringArray[0];
            string2 = string2.replace("module", "");
            string2 = string2.trim();
            String string3 = string.substring(n + 1, n2);
            ScriptModule scriptModule = this.ModuleMap.get(string2);
            if (scriptModule == null) {
                if (DebugLog.isEnabled(DebugType.Script)) {
                    DebugLog.Script.debugln("Adding new module: " + string2);
                }
                scriptModule = new ScriptModule();
                this.ModuleMap.put(string2, scriptModule);
                this.ModuleList.add(scriptModule);
            }
            scriptModule.Load(string2, string3);
        }
    }

    public void searchFolders(URI uRI, File file, ArrayList<String> arrayList) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                this.searchFolders(uRI, new File(file.getAbsolutePath() + File.separator + stringArray[i]), arrayList);
            }
        } else if (file.getAbsolutePath().toLowerCase().endsWith(".txt")) {
            String string = ZomboidFileSystem.instance.getRelativeFile(uRI, file.getAbsolutePath());
            string = string.toLowerCase(Locale.ENGLISH);
            arrayList.add(string);
        }
    }

    public static String getItemName(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public ScriptModule getModule(String string) {
        return this.getModule(string, true);
    }

    public ScriptModule getModule(String string, boolean bl) {
        if (string.trim().equals(Base) || string.startsWith(Base_Module)) {
            return this.ModuleMap.get(Base);
        }
        if (this.CachedModules.containsKey(string)) {
            return this.CachedModules.get(string);
        }
        ScriptModule scriptModule = null;
        if (this.ModuleAliases.containsKey(string)) {
            string = this.ModuleAliases.get(string);
        }
        if (this.CachedModules.containsKey(string)) {
            return this.CachedModules.get(string);
        }
        if (this.ModuleMap.containsKey(string)) {
            scriptModule = this.ModuleMap.get((Object)string).disabled ? null : this.ModuleMap.get(string);
        }
        if (scriptModule != null) {
            this.CachedModules.put(string, scriptModule);
            return scriptModule;
        }
        int n = string.indexOf(".");
        if (n != -1) {
            scriptModule = this.getModule(string.substring(0, n));
        }
        if (scriptModule != null) {
            this.CachedModules.put(string, scriptModule);
            return scriptModule;
        }
        return bl ? this.ModuleMap.get(Base) : null;
    }

    public ScriptModule getModuleNoDisableCheck(String string) {
        if (this.ModuleAliases.containsKey(string)) {
            string = this.ModuleAliases.get(string);
        }
        if (this.ModuleMap.containsKey(string)) {
            return this.ModuleMap.get(string);
        }
        if (string.indexOf(".") != -1) {
            return this.getModule(string.split("\\.")[0]);
        }
        return null;
    }

    @Override
    public Item getItem(String string) {
        if (string.contains(".") && this.FullTypeToItemMap.containsKey(string)) {
            return this.FullTypeToItemMap.get(string);
        }
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getItem(ScriptManager.getItemName(string));
    }

    public Item FindItem(String string) {
        return this.FindItem(string, true);
    }

    public Item FindItem(String string, boolean bl) {
        if (string.contains(".") && this.FullTypeToItemMap.containsKey(string)) {
            return this.FullTypeToItemMap.get(string);
        }
        ScriptModule scriptModule = this.getModule(string, bl);
        if (scriptModule == null) {
            return null;
        }
        Item item = scriptModule.getItem(ScriptManager.getItemName(string));
        if (item == null) {
            for (int i = 0; i < this.ModuleList.size(); ++i) {
                ScriptModule scriptModule2 = this.ModuleList.get(i);
                if (scriptModule2.disabled || (item = scriptModule.getItem(ScriptManager.getItemName(string))) == null) continue;
                return item;
            }
        }
        return item;
    }

    public boolean isDrainableItemType(String string) {
        Item item = this.FindItem(string);
        if (item != null) {
            return item.getType() == Item.Type.Drainable;
        }
        return false;
    }

    @Override
    public Recipe getRecipe(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getRecipe(ScriptManager.getItemName(string));
    }

    public VehicleScript getVehicle(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getVehicle(ScriptManager.getItemName(string));
    }

    public VehicleTemplate getVehicleTemplate(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getVehicleTemplate(ScriptManager.getItemName(string));
    }

    public VehicleEngineRPM getVehicleEngineRPM(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getVehicleEngineRPM(ScriptManager.getItemName(string));
    }

    public void CheckExitPoints() {
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled || !scriptModule.CheckExitPoints()) continue;
            return;
        }
    }

    public ArrayList<Item> getAllItems() {
        if (this.itemTempList.isEmpty()) {
            for (int i = 0; i < this.ModuleList.size(); ++i) {
                ScriptModule scriptModule = this.ModuleList.get(i);
                if (scriptModule.disabled) continue;
                for (Item item : scriptModule.ItemMap.values()) {
                    this.itemTempList.add(item);
                }
            }
        }
        return this.itemTempList;
    }

    public ArrayList<Item> getItemsTag(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("invalid tag \"" + string + "\"");
        }
        ArrayList<Item> arrayList = this.tagToItemMap.get(string = string.toLowerCase(Locale.ENGLISH));
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList();
        ArrayList<Item> arrayList2 = this.getAllItems();
        block0: for (int i = 0; i < arrayList2.size(); ++i) {
            Item item = arrayList2.get(i);
            for (int j = 0; j < item.Tags.size(); ++j) {
                if (!item.Tags.get(j).equalsIgnoreCase(string)) continue;
                arrayList.add(item);
                continue block0;
            }
        }
        this.tagToItemMap.put(string, arrayList);
        return arrayList;
    }

    public ArrayList<Item> getItemsByType(String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            throw new IllegalArgumentException("invalid type \"" + string + "\"");
        }
        ArrayList<Item> arrayList = this.typeToItemMap.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            Item item;
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled || (item = this.FullTypeToItemMap.get(StringUtils.moduleDotType(scriptModule.name, string))) == null) continue;
            arrayList.add(item);
        }
        this.tagToItemMap.put(string, arrayList);
        return arrayList;
    }

    public List<Fixing> getAllFixing(List<Fixing> list) {
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            list.addAll(scriptModule.FixingMap.values());
        }
        return list;
    }

    public ArrayList<Recipe> getAllRecipes() {
        this.recipesTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            for (int j = 0; j < scriptModule.RecipeMap.size(); ++j) {
                Recipe recipe = scriptModule.RecipeMap.get(j);
                this.recipesTempList.add(recipe);
            }
        }
        return this.recipesTempList;
    }

    public Stack<EvolvedRecipe> getAllEvolvedRecipes() {
        this.evolvedRecipesTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            for (int j = 0; j < scriptModule.EvolvedRecipeMap.size(); ++j) {
                EvolvedRecipe evolvedRecipe = scriptModule.EvolvedRecipeMap.get(j);
                this.evolvedRecipesTempList.add(evolvedRecipe);
            }
        }
        return this.evolvedRecipesTempList;
    }

    public Stack<UniqueRecipe> getAllUniqueRecipes() {
        this.uniqueRecipesTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            Iterator<UniqueRecipe> iterator = scriptModule.UniqueRecipeMap.iterator();
            while (iterator != null && iterator.hasNext()) {
                UniqueRecipe uniqueRecipe = iterator.next();
                this.uniqueRecipesTempList.add(uniqueRecipe);
            }
        }
        return this.uniqueRecipesTempList;
    }

    public ArrayList<GameSoundScript> getAllGameSounds() {
        ArrayList<GameSoundScript> arrayList = new ArrayList<GameSoundScript>();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            arrayList.addAll(scriptModule.GameSoundList);
        }
        return arrayList;
    }

    public ArrayList<RuntimeAnimationScript> getAllRuntimeAnimationScripts() {
        ArrayList<RuntimeAnimationScript> arrayList = new ArrayList<RuntimeAnimationScript>();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            arrayList.addAll(scriptModule.RuntimeAnimationScriptMap.values());
        }
        return arrayList;
    }

    public AnimationsMesh getAnimationsMesh(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        string = ScriptManager.getItemName(string);
        return scriptModule.AnimationsMeshMap.get(string);
    }

    public ArrayList<AnimationsMesh> getAllAnimationsMeshes() {
        this.animationsMeshTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            this.animationsMeshTempList.addAll(scriptModule.AnimationsMeshMap.values());
        }
        return this.animationsMeshTempList;
    }

    public MannequinScript getMannequinScript(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        string = ScriptManager.getItemName(string);
        return scriptModule.MannequinScriptMap.get(string);
    }

    public ArrayList<MannequinScript> getAllMannequinScripts() {
        this.mannequinScriptTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            this.mannequinScriptTempList.addAll(scriptModule.MannequinScriptMap.values());
        }
        this.mannequinScriptTempList.sort((mannequinScript, mannequinScript2) -> String.CASE_INSENSITIVE_ORDER.compare(mannequinScript.getName(), mannequinScript2.getName()));
        return this.mannequinScriptTempList;
    }

    public ModelScript getModelScript(String string) {
        ScriptModule scriptModule = this.getModule(string);
        if (scriptModule == null) {
            return null;
        }
        string = ScriptManager.getItemName(string);
        return scriptModule.ModelScriptMap.get(string);
    }

    public ArrayList<ModelScript> getAllModelScripts() {
        this.modelScriptTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            this.modelScriptTempList.addAll(scriptModule.ModelScriptMap.values());
        }
        return this.modelScriptTempList;
    }

    public ArrayList<VehicleScript> getAllVehicleScripts() {
        this.vehicleScriptTempList.clear();
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule = this.ModuleList.get(i);
            if (scriptModule.disabled) continue;
            this.vehicleScriptTempList.addAll(scriptModule.VehicleMap.values());
        }
        return this.vehicleScriptTempList;
    }

    public SoundTimelineScript getSoundTimeline(String string) {
        if (this.SoundTimelineMap.isEmpty()) {
            for (int i = 0; i < this.ModuleList.size(); ++i) {
                ScriptModule scriptModule = this.ModuleList.get(i);
                if (scriptModule.disabled) continue;
                this.SoundTimelineMap.putAll(scriptModule.SoundTimelineMap);
            }
        }
        return this.SoundTimelineMap.get(string);
    }

    public void Reset() {
        for (ScriptModule scriptModule : this.ModuleList) {
            scriptModule.Reset();
        }
        this.ModuleMap.clear();
        this.ModuleList.clear();
        this.ModuleAliases.clear();
        this.CachedModules.clear();
        this.FullTypeToItemMap.clear();
        this.itemTempList.clear();
        this.tagToItemMap.clear();
        this.typeToItemMap.clear();
        this.clothingToItemMap.clear();
        this.scriptsWithVehicles.clear();
        this.scriptsWithVehicleTemplates.clear();
        this.SoundTimelineMap.clear();
    }

    public String getChecksum() {
        return this.checksum;
    }

    public static String getCurrentLoadFileMod() {
        return currentLoadFileMod;
    }

    public static String getCurrentLoadFileAbsPath() {
        return currentLoadFileAbsPath;
    }

    /*
     * WARNING - void declaration
     */
    public void Load() {
        ArrayList<String> arrayList;
        try {
            Object object;
            void var4_10;
            WorldDictionary.StartScriptLoading();
            this.tempFileToModMap = new HashMap();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            this.searchFolders(ZomboidFileSystem.instance.baseURI, ZomboidFileSystem.instance.getMediaFile("scripts"), arrayList3);
            for (String arrayList22 : arrayList3) {
                this.tempFileToModMap.put(ZomboidFileSystem.instance.getAbsolutePath(arrayList22), VanillaID);
            }
            arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = ZomboidFileSystem.instance.getModIDs();
            boolean bl = false;
            while (var4_10 < arrayList2.size()) {
                object = ZomboidFileSystem.instance.getModDir(arrayList2.get((int)var4_10));
                if (object != null) {
                    File file = new File((String)object);
                    URI uRI = file.toURI();
                    int n = arrayList.size();
                    File file2 = ZomboidFileSystem.instance.getCanonicalFile(file, "media");
                    File file3 = ZomboidFileSystem.instance.getCanonicalFile(file2, "scripts");
                    this.searchFolders(uRI, file3, arrayList);
                    if (arrayList2.get((int)var4_10).equals(VanillaID)) {
                        throw new RuntimeException("Warning mod id is named pz-vanilla!");
                    }
                    for (int i = n; i < arrayList.size(); ++i) {
                        String string = arrayList.get(i);
                        this.tempFileToModMap.put(ZomboidFileSystem.instance.getAbsolutePath(string), arrayList2.get((int)var4_10));
                    }
                }
                ++var4_10;
            }
            Comparator<String> comparator = new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    String string3 = new File(string).getName();
                    String string4 = new File(string2).getName();
                    if (string3.startsWith("template_") && !string4.startsWith("template_")) {
                        return -1;
                    }
                    if (!string3.startsWith("template_") && string4.startsWith("template_")) {
                        return 1;
                    }
                    return string.compareTo(string2);
                }
            };
            Collections.sort(arrayList3, comparator);
            Collections.sort(arrayList, comparator);
            arrayList3.addAll(arrayList);
            if (GameClient.bClient || GameServer.bServer) {
                NetChecksum.checksummer.reset(true);
                NetChecksum.GroupOfFiles.initChecksum();
            }
            MultiStageBuilding.stages.clear();
            object = new HashSet();
            for (String string : arrayList3) {
                String string2;
                if (((HashSet)object).contains(string)) continue;
                ((HashSet)object).add(string);
                currentLoadFileAbsPath = string2 = ZomboidFileSystem.instance.getAbsolutePath(string);
                currentLoadFileMod = this.tempFileToModMap.get(string2);
                this.LoadFile(string, false);
                if (!GameClient.bClient && !GameServer.bServer) continue;
                NetChecksum.checksummer.addFile(string, string2);
            }
            if (GameClient.bClient || GameServer.bServer) {
                this.checksum = NetChecksum.checksummer.checksumToString();
                if (GameServer.bServer) {
                    DebugLog.General.println("scriptChecksum: " + this.checksum);
                }
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        this.buf.setLength(0);
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            arrayList = this.ModuleList.get(i);
            for (Item item : ((ScriptModule)((Object)arrayList)).ItemMap.values()) {
                this.FullTypeToItemMap.put(item.getFullName(), item);
            }
        }
        this.debugItems();
        this.resolveItemTypes();
        WorldDictionary.ScriptsLoaded();
        RecipeManager.Loaded();
        GameSounds.ScriptsLoaded();
        ModelScript.ScriptsLoaded();
        if (SoundManager.instance != null) {
            SoundManager.instance.debugScriptSounds();
        }
        Translator.debugItemEvolvedRecipeNames();
        Translator.debugItemNames();
        Translator.debugMultiStageBuildNames();
        Translator.debugRecipeNames();
        this.createClothingItemMap();
        this.createZedDmgMap();
    }

    private void debugItems() {
        ArrayList<Item> arrayList = instance.getAllItems();
        for (Item item : arrayList) {
            ModelScript modelScript;
            if (item.getType() == Item.Type.Drainable && item.getReplaceOnUse() != null) {
                DebugLog.Script.warn("%s ReplaceOnUse instead of ReplaceOnDeplete", item.getFullName());
            }
            if (item.getType() == Item.Type.Weapon && !item.HitSound.equals(item.hitFloorSound)) {
                boolean bl = true;
            }
            if (StringUtils.isNullOrEmpty(item.worldStaticModel) || (modelScript = this.getModelScript(item.worldStaticModel)) == null || modelScript.getAttachmentById("world") == null) continue;
            boolean bl = true;
        }
    }

    public ArrayList<Recipe> getAllRecipesFor(String string) {
        ArrayList<Recipe> arrayList = this.getAllRecipes();
        ArrayList<Recipe> arrayList2 = new ArrayList<Recipe>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get((int)i).Result.type;
            if (string2.contains(".")) {
                string2 = string2.substring(string2.indexOf(".") + 1);
            }
            if (!string2.equals(string)) continue;
            arrayList2.add(arrayList.get(i));
        }
        return arrayList2;
    }

    public String getItemTypeForClothingItem(String string) {
        return this.clothingToItemMap.get(string);
    }

    public Item getItemForClothingItem(String string) {
        String string2 = this.getItemTypeForClothingItem(string);
        if (string2 == null) {
            return null;
        }
        return this.FindItem(string2);
    }

    private void createZedDmgMap() {
        this.visualDamagesList.clear();
        ScriptModule scriptModule = this.getModule(Base);
        for (Item item : scriptModule.ItemMap.values()) {
            if (StringUtils.isNullOrWhitespace(item.getBodyLocation()) || !"ZedDmg".equals(item.getBodyLocation())) continue;
            this.visualDamagesList.add(item.getName());
        }
    }

    public ArrayList<String> getZedDmgMap() {
        return this.visualDamagesList;
    }

    private void createClothingItemMap() {
        for (Item item : this.getAllItems()) {
            if (StringUtils.isNullOrWhitespace(item.getClothingItem())) continue;
            if (DebugLog.isEnabled(DebugType.Script)) {
                DebugLog.Script.debugln("ClothingItem \"%s\" <---> Item \"%s\"", item.getClothingItem(), item.getFullName());
            }
            this.clothingToItemMap.put(item.getClothingItem(), item.getFullName());
        }
    }

    private void resolveItemTypes() {
        for (Item item : this.getAllItems()) {
            item.resolveItemTypes();
        }
    }

    public String resolveItemType(ScriptModule scriptModule, String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        if (string.contains(".")) {
            return string;
        }
        Item item = scriptModule.getItem(string);
        if (item != null) {
            return item.getFullName();
        }
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule2 = this.ModuleList.get(i);
            if (scriptModule2.disabled || (item = scriptModule2.getItem(string)) == null) continue;
            return item.getFullName();
        }
        return "???." + string;
    }

    public String resolveModelScript(ScriptModule scriptModule, String string) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        if (string.contains(".")) {
            return string;
        }
        ModelScript modelScript = scriptModule.getModelScript(string);
        if (modelScript != null) {
            return modelScript.getFullType();
        }
        for (int i = 0; i < this.ModuleList.size(); ++i) {
            ScriptModule scriptModule2 = this.ModuleList.get(i);
            if (scriptModule2 == scriptModule || scriptModule2.disabled || (modelScript = scriptModule2.getModelScript(string)) == null) continue;
            return modelScript.getFullType();
        }
        return "???." + string;
    }

    public Item getSpecificItem(String string) {
        if (!string.contains(".")) {
            DebugLog.log("ScriptManager.getSpecificItem requires a full type name, cannot find: " + string);
            if (Core.bDebug) {
                throw new RuntimeException("ScriptManager.getSpecificItem requires a full type name, cannot find: " + string);
            }
            return null;
        }
        if (this.FullTypeToItemMap.containsKey(string)) {
            return this.FullTypeToItemMap.get(string);
        }
        int n = string.indexOf(".");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        ScriptModule scriptModule = this.getModule(string2, false);
        if (scriptModule == null) {
            return null;
        }
        return scriptModule.getSpecificItem(string3);
    }
}

