/*
 * Decompiled with CFR 0.152.
 */
package zombie.savefile;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.debug.DebugLog;
import zombie.util.PZSQLUtils;
import zombie.vehicles.VehicleDBHelper;

public final class PlayerDBHelper {
    public static Connection create() {
        Statement statement;
        Connection connection = null;
        String string = ZomboidFileSystem.instance.getCurrentSaveDir();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(string + File.separator + "players.db");
        file2.setReadable(true, false);
        file2.setExecutable(true, false);
        file2.setWritable(true, false);
        if (!file2.exists()) {
            try {
                file2.createNewFile();
                connection = PZSQLUtils.getConnection(file2.getAbsolutePath());
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE localPlayers (id   INTEGER PRIMARY KEY NOT NULL,name STRING,wx    INTEGER,wy    INTEGER,x    FLOAT,y    FLOAT,z    FLOAT,worldversion    INTEGER,data BLOB,isDead BOOLEAN);");
                statement.executeUpdate("CREATE TABLE networkPlayers (id   INTEGER PRIMARY KEY NOT NULL,world TEXT,username TEXT,playerIndex   INTEGER,name STRING,steamid STRING,x    FLOAT,y    FLOAT,z    FLOAT,worldversion    INTEGER,data BLOB,isDead BOOLEAN);");
                statement.executeUpdate("CREATE INDEX inpusername ON networkPlayers (username);");
                statement.close();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                DebugLog.log("failed to create players database");
                System.exit(1);
            }
        }
        if (connection == null) {
            try {
                connection = PZSQLUtils.getConnection(file2.getAbsolutePath());
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                DebugLog.log("failed to create players database");
                System.exit(1);
            }
        }
        try {
            statement = connection.createStatement();
            statement.executeQuery("PRAGMA JOURNAL_MODE=TRUNCATE;");
            statement.close();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
            DebugLog.log("failed to config players.db");
            System.exit(1);
        }
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            DebugLog.log("failed to setAutoCommit for players.db");
        }
        return connection;
    }

    public static void rollback(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            connection.rollback();
        }
        catch (SQLException sQLException) {
            ExceptionLogger.logException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPlayerAlive(String string, int n) {
        if (Core.getInstance().isNoSave()) {
            return false;
        }
        File file = new File(string + File.separator + "map_p.bin");
        if (file.exists()) {
            return true;
        }
        if (VehicleDBHelper.isPlayerAlive(string, n)) {
            return true;
        }
        if (n == -1) {
            return false;
        }
        try {
            File file2 = new File(string + File.separator + "players.db");
            if (!file2.exists()) {
                return false;
            }
            file2.setReadable(true, false);
            try (Connection connection = PZSQLUtils.getConnection(file2.getAbsolutePath());){
                String string2 = "SELECT isDead FROM localPlayers WHERE id=?";
                try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                    preparedStatement.setInt(1, n);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) return false;
                    boolean bl = !resultSet.getBoolean(1);
                    return bl;
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
        return false;
    }

    public static ArrayList<Object> getPlayers(String string) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Core.getInstance().isNoSave()) {
            return arrayList;
        }
        File file = new File(string + File.separator + "players.db");
        if (!file.exists()) {
            return arrayList;
        }
        file.setReadable(true, false);
        try (Connection connection = PZSQLUtils.getConnection(file.getAbsolutePath());){
            String string2 = "SELECT id, name, isDead FROM localPlayers";
            try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    String string3 = resultSet.getString(2);
                    boolean bl = resultSet.getBoolean(3);
                    arrayList.add(BoxedStaticValues.toDouble(n));
                    arrayList.add(string3);
                    arrayList.add(bl ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }
        return arrayList;
    }

    public static void setPlayer1(String string, int n) throws SQLException {
        block47: {
            if (Core.getInstance().isNoSave()) {
                return;
            }
            if (n == 1) {
                return;
            }
            File file = new File(string + File.separator + "players.db");
            if (!file.exists()) {
                return;
            }
            file.setReadable(true, false);
            try (Connection connection = PZSQLUtils.getConnection(file.getAbsolutePath());){
                boolean bl = false;
                boolean bl2 = false;
                int n2 = -1;
                int n3 = -1;
                String string2 = "SELECT id FROM localPlayers";
                try (PreparedStatement preparedStatement = connection.prepareStatement(string2);){
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        int n4 = resultSet.getInt(1);
                        if (n4 == 1) {
                            bl = true;
                        } else if (n2 == -1 || n2 > n4) {
                            n2 = n4;
                        }
                        if (n4 == n) {
                            bl2 = true;
                        }
                        n3 = Math.max(n3, n4);
                    }
                }
                if (n <= 0) {
                    if (!bl) {
                        return;
                    }
                    string2 = "UPDATE localPlayers SET id=? WHERE id=?";
                    preparedStatement = connection.prepareStatement(string2);
                    try {
                        preparedStatement.setInt(1, n3 + 1);
                        preparedStatement.setInt(2, 1);
                        preparedStatement.executeUpdate();
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                    return;
                }
                if (!bl2) {
                    return;
                }
                if (bl) {
                    string2 = "UPDATE localPlayers SET id=? WHERE id=?";
                    preparedStatement = connection.prepareStatement(string2);
                    try {
                        preparedStatement.setInt(1, n3 + 1);
                        preparedStatement.setInt(2, 1);
                        preparedStatement.executeUpdate();
                        preparedStatement.setInt(1, 1);
                        preparedStatement.setInt(2, n);
                        preparedStatement.executeUpdate();
                        preparedStatement.setInt(1, n);
                        preparedStatement.setInt(2, n3 + 1);
                        preparedStatement.executeUpdate();
                        break block47;
                    }
                    finally {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                    }
                }
                string2 = "UPDATE localPlayers SET id=? WHERE id=?";
                preparedStatement = connection.prepareStatement(string2);
                try {
                    preparedStatement.setInt(1, 1);
                    preparedStatement.setInt(2, n);
                    preparedStatement.executeUpdate();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
        }
    }
}

