/*
 * Decompiled with CFR 0.152.
 */
package zombie.savefile;

import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;
import zombie.iso.WorldStreamer;
import zombie.savefile.PlayerDBHelper;
import zombie.util.ByteBufferBackedInputStream;
import zombie.util.ByteBufferOutputStream;
import zombie.vehicles.VehiclesDB2;

public final class PlayerDB {
    public static final int INVALID_ID = -1;
    private static final int MIN_ID = 1;
    private static PlayerDB instance = null;
    private static final ThreadLocal<ByteBuffer> TL_SliceBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocate(32768));
    private static final ThreadLocal<byte[]> TL_Bytes = ThreadLocal.withInitial(() -> new byte[1024]);
    private static boolean s_allow = false;
    private final IPlayerStore m_store = new SQLPlayerStore();
    private final TIntHashSet m_usedIDs = new TIntHashSet();
    private final ConcurrentLinkedQueue<PlayerData> m_toThread = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<PlayerData> m_fromThread = new ConcurrentLinkedQueue();
    private boolean m_forceSavePlayers;
    public boolean m_canSavePlayers = false;
    private final UpdateLimit m_saveToDBPeriod = new UpdateLimit(10000L);

    public static synchronized PlayerDB getInstance() {
        if (instance == null && s_allow) {
            instance = new PlayerDB();
        }
        return instance;
    }

    public static void setAllow(boolean bl) {
        s_allow = bl;
    }

    public static boolean isAllow() {
        return s_allow;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    public PlayerDB() {
        if (Core.getInstance().isNoSave()) {
            return;
        }
        this.create();
    }

    private void create() {
        try {
            this.m_store.init(this.m_usedIDs);
            this.m_usedIDs.add(1);
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public void close() {
        assert (WorldStreamer.instance.worldStreamer == null);
        this.updateWorldStreamer();
        assert (this.m_toThread.isEmpty());
        try {
            this.m_store.Reset();
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        this.m_fromThread.clear();
        instance = null;
        s_allow = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateID() {
        TIntHashSet tIntHashSet = this.m_usedIDs;
        synchronized (tIntHashSet) {
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                if (this.m_usedIDs.contains(i)) continue;
                this.m_usedIDs.add(i);
                return i;
            }
        }
        throw new RuntimeException("ran out of unused players.db ids");
    }

    private PlayerData allocPlayerData() {
        PlayerData playerData = this.m_fromThread.poll();
        if (playerData == null) {
            playerData = new PlayerData();
        }
        assert (playerData.m_sqlID == -1);
        return playerData;
    }

    private void releasePlayerData(PlayerData playerData) {
        playerData.m_sqlID = -1;
        this.m_fromThread.add(playerData);
    }

    public void updateMain() {
        if (this.m_canSavePlayers && (this.m_forceSavePlayers || this.m_saveToDBPeriod.Check())) {
            this.m_forceSavePlayers = false;
            this.savePlayersAsync();
            VehiclesDB2.instance.setForceSave();
        }
    }

    public void updateWorldStreamer() {
        PlayerData playerData = this.m_toThread.poll();
        while (playerData != null) {
            try {
                this.m_store.save(playerData);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            finally {
                this.releasePlayerData(playerData);
            }
            playerData = this.m_toThread.poll();
        }
    }

    private void savePlayerAsync(IsoPlayer isoPlayer) throws Exception {
        if (isoPlayer == null) {
            return;
        }
        if (isoPlayer.sqlID == -1) {
            isoPlayer.sqlID = this.allocateID();
        }
        PlayerData playerData = this.allocPlayerData();
        try {
            playerData.set(isoPlayer);
            this.m_toThread.add(playerData);
        }
        catch (Exception exception) {
            this.releasePlayerData(playerData);
            throw exception;
        }
    }

    private void savePlayersAsync() {
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            try {
                this.savePlayerAsync(isoPlayer);
                continue;
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
    }

    public void savePlayers() {
        if (!this.m_canSavePlayers) {
            return;
        }
        this.m_forceSavePlayers = true;
    }

    public void saveLocalPlayersForce() {
        this.savePlayersAsync();
        if (WorldStreamer.instance.worldStreamer == null) {
            this.updateWorldStreamer();
        }
    }

    public void importPlayersFromVehiclesDB() {
        VehiclesDB2.instance.importPlayersFromOldDB((n, string, n2, n3, f, f2, f3, n4, byArray, bl) -> {
            PlayerData playerData = this.allocPlayerData();
            playerData.m_sqlID = this.allocateID();
            playerData.m_x = f;
            playerData.m_y = f2;
            playerData.m_z = f3;
            playerData.m_isDead = bl;
            playerData.m_name = string;
            playerData.m_WorldVersion = n4;
            playerData.setBytes(byArray);
            try {
                this.m_store.save(playerData);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
            this.releasePlayerData(playerData);
        });
    }

    public void uploadLocalPlayers2DB() {
        this.savePlayersAsync();
        String string = ZomboidFileSystem.instance.getCurrentSaveDir();
        for (int i = 1; i < 100; ++i) {
            File file = new File(string + File.separator + "map_p" + i + ".bin");
            if (!file.exists()) continue;
            try {
                IsoPlayer isoPlayer = new IsoPlayer(IsoWorld.instance.CurrentCell);
                isoPlayer.load(file.getAbsolutePath());
                this.savePlayerAsync(isoPlayer);
                file.delete();
                continue;
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        if (WorldStreamer.instance.worldStreamer == null) {
            this.updateWorldStreamer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadPlayer(int n, IsoPlayer isoPlayer) {
        PlayerData playerData = this.allocPlayerData();
        try {
            playerData.m_sqlID = n;
            if (!this.m_store.load(playerData)) {
                boolean bl = false;
                return bl;
            }
            isoPlayer.load(playerData.m_byteBuffer, playerData.m_WorldVersion);
            if (playerData.m_isDead) {
                isoPlayer.getBodyDamage().setOverallBodyHealth(0.0f);
                isoPlayer.setHealth(0.0f);
            }
            isoPlayer.sqlID = n;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        finally {
            this.releasePlayerData(playerData);
        }
        return false;
    }

    public boolean loadLocalPlayer(int n) {
        try {
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            if (isoPlayer == null) {
                isoPlayer = new IsoPlayer(IsoCell.getInstance());
                IsoPlayer.setInstance(isoPlayer);
                IsoPlayer.players[0] = isoPlayer;
            }
            if (this.loadPlayer(n, isoPlayer)) {
                int n2 = (int)(isoPlayer.x / 10.0f);
                int n3 = (int)(isoPlayer.y / 10.0f);
                IsoCell.getInstance().ChunkMap[IsoPlayer.getPlayerIndex()].WorldX = n2 + IsoWorld.saveoffsetx * 30;
                IsoCell.getInstance().ChunkMap[IsoPlayer.getPlayerIndex()].WorldY = n3 + IsoWorld.saveoffsety * 30;
                return true;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return false;
    }

    public ArrayList<IsoPlayer> getAllLocalPlayers() {
        ArrayList<IsoPlayer> arrayList = new ArrayList<IsoPlayer>();
        this.m_usedIDs.forEach(n -> {
            if (n <= 1) {
                return true;
            }
            IsoPlayer isoPlayer = new IsoPlayer(IsoWorld.instance.CurrentCell);
            if (this.loadPlayer(n, isoPlayer)) {
                arrayList.add(isoPlayer);
            }
            return true;
        });
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadLocalPlayerInfo(int n) {
        PlayerData playerData = this.allocPlayerData();
        try {
            playerData.m_sqlID = n;
            if (this.m_store.loadEverythingExceptBytes(playerData)) {
                IsoChunkMap.WorldXA = (int)playerData.m_x;
                IsoChunkMap.WorldYA = (int)playerData.m_y;
                IsoChunkMap.WorldZA = (int)playerData.m_z;
                IsoChunkMap.WorldXA += 300 * IsoWorld.saveoffsetx;
                IsoChunkMap.WorldYA += 300 * IsoWorld.saveoffsety;
                IsoChunkMap.SWorldX[0] = (int)(playerData.m_x / 10.0f);
                IsoChunkMap.SWorldY[0] = (int)(playerData.m_y / 10.0f);
                IsoChunkMap.SWorldX[0] = IsoChunkMap.SWorldX[0] + 30 * IsoWorld.saveoffsetx;
                IsoChunkMap.SWorldY[0] = IsoChunkMap.SWorldY[0] + 30 * IsoWorld.saveoffsety;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        finally {
            this.releasePlayerData(playerData);
        }
        return false;
    }

    private static final class SQLPlayerStore
    implements IPlayerStore {
        Connection m_conn = null;

        private SQLPlayerStore() {
        }

        @Override
        public void init(TIntHashSet tIntHashSet) throws Exception {
            tIntHashSet.clear();
            if (Core.getInstance().isNoSave()) {
                return;
            }
            this.m_conn = PlayerDBHelper.create();
            this.initUsedIDs(tIntHashSet);
        }

        @Override
        public void Reset() {
            if (this.m_conn == null) {
                return;
            }
            try {
                this.m_conn.close();
            }
            catch (SQLException sQLException) {
                ExceptionLogger.logException(sQLException);
            }
            this.m_conn = null;
        }

        @Override
        public void save(PlayerData playerData) throws Exception {
            assert (playerData.m_sqlID >= 1);
            if (this.m_conn == null) {
                return;
            }
            if (this.isInDB(playerData.m_sqlID)) {
                this.update(playerData);
            } else {
                this.add(playerData);
            }
        }

        @Override
        public boolean load(PlayerData playerData) throws Exception {
            assert (playerData.m_sqlID >= 1);
            if (this.m_conn == null) {
                return false;
            }
            String string = "SELECT data,worldversion,x,y,z,isDead,name FROM localPlayers WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, playerData.m_sqlID);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    InputStream inputStream = resultSet.getBinaryStream(1);
                    playerData.setBytes(inputStream);
                    playerData.m_WorldVersion = resultSet.getInt(2);
                    playerData.m_x = resultSet.getInt(3);
                    playerData.m_y = resultSet.getInt(4);
                    playerData.m_z = resultSet.getInt(5);
                    playerData.m_isDead = resultSet.getBoolean(6);
                    playerData.m_name = resultSet.getString(7);
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        @Override
        public boolean loadEverythingExceptBytes(PlayerData playerData) throws Exception {
            if (this.m_conn == null) {
                return false;
            }
            String string = "SELECT worldversion,x,y,z,isDead,name FROM localPlayers WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, playerData.m_sqlID);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    playerData.m_WorldVersion = resultSet.getInt(1);
                    playerData.m_x = resultSet.getInt(2);
                    playerData.m_y = resultSet.getInt(3);
                    playerData.m_z = resultSet.getInt(4);
                    playerData.m_isDead = resultSet.getBoolean(5);
                    playerData.m_name = resultSet.getString(6);
                    boolean bl = true;
                    return bl;
                }
            }
            return false;
        }

        void initUsedIDs(TIntHashSet tIntHashSet) throws SQLException {
            String string = "SELECT id FROM localPlayers";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    tIntHashSet.add(resultSet.getInt(1));
                }
            }
        }

        boolean isInDB(int n) throws SQLException {
            String string = "SELECT 1 FROM localPlayers WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, n);
                ResultSet resultSet = preparedStatement.executeQuery();
                boolean bl = resultSet.next();
                return bl;
            }
        }

        void add(PlayerData playerData) throws Exception {
            if (this.m_conn == null || playerData.m_sqlID < 1) {
                return;
            }
            String string = "INSERT INTO localPlayers(wx,wy,x,y,z,worldversion,data,isDead,name,id) VALUES(?,?,?,?,?,?,?,?,?,?)";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, (int)(playerData.m_x / 10.0f));
                preparedStatement.setInt(2, (int)(playerData.m_y / 10.0f));
                preparedStatement.setFloat(3, playerData.m_x);
                preparedStatement.setFloat(4, playerData.m_y);
                preparedStatement.setFloat(5, playerData.m_z);
                preparedStatement.setInt(6, playerData.m_WorldVersion);
                ByteBuffer byteBuffer = playerData.m_byteBuffer;
                byteBuffer.rewind();
                preparedStatement.setBinaryStream(7, (InputStream)new ByteBufferBackedInputStream(byteBuffer), byteBuffer.remaining());
                preparedStatement.setBoolean(8, playerData.m_isDead);
                preparedStatement.setString(9, playerData.m_name);
                preparedStatement.setInt(10, playerData.m_sqlID);
                int n = preparedStatement.executeUpdate();
                this.m_conn.commit();
            }
            catch (Exception exception) {
                PlayerDBHelper.rollback(this.m_conn);
                throw exception;
            }
        }

        public void update(PlayerData playerData) throws Exception {
            if (this.m_conn == null || playerData.m_sqlID < 1) {
                return;
            }
            String string = "UPDATE localPlayers SET wx = ?, wy = ?, x = ?, y = ?, z = ?, worldversion = ?, data = ?, isDead = ?, name = ? WHERE id=?";
            try (PreparedStatement preparedStatement = this.m_conn.prepareStatement(string);){
                preparedStatement.setInt(1, (int)(playerData.m_x / 10.0f));
                preparedStatement.setInt(2, (int)(playerData.m_y / 10.0f));
                preparedStatement.setFloat(3, playerData.m_x);
                preparedStatement.setFloat(4, playerData.m_y);
                preparedStatement.setFloat(5, playerData.m_z);
                preparedStatement.setInt(6, playerData.m_WorldVersion);
                ByteBuffer byteBuffer = playerData.m_byteBuffer;
                byteBuffer.rewind();
                preparedStatement.setBinaryStream(7, (InputStream)new ByteBufferBackedInputStream(byteBuffer), byteBuffer.remaining());
                preparedStatement.setBoolean(8, playerData.m_isDead);
                preparedStatement.setString(9, playerData.m_name);
                preparedStatement.setInt(10, playerData.m_sqlID);
                int n = preparedStatement.executeUpdate();
                this.m_conn.commit();
            }
            catch (Exception exception) {
                PlayerDBHelper.rollback(this.m_conn);
                throw exception;
            }
        }
    }

    private static interface IPlayerStore {
        public void init(TIntHashSet var1) throws Exception;

        public void Reset() throws Exception;

        public void save(PlayerData var1) throws Exception;

        public boolean load(PlayerData var1) throws Exception;

        public boolean loadEverythingExceptBytes(PlayerData var1) throws Exception;
    }

    private static final class PlayerData {
        int m_sqlID = -1;
        float m_x;
        float m_y;
        float m_z;
        boolean m_isDead;
        String m_name;
        int m_WorldVersion;
        ByteBuffer m_byteBuffer = ByteBuffer.allocate(32768);

        private PlayerData() {
        }

        PlayerData set(IsoPlayer isoPlayer) throws IOException {
            assert (isoPlayer.sqlID >= 1);
            this.m_sqlID = isoPlayer.sqlID;
            this.m_x = isoPlayer.getX();
            this.m_y = isoPlayer.getY();
            this.m_z = isoPlayer.getZ();
            this.m_isDead = isoPlayer.isDead();
            this.m_name = isoPlayer.getDescriptor().getForename() + " " + isoPlayer.getDescriptor().getSurname();
            this.m_WorldVersion = IsoWorld.getWorldVersion();
            ByteBuffer byteBuffer = TL_SliceBuffer.get();
            byteBuffer.clear();
            while (true) {
                try {
                    isoPlayer.save(byteBuffer);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    if (byteBuffer.capacity() >= 0x200000) {
                        DebugLog.General.error("the player %s cannot be saved", isoPlayer.getUsername());
                        throw bufferOverflowException;
                    }
                    byteBuffer = ByteBuffer.allocate(byteBuffer.capacity() + 32768);
                    TL_SliceBuffer.set(byteBuffer);
                    continue;
                }
                break;
            }
            byteBuffer.flip();
            this.setBytes(byteBuffer);
            return this;
        }

        void setBytes(ByteBuffer byteBuffer) {
            int n;
            byteBuffer.rewind();
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_byteBuffer, true);
            byteBufferOutputStream.clear();
            byte[] byArray = TL_Bytes.get();
            for (int i = byteBuffer.limit(); i > 0; i -= n) {
                n = Math.min(byArray.length, i);
                byteBuffer.get(byArray, 0, n);
                byteBufferOutputStream.write(byArray, 0, n);
            }
            byteBufferOutputStream.flip();
            this.m_byteBuffer = byteBufferOutputStream.getWrappedBuffer();
        }

        void setBytes(byte[] byArray) {
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_byteBuffer, true);
            byteBufferOutputStream.clear();
            byteBufferOutputStream.write(byArray);
            byteBufferOutputStream.flip();
            this.m_byteBuffer = byteBufferOutputStream.getWrappedBuffer();
        }

        void setBytes(InputStream inputStream) throws IOException {
            int n;
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(this.m_byteBuffer, true);
            byteBufferOutputStream.clear();
            byte[] byArray = TL_Bytes.get();
            while ((n = inputStream.read(byArray)) >= 1) {
                byteBufferOutputStream.write(byArray, 0, n);
            }
            byteBufferOutputStream.flip();
            this.m_byteBuffer = byteBufferOutputStream.getWrappedBuffer();
        }
    }
}

