/*
 * Decompiled with CFR 0.152.
 */
package zombie.savefile;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.logger.ExceptionLogger;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.utils.UpdateLimit;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;
import zombie.network.GameClient;
import zombie.network.PacketTypes;

public final class ClientPlayerDB {
    private static ClientPlayerDB instance = null;
    private static boolean allow = false;
    private NetworkCharacterProfile networkProfile = null;
    private UpdateLimit saveToDBPeriod4Network = new UpdateLimit(30000L);
    private static ByteBuffer SliceBuffer4NetworkPlayer = ByteBuffer.allocate(65536);
    private boolean forceSavePlayers;
    public boolean canSavePlayers = false;

    public static void setAllow(boolean bl) {
        allow = bl;
    }

    public static boolean isAllow() {
        return allow;
    }

    public static synchronized ClientPlayerDB getInstance() {
        if (instance == null && allow) {
            instance = new ClientPlayerDB();
        }
        return instance;
    }

    public static boolean isAvailable() {
        return instance != null;
    }

    public void updateMain() {
        this.saveNetworkPlayersToDB();
    }

    public void close() {
        instance = null;
        allow = false;
    }

    private void saveNetworkPlayersToDB() {
        if (this.canSavePlayers && (this.forceSavePlayers || this.saveToDBPeriod4Network.Check())) {
            this.forceSavePlayers = false;
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                IsoPlayer isoPlayer = IsoPlayer.players[i];
                if (isoPlayer == null) continue;
                this.clientSendNetworkPlayerInt(isoPlayer);
            }
        }
    }

    public ArrayList<IsoPlayer> getAllNetworkPlayers() {
        ArrayList<IsoPlayer> arrayList = new ArrayList<IsoPlayer>();
        for (int i = 1; i < this.networkProfile.playerCount; ++i) {
            byte[] byArray = this.getClientLoadNetworkPlayerData(i + 1);
            if (byArray == null) continue;
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            byteBuffer.rewind();
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            try {
                IsoPlayer isoPlayer = new IsoPlayer(IsoWorld.instance.CurrentCell);
                isoPlayer.serverPlayerIndex = i + 1;
                isoPlayer.load(byteBuffer, this.networkProfile.worldVersion[i]);
                if (this.networkProfile.isDead[i]) {
                    isoPlayer.getBodyDamage().setOverallBodyHealth(0.0f);
                    isoPlayer.setHealth(0.0f);
                }
                arrayList.add(isoPlayer);
                continue;
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        return arrayList;
    }

    public void clientLoadNetworkCharacter(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        boolean bl = byteBuffer.get() == 1;
        int n = byteBuffer.getInt();
        if (bl) {
            float f = byteBuffer.getFloat();
            float f2 = byteBuffer.getFloat();
            float f3 = byteBuffer.getFloat();
            int n2 = byteBuffer.getInt();
            boolean bl2 = byteBuffer.get() == 1;
            int n3 = byteBuffer.getInt();
            byte[] byArray = new byte[n3];
            byteBuffer.get(byArray);
            if (this.networkProfile != null) {
                ++this.networkProfile.playerCount;
                switch (this.networkProfile.playerCount) {
                    case 2: {
                        this.networkProfile.worldVersion[1] = n2;
                        this.networkProfile.character[1] = byArray;
                        this.networkProfile.x[1] = f;
                        this.networkProfile.y[1] = f2;
                        this.networkProfile.z[1] = f3;
                        this.networkProfile.isDead[1] = bl2;
                        break;
                    }
                    case 3: {
                        this.networkProfile.worldVersion[2] = n2;
                        this.networkProfile.character[2] = byArray;
                        this.networkProfile.x[2] = f;
                        this.networkProfile.y[2] = f2;
                        this.networkProfile.z[2] = f3;
                        this.networkProfile.isDead[2] = bl2;
                        break;
                    }
                    case 4: {
                        this.networkProfile.worldVersion[3] = n2;
                        this.networkProfile.character[3] = byArray;
                        this.networkProfile.x[3] = f;
                        this.networkProfile.y[3] = f2;
                        this.networkProfile.z[3] = f3;
                        this.networkProfile.isDead[3] = bl2;
                    }
                }
            } else {
                this.networkProfile = new NetworkCharacterProfile();
                this.networkProfile.playerCount = 1;
                this.networkProfile.username = GameClient.username;
                this.networkProfile.server = GameClient.ip;
                this.networkProfile.character[0] = byArray;
                this.networkProfile.worldVersion[0] = n2;
                this.networkProfile.x[0] = f;
                this.networkProfile.y[0] = f2;
                this.networkProfile.z[0] = f3;
                this.networkProfile.isDead[0] = bl2;
            }
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.LoadPlayerProfile.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)(n + 1));
            PacketTypes.PacketType.LoadPlayerProfile.send(GameClient.connection);
        } else if (this.networkProfile != null) {
            this.networkProfile.isLoaded = true;
        } else {
            this.networkProfile = new NetworkCharacterProfile();
            this.networkProfile.isLoaded = true;
            this.networkProfile.playerCount = 0;
            this.networkProfile.username = GameClient.username;
            this.networkProfile.server = GameClient.ip;
            this.networkProfile.character[0] = null;
            this.networkProfile.worldVersion[0] = IsoWorld.getWorldVersion();
        }
    }

    private boolean isClientLoadNetworkCharacterCompleted() {
        return this.networkProfile != null && this.networkProfile.isLoaded;
    }

    public void clientSendNetworkPlayerInt(IsoPlayer isoPlayer) {
        if (GameClient.connection == null) {
            return;
        }
        try {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SendPlayerProfile.doPacket(byteBufferWriter);
            byteBufferWriter.putByte((byte)(isoPlayer.serverPlayerIndex - 1));
            String string = isoPlayer.getDescriptor().getForename() + " " + isoPlayer.getDescriptor().getSurname();
            byteBufferWriter.putUTF(string);
            byteBufferWriter.putFloat(isoPlayer.x);
            byteBufferWriter.putFloat(isoPlayer.y);
            byteBufferWriter.putFloat(isoPlayer.z);
            byteBufferWriter.putByte((byte)(isoPlayer.isDead() ? 1 : 0));
            SliceBuffer4NetworkPlayer.rewind();
            isoPlayer.save(SliceBuffer4NetworkPlayer);
            byte[] byArray = new byte[SliceBuffer4NetworkPlayer.position()];
            SliceBuffer4NetworkPlayer.rewind();
            SliceBuffer4NetworkPlayer.get(byArray);
            byteBufferWriter.putInt(IsoWorld.getWorldVersion());
            byteBufferWriter.putInt(SliceBuffer4NetworkPlayer.position());
            byteBufferWriter.bb.put(byArray);
            PacketTypes.PacketType.SendPlayerProfile.send(GameClient.connection);
        }
        catch (IOException iOException) {
            GameClient.connection.cancelPacket();
            ExceptionLogger.logException(iOException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            GameClient.connection.cancelPacket();
            int n = SliceBuffer4NetworkPlayer.capacity();
            if (n > 0x200000) {
                DebugLog.log("FATAL ERROR: The player " + isoPlayer.getUsername() + " cannot be saved");
                ExceptionLogger.logException(bufferOverflowException);
                return;
            }
            SliceBuffer4NetworkPlayer = ByteBuffer.allocate(n * 2);
            this.clientSendNetworkPlayerInt(isoPlayer);
        }
    }

    public boolean isAliveMainNetworkPlayer() {
        return !this.networkProfile.isDead[0];
    }

    public boolean clientLoadNetworkPlayer() {
        if (this.networkProfile != null && this.networkProfile.isLoaded && this.networkProfile.username.equals(GameClient.username) && this.networkProfile.server.equals(GameClient.ip)) {
            return this.networkProfile.playerCount > 0;
        }
        if (GameClient.connection == null) {
            return false;
        }
        if (this.networkProfile != null) {
            this.networkProfile = null;
        }
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.LoadPlayerProfile.doPacket(byteBufferWriter);
        byteBufferWriter.putByte((byte)0);
        PacketTypes.PacketType.LoadPlayerProfile.send(GameClient.connection);
        int n = 200;
        while (n-- > 0) {
            if (this.isClientLoadNetworkCharacterCompleted()) {
                return this.networkProfile.playerCount > 0;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                ExceptionLogger.logException(interruptedException);
            }
        }
        return false;
    }

    public byte[] getClientLoadNetworkPlayerData(int n) {
        if (this.networkProfile != null && this.networkProfile.isLoaded && this.networkProfile.username.equals(GameClient.username) && this.networkProfile.server.equals(GameClient.ip)) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return this.networkProfile.character[n - 1];
                }
            }
            return null;
        }
        if (!this.clientLoadNetworkPlayer()) {
            return null;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.networkProfile.character[n - 1];
            }
        }
        return null;
    }

    public boolean loadNetworkPlayer() {
        try {
            byte[] byArray = this.getClientLoadNetworkPlayerData(1);
            if (byArray != null) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
                byteBuffer.rewind();
                byteBuffer.put(byArray);
                byteBuffer.rewind();
                if (IsoPlayer.getInstance() == null) {
                    IsoPlayer.setInstance(new IsoPlayer(IsoCell.getInstance()));
                    IsoPlayer.players[0] = IsoPlayer.getInstance();
                }
                IsoPlayer.getInstance().serverPlayerIndex = 1;
                IsoPlayer.getInstance().load(byteBuffer, this.networkProfile.worldVersion[0]);
                return true;
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
        return false;
    }

    public boolean loadNetworkPlayerInfo(int n) {
        if (this.networkProfile != null && this.networkProfile.isLoaded && this.networkProfile.username.equals(GameClient.username) && this.networkProfile.server.equals(GameClient.ip) && n >= 1 && n <= 4 && n <= this.networkProfile.playerCount) {
            int n2 = (int)(this.networkProfile.x[n - 1] / 10.0f) + IsoWorld.saveoffsetx * 30;
            int n3 = (int)(this.networkProfile.y[n - 1] / 10.0f) + IsoWorld.saveoffsety * 30;
            IsoChunkMap.WorldXA = (int)this.networkProfile.x[n - 1];
            IsoChunkMap.WorldYA = (int)this.networkProfile.y[n - 1];
            IsoChunkMap.WorldZA = (int)this.networkProfile.z[n - 1];
            IsoChunkMap.WorldXA += 300 * IsoWorld.saveoffsetx;
            IsoChunkMap.WorldYA += 300 * IsoWorld.saveoffsety;
            IsoChunkMap.SWorldX[0] = n2;
            IsoChunkMap.SWorldY[0] = n3;
            IsoChunkMap.SWorldX[0] = IsoChunkMap.SWorldX[0] + 30 * IsoWorld.saveoffsetx;
            IsoChunkMap.SWorldY[0] = IsoChunkMap.SWorldY[0] + 30 * IsoWorld.saveoffsety;
            return true;
        }
        return false;
    }

    public void forgetPlayer(int n) {
        if (this.networkProfile != null && n >= 1 && n <= 4) {
            this.networkProfile.character[n - 1] = null;
            this.networkProfile.isDead[n - 1] = true;
        }
    }

    public int getNextServerPlayerIndex() {
        if (this.networkProfile != null && this.networkProfile.isLoaded && this.networkProfile.username.equals(GameClient.username) && this.networkProfile.server.equals(GameClient.ip)) {
            for (int i = 1; i < 4; ++i) {
                if (this.networkProfile.character[i] != null && !this.networkProfile.isDead[i]) continue;
                return i + 1;
            }
        }
        return 2;
    }

    private final class NetworkCharacterProfile {
        boolean isLoaded = false;
        final byte[][] character = new byte[4][];
        String username;
        String server;
        int playerCount = 0;
        final int[] worldVersion = new int[4];
        final float[] x = new float[4];
        final float[] y = new float[4];
        final float[] z = new float[4];
        final boolean[] isDead = new boolean[4];
    }
}

