/*
 * Decompiled with CFR 0.152.
 */
package zombie.sandbox;

import zombie.core.math.PZMath;
import zombie.scripting.ScriptParser;
import zombie.util.StringUtils;

public class CustomSandboxOption {
    public final String m_id;
    public String m_page;
    public String m_translation;

    CustomSandboxOption(String string) {
        this.m_id = string;
    }

    static double getValueDouble(ScriptParser.Block block, String string, double d) {
        ScriptParser.Value value = block.getValue(string);
        if (value == null) {
            return d;
        }
        return PZMath.tryParseDouble(value.getValue().trim(), d);
    }

    static float getValueFloat(ScriptParser.Block block, String string, float f) {
        ScriptParser.Value value = block.getValue(string);
        if (value == null) {
            return f;
        }
        return PZMath.tryParseFloat(value.getValue().trim(), f);
    }

    static int getValueInt(ScriptParser.Block block, String string, int n) {
        ScriptParser.Value value = block.getValue(string);
        if (value == null) {
            return n;
        }
        return PZMath.tryParseInt(value.getValue().trim(), n);
    }

    boolean parseCommon(ScriptParser.Block block) {
        ScriptParser.Value value;
        ScriptParser.Value value2 = block.getValue("page");
        if (value2 != null) {
            this.m_page = StringUtils.discardNullOrWhitespace(value2.getValue().trim());
        }
        if ((value = block.getValue("translation")) != null) {
            this.m_translation = StringUtils.discardNullOrWhitespace(value.getValue().trim());
        }
        return true;
    }
}

