/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedZoneStory;

import java.util.ArrayList;
import zombie.core.Rand;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.InventoryContainer;
import zombie.iso.IsoMetaGrid;
import zombie.randomizedWorld.randomizedZoneStory.RandomizedZoneStoryBase;

public class RZSForestCamp
extends RandomizedZoneStoryBase {
    public RZSForestCamp() {
        this.name = "Basic Forest Camp";
        this.chance = 10;
        this.minZoneHeight = 6;
        this.minZoneWidth = 6;
        this.zoneType.add(RandomizedZoneStoryBase.ZoneType.Forest.toString());
    }

    public static ArrayList<String> getForestClutter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Base.Crisps");
        arrayList.add("Base.Crisps2");
        arrayList.add("Base.Crisps3");
        arrayList.add("Base.Crisps4");
        arrayList.add("Base.Pop");
        arrayList.add("Base.Pop2");
        arrayList.add("Base.WaterBottleFull");
        arrayList.add("Base.CannedSardines");
        arrayList.add("Base.CannedChili");
        arrayList.add("Base.CannedBolognese");
        arrayList.add("Base.CannedCornedBeef");
        arrayList.add("Base.TinnedSoup");
        arrayList.add("Base.TinnedBeans");
        arrayList.add("Base.TunaTin");
        arrayList.add("Base.WhiskeyFull");
        arrayList.add("Base.BeerBottle");
        arrayList.add("Base.BeerCan");
        arrayList.add("Base.BeerCan");
        return arrayList;
    }

    public static ArrayList<String> getCoolerClutter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Base.Pop");
        arrayList.add("Base.Pop2");
        arrayList.add("Base.BeefJerky");
        arrayList.add("Base.Ham");
        arrayList.add("Base.WaterBottleFull");
        arrayList.add("Base.BeerCan");
        arrayList.add("Base.BeerCan");
        arrayList.add("Base.BeerCan");
        arrayList.add("Base.BeerCan");
        return arrayList;
    }

    public static ArrayList<String> getFireClutter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Base.WaterPotRice");
        arrayList.add("Base.WaterPot");
        arrayList.add("Base.Pot");
        arrayList.add("Base.WaterSaucepanRice");
        arrayList.add("Base.WaterSaucepanPasta");
        arrayList.add("Base.PotOfStew");
        return arrayList;
    }

    @Override
    public void randomizeZoneStory(IsoMetaGrid.Zone zone) {
        int n;
        int n2 = zone.pickedXForZoneStory;
        int n3 = zone.pickedYForZoneStory;
        ArrayList<String> arrayList = RZSForestCamp.getForestClutter();
        ArrayList<String> arrayList2 = RZSForestCamp.getCoolerClutter();
        ArrayList<String> arrayList3 = RZSForestCamp.getFireClutter();
        this.cleanAreaForStory(this, zone);
        this.addTileObject(n2, n3, zone.z, "camping_01_6");
        this.addItemOnGround(this.getSq(n2, n3, zone.z), arrayList3.get(Rand.Next(arrayList3.size())));
        int n4 = Rand.Next(-1, 2);
        int n5 = Rand.Next(-1, 2);
        this.addTentWestEast(n2 + n4 - 2, n3 + n5, zone.z);
        if (Rand.Next(100) < 70) {
            this.addTentNorthSouth(n2 + n4, n3 + n5 - 2, zone.z);
        }
        if (Rand.Next(100) < 30) {
            this.addTentNorthSouth(n2 + n4 + 1, n3 + n5 - 2, zone.z);
        }
        this.addTileObject(n2 + 2, n3, zone.z, "furniture_seating_outdoor_01_19");
        InventoryContainer inventoryContainer = (InventoryContainer)InventoryItemFactory.CreateItem("Base.Cooler");
        int n6 = Rand.Next(2, 5);
        for (n = 0; n < n6; ++n) {
            inventoryContainer.getItemContainer().AddItem(arrayList2.get(Rand.Next(arrayList2.size())));
        }
        this.addItemOnGround(this.getRandomFreeSquare(this, zone), inventoryContainer);
        n6 = Rand.Next(3, 7);
        for (n = 0; n < n6; ++n) {
            this.addItemOnGround(this.getRandomFreeSquare(this, zone), arrayList.get(Rand.Next(arrayList.size())));
        }
        this.addZombiesOnSquare(Rand.Next(1, 3), "Camper", null, this.getRandomFreeSquare(this, zone));
    }
}

