/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.HashMap;
import java.util.Iterator;
import org.joml.Vector2f;
import zombie.SandboxOptions;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.randomizedWorld.RandomizedWorldBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawnData;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public class RandomizedVehicleStoryBase
extends RandomizedWorldBase {
    private int chance = 0;
    private static int totalChance = 0;
    private static HashMap<RandomizedVehicleStoryBase, Integer> rvsMap = new HashMap();
    protected boolean horizontalZone = false;
    protected int zoneWidth = 0;
    public static final float baseChance = 12.5f;
    protected int minX = 0;
    protected int minY = 0;
    protected int maxX = 0;
    protected int maxY = 0;
    protected int minZoneWidth = 0;
    protected int minZoneHeight = 0;

    public static void initAllRVSMapChance(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        totalChance = 0;
        rvsMap.clear();
        for (int i = 0; i < IsoWorld.instance.getRandomizedVehicleStoryList().size(); ++i) {
            RandomizedVehicleStoryBase randomizedVehicleStoryBase = IsoWorld.instance.getRandomizedVehicleStoryList().get(i);
            if (!randomizedVehicleStoryBase.isValid(zone, isoChunk, false) || !randomizedVehicleStoryBase.isTimeValid(false)) continue;
            totalChance += randomizedVehicleStoryBase.getChance();
            rvsMap.put(randomizedVehicleStoryBase, randomizedVehicleStoryBase.getChance());
        }
    }

    public static boolean doRandomStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        float f = Rand.Next(0.0f, 500.0f);
        switch (SandboxOptions.instance.VehicleStoryChance.getValue()) {
            case 1: {
                return false;
            }
            case 2: {
                f = Rand.Next(0.0f, 1000.0f);
                break;
            }
            case 4: {
                f = Rand.Next(0.0f, 300.0f);
                break;
            }
            case 5: {
                f = Rand.Next(0.0f, 175.0f);
                break;
            }
            case 6: {
                f = Rand.Next(0.0f, 50.0f);
            }
        }
        if (f < 12.5f) {
            if (!isoChunk.vehicles.isEmpty()) {
                return false;
            }
            RandomizedVehicleStoryBase randomizedVehicleStoryBase = null;
            RandomizedVehicleStoryBase.initAllRVSMapChance(zone, isoChunk);
            randomizedVehicleStoryBase = RandomizedVehicleStoryBase.getRandomStory();
            if (randomizedVehicleStoryBase == null) {
                return false;
            }
            VehicleStorySpawnData vehicleStorySpawnData = randomizedVehicleStoryBase.initSpawnDataForChunk(zone, isoChunk);
            isoChunk.setRandomVehicleStoryToSpawnLater(vehicleStorySpawnData);
            return true;
        }
        return false;
    }

    private static RandomizedVehicleStoryBase getRandomStory() {
        int n = Rand.Next(totalChance);
        Iterator<RandomizedVehicleStoryBase> iterator = rvsMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            RandomizedVehicleStoryBase randomizedVehicleStoryBase = iterator.next();
            if (n >= (n2 += rvsMap.get(randomizedVehicleStoryBase).intValue())) continue;
            return randomizedVehicleStoryBase;
        }
        return null;
    }

    public int getMinZoneWidth() {
        return this.minZoneWidth <= 0 ? 10 : this.minZoneWidth;
    }

    public int getMinZoneHeight() {
        return this.minZoneHeight <= 0 ? 5 : this.minZoneHeight;
    }

    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
    }

    public IsoGridSquare getCenterOfChunk(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        int n = Math.max(zone.x, isoChunk.wx * 10);
        int n2 = Math.max(zone.y, isoChunk.wy * 10);
        int n3 = Math.min(zone.x + zone.w, (isoChunk.wx + 1) * 10);
        int n4 = Math.min(zone.y + zone.h, (isoChunk.wy + 1) * 10);
        int n5 = 0;
        int n6 = 0;
        if (this.horizontalZone) {
            n6 = (zone.y + (zone.y + zone.h)) / 2;
            n5 = (n + n3) / 2;
        } else {
            n6 = (n2 + n4) / 2;
            n5 = (zone.x + (zone.x + zone.w)) / 2;
        }
        return IsoCell.getInstance().getGridSquare(n5, n6, zone.z);
    }

    public boolean isValid(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        this.horizontalZone = false;
        this.zoneWidth = 0;
        this.debugLine = "";
        if (!bl && zone.hourLastSeen != 0) {
            return false;
        }
        if (!bl && zone.haveConstruction) {
            return false;
        }
        if (!"Nav".equals(zone.getType())) {
            this.debugLine = this.debugLine + "Not a 'Nav' zone.";
            return false;
        }
        this.minX = Math.max(zone.x, isoChunk.wx * 10);
        this.minY = Math.max(zone.y, isoChunk.wy * 10);
        this.maxX = Math.min(zone.x + zone.w, (isoChunk.wx + 1) * 10);
        this.maxY = Math.min(zone.y + zone.h, (isoChunk.wy + 1) * 10);
        return this.getSpawnPoint(zone, isoChunk, null);
    }

    public VehicleStorySpawnData initSpawnDataForChunk(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        int n = this.getMinZoneWidth();
        int n2 = this.getMinZoneHeight();
        float[] fArray = new float[3];
        if (!this.getSpawnPoint(zone, isoChunk, fArray)) {
            return null;
        }
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = fArray[2];
        int[] nArray = new int[4];
        VehicleStorySpawner.getInstance().getAABB(f, f2, n, n2, f3, nArray);
        return new VehicleStorySpawnData(this, zone, f, f2, f3, nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public boolean getSpawnPoint(IsoMetaGrid.Zone zone, IsoChunk isoChunk, float[] fArray) {
        return this.getRectangleSpawnPoint(zone, isoChunk, fArray) || this.getPolylineSpawnPoint(zone, isoChunk, fArray);
    }

    public boolean getRectangleSpawnPoint(IsoMetaGrid.Zone zone, IsoChunk isoChunk, float[] fArray) {
        if (!zone.isRectangle()) {
            return false;
        }
        int n = this.getMinZoneWidth();
        int n2 = this.getMinZoneHeight();
        if (zone.w > 30 && zone.h < 15) {
            this.horizontalZone = true;
            this.zoneWidth = zone.h;
            if (zone.getWidth() < n2) {
                this.debugLine = "Horizontal street is too small, w:" + zone.getWidth() + " h:" + zone.getHeight();
                return false;
            }
            if (zone.getHeight() < n) {
                this.debugLine = "Horizontal street is too small, w:" + zone.getWidth() + " h:" + zone.getHeight();
                return false;
            }
            if (fArray == null) {
                return true;
            }
            float f = zone.getX();
            float f2 = zone.getX() + zone.getWidth();
            float f3 = (float)zone.getY() + (float)zone.getHeight() / 2.0f;
            fArray[0] = PZMath.clamp((float)(isoChunk.wx * 10) + 5.0f, f + (float)n2 / 2.0f, f2 - (float)n2 / 2.0f);
            fArray[1] = f3;
            fArray[2] = Vector2.getDirection(f2 - f, 0.0f);
            return true;
        }
        if (zone.h > 30 && zone.w < 15) {
            float f;
            this.horizontalZone = false;
            this.zoneWidth = zone.w;
            if (zone.getWidth() < n) {
                this.debugLine = "Vertical street is too small, w:" + zone.getWidth() + " h:" + zone.getHeight();
                return false;
            }
            if (zone.getHeight() < n2) {
                this.debugLine = "Vertical street is too small, w:" + zone.getWidth() + " h:" + zone.getHeight();
                return false;
            }
            if (fArray == null) {
                return true;
            }
            float f4 = zone.getY();
            float f5 = zone.getY() + zone.getHeight();
            fArray[0] = f = (float)zone.getX() + (float)zone.getWidth() / 2.0f;
            fArray[1] = PZMath.clamp((float)(isoChunk.wy * 10) + 5.0f, f4 + (float)n2 / 2.0f, f5 - (float)n2 / 2.0f);
            fArray[2] = Vector2.getDirection(0.0f, f4 - f5);
            return true;
        }
        this.debugLine = "Zone too small or too large";
        return false;
    }

    public boolean getPolylineSpawnPoint(IsoMetaGrid.Zone zone, IsoChunk isoChunk, float[] fArray) {
        float f;
        float f2;
        if (!zone.isPolyline() || zone.polylineWidth <= 0) {
            return false;
        }
        int n = this.getMinZoneWidth();
        int n2 = this.getMinZoneHeight();
        if (zone.polylineWidth < n) {
            this.debugLine = "Polyline zone is too narrow, width:" + zone.polylineWidth;
            return false;
        }
        double[] dArray = new double[2];
        int n3 = zone.getClippedSegmentOfPolyline(isoChunk.wx * 10, isoChunk.wy * 10, (isoChunk.wx + 1) * 10, (isoChunk.wy + 1) * 10, dArray);
        if (n3 == -1) {
            return false;
        }
        double d = dArray[0];
        double d2 = dArray[1];
        float f3 = zone.polylineWidth % 2 == 0 ? 0.0f : 0.5f;
        float f4 = (float)zone.points.get(n3 * 2) + f3;
        float f5 = (float)zone.points.get(n3 * 2 + 1) + f3;
        float f6 = (float)zone.points.get(n3 * 2 + 2) + f3;
        float f7 = f6 - f4;
        float f8 = Vector2f.length((float)f7, (float)(f2 = (f = (float)zone.points.get(n3 * 2 + 3) + f3) - f5));
        if (f8 < (float)n2) {
            return false;
        }
        this.zoneWidth = zone.polylineWidth;
        if (fArray == null) {
            return true;
        }
        float f9 = (float)n2 / 2.0f / f8;
        float f10 = PZMath.max((float)d - f9, f9);
        float f11 = PZMath.min((float)d2 + f9, 1.0f - f9);
        float f12 = f4 + f7 * f10;
        float f13 = f5 + f2 * f10;
        float f14 = f4 + f7 * f11;
        float f15 = f5 + f2 * f11;
        float f16 = Rand.Next(0.0f, 1.0f);
        if (Core.bDebug) {
            f16 = (float)(System.currentTimeMillis() / 20L % 360L) / 360.0f;
        }
        fArray[0] = f12 + (f14 - f12) * f16;
        fArray[1] = f13 + (f15 - f13) * f16;
        fArray[2] = Vector2.getDirection(f7, f2);
        return true;
    }

    public boolean isFullyStreamedIn(int n, int n2, int n3, int n4) {
        int n5 = 10;
        int n6 = n / n5;
        int n7 = n2 / n5;
        int n8 = (n3 - 1) / n5;
        int n9 = (n4 - 1) / n5;
        for (int i = n7; i <= n9; ++i) {
            for (int j = n6; j <= n8; ++j) {
                if (this.isChunkLoaded(j, i)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isChunkLoaded(int n, int n2) {
        IsoChunk isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(n, n2) : IsoWorld.instance.CurrentCell.getChunk(n, n2);
        return isoChunk != null && isoChunk.bLoaded;
    }

    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        return false;
    }

    public boolean callVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, float f) {
        float[] fArray = new float[3];
        if (!this.getSpawnPoint(zone, isoChunk, fArray)) {
            return false;
        }
        this.initVehicleStorySpawner(zone, isoChunk, false);
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        float f2 = fArray[2];
        if (Rand.NextBool(2)) {
            f2 += (float)Math.PI;
        }
        f2 += f;
        vehicleStorySpawner.spawn(fArray[0], fArray[1], 0.0f, f2 += 1.5707964f, this::spawnElement);
        return true;
    }

    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
    }

    public BaseVehicle[] addSmashedOverlay(BaseVehicle baseVehicle, BaseVehicle baseVehicle2, int n, int n2, boolean bl, boolean bl2) {
        IsoDirections isoDirections = baseVehicle.getDir();
        IsoDirections isoDirections2 = baseVehicle2.getDir();
        String string = null;
        String string2 = null;
        if (!bl) {
            string = "Front";
            string2 = isoDirections2 == IsoDirections.W ? (isoDirections == IsoDirections.S ? "Right" : "Left") : (isoDirections == IsoDirections.S ? "Left" : "Right");
        } else {
            string = isoDirections == IsoDirections.S ? (n > 0 ? "Left" : "Right") : (n < 0 ? "Left" : "Right");
            string2 = "Front";
        }
        baseVehicle = baseVehicle.setSmashed(string);
        baseVehicle2 = baseVehicle2.setSmashed(string2);
        if (bl2) {
            baseVehicle.setBloodIntensity(string, 1.0f);
            baseVehicle2.setBloodIntensity(string2, 1.0f);
        }
        return new BaseVehicle[]{baseVehicle, baseVehicle2};
    }

    public int getChance() {
        return this.chance;
    }

    public void setChance(int n) {
        this.chance = n;
    }

    public int getMinimumDays() {
        return this.minimumDays;
    }

    public void setMinimumDays(int n) {
        this.minimumDays = n;
    }

    @Override
    public int getMaximumDays() {
        return this.maximumDays;
    }

    @Override
    public void setMaximumDays(int n) {
        this.maximumDays = n;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDebugLine() {
        return this.debugLine;
    }

    public void registerCustomOutfits() {
    }
}

