/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSTrailerCrash
extends RandomizedVehicleStoryBase {
    public RVSTrailerCrash() {
        this.name = "Trailer Crash";
        this.minZoneWidth = 5;
        this.minZoneHeight = 12;
        this.setChance(3);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        Vector2 vector22 = IsoDirections.N.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        float f2 = 0.0f;
        float f3 = -1.5f;
        vehicleStorySpawner.addElement("vehicle1", f2, f3, vector22.getDirection(), 2.0f, 5.0f);
        int n = 4;
        vehicleStorySpawner.addElement("trailer", f2, f3 + 2.5f + 1.0f + (float)n / 2.0f, vector22.getDirection(), 2.0f, n);
        boolean bl2 = Rand.NextBool(2);
        vector22 = bl2 ? IsoDirections.E.ToVector() : IsoDirections.W.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        float f4 = 0.0f;
        float f5 = f3 - 2.5f - 1.0f;
        vehicleStorySpawner.addElement("vehicle2", f4, f5, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("east", bl2);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        boolean bl = vehicleStorySpawner.getParameterBoolean("east");
        switch (element.id) {
            case "vehicle1": {
                BaseVehicle baseVehicle;
                String string;
                BaseVehicle baseVehicle2 = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, null, "Base.PickUpVan", null, null);
                if (baseVehicle2 == null) break;
                baseVehicle2 = baseVehicle2.setSmashed("Front");
                baseVehicle2.setBloodIntensity("Front", 1.0f);
                String string2 = string = Rand.NextBool(2) ? "Base.Trailer" : "Base.TrailerCover";
                if (Rand.NextBool(6)) {
                    string = "Base.TrailerAdvert";
                }
                if ((baseVehicle = this.addTrailer(baseVehicle2, zone, isoGridSquare.getChunk(), null, null, string)) != null && Rand.NextBool(3)) {
                    baseVehicle.setAngles(baseVehicle.getAngleX(), Rand.Next(90.0f, 110.0f), baseVehicle.getAngleZ());
                }
                if (Rand.Next(10) < 4) {
                    this.addZombiesOnVehicle(Rand.Next(2, 5), null, null, baseVehicle2);
                }
                vehicleStorySpawner.setParameter("vehicle1", baseVehicle2);
                break;
            }
            case "vehicle2": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle == null) break;
                String string = bl ? "Right" : "Left";
                baseVehicle = baseVehicle.setSmashed(string);
                baseVehicle.setBloodIntensity(string, 1.0f);
                vehicleStorySpawner.setParameter("vehicle2", baseVehicle);
                break;
            }
        }
    }
}

