/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;

public final class RVSPoliceBlockadeShooting
extends RandomizedVehicleStoryBase {
    public RVSPoliceBlockadeShooting() {
        this.name = "Police Blockade Shooting";
        this.minZoneWidth = 8;
        this.minZoneHeight = 8;
        this.setChance(1);
        this.setMaximumDays(30);
    }

    @Override
    public boolean isValid(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        boolean bl2 = super.isValid(zone, isoChunk, bl);
        if (!bl2) {
            return false;
        }
        return zone.isRectangle();
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.17453292f;
        if (bl) {
            f = 0.0f;
        }
        float f2 = 1.5f;
        float f3 = 1.0f;
        if (this.zoneWidth >= 10) {
            f2 = 2.5f;
            f3 = 0.0f;
        }
        boolean bl2 = Rand.NextBool(2);
        if (bl) {
            bl2 = true;
        }
        IsoDirections isoDirections = Rand.NextBool(2) ? IsoDirections.W : IsoDirections.E;
        Vector2 vector22 = isoDirections.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", -f2, f3, vector22.getDirection(), 2.0f, 5.0f);
        vector22 = isoDirections.RotLeft(4).ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle2", f2, -f3, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.addElement("barricade", 0.0f, bl2 ? -f3 - 2.5f : f3 + 2.5f, IsoDirections.N.ToVector().getDirection(), this.zoneWidth, 1.0f);
        int n = Rand.Next(7, 15);
        for (int i = 0; i < n; ++i) {
            vehicleStorySpawner.addElement("corpse", Rand.Next((float)(-this.zoneWidth) / 2.0f + 1.0f, (float)this.zoneWidth / 2.0f - 1.0f), bl2 ? (float)Rand.Next(-7, -4) - f3 : (float)Rand.Next(5, 8) + f3, IsoDirections.getRandom().ToVector().getDirection(), 1.0f, 2.0f);
        }
        String string = "Base.CarLightsPolice";
        if (Rand.NextBool(3)) {
            string = "Base.PickUpVanLightsPolice";
        }
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("script", string);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        String string = vehicleStorySpawner.getParameterString("script");
        switch (element.id) {
            case "barricade": {
                if (this.horizontalZone) {
                    int n = (int)(element.position.y - element.width / 2.0f);
                    int n2 = (int)(element.position.y + element.width / 2.0f) - 1;
                    int n3 = (int)element.position.x;
                    for (int i = n; i <= n2; ++i) {
                        IsoGridSquare isoGridSquare2 = IsoCell.getInstance().getGridSquare(n3, i, zone.z);
                        if (isoGridSquare2 == null) continue;
                        if (i == n || i == n2) {
                            isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "street_decoration_01_26", null, false));
                            continue;
                        }
                        isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "construction_01_9", null, false));
                    }
                } else {
                    int n = (int)(element.position.x - element.width / 2.0f);
                    int n4 = (int)(element.position.x + element.width / 2.0f) - 1;
                    int n5 = (int)element.position.y;
                    for (int i = n; i <= n4; ++i) {
                        IsoGridSquare isoGridSquare3 = IsoCell.getInstance().getGridSquare(i, n5, zone.z);
                        if (isoGridSquare3 == null) continue;
                        if (i == n || i == n4) {
                            isoGridSquare3.AddTileObject(IsoObject.getNew(isoGridSquare3, "street_decoration_01_26", null, false));
                            continue;
                        }
                        isoGridSquare3.AddTileObject(IsoObject.getNew(isoGridSquare3, "construction_01_8", null, false));
                    }
                }
                break;
            }
            case "corpse": {
                BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
                if (baseVehicle == null) break;
                RVSPoliceBlockadeShooting.createRandomDeadBody(element.position.x, element.position.y, zone.z, element.direction, false, 10, 10, null);
                IsoDirections isoDirections = this.horizontalZone ? (element.position.x < baseVehicle.x ? IsoDirections.W : IsoDirections.E) : (element.position.y < baseVehicle.y ? IsoDirections.N : IsoDirections.S);
                float f2 = isoDirections.ToVector().getDirection();
                this.addTrailOfBlood(element.position.x, element.position.y, element.z, f2, 5);
                break;
            }
            case "vehicle1": 
            case "vehicle2": {
                Object object;
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, null, string, null, null);
                if (baseVehicle == null) break;
                vehicleStorySpawner.setParameter(element.id, baseVehicle);
                if (Rand.NextBool(3)) {
                    baseVehicle.setHeadlightsOn(true);
                    baseVehicle.setLightbarLightsMode(2);
                    object = baseVehicle.getBattery();
                    if (object != null) {
                        ((VehiclePart)object).setLastUpdated(0.0f);
                    }
                }
                object = "PoliceRiot";
                Integer n = 0;
                this.addZombiesOnVehicle(Rand.Next(2, 4), (String)object, n, baseVehicle);
                break;
            }
        }
    }
}

