/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;

public final class RVSPoliceBlockade
extends RandomizedVehicleStoryBase {
    public RVSPoliceBlockade() {
        this.name = "Police Blockade";
        this.minZoneWidth = 8;
        this.minZoneHeight = 8;
        this.setChance(3);
        this.setMaximumDays(30);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.17453292f;
        if (bl) {
            f = 0.0f;
        }
        float f2 = 1.5f;
        float f3 = 1.0f;
        if (this.zoneWidth >= 10) {
            f2 = 2.5f;
            f3 = 0.0f;
        }
        IsoDirections isoDirections = Rand.NextBool(2) ? IsoDirections.W : IsoDirections.E;
        Vector2 vector22 = isoDirections.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", -f2, f3, vector22.getDirection(), 2.0f, 5.0f);
        vector22 = isoDirections.RotLeft(4).ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle2", f2, -f3, vector22.getDirection(), 2.0f, 5.0f);
        String string = "Base.CarLightsPolice";
        if (Rand.NextBool(3)) {
            string = "Base.PickUpVanLightsPolice";
        }
        vehicleStorySpawner.setParameter("zone", zone);
        vehicleStorySpawner.setParameter("script", string);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        String string = vehicleStorySpawner.getParameterString("script");
        switch (element.id) {
            case "vehicle1": 
            case "vehicle2": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, null, string, null, null);
                if (baseVehicle == null) break;
                if (Rand.NextBool(3)) {
                    baseVehicle.setHeadlightsOn(true);
                    baseVehicle.setLightbarLightsMode(2);
                    VehiclePart vehiclePart = baseVehicle.getBattery();
                    if (vehiclePart != null) {
                        vehiclePart.setLastUpdated(0.0f);
                    }
                }
                this.addZombiesOnVehicle(Rand.Next(2, 4), "police", null, baseVehicle);
            }
        }
    }
}

