/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.ArrayList;
import zombie.core.Rand;
import zombie.core.math.PZMath;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSConstructionSite
extends RandomizedVehicleStoryBase {
    private ArrayList<String> tools = null;

    public RVSConstructionSite() {
        this.name = "Construction Site";
        this.minZoneWidth = 6;
        this.minZoneHeight = 6;
        this.setChance(3);
        this.tools = new ArrayList();
        this.tools.add("Base.PickAxe");
        this.tools.add("Base.Shovel");
        this.tools.add("Base.Shovel2");
        this.tools.add("Base.Hammer");
        this.tools.add("Base.LeadPipe");
        this.tools.add("Base.PipeWrench");
        this.tools.add("Base.Sledgehammer");
        this.tools.add("Base.Sledgehammer2");
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        boolean bl2 = Rand.NextBool(2);
        if (bl) {
            bl2 = true;
        }
        int n = bl2 ? 1 : -1;
        Vector2 vector22 = IsoDirections.N.ToVector();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", (float)(-n) * 2.0f, 0.0f, vector22.getDirection(), 2.0f, 5.0f);
        float f2 = 0.0f;
        vehicleStorySpawner.addElement("manhole", (float)n * 1.5f, 1.5f, f2, 3.0f, 3.0f);
        int n2 = Rand.Next(0, 3);
        for (int i = 0; i < n2; ++i) {
            f2 = 0.0f;
            vehicleStorySpawner.addElement("tool", (float)n * Rand.Next(0.0f, 3.0f), -Rand.Next(0.7f, 2.3f), f2, 1.0f, 1.0f);
        }
        vehicleStorySpawner.setParameter("zone", zone);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = PZMath.max(element.position.x - (float)isoGridSquare.x, 0.001f);
        float f2 = PZMath.max(element.position.y - (float)isoGridSquare.y, 0.001f);
        float f3 = 0.0f;
        float f4 = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
        switch (element.id) {
            case "manhole": {
                isoGridSquare.AddTileObject(IsoObject.getNew(isoGridSquare, "street_decoration_01_15", null, false));
                IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.E);
                if (isoGridSquare2 != null) {
                    isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "street_decoration_01_26", null, false));
                }
                if ((isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.W)) != null) {
                    isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "street_decoration_01_26", null, false));
                }
                if ((isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.S)) != null) {
                    isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "street_decoration_01_26", null, false));
                }
                if ((isoGridSquare2 = isoGridSquare.getAdjacentSquare(IsoDirections.N)) == null) break;
                isoGridSquare2.AddTileObject(IsoObject.getNew(isoGridSquare2, "street_decoration_01_26", null, false));
                break;
            }
            case "tool": {
                String string = this.tools.get(Rand.Next(this.tools.size()));
                isoGridSquare.AddWorldInventoryItem(string, f, f2, f3);
                break;
            }
            case "vehicle1": {
                baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f4, element.direction, null, "Base.PickUpTruck", null, "ConstructionWorker");
                if (baseVehicle == null) break;
                this.addZombiesOnVehicle(Rand.Next(2, 5), "ConstructionWorker", 0, baseVehicle);
                this.addZombiesOnVehicle(1, "Foreman", 0, baseVehicle);
                vehicleStorySpawner.setParameter("vehicle1", baseVehicle);
            }
        }
    }
}

