/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSCarCrashCorpse
extends RandomizedVehicleStoryBase {
    public RVSCarCrashCorpse() {
        this.name = "Basic Car Crash Corpse";
        this.minZoneWidth = 6;
        this.minZoneHeight = 11;
        this.setChance(10);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        float f = 0.5235988f;
        this.callVehicleStorySpawner(zone, isoChunk, Rand.Next(-f, f));
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        Vector2 vector22 = IsoDirections.N.ToVector();
        float f = 2.5f;
        vehicleStorySpawner.addElement("vehicle1", 0.0f, f, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.addElement("corpse", 0.0f, f - (float)(bl ? 7 : Rand.Next(4, 7)), vector22.getDirection() + (float)Math.PI, 1.0f, 2.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
        switch (element.id) {
            case "corpse": {
                if (baseVehicle == null) break;
                RVSCarCrashCorpse.createRandomDeadBody(element.position.x, element.position.y, element.z, element.direction, false, 35, 30, null);
                this.addTrailOfBlood(element.position.x, element.position.y, element.z, element.direction, 15);
                break;
            }
            case "vehicle1": {
                baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle == null) break;
                baseVehicle = baseVehicle.setSmashed("Front");
                baseVehicle.setBloodIntensity("Front", 1.0f);
                vehicleStorySpawner.setParameter("vehicle1", baseVehicle);
            }
        }
    }
}

