/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSBanditRoad
extends RandomizedVehicleStoryBase {
    public RVSBanditRoad() {
        this.name = "Bandits on Road";
        this.minZoneWidth = 7;
        this.minZoneHeight = 9;
        this.setMinimumDays(30);
        this.setChance(3);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        Vector2 vector22 = IsoDirections.N.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", 0.0f, 2.0f, vector22.getDirection(), 2.0f, 5.0f);
        boolean bl2 = Rand.NextBool(2);
        vector22 = bl2 ? IsoDirections.E.ToVector() : IsoDirections.W.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        float f2 = 0.0f;
        float f3 = -1.5f;
        vehicleStorySpawner.addElement("vehicle2", f2, f3, vector22.getDirection(), 2.0f, 5.0f);
        int n = Rand.Next(3, 6);
        for (int i = 0; i < n; ++i) {
            float f4 = Rand.Next(f2 - 3.0f, f2 + 3.0f);
            float f5 = Rand.Next(f3 - 3.0f, f3 + 3.0f);
            vehicleStorySpawner.addElement("corpse", f4, f5, Rand.Next(0.0f, (float)Math.PI * 2), 1.0f, 2.0f);
        }
        vehicleStorySpawner.setParameter("zone", zone);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        switch (element.id) {
            case "corpse": {
                BaseVehicle baseVehicle = vehicleStorySpawner.getParameter("vehicle1", BaseVehicle.class);
                if (baseVehicle == null) break;
                RVSBanditRoad.createRandomDeadBody(element.position.x, element.position.y, element.z, element.direction, false, 6, 0, null);
                this.addTrailOfBlood(element.position.x, element.position.y, element.z, Vector2.getDirection(element.position.x - baseVehicle.x, element.position.y - baseVehicle.y), 15);
                break;
            }
            case "vehicle1": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle == null) break;
                baseVehicle = baseVehicle.setSmashed("Front");
                this.addZombiesOnVehicle(Rand.Next(3, 6), "Bandit", null, baseVehicle);
                vehicleStorySpawner.setParameter("vehicle1", baseVehicle);
                break;
            }
            case "vehicle2": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle == null) break;
                this.addZombiesOnVehicle(Rand.Next(3, 5), null, null, baseVehicle);
                vehicleStorySpawner.setParameter("vehicle2", baseVehicle);
                break;
            }
        }
    }
}

