/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedVehicleStory;

import java.util.ArrayList;
import zombie.characters.BodyDamage.BodyPartType;
import zombie.characters.IsoZombie;
import zombie.core.Rand;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.Vector2;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawner;
import zombie.vehicles.BaseVehicle;

public final class RVSAmbulanceCrash
extends RandomizedVehicleStoryBase {
    public RVSAmbulanceCrash() {
        this.name = "Ambulance Crash";
        this.minZoneWidth = 5;
        this.minZoneHeight = 7;
        this.setChance(5);
    }

    @Override
    public void randomizeVehicleStory(IsoMetaGrid.Zone zone, IsoChunk isoChunk) {
        this.callVehicleStorySpawner(zone, isoChunk, 0.0f);
    }

    @Override
    public boolean initVehicleStorySpawner(IsoMetaGrid.Zone zone, IsoChunk isoChunk, boolean bl) {
        VehicleStorySpawner vehicleStorySpawner = VehicleStorySpawner.getInstance();
        vehicleStorySpawner.clear();
        float f = 0.5235988f;
        if (bl) {
            f = 0.0f;
        }
        Vector2 vector22 = IsoDirections.N.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle1", 0.0f, 1.0f, vector22.getDirection(), 2.0f, 5.0f);
        boolean bl2 = Rand.NextBool(2);
        vector22 = bl2 ? IsoDirections.E.ToVector() : IsoDirections.W.ToVector();
        vector22.rotate(Rand.Next(-f, f));
        vehicleStorySpawner.addElement("vehicle2", 0.0f, -2.5f, vector22.getDirection(), 2.0f, 5.0f);
        vehicleStorySpawner.setParameter("zone", zone);
        return true;
    }

    @Override
    public void spawnElement(VehicleStorySpawner vehicleStorySpawner, VehicleStorySpawner.Element element) {
        IsoGridSquare isoGridSquare = element.square;
        if (isoGridSquare == null) {
            return;
        }
        float f = element.z;
        IsoMetaGrid.Zone zone = vehicleStorySpawner.getParameter("zone", IsoMetaGrid.Zone.class);
        switch (element.id) {
            case "vehicle1": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, null, "Base.VanAmbulance", null, null);
                if (baseVehicle == null) break;
                this.addZombiesOnVehicle(Rand.Next(1, 3), "AmbulanceDriver", null, baseVehicle);
                ArrayList<IsoZombie> arrayList = this.addZombiesOnVehicle(Rand.Next(1, 3), "HospitalPatient", null, baseVehicle);
                for (int i = 0; i < arrayList.size(); ++i) {
                    for (int j = 0; j < 7; ++j) {
                        if (!Rand.NextBool(2)) continue;
                        arrayList.get(i).addVisualBandage(BodyPartType.getRandom(), true);
                    }
                }
                break;
            }
            case "vehicle2": {
                BaseVehicle baseVehicle = this.addVehicle(zone, element.position.x, element.position.y, f, element.direction, "bad", null, null, null);
                if (baseVehicle != null) break;
                break;
            }
        }
    }
}

