/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedDeadSurvivor;

import java.util.ArrayList;
import zombie.characters.IsoPlayer;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedDeadSurvivor.RandomizedDeadSurvivorBase;
import zombie.util.list.PZArrayUtil;

public final class RDSBandPractice
extends RandomizedDeadSurvivorBase {
    private final ArrayList<String> instrumentsList = new ArrayList();

    public RDSBandPractice() {
        this.name = "Band Practice";
        this.setChance(10);
        this.setMaximumDays(60);
        this.instrumentsList.add("GuitarAcoustic");
        this.instrumentsList.add("GuitarElectricBlack");
        this.instrumentsList.add("GuitarElectricBlue");
        this.instrumentsList.add("GuitarElectricRed");
        this.instrumentsList.add("GuitarElectricBassBlue");
        this.instrumentsList.add("GuitarElectricBassBlack");
        this.instrumentsList.add("GuitarElectricBassRed");
    }

    @Override
    public void randomizeDeadSurvivor(BuildingDef buildingDef) {
        this.spawnItemsInContainers(buildingDef, "BandPractice", 90);
        RoomDef roomDef = this.getRoom(buildingDef, "garagestorage");
        if (roomDef == null) {
            roomDef = this.getRoom(buildingDef, "shed");
        }
        if (roomDef == null) {
            roomDef = this.getRoom(buildingDef, "garage");
        }
        this.addZombies(buildingDef, Rand.Next(2, 4), "Rocker", 20, roomDef);
        IsoGridSquare isoGridSquare = RDSBandPractice.getRandomSpawnSquare(roomDef);
        if (isoGridSquare == null) {
            return;
        }
        isoGridSquare.AddWorldInventoryItem(PZArrayUtil.pickRandom(this.instrumentsList), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        if (Rand.Next(4) == 0) {
            isoGridSquare.AddWorldInventoryItem(PZArrayUtil.pickRandom(this.instrumentsList), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        if (Rand.Next(4) == 0) {
            isoGridSquare.AddWorldInventoryItem(PZArrayUtil.pickRandom(this.instrumentsList), Rand.Next(0.0f, 0.5f), Rand.Next(0.0f, 0.5f), 0.0f);
        }
        buildingDef.bAlarmed = false;
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        int n;
        this.debugLine = "";
        if (GameClient.bClient) {
            return false;
        }
        if (buildingDef.isAllExplored() && !bl) {
            return false;
        }
        if (!bl) {
            for (n = 0; n < GameServer.Players.size(); ++n) {
                IsoPlayer isoPlayer = GameServer.Players.get(n);
                if (isoPlayer.getSquare() == null || isoPlayer.getSquare().getBuilding() == null || isoPlayer.getSquare().getBuilding().def != buildingDef) continue;
                return false;
            }
        }
        n = 0;
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            RoomDef roomDef = buildingDef.rooms.get(i);
            if (!"garagestorage".equals(roomDef.name) && !"shed".equals(roomDef.name) && !"garage".equals(roomDef.name) || roomDef.area < 9) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            this.debugLine = "No shed/garage or is too small";
        }
        return n != 0;
    }
}

