/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.characters.SurvivorDesc;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.core.skinnedmodel.visual.IHumanVisual;
import zombie.core.skinnedmodel.visual.ItemVisuals;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemPickerJava;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.WeaponPart;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.SpawnPoints;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.RandomizedWorldBase;
import zombie.randomizedWorld.randomizedBuilding.RBKateAndBaldspot;

public class RandomizedBuildingBase
extends RandomizedWorldBase {
    private int chance = 0;
    private static int totalChance = 0;
    private static HashMap<RandomizedBuildingBase, Integer> rbMap = new HashMap();
    protected static final int KBBuildingX = 10744;
    protected static final int KBBuildingY = 9409;
    private boolean alwaysDo = false;
    private static HashMap<String, String> weaponsList = new HashMap();

    public void randomizeBuilding(BuildingDef buildingDef) {
        buildingDef.bAlarmed = false;
    }

    public void init() {
        if (!weaponsList.isEmpty()) {
            return;
        }
        weaponsList.put("Base.Shotgun", "Base.ShotgunShellsBox");
        weaponsList.put("Base.Pistol", "Base.Bullets9mmBox");
        weaponsList.put("Base.Pistol2", "Base.Bullets45Box");
        weaponsList.put("Base.Pistol3", "Base.Bullets44Box");
        weaponsList.put("Base.VarmintRifle", "Base.223Box");
        weaponsList.put("Base.HuntingRifle", "Base.308Box");
    }

    public static void initAllRBMapChance() {
        for (int i = 0; i < IsoWorld.instance.getRandomizedBuildingList().size(); ++i) {
            totalChance += IsoWorld.instance.getRandomizedBuildingList().get(i).getChance();
            rbMap.put(IsoWorld.instance.getRandomizedBuildingList().get(i), IsoWorld.instance.getRandomizedBuildingList().get(i).getChance());
        }
    }

    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        int n;
        this.debugLine = "";
        if (GameClient.bClient) {
            return false;
        }
        if (buildingDef.isAllExplored() && !bl) {
            return false;
        }
        if (!GameServer.bServer) {
            if (!bl && IsoPlayer.getInstance().getSquare() != null && IsoPlayer.getInstance().getSquare().getBuilding() != null && IsoPlayer.getInstance().getSquare().getBuilding().def == buildingDef) {
                this.customizeStartingHouse(IsoPlayer.getInstance().getSquare().getBuilding().def);
                return false;
            }
        } else if (!bl) {
            for (n = 0; n < GameServer.Players.size(); ++n) {
                IsoPlayer isoPlayer = GameServer.Players.get(n);
                if (isoPlayer.getSquare() == null || isoPlayer.getSquare().getBuilding() == null || isoPlayer.getSquare().getBuilding().def != buildingDef) continue;
                return false;
            }
        }
        n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            RoomDef roomDef = buildingDef.rooms.get(i);
            if ("bedroom".equals(roomDef.name)) {
                n = 1;
            }
            if ("kitchen".equals(roomDef.name) || "livingroom".equals(roomDef.name)) {
                bl2 = true;
            }
            if (!"bathroom".equals(roomDef.name)) continue;
            bl3 = true;
        }
        if (n == 0) {
            this.debugLine = this.debugLine + "no bedroom ";
        }
        if (!bl3) {
            this.debugLine = this.debugLine + "no bathroom ";
        }
        if (!bl2) {
            this.debugLine = this.debugLine + "no living room or kitchen ";
        }
        return n != 0 && bl3 && bl2;
    }

    private void customizeStartingHouse(BuildingDef buildingDef) {
    }

    public int getMinimumDays() {
        return this.minimumDays;
    }

    public void setMinimumDays(int n) {
        this.minimumDays = n;
    }

    public int getMinimumRooms() {
        return this.minimumRooms;
    }

    public void setMinimumRooms(int n) {
        this.minimumRooms = n;
    }

    public static void ChunkLoaded(IsoBuilding isoBuilding) {
        if (!GameClient.bClient && isoBuilding.def != null && !isoBuilding.def.seen && isoBuilding.def.isFullyStreamedIn()) {
            RandomizedBuildingBase randomizedBuildingBase;
            if (GameServer.bServer && GameServer.Players.isEmpty()) {
                return;
            }
            for (int i = 0; i < isoBuilding.Rooms.size(); ++i) {
                if (!isoBuilding.Rooms.get((int)i).def.bExplored) continue;
                return;
            }
            if (!isoBuilding.def.isAnyChunkNewlyLoaded()) {
                isoBuilding.def.seen = true;
                return;
            }
            ArrayList<RandomizedBuildingBase> arrayList = new ArrayList<RandomizedBuildingBase>();
            for (int i = 0; i < IsoWorld.instance.getRandomizedBuildingList().size(); ++i) {
                RandomizedBuildingBase randomizedBuildingBase2 = IsoWorld.instance.getRandomizedBuildingList().get(i);
                if (!randomizedBuildingBase2.isAlwaysDo() || !randomizedBuildingBase2.isValid(isoBuilding.def, false)) continue;
                arrayList.add(randomizedBuildingBase2);
            }
            isoBuilding.def.seen = true;
            if (isoBuilding.def.x == 10744 && isoBuilding.def.y == 9409 && Rand.Next(100) < 31) {
                RBKateAndBaldspot rBKateAndBaldspot = new RBKateAndBaldspot();
                ((RandomizedBuildingBase)rBKateAndBaldspot).randomizeBuilding(isoBuilding.def);
                return;
            }
            if (!arrayList.isEmpty() && (randomizedBuildingBase = (RandomizedBuildingBase)arrayList.get(Rand.Next(0, arrayList.size()))) != null) {
                randomizedBuildingBase.randomizeBuilding(isoBuilding.def);
                return;
            }
            if (GameServer.bServer && SpawnPoints.instance.isSpawnBuilding(isoBuilding.getDef())) {
                return;
            }
            RandomizedBuildingBase randomizedBuildingBase3 = IsoWorld.instance.getRBBasic();
            if ("Tutorial".equals(Core.GameMode)) {
                return;
            }
            try {
                int n = 10;
                switch (SandboxOptions.instance.SurvivorHouseChance.getValue()) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        n -= 5;
                        break;
                    }
                    case 4: {
                        n += 5;
                        break;
                    }
                    case 5: {
                        n += 10;
                        break;
                    }
                    case 6: {
                        n += 20;
                    }
                }
                if (Rand.Next(100) <= n) {
                    if (totalChance == 0) {
                        RandomizedBuildingBase.initAllRBMapChance();
                    }
                    if ((randomizedBuildingBase3 = RandomizedBuildingBase.getRandomStory()) == null) {
                        return;
                    }
                }
                if (randomizedBuildingBase3.isValid(isoBuilding.def, false) && randomizedBuildingBase3.isTimeValid(false)) {
                    randomizedBuildingBase3.randomizeBuilding(isoBuilding.def);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getChance() {
        return this.chance;
    }

    public void setChance(int n) {
        this.chance = n;
    }

    public boolean isAlwaysDo() {
        return this.alwaysDo;
    }

    public void setAlwaysDo(boolean bl) {
        this.alwaysDo = bl;
    }

    private static RandomizedBuildingBase getRandomStory() {
        int n = Rand.Next(totalChance);
        Iterator<RandomizedBuildingBase> iterator = rbMap.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            RandomizedBuildingBase randomizedBuildingBase = iterator.next();
            if (n >= (n2 += rbMap.get(randomizedBuildingBase).intValue())) continue;
            return randomizedBuildingBase;
        }
        return null;
    }

    @Override
    public ArrayList<IsoZombie> addZombiesOnSquare(int n, String string, Integer n2, IsoGridSquare isoGridSquare) {
        if (IsoWorld.getZombiesDisabled() || "Tutorial".equals(Core.GameMode)) {
            return null;
        }
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        for (int i = 0; i < n; ++i) {
            VirtualZombieManager.instance.choices.clear();
            VirtualZombieManager.instance.choices.add(isoGridSquare);
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.getRandom().index(), false);
            if (isoZombie == null) continue;
            if ("Kate".equals(string) || "Bob".equals(string) || "Raider".equals(string)) {
                isoZombie.doDirtBloodEtc = false;
            }
            if (n2 != null) {
                isoZombie.setFemaleEtc(Rand.Next(100) < n2);
            }
            if (string != null) {
                isoZombie.dressInPersistentOutfit(string);
                isoZombie.bDressInRandomOutfit = false;
            } else {
                isoZombie.bDressInRandomOutfit = true;
            }
            arrayList.add(isoZombie);
        }
        ZombieSpawnRecorder.instance.record(arrayList, this.getClass().getSimpleName());
        return arrayList;
    }

    public ArrayList<IsoZombie> addZombies(BuildingDef buildingDef, int n, String string, Integer n2, RoomDef roomDef) {
        IsoGridSquare isoGridSquare;
        boolean bl = roomDef == null;
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        if (IsoWorld.getZombiesDisabled() || "Tutorial".equals(Core.GameMode)) {
            return arrayList;
        }
        if (roomDef == null) {
            roomDef = this.getRandomRoom(buildingDef, 6);
        }
        int n3 = 2;
        int n4 = roomDef.area / 2;
        if (n == 0) {
            if (SandboxOptions.instance.Zombies.getValue() == 1) {
                n4 += 4;
            } else if (SandboxOptions.instance.Zombies.getValue() == 2) {
                n4 += 3;
            } else if (SandboxOptions.instance.Zombies.getValue() == 3) {
                n4 += 2;
            } else if (SandboxOptions.instance.Zombies.getValue() == 5) {
                n4 -= 4;
            }
            if (n4 > 8) {
                n4 = 8;
            }
            if (n4 < n3) {
                n4 = n3 + 1;
            }
        } else {
            n4 = n3 = n;
        }
        int n5 = Rand.Next(n3, n4);
        for (int i = 0; i < n5 && (isoGridSquare = RandomizedBuildingBase.getRandomSpawnSquare(roomDef)) != null; ++i) {
            VirtualZombieManager.instance.choices.clear();
            VirtualZombieManager.instance.choices.add(isoGridSquare);
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.getRandom().index(), false);
            if (isoZombie == null) continue;
            if (n2 != null) {
                isoZombie.setFemaleEtc(Rand.Next(100) < n2);
            }
            if (string != null) {
                isoZombie.dressInPersistentOutfit(string);
                isoZombie.bDressInRandomOutfit = false;
            } else {
                isoZombie.bDressInRandomOutfit = true;
            }
            arrayList.add(isoZombie);
            if (!bl) continue;
            roomDef = this.getRandomRoom(buildingDef, 6);
        }
        ZombieSpawnRecorder.instance.record(arrayList, this.getClass().getSimpleName());
        return arrayList;
    }

    public HandWeapon addRandomRangedWeapon(ItemContainer itemContainer, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<String> arrayList;
        String string;
        HandWeapon handWeapon;
        if (weaponsList == null || weaponsList.isEmpty()) {
            this.init();
        }
        if ((handWeapon = this.addWeapon(string = (arrayList = new ArrayList<String>(weaponsList.keySet())).get(Rand.Next(0, arrayList.size())), bl)) == null) {
            return null;
        }
        if (bl2) {
            itemContainer.addItem(InventoryItemFactory.CreateItem(weaponsList.get(string)));
        }
        if (bl3) {
            KahluaTable kahluaTable = (KahluaTable)LuaManager.env.rawget((Object)"WeaponUpgrades");
            if (kahluaTable == null) {
                return null;
            }
            KahluaTable kahluaTable2 = (KahluaTable)kahluaTable.rawget((Object)handWeapon.getType());
            if (kahluaTable2 == null) {
                return null;
            }
            int n = Rand.Next(1, kahluaTable2.len() + 1);
            for (int i = 1; i <= n; ++i) {
                int n2 = Rand.Next(kahluaTable2.len()) + 1;
                WeaponPart weaponPart = (WeaponPart)InventoryItemFactory.CreateItem((String)kahluaTable2.rawget(n2));
                handWeapon.attachWeaponPart(weaponPart);
            }
        }
        return handWeapon;
    }

    public void spawnItemsInContainers(BuildingDef buildingDef, String string, int n) {
        int n2;
        ArrayList<ItemContainer> arrayList = new ArrayList<ItemContainer>();
        ItemPickerJava.ItemPickerRoom itemPickerRoom = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)string);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (n2 = buildingDef.x - 1; n2 < buildingDef.x2 + 1; ++n2) {
            for (int i = buildingDef.y - 1; i < buildingDef.y2 + 1; ++i) {
                for (int j = 0; j < 8; ++j) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(n2, i, j);
                    if (isoGridSquare == null) continue;
                    for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(k);
                        if (Rand.Next(100) > n || isoObject.getContainer() == null || isoGridSquare.getRoom() == null || isoGridSquare.getRoom().getName() == null || !itemPickerRoom.Containers.containsKey((Object)isoObject.getContainer().getType())) continue;
                        isoObject.getContainer().clear();
                        arrayList.add(isoObject.getContainer());
                        isoObject.getContainer().setExplored(true);
                    }
                }
            }
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ItemContainer itemContainer = (ItemContainer)arrayList.get(n2);
            ItemPickerJava.fillContainerType(itemPickerRoom, itemContainer, "", null);
            ItemPickerJava.updateOverlaySprite(itemContainer.getParent());
            if (!GameServer.bServer) continue;
            GameServer.sendItemsInContainer(itemContainer.getParent(), itemContainer);
        }
    }

    protected void removeAllZombies(BuildingDef buildingDef) {
        for (int i = buildingDef.x - 1; i < buildingDef.x + buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y + buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = this.getSq(i, j, k);
                    if (isoGridSquare == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getMovingObjects().size(); ++i2) {
                        isoGridSquare.getMovingObjects().remove(i2);
                        --i2;
                    }
                }
            }
        }
    }

    public IsoWindow getWindow(IsoGridSquare isoGridSquare) {
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (!(isoObject instanceof IsoWindow)) continue;
            return (IsoWindow)isoObject;
        }
        return null;
    }

    public IsoDoor getDoor(IsoGridSquare isoGridSquare) {
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (!(isoObject instanceof IsoDoor)) continue;
            return (IsoDoor)isoObject;
        }
        return null;
    }

    public void addBarricade(IsoGridSquare isoGridSquare, int n) {
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            int n2;
            boolean bl;
            IsoBarricade isoBarricade;
            IsoGridSquare isoGridSquare2;
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject instanceof IsoDoor) {
                if (!((IsoDoor)isoObject).isBarricadeAllowed()) continue;
                IsoGridSquare isoGridSquare3 = isoGridSquare2 = isoGridSquare.getRoom() == null ? isoGridSquare : ((IsoDoor)isoObject).getOppositeSquare();
                if (isoGridSquare2 != null && isoGridSquare2.getRoom() == null && (isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)((IsoDoor)isoObject), bl = isoGridSquare2 != isoGridSquare)) != null) {
                    for (n2 = 0; n2 < n; ++n2) {
                        isoBarricade.addPlank(null, null);
                    }
                    if (GameServer.bServer) {
                        isoBarricade.transmitCompleteItemToClients();
                    }
                }
            }
            if (!(isoObject instanceof IsoWindow) || !((IsoWindow)isoObject).isBarricadeAllowed() || (isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)((IsoWindow)isoObject), bl = (isoGridSquare2 = isoGridSquare.getRoom() == null ? isoGridSquare : ((IsoWindow)isoObject).getOppositeSquare()) != isoGridSquare)) == null) continue;
            for (n2 = 0; n2 < n; ++n2) {
                isoBarricade.addPlank(null, null);
            }
            if (!GameServer.bServer) continue;
            isoBarricade.transmitCompleteItemToClients();
        }
    }

    public InventoryItem addWorldItem(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3) {
        return this.addWorldItem(string, isoGridSquare, f, f2, f3, 0);
    }

    public InventoryItem addWorldItem(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, int n) {
        if (string == null || isoGridSquare == null) {
            return null;
        }
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
        if (inventoryItem != null) {
            inventoryItem.setAutoAge();
            inventoryItem.setWorldZRotation(n);
            if (inventoryItem instanceof HandWeapon) {
                inventoryItem.setCondition(Rand.Next(2, inventoryItem.getConditionMax()));
            }
            return isoGridSquare.AddWorldInventoryItem(inventoryItem, f, f2, f3);
        }
        return null;
    }

    public InventoryItem addWorldItem(String string, IsoGridSquare isoGridSquare, IsoObject isoObject) {
        InventoryItem inventoryItem;
        if (string == null || isoGridSquare == null) {
            return null;
        }
        float f = 0.0f;
        if (isoObject != null) {
            f = isoObject.getSurfaceOffsetNoTable() / 96.0f;
        }
        if ((inventoryItem = InventoryItemFactory.CreateItem(string)) != null) {
            inventoryItem.setAutoAge();
            return isoGridSquare.AddWorldInventoryItem(inventoryItem, Rand.Next(0.3f, 0.9f), Rand.Next(0.3f, 0.9f), f);
        }
        return null;
    }

    public boolean isTableFor3DItems(IsoObject isoObject, IsoGridSquare isoGridSquare) {
        return isoObject.getSurfaceOffsetNoTable() > 0.0f && isoObject.getContainer() == null && isoGridSquare.getProperties().Val("waterAmount") == null && !isoObject.hasWater() && isoObject.getProperties().Val("BedType") == null;
    }

    public static final class HumanCorpse
    extends IsoGameCharacter
    implements IHumanVisual {
        final HumanVisual humanVisual = new HumanVisual(this);
        final ItemVisuals itemVisuals = new ItemVisuals();
        public boolean isSkeleton = false;

        public HumanCorpse(IsoCell isoCell, float f, float f2, float f3) {
            super(isoCell, f, f2, f3);
            isoCell.getObjectList().remove(this);
            isoCell.getAddList().remove(this);
        }

        @Override
        public void dressInNamedOutfit(String string) {
            this.getHumanVisual().dressInNamedOutfit(string, this.itemVisuals);
            this.getHumanVisual().synchWithOutfit(this.getHumanVisual().getOutfit());
        }

        @Override
        public HumanVisual getHumanVisual() {
            return this.humanVisual;
        }

        @Override
        public HumanVisual getVisual() {
            return this.humanVisual;
        }

        @Override
        public void Dressup(SurvivorDesc survivorDesc) {
            this.wornItems.setFromItemVisuals(this.itemVisuals);
            this.wornItems.addItemsToItemContainer(this.inventory);
        }

        @Override
        public boolean isSkeleton() {
            return this.isSkeleton;
        }
    }
}

