/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import zombie.core.Rand;
import zombie.inventory.InventoryItem;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBTableStory
extends RandomizedBuildingBase {
    public static ArrayList<StoryDef> allStories = new ArrayList();
    private float xOffset = 0.0f;
    private float yOffset = 0.0f;
    private IsoGridSquare currentSquare = null;
    public ArrayList<HashMap<String, Integer>> fullTableMap = new ArrayList();
    public IsoObject table1 = null;
    public IsoObject table2 = null;

    public void initStories() {
        if (!allStories.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("livingroom");
        arrayList.add("kitchen");
        ArrayList<StorySpawnItem> arrayList2 = new ArrayList<StorySpawnItem>();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put("BakingPan", 50);
        linkedHashMap.put("CakePrep", 50);
        arrayList2.add(new StorySpawnItem(linkedHashMap, null, 100));
        arrayList2.add(new StorySpawnItem(null, "Chocolate", 100));
        arrayList2.add(new StorySpawnItem(null, "Butter", 70));
        arrayList2.add(new StorySpawnItem(null, "Flour", 70));
        arrayList2.add(new StorySpawnItem(null, "Spoon", 100));
        arrayList2.add(new StorySpawnItem(null, "EggCarton", 100));
        arrayList2.add(new StorySpawnItem(null, "Egg", 100));
        allStories.add(new StoryDef(arrayList2, arrayList));
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return false;
    }

    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        this.initStories();
        if (this.table1 == null || this.table2 == null) {
            return;
        }
        if (this.table1.getSquare() == null || this.table1.getSquare().getRoom() == null) {
            return;
        }
        ArrayList<StoryDef> arrayList = new ArrayList<StoryDef>();
        for (int i = 0; i < allStories.size(); ++i) {
            StoryDef storyDef = allStories.get(i);
            if (storyDef.rooms != null && !storyDef.rooms.contains(this.table1.getSquare().getRoom().getName())) continue;
            arrayList.add(storyDef);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        StoryDef storyDef = (StoryDef)arrayList.get(Rand.Next(0, arrayList.size()));
        if (storyDef == null) {
            return;
        }
        boolean bl = true;
        if ((int)this.table1.getY() != (int)this.table2.getY()) {
            bl = false;
        }
        this.doSpawnTable(storyDef.items, bl);
        if (storyDef.addBlood) {
            int n = (int)this.table1.getX() - 1;
            int n2 = (int)this.table1.getX() + 1;
            int n3 = (int)this.table1.getY() - 1;
            int n4 = (int)this.table2.getY() + 1;
            if (bl) {
                n = (int)this.table1.getX() - 1;
                n2 = (int)this.table2.getX() + 1;
                n3 = (int)this.table1.getY() - 1;
                n4 = (int)this.table2.getY() + 1;
            }
            for (int i = n; i < n2 + 1; ++i) {
                for (int j = n3; j < n4 + 1; ++j) {
                    int n5 = Rand.Next(7, 15);
                    for (int k = 0; k < n5; ++k) {
                        this.currentSquare.getChunk().addBloodSplat((float)i + Rand.Next(-0.5f, 0.5f), (float)j + Rand.Next(-0.5f, 0.5f), this.table1.getZ(), Rand.Next(8));
                    }
                }
            }
        }
    }

    private void doSpawnTable(ArrayList<StorySpawnItem> arrayList, boolean bl) {
        this.xOffset = 0.0f;
        this.yOffset = 0.0f;
        int n = 0;
        if (bl) {
            this.xOffset = 0.6f;
            this.yOffset = Rand.Next(0.5f, 1.1f);
        } else {
            this.yOffset = 0.6f;
            this.xOffset = Rand.Next(0.5f, 1.1f);
        }
        this.currentSquare = this.table1.getSquare();
        while (n < arrayList.size()) {
            InventoryItem inventoryItem;
            StorySpawnItem storySpawnItem = arrayList.get(n);
            String string = this.getItemFromSSI(storySpawnItem);
            if (string != null && (inventoryItem = this.currentSquare.AddWorldInventoryItem(string, this.xOffset, this.yOffset, 0.4f)) != null) {
                this.increaseOffsets(bl, storySpawnItem);
            }
            ++n;
        }
    }

    private void increaseOffsets(boolean bl, StorySpawnItem storySpawnItem) {
        float f = 0.15f + storySpawnItem.forcedOffset;
        if (bl) {
            this.xOffset += f;
            if (this.xOffset > 1.0f) {
                this.currentSquare = this.table2.getSquare();
                this.xOffset = 0.35f;
            }
            float f2 = this.yOffset;
            while (Math.abs(f2 - this.yOffset) < 0.11f) {
                this.yOffset = Rand.Next(0.5f, 1.1f);
            }
        } else {
            this.yOffset += f;
            if (this.yOffset > 1.0f) {
                this.currentSquare = this.table2.getSquare();
                this.yOffset = 0.35f;
            }
            float f3 = this.xOffset;
            while (Math.abs(f3 - this.xOffset) < 0.11f) {
                this.xOffset = Rand.Next(0.5f, 1.1f);
            }
        }
    }

    private String getItemFromSSI(StorySpawnItem storySpawnItem) {
        if (Rand.Next(100) > storySpawnItem.chanceToSpawn) {
            return null;
        }
        if (storySpawnItem.eitherObject != null && !storySpawnItem.eitherObject.isEmpty()) {
            int n = Rand.Next(100);
            int n2 = 0;
            for (String string : storySpawnItem.eitherObject.keySet()) {
                int n3 = storySpawnItem.eitherObject.get(string);
                if ((n2 += n3) < n) continue;
                return string;
            }
        } else {
            return storySpawnItem.object;
        }
        return null;
    }

    public class StorySpawnItem {
        LinkedHashMap<String, Integer> eitherObject = null;
        String object = null;
        Integer chanceToSpawn = null;
        float forcedOffset = 0.0f;

        public StorySpawnItem(LinkedHashMap<String, Integer> linkedHashMap, String string, Integer n) {
            this.eitherObject = linkedHashMap;
            this.object = string;
            this.chanceToSpawn = n;
        }

        public StorySpawnItem(LinkedHashMap<String, Integer> linkedHashMap, String string, Integer n, float f) {
            this.eitherObject = linkedHashMap;
            this.object = string;
            this.chanceToSpawn = n;
            this.forcedOffset = f;
        }
    }

    public class StoryDef {
        public ArrayList<StorySpawnItem> items = null;
        public boolean addBlood = false;
        public ArrayList<String> rooms = null;

        public StoryDef(ArrayList<StorySpawnItem> arrayList) {
            this.items = arrayList;
        }

        public StoryDef(ArrayList<StorySpawnItem> arrayList, ArrayList<String> arrayList2) {
            this.items = arrayList;
            this.rooms = arrayList2;
        }
    }
}

