/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import java.util.ArrayList;
import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.RoomDef;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBShopLooted
extends RandomizedBuildingBase {
    private final ArrayList<String> buildingList = new ArrayList();

    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        int n;
        int n2;
        buildingDef.bAlarmed = false;
        buildingDef.setAllExplored(true);
        RoomDef roomDef = null;
        for (n2 = 0; n2 < buildingDef.rooms.size(); ++n2) {
            RoomDef roomDef2 = buildingDef.rooms.get(n2);
            if (!this.buildingList.contains(roomDef2.name)) continue;
            roomDef = roomDef2;
            break;
        }
        if (roomDef == null) {
            return;
        }
        n2 = Rand.Next(3, 8);
        for (n = 0; n < n2; ++n) {
            this.addZombiesOnSquare(1, "Bandit", null, roomDef.getFreeSquare());
        }
        this.addZombiesOnSquare(2, "Police", null, roomDef.getFreeSquare());
        n = Rand.Next(3, 8);
        for (int i = 0; i < n; ++i) {
            IsoGridSquare isoGridSquare = RBShopLooted.getRandomSquareForCorpse(roomDef);
            RBShopLooted.createRandomDeadBody(isoGridSquare, null, Rand.Next(5, 10), 5, null);
        }
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        Object object;
        int n;
        this.debugLine = "";
        if (GameClient.bClient) {
            return false;
        }
        if (!this.isTimeValid(bl)) {
            return false;
        }
        if (buildingDef.isAllExplored() && !bl) {
            return false;
        }
        if (!bl) {
            if (Rand.Next(100) > this.getChance()) {
                return false;
            }
            for (n = 0; n < GameServer.Players.size(); ++n) {
                object = GameServer.Players.get(n);
                if (((IsoMovingObject)object).getSquare() == null || ((IsoMovingObject)object).getSquare().getBuilding() == null || ((IsoMovingObject)object).getSquare().getBuilding().def != buildingDef) continue;
                return false;
            }
        }
        for (n = 0; n < buildingDef.rooms.size(); ++n) {
            object = buildingDef.rooms.get(n);
            if (!this.buildingList.contains(((RoomDef)object).name)) continue;
            return true;
        }
        this.debugLine = this.debugLine + "not a shop";
        return false;
    }

    public RBShopLooted() {
        this.name = "Looted Shop";
        this.setChance(2);
        this.setAlwaysDo(true);
        this.setMaximumDays(30);
        this.buildingList.add("conveniencestore");
        this.buildingList.add("warehouse");
        this.buildingList.add("medclinic");
        this.buildingList.add("grocery");
        this.buildingList.add("zippeestore");
        this.buildingList.add("gigamart");
        this.buildingList.add("fossoil");
        this.buildingList.add("spiffo_dining");
        this.buildingList.add("pizzawhirled");
        this.buildingList.add("bookstore");
        this.buildingList.add("grocers");
        this.buildingList.add("library");
        this.buildingList.add("toolstore");
        this.buildingList.add("bar");
        this.buildingList.add("pharmacy");
        this.buildingList.add("gunstore");
        this.buildingList.add("mechanic");
        this.buildingList.add("bakery");
        this.buildingList.add("aesthetic");
        this.buildingList.add("clothesstore");
        this.buildingList.add("restaurant");
        this.buildingList.add("poststorage");
        this.buildingList.add("generalstore");
        this.buildingList.add("furniturestore");
        this.buildingList.add("fishingstorage");
        this.buildingList.add("cornerstore");
        this.buildingList.add("housewarestore");
        this.buildingList.add("shoestore");
        this.buildingList.add("sportstore");
        this.buildingList.add("giftstore");
        this.buildingList.add("candystore");
        this.buildingList.add("toystore");
        this.buildingList.add("electronicsstore");
        this.buildingList.add("sewingstore");
        this.buildingList.add("medical");
        this.buildingList.add("medicaloffice");
        this.buildingList.add("jewelrystore");
        this.buildingList.add("musicstore");
        this.buildingList.add("departmentstore");
        this.buildingList.add("gasstore");
        this.buildingList.add("gardenstore");
        this.buildingList.add("farmstorage");
        this.buildingList.add("hunting");
        this.buildingList.add("camping");
        this.buildingList.add("butcher");
        this.buildingList.add("optometrist");
        this.buildingList.add("knoxbutcher");
    }
}

