/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.inventory.ItemPickerJava;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpawnPoints;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.network.GameServer;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBSafehouse
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        buildingDef.bAlarmed = false;
        buildingDef.setHasBeenVisited(true);
        ItemPickerJava.ItemPickerRoom itemPickerRoom = (ItemPickerJava.ItemPickerRoom)ItemPickerJava.rooms.get((Object)"SafehouseLoot");
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        int n;
                        int n2;
                        boolean bl;
                        IsoBarricade isoBarricade;
                        IsoGridSquare isoGridSquare2;
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (isoObject instanceof IsoDoor && ((IsoDoor)isoObject).isBarricadeAllowed() && !SpawnPoints.instance.isSpawnBuilding(buildingDef)) {
                            IsoGridSquare isoGridSquare3 = isoGridSquare2 = isoGridSquare.getRoom() == null ? isoGridSquare : ((IsoDoor)isoObject).getOppositeSquare();
                            if (isoGridSquare2 != null && isoGridSquare2.getRoom() == null && (isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)((IsoDoor)isoObject), bl = isoGridSquare2 != isoGridSquare)) != null) {
                                n2 = Rand.Next(1, 4);
                                for (n = 0; n < n2; ++n) {
                                    isoBarricade.addPlank(null, null);
                                }
                                if (GameServer.bServer) {
                                    isoBarricade.transmitCompleteItemToClients();
                                }
                            }
                        }
                        if (isoObject instanceof IsoWindow) {
                            IsoGridSquare isoGridSquare4 = isoGridSquare2 = isoGridSquare.getRoom() == null ? isoGridSquare : ((IsoWindow)isoObject).getOppositeSquare();
                            if (((IsoWindow)isoObject).isBarricadeAllowed() && k == 0 && isoGridSquare2 != null && isoGridSquare2.getRoom() == null) {
                                bl = isoGridSquare2 != isoGridSquare;
                                isoBarricade = IsoBarricade.AddBarricadeToObject((BarricadeAble)((IsoWindow)isoObject), bl);
                                if (isoBarricade != null) {
                                    n2 = Rand.Next(1, 4);
                                    for (n = 0; n < n2; ++n) {
                                        isoBarricade.addPlank(null, null);
                                    }
                                    if (GameServer.bServer) {
                                        isoBarricade.transmitCompleteItemToClients();
                                    }
                                }
                            } else {
                                ((IsoWindow)isoObject).addSheet(null);
                                ((IsoWindow)isoObject).HasCurtains().ToggleDoor(null);
                            }
                        }
                        if (isoObject.getContainer() == null || isoGridSquare.getRoom() == null || isoGridSquare.getRoom().getBuilding().getDef() != buildingDef || Rand.Next(100) > 70 || isoGridSquare.getRoom().getName() == null || !itemPickerRoom.Containers.containsKey((Object)isoObject.getContainer().getType())) continue;
                        isoObject.getContainer().clear();
                        ItemPickerJava.fillContainerType(itemPickerRoom, isoObject.getContainer(), "", null);
                        ItemPickerJava.updateOverlaySprite(isoObject);
                        isoObject.getContainer().setExplored(true);
                    }
                }
            }
        }
        buildingDef.setAllExplored(true);
        buildingDef.bAlarmed = false;
        this.addZombies(buildingDef);
    }

    private void addZombies(BuildingDef buildingDef) {
        this.addZombies(buildingDef, 0, null, null, null);
        if (Rand.Next(5) == 0) {
            this.addZombies(buildingDef, 1, "Survivalist", null, null);
        }
        if (Rand.Next(100) <= 60) {
            RandomizedBuildingBase.createRandomDeadBody(this.getLivingRoomOrKitchen(buildingDef), Rand.Next(3, 7));
        }
        if (Rand.Next(100) <= 60) {
            RandomizedBuildingBase.createRandomDeadBody(this.getLivingRoomOrKitchen(buildingDef), Rand.Next(3, 7));
        }
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        if (!super.isValid(buildingDef, bl)) {
            return false;
        }
        if (buildingDef.getRooms().size() > 20) {
            return false;
        }
        return !SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    public RBSafehouse() {
        this.name = "Safehouse";
        this.setChance(10);
    }
}

