/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBPileOCrepe
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!Rand.NextBool(3) || !this.isTableFor3DItems(isoObject, isoGridSquare)) continue;
                        if (Rand.NextBool(2)) {
                            this.addWorldItem("WafflesRecipe", isoGridSquare, isoObject);
                        } else {
                            this.addWorldItem("PancakesRecipe", isoGridSquare, isoObject);
                        }
                        if (Rand.NextBool(3)) {
                            this.addWorldItem("Fork", isoGridSquare, isoObject);
                        }
                        if (!Rand.NextBool(3)) continue;
                        this.addWorldItem("ButterKnife", isoGridSquare, isoObject);
                    }
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && ("pileocrepe".equals(isoGridSquare.getRoom().getName()) || "kitchen_crepe".equals(isoGridSquare.getRoom().getName()));
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("pileocrepe") != null || buildingDef.getRoom("kitchen_crepe") != null || bl;
    }

    public RBPileOCrepe() {
        this.name = "PileOCrepe Restaurant";
        this.setAlwaysDo(true);
    }
}

