/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.inventory.ItemPickerJava;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpawnPoints;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBOther
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        buildingDef.bAlarmed = false;
        buildingDef.setHasBeenVisited(true);
        buildingDef.setAllExplored(true);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (isoObject.getContainer() == null) continue;
                        isoObject.getContainer().emptyIt();
                        isoObject.getContainer().AddItems("Base.ToiletPaper", Rand.Next(10, 30));
                        ItemPickerJava.updateOverlaySprite(isoObject);
                    }
                }
            }
        }
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        if (!super.isValid(buildingDef, bl)) {
            return false;
        }
        if (buildingDef.getRooms().size() > 10) {
            return false;
        }
        return !SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    public RBOther() {
        this.name = "Other";
        this.setChance(1);
        this.setUnique(true);
    }
}

