/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBHairSalon
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    block16: for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!Rand.NextBool(3) || !(isoObject.getSurfaceOffsetNoTable() > 0.0f) || isoGridSquare.getProperties().Val("waterAmount") != null || isoObject.hasWater() || isoObject.getProperties().Val("BedType") != null) continue;
                        int n = Rand.Next(12);
                        switch (n) {
                            case 0: {
                                this.addWorldItem("Comb", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 1: {
                                this.addWorldItem("HairDyeBlonde", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 2: {
                                this.addWorldItem("HairDyeBlack", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 3: {
                                this.addWorldItem("HairDyeWhite", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 5: {
                                this.addWorldItem("HairDyePink", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 6: {
                                this.addWorldItem("HairDyeYellow", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 7: {
                                this.addWorldItem("HairDyeRed", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 8: {
                                this.addWorldItem("HairDyeGinger", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 9: {
                                this.addWorldItem("Hairgel", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 10: {
                                this.addWorldItem("Hairspray", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                continue block16;
                            }
                            case 11: {
                                this.addWorldItem("Razor", isoGridSquare, 0.5f, 0.5f, isoObject.getSurfaceOffsetNoTable() / 96.0f);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && "aesthetic".equals(isoGridSquare.getRoom().getName());
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("aesthetic") != null || bl;
    }

    public RBHairSalon() {
        this.name = "Hair Salon";
        this.setAlwaysDo(true);
    }
}

