/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBClinic
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || !this.roomValid(isoGridSquare)) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getObjects().size(); ++i2) {
                        IsoObject isoObject = isoGridSquare.getObjects().get(i2);
                        if (!Rand.NextBool(2) || !(isoObject.getSurfaceOffsetNoTable() > 0.0f) || isoObject.getContainer() != null || isoGridSquare.getProperties().Val("waterAmount") != null || isoObject.hasWater()) continue;
                        int n = Rand.Next(1, 3);
                        block18: for (int i3 = 0; i3 < n; ++i3) {
                            int n2 = Rand.Next(12);
                            switch (n2) {
                                case 0: {
                                    this.addWorldItem("Scalpel", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 1: {
                                    this.addWorldItem("Bandage", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 2: {
                                    this.addWorldItem("Pills", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 3: {
                                    this.addWorldItem("AlcoholWipes", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 4: {
                                    this.addWorldItem("Bandaid", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 5: {
                                    this.addWorldItem("CottonBalls", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 6: {
                                    this.addWorldItem("Disinfectant", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 7: {
                                    this.addWorldItem("SutureNeedle", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 8: {
                                    this.addWorldItem("SutureNeedleHolder", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 9: {
                                    this.addWorldItem("Tweezers", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 10: {
                                    this.addWorldItem("Gloves_Surgical", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                    continue block18;
                                }
                                case 11: {
                                    this.addWorldItem("Hat_SurgicalMask_Blue", isoGridSquare, Rand.Next(0.4f, 0.6f), Rand.Next(0.4f, 0.6f), isoObject.getSurfaceOffsetNoTable() / 96.0f);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean roomValid(IsoGridSquare isoGridSquare) {
        return isoGridSquare.getRoom() != null && ("hospitalroom".equals(isoGridSquare.getRoom().getName()) || "clinic".equals(isoGridSquare.getRoom().getName()) || "medical".equals(isoGridSquare.getRoom().getName()));
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        return buildingDef.getRoom("medical") != null || buildingDef.getRoom("clinic") != null || bl;
    }

    public RBClinic() {
        this.name = "Clinic (Vet, Doctor..)";
        this.setAlwaysDo(true);
    }
}

