/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld.randomizedBuilding;

import zombie.core.Rand;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.SpawnPoints;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;

public final class RBBurnt
extends RandomizedBuildingBase {
    @Override
    public void randomizeBuilding(BuildingDef buildingDef) {
        buildingDef.bAlarmed = false;
        buildingDef.setHasBeenVisited(true);
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = buildingDef.x - 1; i < buildingDef.x2 + 1; ++i) {
            for (int j = buildingDef.y - 1; j < buildingDef.y2 + 1; ++j) {
                for (int k = 0; k < 8; ++k) {
                    IsoGridSquare isoGridSquare = isoCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null || Rand.Next(100) >= 90) continue;
                    isoGridSquare.Burn(false);
                }
            }
        }
        buildingDef.setAllExplored(true);
        buildingDef.bAlarmed = false;
    }

    @Override
    public boolean isValid(BuildingDef buildingDef, boolean bl) {
        if (!super.isValid(buildingDef, bl)) {
            return false;
        }
        if (buildingDef.getRooms().size() > 20) {
            return false;
        }
        return !SpawnPoints.instance.isSpawnBuilding(buildingDef);
    }

    public RBBurnt() {
        this.name = "Burnt";
        this.setChance(3);
    }
}

