/*
 * Decompiled with CFR 0.152.
 */
package zombie.randomizedWorld;

import java.util.ArrayList;
import zombie.GameTime;
import zombie.Lua.MapObjects;
import zombie.SandboxOptions;
import zombie.VirtualZombieManager;
import zombie.ZombieSpawnRecorder;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoZombie;
import zombie.characters.SurvivorFactory;
import zombie.core.Rand;
import zombie.core.skinnedmodel.population.Outfit;
import zombie.core.skinnedmodel.visual.HumanVisual;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoZombieGiblets;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;
import zombie.util.StringUtils;
import zombie.util.list.PZArrayUtil;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleType;
import zombie.vehicles.VehiclesDB2;

public class RandomizedWorldBase {
    private static final Vector2 s_tempVector2 = new Vector2();
    protected int minimumDays = 0;
    protected int maximumDays = 0;
    protected int minimumRooms = 0;
    protected boolean unique = false;
    private boolean rvsVehicleKeyAddedToZombie = false;
    protected String name = null;
    protected String debugLine = "";

    public BaseVehicle addVehicle(IsoMetaGrid.Zone zone, IsoGridSquare isoGridSquare, IsoChunk isoChunk, String string, String string2, IsoDirections isoDirections) {
        return this.addVehicle(zone, isoGridSquare, isoChunk, string, string2, null, isoDirections, null);
    }

    public BaseVehicle addVehicleFlipped(IsoMetaGrid.Zone zone, IsoGridSquare isoGridSquare, IsoChunk isoChunk, String string, String string2, Integer n, IsoDirections isoDirections, String string3) {
        if (isoGridSquare == null) {
            return null;
        }
        if (isoDirections == null) {
            isoDirections = IsoDirections.getRandom();
        }
        Vector2 vector22 = isoDirections.ToVector();
        return this.addVehicleFlipped(zone, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, vector22.getDirection(), string, string2, n, string3);
    }

    public BaseVehicle addVehicleFlipped(IsoMetaGrid.Zone zone, float f, float f2, float f3, float f4, String string, String string2, Integer n, String string3) {
        IsoGridSquare isoGridSquare;
        if (StringUtils.isNullOrEmpty(string)) {
            string = "junkyard";
        }
        if ((isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, f3)) == null) {
            return null;
        }
        IsoChunk isoChunk = isoGridSquare.getChunk();
        IsoDirections isoDirections = IsoDirections.fromAngle(f4);
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.specificDistributionId = string3;
        VehicleType vehicleType = VehicleType.getRandomVehicleType(string, false);
        if (!StringUtils.isNullOrEmpty(string2)) {
            baseVehicle.setScriptName(string2);
            baseVehicle.setScript();
            if (n != null) {
                baseVehicle.setSkinIndex(n);
            }
        } else {
            if (vehicleType == null) {
                return null;
            }
            baseVehicle.setVehicleType(vehicleType.name);
            if (!isoChunk.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                return null;
            }
        }
        if (vehicleType.isSpecialCar) {
            baseVehicle.setDoColor(false);
        }
        baseVehicle.setDir(isoDirections);
        float f5 = f4 - 1.5707964f;
        while ((double)f5 > Math.PI * 2) {
            f5 = (float)((double)f5 - Math.PI * 2);
        }
        baseVehicle.savedRot.rotationXYZ(0.0f, -f5, (float)Math.PI);
        baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
        baseVehicle.setX(f);
        baseVehicle.setY(f2);
        baseVehicle.setZ(f3);
        if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle)) {
            baseVehicle.setSquare(isoGridSquare);
            isoGridSquare.chunk.vehicles.add(baseVehicle);
            baseVehicle.chunk = isoGridSquare.chunk;
            baseVehicle.addToWorld();
            VehiclesDB2.instance.addVehicle(baseVehicle);
        }
        baseVehicle.setGeneralPartCondition(0.2f, 70.0f);
        baseVehicle.rust = Rand.Next(100) < 70 ? 1.0f : 0.0f;
        return baseVehicle;
    }

    public BaseVehicle addVehicle(IsoMetaGrid.Zone zone, IsoGridSquare isoGridSquare, IsoChunk isoChunk, String string, String string2, Integer n, IsoDirections isoDirections, String string3) {
        if (isoGridSquare == null) {
            return null;
        }
        if (isoDirections == null) {
            isoDirections = IsoDirections.getRandom();
        }
        Vector2 vector22 = isoDirections.ToVector();
        vector22.rotate(Rand.Next(-0.5f, 0.5f));
        return this.addVehicle(zone, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, vector22.getDirection(), string, string2, n, string3);
    }

    public BaseVehicle addVehicle(IsoMetaGrid.Zone zone, float f, float f2, float f3, float f4, String string, String string2, Integer n, String string3) {
        IsoGridSquare isoGridSquare;
        if (StringUtils.isNullOrEmpty(string)) {
            string = "junkyard";
        }
        if ((isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(f, f2, f3)) == null) {
            return null;
        }
        IsoChunk isoChunk = isoGridSquare.getChunk();
        IsoDirections isoDirections = IsoDirections.fromAngle(f4);
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.specificDistributionId = string3;
        VehicleType vehicleType = VehicleType.getRandomVehicleType(string, false);
        if (!StringUtils.isNullOrEmpty(string2)) {
            baseVehicle.setScriptName(string2);
            baseVehicle.setScript();
            if (n != null) {
                baseVehicle.setSkinIndex(n);
            }
        } else {
            if (vehicleType == null) {
                return null;
            }
            baseVehicle.setVehicleType(vehicleType.name);
            if (!isoChunk.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                return null;
            }
        }
        if (vehicleType.isSpecialCar) {
            baseVehicle.setDoColor(false);
        }
        baseVehicle.setDir(isoDirections);
        float f5 = f4 - 1.5707964f;
        while ((double)f5 > Math.PI * 2) {
            f5 = (float)((double)f5 - Math.PI * 2);
        }
        baseVehicle.savedRot.setAngleAxis(-f5, 0.0f, 1.0f, 0.0f);
        baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
        baseVehicle.setX(f);
        baseVehicle.setY(f2);
        baseVehicle.setZ(f3);
        if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle)) {
            baseVehicle.setSquare(isoGridSquare);
            isoGridSquare.chunk.vehicles.add(baseVehicle);
            baseVehicle.chunk = isoGridSquare.chunk;
            baseVehicle.addToWorld();
            VehiclesDB2.instance.addVehicle(baseVehicle);
        }
        baseVehicle.setGeneralPartCondition(0.2f, 70.0f);
        baseVehicle.rust = Rand.Next(100) < 70 ? 1.0f : 0.0f;
        return baseVehicle;
    }

    public static void removeAllVehiclesOnZone(IsoMetaGrid.Zone zone) {
        for (int i = zone.x; i < zone.x + zone.w; ++i) {
            for (int j = zone.y; j < zone.y + zone.h; ++j) {
                BaseVehicle baseVehicle;
                IsoGridSquare isoGridSquare = IsoCell.getInstance().getGridSquare(i, j, 0);
                if (isoGridSquare == null || (baseVehicle = isoGridSquare.getVehicleContainer()) == null) continue;
                baseVehicle.permanentlyRemove();
            }
        }
    }

    public ArrayList<IsoZombie> addZombiesOnVehicle(int n, String string, Integer n2, BaseVehicle baseVehicle) {
        Object object;
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        if (baseVehicle == null) {
            return arrayList;
        }
        int n3 = 100;
        IsoGridSquare isoGridSquare = baseVehicle.getSquare();
        if (isoGridSquare == null || isoGridSquare.getCell() == null) {
            return arrayList;
        }
        while (n > 0) {
            while (n3 > 0) {
                object = isoGridSquare.getCell().getGridSquare(Rand.Next(isoGridSquare.x - 4, isoGridSquare.x + 4), Rand.Next(isoGridSquare.y - 4, isoGridSquare.y + 4), isoGridSquare.z);
                if (object != null && ((IsoGridSquare)object).getVehicleContainer() == null) {
                    --n;
                    arrayList.addAll(this.addZombiesOnSquare(1, string, n2, (IsoGridSquare)object));
                    break;
                }
                --n3;
            }
            n3 = 100;
        }
        if (!this.rvsVehicleKeyAddedToZombie && !arrayList.isEmpty()) {
            object = arrayList.get(Rand.Next(0, arrayList.size()));
            ((IsoZombie)object).addItemToSpawnAtDeath(baseVehicle.createVehicleKey());
            this.rvsVehicleKeyAddedToZombie = true;
        }
        return arrayList;
    }

    public static IsoDeadBody createRandomDeadBody(RoomDef roomDef, int n) {
        if (IsoWorld.getZombiesDisabled()) {
            return null;
        }
        if (roomDef == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = RandomizedWorldBase.getRandomSquareForCorpse(roomDef);
        if (isoGridSquare == null) {
            return null;
        }
        return RandomizedWorldBase.createRandomDeadBody(isoGridSquare, null, n, 0, null);
    }

    public ArrayList<IsoZombie> addZombiesOnSquare(int n, String string, Integer n2, IsoGridSquare isoGridSquare) {
        ArrayList<IsoZombie> arrayList = new ArrayList<IsoZombie>();
        if (IsoWorld.getZombiesDisabled()) {
            return arrayList;
        }
        if (isoGridSquare == null) {
            return arrayList;
        }
        for (int i = 0; i < n; ++i) {
            VirtualZombieManager.instance.choices.clear();
            VirtualZombieManager.instance.choices.add(isoGridSquare);
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(IsoDirections.getRandom().index(), false);
            if (isoZombie == null) continue;
            if (n2 != null) {
                isoZombie.setFemaleEtc(Rand.Next(100) < n2);
            }
            if (string != null) {
                isoZombie.dressInPersistentOutfit(string);
                isoZombie.bDressInRandomOutfit = false;
            } else {
                isoZombie.dressInRandomOutfit();
                isoZombie.bDressInRandomOutfit = false;
            }
            arrayList.add(isoZombie);
        }
        ZombieSpawnRecorder.instance.record(arrayList, this.getClass().getSimpleName());
        return arrayList;
    }

    public static IsoDeadBody createRandomDeadBody(int n, int n2, int n3, IsoDirections isoDirections, int n4) {
        return RandomizedWorldBase.createRandomDeadBody(n, n2, n3, isoDirections, n4, 0);
    }

    public static IsoDeadBody createRandomDeadBody(int n, int n2, int n3, IsoDirections isoDirections, int n4, int n5) {
        IsoGridSquare isoGridSquare = IsoCell.getInstance().getGridSquare(n, n2, n3);
        return RandomizedWorldBase.createRandomDeadBody(isoGridSquare, isoDirections, n4, n5, null);
    }

    public static IsoDeadBody createRandomDeadBody(IsoGridSquare isoGridSquare, IsoDirections isoDirections, int n, int n2, String string) {
        boolean bl;
        if (isoGridSquare == null) {
            return null;
        }
        boolean bl2 = bl = isoDirections == null;
        if (bl) {
            isoDirections = IsoDirections.getRandom();
        }
        return RandomizedWorldBase.createRandomDeadBody((float)isoGridSquare.x + Rand.Next(0.05f, 0.95f), (float)isoGridSquare.y + Rand.Next(0.05f, 0.95f), isoGridSquare.z, isoDirections.ToVector().getDirection(), bl, n, n2, string);
    }

    public static IsoDeadBody createRandomDeadBody(float f, float f2, float f3, float f4, boolean bl, int n, int n2, String string) {
        IsoDeadBody isoDeadBody;
        if (IsoWorld.getZombiesDisabled()) {
            return null;
        }
        IsoGridSquare isoGridSquare = IsoCell.getInstance().getGridSquare(f, f2, f3);
        if (isoGridSquare == null) {
            return null;
        }
        IsoDirections isoDirections = IsoDirections.fromAngle(f4);
        VirtualZombieManager.instance.choices.clear();
        VirtualZombieManager.instance.choices.add(isoGridSquare);
        IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(isoDirections.index(), false);
        if (isoZombie == null) {
            return null;
        }
        if (string != null) {
            isoZombie.dressInPersistentOutfit(string);
            isoZombie.bDressInRandomOutfit = false;
        } else {
            isoZombie.dressInRandomOutfit();
        }
        if (Rand.Next(100) < n2) {
            isoZombie.setFakeDead(true);
            isoZombie.setCrawler(true);
            isoZombie.setCanWalk(false);
            isoZombie.setCrawlerType(1);
        } else {
            isoZombie.setFakeDead(false);
            isoZombie.setHealth(0.0f);
        }
        isoZombie.upKillCount = false;
        isoZombie.getHumanVisual().zombieRotStage = ((HumanVisual)isoZombie.getVisual()).pickRandomZombieRotStage();
        for (int i = 0; i < n; ++i) {
            isoZombie.addBlood(null, false, true, true);
        }
        isoZombie.DoCorpseInventory();
        isoZombie.setX(f);
        isoZombie.setY(f2);
        isoZombie.getForwardDirection().setLengthAndDirection(f4, 1.0f);
        if (bl || isoZombie.isSkeleton()) {
            RandomizedWorldBase.alignCorpseToSquare(isoZombie, isoGridSquare);
        }
        if (!(isoDeadBody = new IsoDeadBody(isoZombie, true)).isFakeDead() && !isoDeadBody.isSkeleton() && Rand.Next(20) == 0) {
            isoDeadBody.setFakeDead(true);
            if (Rand.Next(5) == 0) {
                isoDeadBody.setCrawling(true);
            }
        }
        return isoDeadBody;
    }

    public void addTraitOfBlood(IsoDirections isoDirections, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n; ++i) {
            float f = 0.0f;
            float f2 = 0.0f;
            if (isoDirections == IsoDirections.S) {
                f2 = Rand.Next(-2.0f, 0.5f);
            }
            if (isoDirections == IsoDirections.N) {
                f2 = Rand.Next(-0.5f, 2.0f);
            }
            if (isoDirections == IsoDirections.E) {
                f = Rand.Next(-2.0f, 0.5f);
            }
            if (isoDirections == IsoDirections.W) {
                f = Rand.Next(-0.5f, 2.0f);
            }
            new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, IsoCell.getInstance(), n2, n3, (float)n4 + 0.2f, f, f2);
        }
    }

    public void addTrailOfBlood(float f, float f2, float f3, float f4, int n) {
        Vector2 vector22 = s_tempVector2;
        for (int i = 0; i < n; ++i) {
            float f5 = Rand.Next(-0.5f, 2.0f);
            if (f5 < 0.0f) {
                vector22.setLengthAndDirection(f4 + (float)Math.PI, -f5);
            } else {
                vector22.setLengthAndDirection(f4, f5);
            }
            new IsoZombieGiblets(IsoZombieGiblets.GibletType.A, IsoCell.getInstance(), f, f2, f3 + 0.2f, vector22.x, vector22.y);
        }
    }

    public void addBloodSplat(IsoGridSquare isoGridSquare, int n) {
        for (int i = 0; i < n; ++i) {
            isoGridSquare.getChunk().addBloodSplat((float)isoGridSquare.x + Rand.Next(-0.5f, 0.5f), (float)isoGridSquare.y + Rand.Next(-0.5f, 0.5f), isoGridSquare.z, Rand.Next(8));
        }
    }

    public void setAttachedItem(IsoZombie isoZombie, String string, String string2, String string3) {
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string2);
        if (inventoryItem == null) {
            return;
        }
        inventoryItem.setCondition(Rand.Next(Math.max(2, inventoryItem.getConditionMax() - 5), inventoryItem.getConditionMax()));
        if (inventoryItem instanceof HandWeapon) {
            ((HandWeapon)inventoryItem).randomizeBullets();
        }
        isoZombie.setAttachedItem(string, inventoryItem);
        if (!StringUtils.isNullOrEmpty(string3)) {
            isoZombie.addItemToSpawnAtDeath(InventoryItemFactory.CreateItem(string3));
        }
    }

    public static IsoGameCharacter createRandomZombie(RoomDef roomDef) {
        IsoGridSquare isoGridSquare = RandomizedWorldBase.getRandomSpawnSquare(roomDef);
        return RandomizedWorldBase.createRandomZombie(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
    }

    public static IsoGameCharacter createRandomZombieForCorpse(RoomDef roomDef) {
        IsoGridSquare isoGridSquare = RandomizedWorldBase.getRandomSquareForCorpse(roomDef);
        if (isoGridSquare == null) {
            return null;
        }
        IsoGameCharacter isoGameCharacter = RandomizedWorldBase.createRandomZombie(isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ());
        if (isoGameCharacter != null) {
            RandomizedWorldBase.alignCorpseToSquare(isoGameCharacter, isoGridSquare);
        }
        return isoGameCharacter;
    }

    public static IsoDeadBody createBodyFromZombie(IsoGameCharacter isoGameCharacter) {
        if (IsoWorld.getZombiesDisabled()) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            isoGameCharacter.splatBlood(Rand.Next(1, 4), 0.3f);
        }
        IsoDeadBody isoDeadBody = new IsoDeadBody(isoGameCharacter, true);
        return isoDeadBody;
    }

    public static IsoGameCharacter createRandomZombie(int n, int n2, int n3) {
        RandomizedBuildingBase.HumanCorpse humanCorpse = new RandomizedBuildingBase.HumanCorpse(IsoWorld.instance.getCell(), n, n2, n3);
        humanCorpse.setDescriptor(SurvivorFactory.CreateSurvivor());
        humanCorpse.setFemale(humanCorpse.getDescriptor().isFemale());
        humanCorpse.setDir(IsoDirections.fromIndex(Rand.Next(8)));
        humanCorpse.initWornItems("Human");
        humanCorpse.initAttachedItems("Human");
        Outfit outfit = humanCorpse.getRandomDefaultOutfit();
        ((IsoGameCharacter)humanCorpse).dressInNamedOutfit(outfit.m_Name);
        humanCorpse.initSpritePartsEmpty();
        ((IsoGameCharacter)humanCorpse).Dressup(humanCorpse.getDescriptor());
        return humanCorpse;
    }

    private static boolean isSquareClear(IsoGridSquare isoGridSquare) {
        return isoGridSquare != null && RandomizedWorldBase.canSpawnAt(isoGridSquare) && !isoGridSquare.HasStairs() && !isoGridSquare.HasTree() && !isoGridSquare.getProperties().Is(IsoFlagType.bed) && !isoGridSquare.getProperties().Is(IsoFlagType.waterPiped);
    }

    private static boolean isSquareClear(IsoGridSquare isoGridSquare, IsoDirections isoDirections) {
        IsoGridSquare isoGridSquare2 = isoGridSquare.getAdjacentSquare(isoDirections);
        return RandomizedWorldBase.isSquareClear(isoGridSquare2) && !isoGridSquare.isSomethingTo(isoGridSquare2) && isoGridSquare.getRoomID() == isoGridSquare2.getRoomID();
    }

    public static boolean is1x2AreaClear(IsoGridSquare isoGridSquare) {
        return RandomizedWorldBase.isSquareClear(isoGridSquare) && RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.N);
    }

    public static boolean is2x1AreaClear(IsoGridSquare isoGridSquare) {
        return RandomizedWorldBase.isSquareClear(isoGridSquare) && RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.W);
    }

    public static boolean is2x1or1x2AreaClear(IsoGridSquare isoGridSquare) {
        return RandomizedWorldBase.isSquareClear(isoGridSquare) && (RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.W) || RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.N));
    }

    public static boolean is2x2AreaClear(IsoGridSquare isoGridSquare) {
        return RandomizedWorldBase.isSquareClear(isoGridSquare) && RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.N) && RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.W) && RandomizedWorldBase.isSquareClear(isoGridSquare, IsoDirections.NW);
    }

    public static void alignCorpseToSquare(IsoGameCharacter isoGameCharacter, IsoGridSquare isoGridSquare) {
        int n = isoGridSquare.x;
        int n2 = isoGridSquare.y;
        IsoDirections isoDirections = IsoDirections.fromIndex(Rand.Next(8));
        boolean bl = RandomizedWorldBase.is1x2AreaClear(isoGridSquare);
        boolean bl2 = RandomizedWorldBase.is2x1AreaClear(isoGridSquare);
        if (bl && bl2) {
            bl = Rand.Next(2) == 0;
            boolean bl3 = bl2 = !bl;
        }
        if (RandomizedWorldBase.is2x2AreaClear(isoGridSquare)) {
            isoGameCharacter.setX(n);
            isoGameCharacter.setY(n2);
        } else if (bl) {
            isoGameCharacter.setX((float)n + 0.5f);
            isoGameCharacter.setY(n2);
            isoDirections = Rand.Next(2) == 0 ? IsoDirections.N : IsoDirections.S;
        } else if (bl2) {
            isoGameCharacter.setX(n);
            isoGameCharacter.setY((float)n2 + 0.5f);
            isoDirections = Rand.Next(2) == 0 ? IsoDirections.W : IsoDirections.E;
        } else if (RandomizedWorldBase.is1x2AreaClear(isoGridSquare.getAdjacentSquare(IsoDirections.S))) {
            isoGameCharacter.setX((float)n + 0.5f);
            isoGameCharacter.setY((float)n2 + 0.99f);
            isoDirections = Rand.Next(2) == 0 ? IsoDirections.N : IsoDirections.S;
        } else if (RandomizedWorldBase.is2x1AreaClear(isoGridSquare.getAdjacentSquare(IsoDirections.E))) {
            isoGameCharacter.setX((float)n + 0.99f);
            isoGameCharacter.setY((float)n2 + 0.5f);
            isoDirections = Rand.Next(2) == 0 ? IsoDirections.W : IsoDirections.E;
        }
        isoGameCharacter.setDir(isoDirections);
        isoGameCharacter.lx = isoGameCharacter.nx = isoGameCharacter.x;
        isoGameCharacter.ly = isoGameCharacter.ny = isoGameCharacter.y;
        isoGameCharacter.setScriptnx(isoGameCharacter.x);
        isoGameCharacter.setScriptny(isoGameCharacter.y);
    }

    public RoomDef getRandomRoom(BuildingDef buildingDef, int n) {
        RoomDef roomDef = buildingDef.getRooms().get(Rand.Next(0, buildingDef.getRooms().size()));
        if (n > 0 && roomDef.area >= n) {
            return roomDef;
        }
        for (int i = 0; i <= 20; ++i) {
            roomDef = buildingDef.getRooms().get(Rand.Next(0, buildingDef.getRooms().size()));
            if (roomDef.area < n) continue;
            return roomDef;
        }
        return roomDef;
    }

    public RoomDef getRoom(BuildingDef buildingDef, String string) {
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            RoomDef roomDef = buildingDef.rooms.get(i);
            if (!roomDef.getName().equalsIgnoreCase(string)) continue;
            return roomDef;
        }
        return null;
    }

    public RoomDef getLivingRoomOrKitchen(BuildingDef buildingDef) {
        RoomDef roomDef = this.getRoom(buildingDef, "livingroom");
        if (roomDef == null) {
            roomDef = this.getRoom(buildingDef, "kitchen");
        }
        return roomDef;
    }

    private static boolean canSpawnAt(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        if (isoGridSquare.HasStairs()) {
            return false;
        }
        return VirtualZombieManager.instance.canSpawnAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
    }

    public static IsoGridSquare getRandomSpawnSquare(RoomDef roomDef) {
        if (roomDef == null) {
            return null;
        }
        return roomDef.getRandomSquare(RandomizedWorldBase::canSpawnAt);
    }

    public static IsoGridSquare getRandomSquareForCorpse(RoomDef roomDef) {
        IsoGridSquare isoGridSquare = roomDef.getRandomSquare(RandomizedWorldBase::is2x2AreaClear);
        IsoGridSquare isoGridSquare2 = roomDef.getRandomSquare(RandomizedWorldBase::is2x1or1x2AreaClear);
        if (isoGridSquare == null || isoGridSquare2 != null && Rand.Next(4) == 0) {
            isoGridSquare = isoGridSquare2;
        }
        return isoGridSquare;
    }

    public BaseVehicle spawnCarOnNearestNav(String string, BuildingDef buildingDef) {
        IsoGridSquare isoGridSquare;
        int n;
        IsoGridSquare isoGridSquare2 = null;
        int n2 = (buildingDef.x + buildingDef.x2) / 2;
        int n3 = (buildingDef.y + buildingDef.y2) / 2;
        for (n = n2; n < n2 + 20; ++n) {
            isoGridSquare = IsoCell.getInstance().getGridSquare(n, n3, 0);
            if (isoGridSquare == null || !"Nav".equals(isoGridSquare.getZoneType())) continue;
            isoGridSquare2 = isoGridSquare;
            break;
        }
        if (isoGridSquare2 != null) {
            return this.spawnCar(string, isoGridSquare2);
        }
        for (n = n2; n > n2 - 20; --n) {
            isoGridSquare = IsoCell.getInstance().getGridSquare(n, n3, 0);
            if (isoGridSquare == null || !"Nav".equals(isoGridSquare.getZoneType())) continue;
            isoGridSquare2 = isoGridSquare;
            break;
        }
        if (isoGridSquare2 != null) {
            return this.spawnCar(string, isoGridSquare2);
        }
        for (n = n3; n < n3 + 20; ++n) {
            isoGridSquare = IsoCell.getInstance().getGridSquare(n2, n, 0);
            if (isoGridSquare == null || !"Nav".equals(isoGridSquare.getZoneType())) continue;
            isoGridSquare2 = isoGridSquare;
            break;
        }
        if (isoGridSquare2 != null) {
            return this.spawnCar(string, isoGridSquare2);
        }
        for (n = n3; n > n3 - 20; --n) {
            isoGridSquare = IsoCell.getInstance().getGridSquare(n2, n, 0);
            if (isoGridSquare == null || !"Nav".equals(isoGridSquare.getZoneType())) continue;
            isoGridSquare2 = isoGridSquare;
            break;
        }
        if (isoGridSquare2 != null) {
            return this.spawnCar(string, isoGridSquare2);
        }
        return null;
    }

    private BaseVehicle spawnCar(String string, IsoGridSquare isoGridSquare) {
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.setScriptName(string);
        baseVehicle.setX((float)isoGridSquare.x + 0.5f);
        baseVehicle.setY((float)isoGridSquare.y + 0.5f);
        baseVehicle.setZ(0.0f);
        baseVehicle.savedRot.setAngleAxis(Rand.Next(0.0f, (float)Math.PI * 2), 0.0f, 1.0f, 0.0f);
        baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
        if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle)) {
            baseVehicle.keySpawned = 1;
            baseVehicle.setSquare(isoGridSquare);
            baseVehicle.square.chunk.vehicles.add(baseVehicle);
            baseVehicle.chunk = baseVehicle.square.chunk;
            baseVehicle.addToWorld();
            VehiclesDB2.instance.addVehicle(baseVehicle);
        }
        baseVehicle.setGeneralPartCondition(0.3f, 70.0f);
        return baseVehicle;
    }

    public InventoryItem addItemOnGround(IsoGridSquare isoGridSquare, String string) {
        if (isoGridSquare == null || StringUtils.isNullOrWhitespace(string)) {
            return null;
        }
        return isoGridSquare.AddWorldInventoryItem(string, Rand.Next(0.2f, 0.8f), Rand.Next(0.2f, 0.8f), 0.0f);
    }

    public InventoryItem addItemOnGround(IsoGridSquare isoGridSquare, InventoryItem inventoryItem) {
        if (isoGridSquare == null || inventoryItem == null) {
            return null;
        }
        return isoGridSquare.AddWorldInventoryItem(inventoryItem, Rand.Next(0.2f, 0.8f), Rand.Next(0.2f, 0.8f), 0.0f);
    }

    public void addRandomItemsOnGround(RoomDef roomDef, String string, int n) {
        for (int i = 0; i < n; ++i) {
            IsoGridSquare isoGridSquare = RandomizedWorldBase.getRandomSpawnSquare(roomDef);
            this.addItemOnGround(isoGridSquare, string);
        }
    }

    public void addRandomItemsOnGround(RoomDef roomDef, ArrayList<String> arrayList, int n) {
        for (int i = 0; i < n; ++i) {
            IsoGridSquare isoGridSquare = RandomizedWorldBase.getRandomSpawnSquare(roomDef);
            this.addRandomItemOnGround(isoGridSquare, arrayList);
        }
    }

    public InventoryItem addRandomItemOnGround(IsoGridSquare isoGridSquare, ArrayList<String> arrayList) {
        if (isoGridSquare == null || arrayList.isEmpty()) {
            return null;
        }
        String string = PZArrayUtil.pickRandom(arrayList);
        return this.addItemOnGround(isoGridSquare, string);
    }

    public HandWeapon addWeapon(String string, boolean bl) {
        HandWeapon handWeapon = (HandWeapon)InventoryItemFactory.CreateItem(string);
        if (handWeapon == null) {
            return null;
        }
        if (handWeapon.isRanged() && bl) {
            if (!StringUtils.isNullOrWhitespace(handWeapon.getMagazineType())) {
                handWeapon.setContainsClip(true);
            }
            handWeapon.setCurrentAmmoCount(Rand.Next(Math.max(handWeapon.getMaxAmmo() - 8, 0), handWeapon.getMaxAmmo() - 2));
        }
        return handWeapon;
    }

    public IsoDeadBody createSkeletonCorpse(RoomDef roomDef) {
        if (roomDef == null) {
            return null;
        }
        IsoGridSquare isoGridSquare = roomDef.getRandomSquare(RandomizedWorldBase::is2x1or1x2AreaClear);
        if (isoGridSquare == null) {
            return null;
        }
        VirtualZombieManager.instance.choices.clear();
        VirtualZombieManager.instance.choices.add(isoGridSquare);
        IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(Rand.Next(8), false);
        if (isoZombie == null) {
            return null;
        }
        ZombieSpawnRecorder.instance.record(isoZombie, this.getClass().getSimpleName());
        RandomizedWorldBase.alignCorpseToSquare(isoZombie, isoGridSquare);
        isoZombie.setFakeDead(false);
        isoZombie.setHealth(0.0f);
        isoZombie.upKillCount = false;
        isoZombie.setSkeleton(true);
        isoZombie.getHumanVisual().setSkinTextureIndex(Rand.Next(1, 3));
        return new IsoDeadBody(isoZombie, true);
    }

    public boolean isTimeValid(boolean bl) {
        if (this.minimumDays == 0 || this.maximumDays == 0) {
            return true;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours() / 24.0f;
        f += (float)((SandboxOptions.instance.TimeSinceApo.getValue() - 1) * 30);
        if (this.minimumDays > 0 && f < (float)this.minimumDays) {
            return false;
        }
        return this.maximumDays <= 0 || !(f > (float)this.maximumDays);
    }

    public String getName() {
        return this.name;
    }

    public String getDebugLine() {
        return this.debugLine;
    }

    public void setDebugLine(String string) {
        this.debugLine = string;
    }

    public int getMaximumDays() {
        return this.maximumDays;
    }

    public void setMaximumDays(int n) {
        this.maximumDays = n;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public IsoGridSquare getSq(int n, int n2, int n3) {
        return IsoWorld.instance.getCell().getGridSquare(n, n2, n3);
    }

    public IsoObject addTileObject(int n, int n2, int n3, String string) {
        return this.addTileObject(this.getSq(n, n2, n3), string);
    }

    public IsoObject addTileObject(IsoGridSquare isoGridSquare, String string) {
        if (isoGridSquare == null) {
            return null;
        }
        IsoObject isoObject = IsoObject.getNew(isoGridSquare, string, null, false);
        isoGridSquare.AddTileObject(isoObject);
        MapObjects.newGridSquare(isoGridSquare);
        MapObjects.loadGridSquare(isoGridSquare);
        return isoObject;
    }

    public IsoObject addTentNorthSouth(int n, int n2, int n3) {
        this.addTileObject(n, n2 - 1, n3, "camping_01_1");
        return this.addTileObject(n, n2, n3, "camping_01_0");
    }

    public IsoObject addTentWestEast(int n, int n2, int n3) {
        this.addTileObject(n - 1, n2, n3, "camping_01_2");
        return this.addTileObject(n, n2, n3, "camping_01_3");
    }

    public BaseVehicle addTrailer(BaseVehicle baseVehicle, IsoMetaGrid.Zone zone, IsoChunk isoChunk, String string, String string2, String string3) {
        BaseVehicle baseVehicle2;
        IsoGridSquare isoGridSquare = baseVehicle.getSquare();
        IsoDirections isoDirections = baseVehicle.getDir();
        int n = 0;
        int n2 = 0;
        if (isoDirections == IsoDirections.S) {
            n2 = -3;
        }
        if (isoDirections == IsoDirections.N) {
            n2 = 3;
        }
        if (isoDirections == IsoDirections.W) {
            n = 3;
        }
        if (isoDirections == IsoDirections.E) {
            n = -3;
        }
        if ((baseVehicle2 = this.addVehicle(zone, this.getSq(isoGridSquare.x + n, isoGridSquare.y + n2, isoGridSquare.z), isoChunk, string, string3, null, isoDirections, string2)) != null) {
            baseVehicle.positionTrailer(baseVehicle2);
        }
        return baseVehicle2;
    }
}

