/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.scripting;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.ZomboidRadio;
import zombie.radio.scripting.RadioBroadCast;
import zombie.radio.scripting.RadioChannel;
import zombie.radio.scripting.RadioScript;

public final class RadioScriptManager {
    private final Map<Integer, RadioChannel> channels = new LinkedHashMap<Integer, RadioChannel>();
    private static RadioScriptManager instance;
    private int currentTimeStamp = 0;
    private ArrayList<RadioChannel> channelsList = new ArrayList();

    public static boolean hasInstance() {
        return instance != null;
    }

    public static RadioScriptManager getInstance() {
        if (instance == null) {
            instance = new RadioScriptManager();
        }
        return instance;
    }

    private RadioScriptManager() {
    }

    public void init(int n) {
    }

    public Map<Integer, RadioChannel> getChannels() {
        return this.channels;
    }

    public ArrayList getChannelsList() {
        this.channelsList.clear();
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            this.channelsList.add(entry.getValue());
        }
        return this.channelsList;
    }

    public RadioChannel getRadioChannel(String string) {
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            if (!entry.getValue().getGUID().equals(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void simulateScriptsUntil(int n, boolean bl) {
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            this.simulateChannelUntil(entry.getValue().GetFrequency(), n, bl);
        }
    }

    public void simulateChannelUntil(int n, int n2, boolean bl) {
        if (this.channels.containsKey(n)) {
            RadioChannel radioChannel = this.channels.get(n);
            if (radioChannel.isTimeSynced() && !bl) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = i * 24 * 60;
                radioChannel.UpdateScripts(this.currentTimeStamp, n3);
            }
            radioChannel.setTimeSynced(true);
        }
    }

    public int getCurrentTimeStamp() {
        return this.currentTimeStamp;
    }

    public void PlayerListensChannel(int n, boolean bl, boolean bl2) {
        if (this.channels.containsKey(n) && this.channels.get(n).IsTv() == bl2) {
            this.channels.get(n).SetPlayerIsListening(bl);
        }
    }

    public void AddChannel(RadioChannel radioChannel, boolean bl) {
        if (radioChannel != null && (bl || !this.channels.containsKey(radioChannel.GetFrequency()))) {
            this.channels.put(radioChannel.GetFrequency(), radioChannel);
            String string = radioChannel.GetCategory().name();
            ZomboidRadio.getInstance().addChannelName(radioChannel.GetName(), radioChannel.GetFrequency(), string, bl);
        } else {
            String string = radioChannel != null ? radioChannel.GetName() : "null";
            DebugLog.log(DebugType.Radio, "Error adding radiochannel (" + string + "), channel is null or frequency key already exists");
        }
    }

    public void RemoveChannel(int n) {
        if (this.channels.containsKey(n)) {
            this.channels.remove(n);
            ZomboidRadio.getInstance().removeChannelName(n);
        }
    }

    public void UpdateScripts(int n, int n2, int n3) {
        this.currentTimeStamp = n * 24 * 60 + n2 * 60 + n3;
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            entry.getValue().UpdateScripts(this.currentTimeStamp, n);
        }
    }

    public void update() {
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            entry.getValue().update();
        }
    }

    public void reset() {
        instance = null;
    }

    public void Save(Writer writer) throws IOException {
        for (Map.Entry<Integer, RadioChannel> entry : this.channels.entrySet()) {
            RadioBroadCast radioBroadCast;
            writer.write(entry.getKey() + "," + entry.getValue().getCurrentScriptLoop() + "," + entry.getValue().getCurrentScriptMaxLoops());
            RadioScript radioScript = entry.getValue().getCurrentScript();
            if (radioScript != null) {
                writer.write("," + radioScript.GetName() + "," + radioScript.getStartDay());
            }
            if ((radioBroadCast = entry.getValue().getAiringBroadcast()) != null) {
                writer.write("," + radioBroadCast.getID());
            } else if (entry.getValue().getLastBroadcastID() != null) {
                writer.write("," + entry.getValue().getLastBroadcastID());
            } else {
                writer.write(",none");
            }
            writer.write("," + (String)(radioBroadCast != null ? "" + radioBroadCast.getCurrentLineNumber() : "-1"));
            writer.write(System.lineSeparator());
        }
    }

    public void Load(List<String> list) throws IOException, NumberFormatException {
        int n = 1;
        int n2 = 1;
        for (String string : list) {
            String string2;
            RadioChannel radioChannel = null;
            if (string == null) continue;
            String[] stringArray = (string = string.trim()).split(",");
            if (stringArray.length >= 3) {
                int n3 = Integer.parseInt(stringArray[0]);
                n = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[2]);
                if (this.channels.containsKey(n3)) {
                    radioChannel = this.channels.get(n3);
                    radioChannel.setTimeSynced(true);
                }
            }
            if (radioChannel != null && stringArray.length >= 5) {
                String string3 = stringArray[3];
                int n4 = Integer.parseInt(stringArray[4]);
                if (radioChannel != null) {
                    radioChannel.setActiveScript(string3, n4, n, n2);
                }
            }
            if (radioChannel == null || stringArray.length < 7 || (string2 = stringArray[5]).equals("none")) continue;
            int n5 = Integer.parseInt(stringArray[6]);
            radioChannel.LoadAiringBroadcast(string2, n5);
        }
    }
}

