/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.scripting;

import java.util.ArrayList;
import java.util.UUID;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.scripting.RadioBroadCast;

public final class RadioScript {
    private final ArrayList<RadioBroadCast> broadcasts = new ArrayList();
    private final ArrayList<ExitOption> exitOptions = new ArrayList();
    private String GUID;
    private String name = "Unnamed radioscript";
    private int startDay = 0;
    private int startDayStamp = 0;
    private int loopMin = 1;
    private int loopMax = 1;
    private int internalStamp = 0;
    private RadioBroadCast currentBroadcast = null;
    private boolean currentHasAired = false;

    public RadioScript(String string, int n, int n2) {
        this(string, n, n2, UUID.randomUUID().toString());
    }

    public RadioScript(String string, int n, int n2, String string2) {
        this.name = string;
        this.loopMin = n;
        this.loopMax = n2;
        this.GUID = string2;
    }

    public String GetGUID() {
        return this.GUID;
    }

    public String GetName() {
        return this.name;
    }

    public int getStartDayStamp() {
        return this.startDayStamp;
    }

    public int getStartDay() {
        return this.startDay;
    }

    public int getLoopMin() {
        return this.loopMin;
    }

    public int getLoopMax() {
        return this.loopMax;
    }

    public RadioBroadCast getCurrentBroadcast() {
        return this.currentBroadcast;
    }

    public ArrayList<RadioBroadCast> getBroadcastList() {
        return this.broadcasts;
    }

    public void clearExitOptions() {
        this.exitOptions.clear();
    }

    public void setStartDayStamp(int n) {
        this.startDay = n;
        this.startDayStamp = n * 24 * 60;
    }

    public RadioBroadCast getValidAirBroadcast() {
        if (!this.currentHasAired && this.currentBroadcast != null && this.internalStamp >= this.currentBroadcast.getStartStamp() && this.internalStamp < this.currentBroadcast.getEndStamp()) {
            this.currentHasAired = true;
            return this.currentBroadcast;
        }
        return null;
    }

    public void Reset() {
        this.currentBroadcast = null;
        this.currentHasAired = false;
    }

    private RadioBroadCast getNextBroadcast() {
        if (this.currentBroadcast == null || this.currentBroadcast.getEndStamp() <= this.internalStamp) {
            for (int i = 0; i < this.broadcasts.size(); ++i) {
                RadioBroadCast radioBroadCast = this.broadcasts.get(i);
                if (radioBroadCast.getEndStamp() <= this.internalStamp) continue;
                this.currentHasAired = false;
                return radioBroadCast;
            }
            return null;
        }
        return this.currentBroadcast;
    }

    public RadioBroadCast getBroadcastWithID(String string) {
        for (int i = 0; i < this.broadcasts.size(); ++i) {
            RadioBroadCast radioBroadCast = this.broadcasts.get(i);
            if (!radioBroadCast.getID().equals(string)) continue;
            this.currentBroadcast = radioBroadCast;
            this.currentHasAired = true;
            return radioBroadCast;
        }
        return null;
    }

    public boolean UpdateScript(int n) {
        this.internalStamp = n - this.startDayStamp;
        this.currentBroadcast = this.getNextBroadcast();
        return this.currentBroadcast != null;
    }

    public ExitOption getNextScript() {
        int n = 0;
        int n2 = Rand.Next(100);
        for (ExitOption exitOption : this.exitOptions) {
            if (n2 >= n && n2 < n + exitOption.getChance()) {
                return exitOption;
            }
            n += exitOption.getChance();
        }
        return null;
    }

    public void AddBroadcast(RadioBroadCast radioBroadCast) {
        this.AddBroadcast(radioBroadCast, false);
    }

    public void AddBroadcast(RadioBroadCast radioBroadCast, boolean bl) {
        boolean bl2 = false;
        if (radioBroadCast != null && radioBroadCast.getID() != null) {
            if (bl) {
                this.broadcasts.add(radioBroadCast);
                bl2 = true;
            } else if (radioBroadCast.getStartStamp() >= 0 && radioBroadCast.getEndStamp() > radioBroadCast.getStartStamp()) {
                if (this.broadcasts.size() == 0 || this.broadcasts.get(this.broadcasts.size() - 1).getEndStamp() <= radioBroadCast.getStartStamp()) {
                    this.broadcasts.add(radioBroadCast);
                    bl2 = true;
                } else if (this.broadcasts.size() > 0) {
                    DebugLog.log(DebugType.Radio, "startstamp = '" + radioBroadCast.getStartStamp() + "', endstamp = '" + radioBroadCast.getEndStamp() + "', previous endstamp = '" + this.broadcasts.get(this.broadcasts.size() - 1).getEndStamp() + "'.");
                }
            } else {
                DebugLog.log(DebugType.Radio, "startstamp = '" + radioBroadCast.getStartStamp() + "', endstamp = '" + radioBroadCast.getEndStamp() + "'.");
            }
        }
        if (!bl2) {
            String string = radioBroadCast != null ? radioBroadCast.getID() : "null";
            DebugLog.log(DebugType.Radio, "Error cannot add broadcast ID: '" + string + "' to script '" + this.name + "', null or timestamp error");
        }
    }

    public void AddExitOption(String string, int n, int n2) {
        int n3 = n;
        for (ExitOption exitOption : this.exitOptions) {
            n3 += exitOption.getChance();
        }
        if (n3 <= 100) {
            this.exitOptions.add(new ExitOption(string, n, n2));
        } else {
            DebugLog.log(DebugType.Radio, "Error cannot add exitoption with scriptname '" + string + "' to script '" + this.name + "', total chance exceeding 100");
        }
    }

    public RadioBroadCast getValidAirBroadcastDebug() {
        if (this.currentBroadcast == null || this.currentBroadcast.getEndStamp() <= this.internalStamp) {
            for (int i = 0; i < this.broadcasts.size(); ++i) {
                RadioBroadCast radioBroadCast = this.broadcasts.get(i);
                if (radioBroadCast.getEndStamp() <= this.internalStamp) continue;
                return radioBroadCast;
            }
            return null;
        }
        return this.currentBroadcast;
    }

    public ArrayList<ExitOption> getExitOptions() {
        return this.exitOptions;
    }

    public static final class ExitOption {
        private String scriptname = "";
        private int chance = 0;
        private int startDelay = 0;

        public ExitOption(String string, int n, int n2) {
            this.scriptname = string;
            this.chance = n;
            this.startDelay = n2;
        }

        public String getScriptname() {
            return this.scriptname;
        }

        public int getChance() {
            return this.chance;
        }

        public int getStartDelay() {
            return this.startDelay;
        }
    }
}

