/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.scripting;

import java.util.ArrayList;
import zombie.radio.scripting.RadioLine;

public final class RadioBroadCast {
    private static final RadioLine pauseLine = new RadioLine("~", 0.5f, 0.5f, 0.5f);
    private final ArrayList<RadioLine> lines = new ArrayList();
    private String ID = "";
    private int startStamp = 0;
    private int endStamp = 0;
    private int lineCount = 0;
    private RadioBroadCast preSegment = null;
    private RadioBroadCast postSegment = null;
    private boolean hasDonePreSegment = false;
    private boolean hasDonePostSegment = false;
    private boolean hasDonePostPause = false;

    public RadioBroadCast(String string, int n, int n2) {
        this.ID = string;
        this.startStamp = n;
        this.endStamp = n2;
    }

    public String getID() {
        return this.ID;
    }

    public int getStartStamp() {
        return this.startStamp;
    }

    public int getEndStamp() {
        return this.endStamp;
    }

    public void resetLineCounter() {
        this.resetLineCounter(true);
    }

    public void resetLineCounter(boolean bl) {
        this.lineCount = 0;
        if (bl) {
            if (this.preSegment != null) {
                this.preSegment.resetLineCounter(false);
            }
            if (this.postSegment != null) {
                this.postSegment.resetLineCounter(false);
            }
        }
    }

    public void setPreSegment(RadioBroadCast radioBroadCast) {
        this.preSegment = radioBroadCast;
    }

    public void setPostSegment(RadioBroadCast radioBroadCast) {
        this.postSegment = radioBroadCast;
    }

    public RadioLine getNextLine() {
        return this.getNextLine(true);
    }

    public RadioLine getNextLine(boolean bl) {
        RadioLine radioLine = null;
        if (bl && !this.hasDonePreSegment && this.lineCount == 0 && this.preSegment != null) {
            radioLine = this.preSegment.getNextLine();
            if (radioLine != null) {
                return radioLine;
            }
            this.hasDonePreSegment = true;
            return pauseLine;
        }
        if (this.lineCount >= 0 && this.lineCount < this.lines.size()) {
            radioLine = this.lines.get(this.lineCount);
        }
        if (bl && radioLine == null && this.postSegment != null) {
            if (!this.hasDonePostPause) {
                this.hasDonePostPause = true;
                return pauseLine;
            }
            radioLine = this.postSegment.getNextLine();
            return radioLine;
        }
        ++this.lineCount;
        return radioLine;
    }

    public int getCurrentLineNumber() {
        return this.lineCount;
    }

    public void setCurrentLineNumber(int n) {
        this.lineCount = n;
        if (this.lineCount < 0) {
            this.lineCount = 0;
        }
    }

    public RadioLine getCurrentLine() {
        if (this.lineCount >= 0 && this.lineCount < this.lines.size()) {
            return this.lines.get(this.lineCount);
        }
        return null;
    }

    public String PeekNextLineText() {
        if (this.lineCount >= 0 && this.lineCount < this.lines.size()) {
            return this.lines.get(this.lineCount) != null && this.lines.get(this.lineCount).getText() != null ? this.lines.get(this.lineCount).getText() : "Error";
        }
        return "None";
    }

    public void AddRadioLine(RadioLine radioLine) {
        if (radioLine != null) {
            this.lines.add(radioLine);
        }
    }

    public ArrayList<RadioLine> getLines() {
        return this.lines;
    }
}

