/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.script;

import java.util.ArrayList;
import java.util.List;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.globals.CompareResult;
import zombie.radio.script.ConditionContainer;
import zombie.radio.script.RadioScriptEntry;

public final class ExitOptionOld {
    private String parentScript;
    private String name;
    private ConditionContainer condition;
    private List<RadioScriptEntry> scriptEntries = new ArrayList<RadioScriptEntry>();

    public ExitOptionOld(String string, String string2) {
        this.parentScript = string != null ? string : "Noname";
        this.name = string2 != null ? string2 : "Noname";
    }

    public void setCondition(ConditionContainer conditionContainer) {
        this.condition = conditionContainer;
    }

    public void addScriptEntry(RadioScriptEntry radioScriptEntry) {
        if (radioScriptEntry != null) {
            this.scriptEntries.add(radioScriptEntry);
        } else {
            DebugLog.log(DebugType.Radio, "Error trying to add 'null' scriptentry in script: " + this.parentScript + ", exitoption: " + this.name);
        }
    }

    public RadioScriptEntry evaluate() {
        CompareResult compareResult = CompareResult.True;
        if (this.condition != null) {
            compareResult = this.condition.Evaluate();
        }
        if (compareResult.equals((Object)CompareResult.True)) {
            if (this.scriptEntries != null && this.scriptEntries.size() > 0) {
                int n = Rand.Next(100);
                for (RadioScriptEntry radioScriptEntry : this.scriptEntries) {
                    if (radioScriptEntry == null) continue;
                    System.out.println("ScriptEntry " + radioScriptEntry.getScriptName());
                    System.out.println("Chance: " + n + " Min: " + radioScriptEntry.getChanceMin() + " Max: " + radioScriptEntry.getChanceMax());
                    if (n < radioScriptEntry.getChanceMin() || n >= radioScriptEntry.getChanceMax()) continue;
                    return radioScriptEntry;
                }
            }
        } else if (compareResult.equals((Object)CompareResult.Invalid)) {
            System.out.println("Error occured evaluating condition: " + this.parentScript + ", exitoption: " + this.name);
            DebugLog.log(DebugType.Radio, "Error occured evaluating condition: " + this.parentScript + ", exitoption: " + this.name);
        }
        return null;
    }
}

