/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.globals;

import java.util.HashMap;
import java.util.Map;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.globals.CompareMethod;
import zombie.radio.globals.CompareResult;
import zombie.radio.globals.EditGlobalOps;
import zombie.radio.globals.RadioGlobal;
import zombie.radio.globals.RadioGlobalBool;
import zombie.radio.globals.RadioGlobalFloat;
import zombie.radio.globals.RadioGlobalInt;
import zombie.radio.globals.RadioGlobalString;
import zombie.radio.globals.RadioGlobalType;

public final class RadioGlobalsManager {
    private final Map<String, RadioGlobal> globals = new HashMap<String, RadioGlobal>();
    private final RadioGlobalInt bufferInt = new RadioGlobalInt("bufferInt", 0);
    private final RadioGlobalString bufferString = new RadioGlobalString("bufferString", "");
    private final RadioGlobalBool bufferBoolean = new RadioGlobalBool("bufferBoolean", false);
    private final RadioGlobalFloat bufferFloat = new RadioGlobalFloat("bufferFloat", 0.0f);
    private static RadioGlobalsManager instance;

    public static RadioGlobalsManager getInstance() {
        if (instance == null) {
            instance = new RadioGlobalsManager();
        }
        return instance;
    }

    private RadioGlobalsManager() {
    }

    public void reset() {
        instance = null;
    }

    public boolean exists(String string) {
        return this.globals.containsKey(string);
    }

    public RadioGlobalType getType(String string) {
        if (this.globals.containsKey(string)) {
            return this.globals.get(string).getType();
        }
        return RadioGlobalType.Invalid;
    }

    public String getString(String string) {
        RadioGlobal radioGlobal = this.getGlobal(string);
        if (radioGlobal != null) {
            return radioGlobal.getString();
        }
        return null;
    }

    public boolean addGlobal(String string, RadioGlobal radioGlobal) {
        if (!this.exists(string) && radioGlobal != null) {
            this.globals.put(string, radioGlobal);
            return true;
        }
        DebugLog.log(DebugType.Radio, "Error adding global: " + string + " to globals (already exists or global==null)");
        return false;
    }

    public boolean addGlobalString(String string, String string2) {
        return this.addGlobal(string, new RadioGlobalString(string, string2));
    }

    public boolean addGlobalBool(String string, boolean bl) {
        return this.addGlobal(string, new RadioGlobalBool(string, bl));
    }

    public boolean addGlobalInt(String string, int n) {
        return this.addGlobal(string, new RadioGlobalInt(string, n));
    }

    public boolean addGlobalFloat(String string, float f) {
        return this.addGlobal(string, new RadioGlobalFloat(string, f));
    }

    public RadioGlobal getGlobal(String string) {
        if (this.exists(string)) {
            return this.globals.get(string);
        }
        return null;
    }

    public RadioGlobalString getGlobalString(String string) {
        RadioGlobal radioGlobal = this.getGlobal(string);
        return radioGlobal != null && radioGlobal instanceof RadioGlobalString ? (RadioGlobalString)radioGlobal : null;
    }

    public RadioGlobalInt getGlobalInt(String string) {
        RadioGlobal radioGlobal = this.getGlobal(string);
        return radioGlobal != null && radioGlobal instanceof RadioGlobalInt ? (RadioGlobalInt)radioGlobal : null;
    }

    public RadioGlobalFloat getGlobalFloat(String string) {
        RadioGlobal radioGlobal = this.getGlobal(string);
        return radioGlobal != null && radioGlobal instanceof RadioGlobalFloat ? (RadioGlobalFloat)radioGlobal : null;
    }

    public RadioGlobalBool getGlobalBool(String string) {
        RadioGlobal radioGlobal = this.getGlobal(string);
        return radioGlobal != null && radioGlobal instanceof RadioGlobalBool ? (RadioGlobalBool)radioGlobal : null;
    }

    public boolean setGlobal(String string, RadioGlobal radioGlobal, EditGlobalOps editGlobalOps) {
        RadioGlobal radioGlobal2 = this.getGlobal(string);
        if (radioGlobal2 != null && radioGlobal != null) {
            return radioGlobal2.setValue(radioGlobal, editGlobalOps);
        }
        return false;
    }

    public boolean setGlobal(String string, String string2) {
        this.bufferString.setValue(string2);
        return this.setGlobal(string, this.bufferString, EditGlobalOps.set);
    }

    public boolean setGlobal(String string, int n) {
        this.bufferInt.setValue(n);
        return this.setGlobal(string, this.bufferInt, EditGlobalOps.set);
    }

    public boolean setGlobal(String string, float f) {
        this.bufferFloat.setValue(f);
        return this.setGlobal(string, this.bufferFloat, EditGlobalOps.set);
    }

    public boolean setGlobal(String string, boolean bl) {
        this.bufferBoolean.setValue(bl);
        return this.setGlobal(string, this.bufferBoolean, EditGlobalOps.set);
    }

    public CompareResult compare(RadioGlobal radioGlobal, RadioGlobal radioGlobal2, CompareMethod compareMethod) {
        if (radioGlobal != null && radioGlobal2 != null && radioGlobal.getType().equals((Object)radioGlobal2.getType())) {
            return radioGlobal.compare(radioGlobal2, compareMethod);
        }
        return CompareResult.Invalid;
    }

    public CompareResult compare(String string, String string2, CompareMethod compareMethod) {
        return this.compare(this.getGlobal(string), this.getGlobal(string2), compareMethod);
    }
}

