/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.globals;

import zombie.radio.globals.CompareMethod;
import zombie.radio.globals.CompareResult;
import zombie.radio.globals.EditGlobalOps;
import zombie.radio.globals.RadioGlobal;
import zombie.radio.globals.RadioGlobalType;

public final class RadioGlobalInt
extends RadioGlobal<Integer> {
    public RadioGlobalInt(int n) {
        super(n, RadioGlobalType.Integer);
    }

    public RadioGlobalInt(String string, int n) {
        super(string, n, RadioGlobalType.Integer);
    }

    public int getValue() {
        return (Integer)this.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public String getString() {
        return ((Integer)this.value).toString();
    }

    @Override
    public CompareResult compare(RadioGlobal radioGlobal, CompareMethod compareMethod) {
        if (radioGlobal instanceof RadioGlobalInt) {
            RadioGlobalInt radioGlobalInt = (RadioGlobalInt)radioGlobal;
            switch (compareMethod) {
                case equals: {
                    return ((Integer)this.value).intValue() == radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
                case notequals: {
                    return ((Integer)this.value).intValue() != radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
                case lessthan: {
                    return (Integer)this.value < radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
                case morethan: {
                    return (Integer)this.value > radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
                case lessthanorequals: {
                    return (Integer)this.value <= radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
                case morethanorequals: {
                    return (Integer)this.value >= radioGlobalInt.getValue() ? CompareResult.True : CompareResult.False;
                }
            }
            return CompareResult.Invalid;
        }
        return CompareResult.Invalid;
    }

    @Override
    public boolean setValue(RadioGlobal radioGlobal, EditGlobalOps editGlobalOps) {
        if (radioGlobal instanceof RadioGlobalInt) {
            RadioGlobalInt radioGlobalInt = (RadioGlobalInt)radioGlobal;
            switch (editGlobalOps) {
                case set: {
                    this.value = radioGlobalInt.getValue();
                    return true;
                }
                case add: {
                    this.value = (Integer)this.value + radioGlobalInt.getValue();
                    return true;
                }
                case sub: {
                    this.value = (Integer)this.value - radioGlobalInt.getValue();
                    return true;
                }
            }
        }
        return false;
    }
}

