/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.devices;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.radio.devices.PresetEntry;

public final class DevicePresets
implements Cloneable {
    protected int maxPresets = 10;
    protected ArrayList<PresetEntry> presets = new ArrayList();

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public KahluaTable getPresetsLua() {
        KahluaTable kahluaTable = LuaManager.platform.newTable();
        for (int i = 0; i < this.presets.size(); ++i) {
            PresetEntry presetEntry = this.presets.get(i);
            KahluaTable kahluaTable2 = LuaManager.platform.newTable();
            kahluaTable2.rawset((Object)"name", (Object)presetEntry.name);
            kahluaTable2.rawset((Object)"frequency", (Object)presetEntry.frequency);
            kahluaTable.rawset(i, (Object)kahluaTable2);
        }
        return kahluaTable;
    }

    public ArrayList<PresetEntry> getPresets() {
        return this.presets;
    }

    public void setPresets(ArrayList<PresetEntry> arrayList) {
        this.presets = arrayList;
    }

    public int getMaxPresets() {
        return this.maxPresets;
    }

    public void setMaxPresets(int n) {
        this.maxPresets = n;
    }

    public void addPreset(String string, int n) {
        if (this.presets.size() < this.maxPresets) {
            this.presets.add(new PresetEntry(string, n));
        }
    }

    public void removePreset(int n) {
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            this.presets.remove(n);
        }
    }

    public String getPresetName(int n) {
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            return this.presets.get((int)n).name;
        }
        return "";
    }

    public int getPresetFreq(int n) {
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            return this.presets.get((int)n).frequency;
        }
        return -1;
    }

    public void setPresetName(int n, String string) {
        if (string == null) {
            string = "name-is-null";
        }
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            PresetEntry presetEntry = this.presets.get(n);
            presetEntry.name = string;
        }
    }

    public void setPresetFreq(int n, int n2) {
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            PresetEntry presetEntry = this.presets.get(n);
            presetEntry.frequency = n2;
        }
    }

    public void setPreset(int n, String string, int n2) {
        if (string == null) {
            string = "name-is-null";
        }
        if (this.presets.size() != 0 && n >= 0 && n < this.presets.size()) {
            PresetEntry presetEntry = this.presets.get(n);
            presetEntry.name = string;
            presetEntry.frequency = n2;
        }
    }

    public void clearPresets() {
        this.presets.clear();
    }

    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.putInt(this.maxPresets);
        byteBuffer.putInt(this.presets.size());
        for (int i = 0; i < this.presets.size(); ++i) {
            PresetEntry presetEntry = this.presets.get(i);
            GameWindow.WriteString(byteBuffer, presetEntry.name);
            byteBuffer.putInt(presetEntry.frequency);
        }
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        if (n >= 69) {
            this.clearPresets();
            this.maxPresets = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                String string = GameWindow.ReadString(byteBuffer);
                int n3 = byteBuffer.getInt();
                if (this.presets.size() >= this.maxPresets) continue;
                this.presets.add(new PresetEntry(string, n3));
            }
        }
    }
}

