/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio.StorySounds;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import zombie.ZomboidFileSystem;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.input.GameKeyboard;
import zombie.iso.Vector2;
import zombie.radio.StorySounds.StoryEmitter;
import zombie.radio.StorySounds.StorySound;
import zombie.ui.TextManager;
import zombie.ui.UIFont;

public final class SLSoundManager {
    public static boolean ENABLED = false;
    public static boolean DEBUG = false;
    public static boolean LUA_DEBUG = false;
    public static StoryEmitter Emitter = new StoryEmitter();
    private static SLSoundManager instance;
    private HashMap<Integer, Boolean> state = new HashMap();
    private ArrayList<StorySound> storySounds = new ArrayList();
    private int nextTick = 0;
    private float borderCenterX = 10500.0f;
    private float borderCenterY = 9000.0f;
    private float borderRadiusMin = 12000.0f;
    private float borderRadiusMax = 16000.0f;
    private float borderScale = 1.0f;

    public static SLSoundManager getInstance() {
        if (instance == null) {
            instance = new SLSoundManager();
        }
        return instance;
    }

    private SLSoundManager() {
        this.state.put(12, false);
        this.state.put(13, false);
    }

    public boolean getDebug() {
        return DEBUG;
    }

    public boolean getLuaDebug() {
        return LUA_DEBUG;
    }

    public ArrayList<StorySound> getStorySounds() {
        return this.storySounds;
    }

    public void print(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public void init() {
        this.loadSounds();
    }

    public void loadSounds() {
        this.storySounds.clear();
        try {
            File file = ZomboidFileSystem.instance.getMediaFile("sound" + File.separator);
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string;
                    if (!fileArray[i].isFile() || (string = fileArray[i].getName()).lastIndexOf(".") == -1 || string.lastIndexOf(".") == 0 || !string.substring(string.lastIndexOf(".") + 1).equals("ogg")) continue;
                    String string2 = string.substring(0, string.lastIndexOf("."));
                    this.print("Adding sound: " + string2);
                    this.addStorySound(new StorySound(string2, 1.0f));
                }
            }
        }
        catch (Exception exception) {
            System.out.print(exception.getMessage());
        }
    }

    private void addStorySound(StorySound storySound) {
        this.storySounds.add(storySound);
    }

    public void updateKeys() {
        for (Map.Entry<Integer, Boolean> entry : this.state.entrySet()) {
            boolean bl = GameKeyboard.isKeyDown(entry.getKey());
            if (bl && entry.getValue() != bl) {
                switch (entry.getKey()) {
                    case 12: {
                        break;
                    }
                    case 13: {
                        SLSoundManager.Emitter.coordinate3D = !SLSoundManager.Emitter.coordinate3D;
                        break;
                    }
                    case 53: {
                        break;
                    }
                }
            }
            entry.setValue(bl);
        }
    }

    public void update(int n, int n2, int n3) {
        this.updateKeys();
        Emitter.tick();
    }

    public void thunderTest() {
        --this.nextTick;
        if (this.nextTick <= 0) {
            this.nextTick = Rand.Next(10, 180);
            float f = Rand.Next(0.0f, 8000.0f);
            double d = Math.random() * Math.PI * 2.0;
            float f2 = this.borderCenterX + (float)(Math.cos(d) * (double)f);
            float f3 = this.borderCenterY + (float)(Math.sin(d) * (double)f);
            if (Rand.Next(0, 100) < 60) {
                Emitter.playSound("thunder", 1.0f, f2, f3, 0.0f, 100.0f, 8500.0f);
            } else {
                Emitter.playSound("thundereffect", 1.0f, f2, f3, 0.0f, 100.0f, 8500.0f);
            }
        }
    }

    public void render() {
        this.renderDebug();
    }

    public void renderDebug() {
        if (DEBUG) {
            String string = SLSoundManager.Emitter.coordinate3D ? "3D coordinates, X-Z-Y" : "2D coordinates X-Y-Z";
            int n = TextManager.instance.MeasureStringX(UIFont.Large, string) / 2;
            int n2 = TextManager.instance.MeasureStringY(UIFont.Large, string);
            int n3 = Core.getInstance().getScreenWidth() / 2;
            int n4 = Core.getInstance().getScreenHeight() / 2;
            this.renderLine(UIFont.Large, string, n3 - n, n4);
        }
    }

    private void renderLine(UIFont uIFont, String string, int n, int n2) {
        TextManager.instance.DrawString(uIFont, n + 1, n2 + 1, string, 0.0, 0.0, 0.0, 1.0);
        TextManager.instance.DrawString(uIFont, n - 1, n2 - 1, string, 0.0, 0.0, 0.0, 1.0);
        TextManager.instance.DrawString(uIFont, n + 1, n2 - 1, string, 0.0, 0.0, 0.0, 1.0);
        TextManager.instance.DrawString(uIFont, n - 1, n2 + 1, string, 0.0, 0.0, 0.0, 1.0);
        TextManager.instance.DrawString(uIFont, n, n2, string, 1.0, 1.0, 1.0, 1.0);
    }

    public Vector2 getRandomBorderPosition() {
        float f = Rand.Next(this.borderRadiusMin * this.borderScale, this.borderRadiusMax * this.borderScale);
        double d = Math.random() * Math.PI * 2.0;
        float f2 = this.borderCenterX + (float)(Math.cos(d) * (double)f);
        float f3 = this.borderCenterY + (float)(Math.sin(d) * (double)f);
        return new Vector2(f2, f3);
    }

    public float getRandomBorderRange() {
        return Rand.Next(this.borderRadiusMin * this.borderScale * 1.5f, this.borderRadiusMax * this.borderScale * 1.5f);
    }
}

