/*
 * Decompiled with CFR 0.152.
 */
package zombie.radio;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import zombie.core.Rand;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.radio.ChannelCategory;
import zombie.radio.RadioData;
import zombie.radio.ZomboidRadio;
import zombie.radio.globals.RadioGlobal;
import zombie.radio.globals.RadioGlobalBool;
import zombie.radio.globals.RadioGlobalFloat;
import zombie.radio.globals.RadioGlobalInt;
import zombie.radio.globals.RadioGlobalString;
import zombie.radio.globals.RadioGlobalType;
import zombie.radio.globals.RadioGlobalsManager;
import zombie.radio.scripting.RadioBroadCast;
import zombie.radio.scripting.RadioChannel;
import zombie.radio.scripting.RadioLine;
import zombie.radio.scripting.RadioScript;
import zombie.radio.scripting.RadioScriptManager;

public final class RadioXmlReader {
    private boolean printDebug = false;
    private ArrayList<RadioGlobal> globalQueue;
    private ArrayList<RadioChannel> channelQueue;
    private Map<String, ArrayList<RadioBroadCast>> advertQue;
    private final String charsNormal = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private final String charsEncrypt = "UVWKLMABCDEFGXYZHIJOPQRSTNuvwklmabcdefgxyzhijopqrstn";
    private String radioVersion = "1.0";
    private float version = 1.0f;
    private float formatVersion = 1.0f;
    private final Map<String, String> radioFileSettings = new HashMap<String, String>();

    public RadioXmlReader() {
        this(false);
    }

    public RadioXmlReader(boolean bl) {
        this.printDebug = bl;
    }

    public static RadioData ReadFileHeader(String string) {
        RadioXmlReader radioXmlReader = new RadioXmlReader(ZomboidRadio.DEBUG_XML);
        return null;
    }

    private void readfileheader(String string) throws ParserConfigurationException, IOException, SAXException {
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("RadioData");
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            Node node2 = null;
            for (Node node3 : this.getChildNodes(node)) {
                if (!this.nodeNameIs(node3, "RootInfo")) continue;
                node2 = node3;
                break;
            }
            this.loadRootInfo(node2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean LoadFile(String string) {
        RadioXmlReader radioXmlReader = new RadioXmlReader(ZomboidRadio.DEBUG_XML);
        try {
            radioXmlReader.start(string);
        }
        catch (Exception exception) {
            DebugLog.log(DebugType.Radio, "Error loading radio system: " + exception.getMessage());
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DebugLog.log(DebugType.Radio, "RadioSystem online.");
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> LoadTranslatorNames(String string) {
        ArrayList<String> arrayList = new ArrayList();
        RadioXmlReader radioXmlReader = new RadioXmlReader(ZomboidRadio.DEBUG_XML);
        try {
            ArrayList<String> arrayList2 = radioXmlReader.readTranslatorNames(string);
            arrayList = arrayList2;
            return arrayList;
        }
        catch (Exception exception) {
            DebugLog.log(DebugType.Radio, "Error reading translator names: " + exception.getMessage());
            exception.printStackTrace();
            ArrayList<String> arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            DebugLog.log(DebugType.Radio, "Returning translator names.");
            return arrayList;
        }
    }

    private void print(String string) {
        if (this.printDebug) {
            DebugLog.log(DebugType.Radio, string);
        }
    }

    private ArrayList<Node> getChildNodes(Node node) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (node.hasChildNodes()) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (!(node2 instanceof Element)) {
                    node2 = node2.getNextSibling();
                    continue;
                }
                arrayList.add(node2);
                node2 = node2.getNextSibling();
            }
        }
        return arrayList;
    }

    private boolean nodeNameIs(Node node, String string) {
        return node.getNodeName().equals(string);
    }

    private String getAttrib(Node node, String string, boolean bl) {
        return this.getAttrib(node, string, bl, false);
    }

    private String getAttrib(Node node, String string) {
        return this.getAttrib(node, string, true, false).trim();
    }

    private String getAttrib(Node node, String string, boolean bl, boolean bl2) {
        String string2 = node.getAttributes().getNamedItem(string).getTextContent();
        if (bl) {
            string2 = string2.trim();
        }
        if (bl2) {
            string2 = string2.toLowerCase();
        }
        return string2;
    }

    private RadioGlobal getGlobalFromQueue(String string) {
        for (RadioGlobal radioGlobal : this.globalQueue) {
            if (radioGlobal == null || !radioGlobal.getName().equals(string)) continue;
            return radioGlobal;
        }
        return null;
    }

    private RadioGlobal createGlobal(String string, String string2) {
        return this.createGlobal("", string, string2);
    }

    private RadioGlobal createGlobal(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        RadioGlobalType radioGlobalType = RadioGlobalType.valueOf(string2.trim());
        switch (radioGlobalType) {
            case String: {
                return new RadioGlobalString(string, string3);
            }
            case Integer: {
                return new RadioGlobalInt(string, Integer.parseInt(string3.trim()));
            }
            case Float: {
                return new RadioGlobalFloat(string, Float.parseFloat(string3.trim()));
            }
            case Boolean: {
                return new RadioGlobalBool(string, Boolean.parseBoolean(string3.trim().toLowerCase()));
            }
        }
        return null;
    }

    private ArrayList<String> readTranslatorNames(String string) throws ParserConfigurationException, IOException, SAXException {
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = document.getElementsByTagName("TranslationData");
        if (nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            for (Node node2 : this.getChildNodes(node)) {
                if (!this.nodeNameIs(node2, "RootInfo")) continue;
                for (Node node3 : this.getChildNodes(node2)) {
                    if (!this.nodeNameIs(node3, "Translators")) continue;
                    for (Node node4 : this.getChildNodes(node3)) {
                        String string2 = this.getAttrib(node4, "name", true, false);
                        if (string2 == null) continue;
                        arrayList.add(string2);
                    }
                }
            }
        }
        return arrayList;
    }

    private void start(String string) throws ParserConfigurationException, IOException, SAXException {
        Object object;
        Object object2;
        File file = new File(string);
        this.print("RadioDataFile: " + file.getAbsolutePath());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        document.getDocumentElement().normalize();
        this.globalQueue = new ArrayList();
        this.channelQueue = new ArrayList();
        this.advertQue = new HashMap<String, ArrayList<RadioBroadCast>>();
        NodeList nodeList = document.getElementsByTagName("RadioData");
        if (nodeList.getLength() > 0) {
            object2 = nodeList.item(0);
            object = null;
            for (Node node : this.getChildNodes((Node)object2)) {
                if (!this.nodeNameIs(node, "RootInfo")) continue;
                object = node;
                break;
            }
            this.loadRootInfo((Node)object);
            for (Node node : this.getChildNodes((Node)object2)) {
                if (this.nodeNameIs(node, "Globals")) {
                    this.loadGlobals(node);
                    continue;
                }
                if (this.nodeNameIs(node, "Adverts")) {
                    this.loadAdverts(node);
                    continue;
                }
                if (!this.nodeNameIs(node, "Channels")) continue;
                this.loadChannels(node);
            }
        }
        object2 = RadioGlobalsManager.getInstance();
        for (RadioGlobal radioGlobal : this.globalQueue) {
            ((RadioGlobalsManager)object2).addGlobal(radioGlobal.getName(), radioGlobal);
        }
        object = RadioScriptManager.getInstance();
        for (RadioChannel radioChannel : this.channelQueue) {
            ((RadioScriptManager)object).AddChannel(radioChannel, false);
        }
    }

    private void loadRootInfo(Node node) {
        this.print(">>> Loading root info...");
        if (node == null) {
            this.print(" -> root info not found, default version = " + this.radioVersion);
            this.radioFileSettings.put("Version", this.radioVersion);
            return;
        }
        this.print(" -> Reading RootInfo");
        for (Node node2 : this.getChildNodes(node)) {
            String string = node2.getNodeName();
            String string2 = node2.getTextContent();
            if (string == null || string2 == null) continue;
            this.print("   -> " + string + " = " + string2);
            this.radioFileSettings.put(string, string2);
            if (!string.equals("Version")) continue;
            this.radioVersion = string2;
            this.version = Float.parseFloat(this.radioVersion);
        }
    }

    private void loadGlobals(Node node) {
        this.print(">>> Loading globals...");
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "GlobalEntry")) continue;
            String string = this.getAttrib(node2, "name");
            String string2 = this.getAttrib(node2, "type");
            String string3 = node2.getTextContent();
            this.print(" -> Found global, name: " + string + ", type: " + string2 + ", value: " + string3);
            RadioGlobal radioGlobal = this.createGlobal(string, string2, string3);
            if (radioGlobal != null) {
                this.globalQueue.add(radioGlobal);
                continue;
            }
            this.print(" -> Error adding Global, name: " + string + ", type: " + string2 + ", value: " + string3);
        }
    }

    private void loadAdverts(Node node) {
        this.print(">>> Loading adverts...");
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "AdvertCategory")) continue;
            String string = this.getAttrib(node2, "name");
            if (!this.advertQue.containsKey(string)) {
                this.advertQue.put(string, new ArrayList());
            }
            this.print(" -> Found category: " + string);
            for (Node node3 : this.getChildNodes(node2)) {
                RadioBroadCast radioBroadCast = this.loadBroadcast(node3, null);
                this.advertQue.get(string).add(radioBroadCast);
            }
        }
    }

    private void loadChannels(Node node) {
        this.print(">>> Loading channels...");
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ChannelEntry")) continue;
            String string = this.getAttrib(node2, "name");
            String string2 = this.getAttrib(node2, "cat");
            String string3 = this.getAttrib(node2, "freq");
            String string4 = this.getAttrib(node2, "startscript");
            this.print(" -> Found channel: " + string + ", on freq: " + string3 + " , category: " + string2 + ", startscript: " + string4);
            RadioChannel radioChannel = new RadioChannel(string, Integer.parseInt(string3), ChannelCategory.valueOf(string2));
            this.loadScripts(node2, radioChannel);
            radioChannel.setActiveScript(string4, 0);
            this.channelQueue.add(radioChannel);
        }
    }

    private void loadScripts(Node node, RadioChannel radioChannel) {
        this.print(" --> Loading scripts...");
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ScriptEntry")) continue;
            String string = this.getAttrib(node2, "name");
            String string2 = this.getAttrib(node2, "loopmin");
            String string3 = this.getAttrib(node2, "loopmin");
            this.print(" ---> Found script: " + string);
            RadioScript radioScript = new RadioScript(string, Integer.parseInt(string2), Integer.parseInt(string3));
            for (Node node3 : this.getChildNodes(node2)) {
                if (this.nodeNameIs(node3, "BroadcastEntry")) {
                    this.loadBroadcast(node3, radioScript);
                    continue;
                }
                if (!this.nodeNameIs(node3, "ExitOptions")) continue;
                this.loadExitOptions(node3, radioScript);
            }
            radioChannel.AddRadioScript(radioScript);
        }
    }

    private RadioBroadCast loadBroadcast(Node node, RadioScript radioScript) {
        int n;
        int n2;
        String string = this.getAttrib(node, "ID");
        String string2 = this.getAttrib(node, "timestamp");
        String string3 = this.getAttrib(node, "endstamp");
        this.print(" ----> BroadCast, Timestamp: " + string2 + ", endstamp: " + string3);
        int n3 = Integer.parseInt(string2);
        int n4 = Integer.parseInt(string3);
        String string4 = this.getAttrib(node, "preCat");
        int n5 = Integer.parseInt(this.getAttrib(node, "preChance"));
        String string5 = this.getAttrib(node, "postCat");
        int n6 = Integer.parseInt(this.getAttrib(node, "postChance"));
        RadioBroadCast radioBroadCast = new RadioBroadCast(string, n3, n4);
        if (!string4.equals("none") && this.advertQue.containsKey(string4)) {
            n2 = Rand.Next(101);
            n = this.advertQue.get(string4).size();
            if (n > 0 && n2 <= n5) {
                radioBroadCast.setPreSegment(this.advertQue.get(string4).get(Rand.Next(n)));
            }
        }
        if (!string5.equals("none") && this.advertQue.containsKey(string5)) {
            n2 = Rand.Next(101);
            n = this.advertQue.get(string5).size();
            if (n > 0 && n2 <= n6) {
                radioBroadCast.setPostSegment(this.advertQue.get(string5).get(Rand.Next(n)));
            }
        }
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "LineEntry")) continue;
            String string6 = this.getAttrib(node2, "r");
            String string7 = this.getAttrib(node2, "g");
            String string8 = this.getAttrib(node2, "b");
            Object object = null;
            String string9 = node2.getTextContent();
            this.print(" -----> New Line, Color: " + string6 + ", " + string7 + ", " + string8);
            for (Node node3 : this.getChildNodes(node2)) {
                if (!this.nodeNameIs(node3, "LineEffects")) continue;
                object = "";
                for (Node node4 : this.getChildNodes(node2)) {
                    if (!this.nodeNameIs(node4, "Effect")) continue;
                    String string10 = this.getAttrib(node4, "tag");
                    String string11 = this.getAttrib(node4, "value");
                    object = (String)object + string10 + "=" + string11 + ",";
                }
            }
            string9 = this.simpleDecrypt(string9);
            RadioLine radioLine = new RadioLine(string9, Float.parseFloat(string6) / 255.0f, Float.parseFloat(string7) / 255.0f, Float.parseFloat(string8) / 255.0f, (String)object);
            radioBroadCast.AddRadioLine(radioLine);
        }
        if (radioScript != null) {
            radioScript.AddBroadcast(radioBroadCast);
        }
        return radioBroadCast;
    }

    private String simpleDecrypt(String string) {
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            object = "UVWKLMABCDEFGXYZHIJOPQRSTNuvwklmabcdefgxyzhijopqrstn".indexOf(c) != -1 ? (String)object + "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".charAt("UVWKLMABCDEFGXYZHIJOPQRSTNuvwklmabcdefgxyzhijopqrstn".indexOf(c)) : (String)object + c;
        }
        return object;
    }

    private void loadExitOptions(Node node, RadioScript radioScript) {
        for (Node node2 : this.getChildNodes(node)) {
            if (!this.nodeNameIs(node2, "ExitOption")) continue;
            String string = this.getAttrib(node2, "script");
            String string2 = this.getAttrib(node2, "chance");
            String string3 = this.getAttrib(node2, "delay");
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            radioScript.AddExitOption(string, n, n2);
        }
    }
}

